/*
 * Decompiled with CFR 0.152.
 */
package azkaban.file2Trigger;

import azkaban.executor.ExecutionOptions;
import azkaban.scheduler.Schedule;
import azkaban.sla.SlaOption;
import azkaban.trigger.Condition;
import azkaban.trigger.JdbcTriggerLoader;
import azkaban.trigger.Trigger;
import azkaban.trigger.TriggerAction;
import azkaban.trigger.builtin.BasicTimeChecker;
import azkaban.trigger.builtin.ExecuteFlowAction;
import azkaban.utils.JSONUtils;
import azkaban.utils.Props;
import azkaban.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePeriod;

public class File2ScheduleTrigger {
    private static final Logger logger = Logger.getLogger(File2ScheduleTrigger.class);

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            File2ScheduleTrigger.printUsage();
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            logger.info((Object)arg);
            ++n2;
        }
        File confFile = new File(args[0]);
        logger.info((Object)("Trying to load config from " + confFile.toString()));
        if (!(confFile.exists() && confFile.isFile() && confFile.canRead())) {
            logger.error((Object)"Cannot read conf file!");
            return;
        }
        Props props = File2ScheduleTrigger.loadAzkabanConfig(confFile);
        File inputDir = new File(args[1]);
        if (!(inputDir.exists() && inputDir.isDirectory() && inputDir.canRead())) {
            logger.error((Object)"Input directory is not ready!");
            return;
        }
        JdbcTriggerLoader triggerLoader = new JdbcTriggerLoader(props);
        File[] fileArray = inputDir.listFiles();
        int n3 = fileArray.length;
        int n4 = 0;
        while (n4 < n3) {
            File scheduleFile = fileArray[n4];
            logger.info((Object)("Trying to load schedule from " + scheduleFile.getAbsolutePath()));
            if (scheduleFile.isFile()) {
                Props schedProps = new Props(null, scheduleFile);
                String flowName = schedProps.getString("flowName");
                String projectName = schedProps.getString("projectName");
                int projectId = schedProps.getInt("projectId");
                long firstSchedTimeLong = schedProps.getLong("firstScheduleTimeLong");
                String timezoneId = schedProps.getString("timezone");
                DateTimeZone timezone = DateTimeZone.forID((String)timezoneId);
                ReadablePeriod period = Utils.parsePeriodString((String)schedProps.getString("period"));
                long nextExecTimeLong = schedProps.getLong("nextExecTimeLong");
                long submitTimeLong = schedProps.getLong("submitTimeLong");
                String submitUser = schedProps.getString("submitUser");
                ExecutionOptions executionOptions = null;
                if (schedProps.containsKey((Object)"executionOptionsObj")) {
                    String executionOptionsObj = schedProps.getString("executionOptionsObj");
                    executionOptions = ExecutionOptions.createFromObject((Object)JSONUtils.parseJSONFromString((String)executionOptionsObj));
                } else {
                    executionOptions = new ExecutionOptions();
                }
                ArrayList<SlaOption> slaOptions = null;
                if (schedProps.containsKey((Object)"slaOptionsObj")) {
                    slaOptions = new ArrayList<SlaOption>();
                    List settingsObj = (List)JSONUtils.parseJSONFromString((String)schedProps.getString("slaOptionsObj"));
                    for (Map sla : settingsObj) {
                        String type = (String)sla.get("type");
                        Map info = (Map)sla.get("info");
                        List actions = (List)sla.get("actions");
                        SlaOption slaOption = new SlaOption(type, actions, info);
                        slaOptions.add(slaOption);
                    }
                }
                Schedule schedule = new Schedule(-1, projectId, projectName, flowName, "ready", firstSchedTimeLong, timezone, period, DateTime.now().getMillis(), nextExecTimeLong, submitTimeLong, submitUser, executionOptions, slaOptions);
                Trigger t = File2ScheduleTrigger.scheduleToTrigger(schedule);
                logger.info((Object)("Ready to insert trigger " + t.getDescription()));
                triggerLoader.addTrigger(t);
            }
            ++n4;
        }
    }

    private static Props loadAzkabanConfig(File confFile) throws IOException {
        return new Props(null, confFile);
    }

    private static void printUsage() {
        System.out.println("Usage: file2ScheduleTrigger PATH_TO_CONFIG_FILE PATH_TO_INPUT_DIR");
    }

    private static Trigger scheduleToTrigger(Schedule s) {
        Condition triggerCondition = File2ScheduleTrigger.createTimeTriggerCondition(s);
        Condition expireCondition = File2ScheduleTrigger.createTimeExpireCondition(s);
        List<TriggerAction> actions = File2ScheduleTrigger.createActions(s);
        Trigger t = new Trigger(s.getScheduleId(), s.getLastModifyTime(), s.getSubmitTime(), s.getSubmitUser(), "SimpleTimeTrigger", triggerCondition, expireCondition, actions);
        if (s.isRecurring()) {
            t.setResetOnTrigger(true);
        }
        return t;
    }

    private static List<TriggerAction> createActions(Schedule s) {
        ArrayList<TriggerAction> actions = new ArrayList<TriggerAction>();
        ExecuteFlowAction executeAct = new ExecuteFlowAction("executeFlowAction", s.getProjectId(), s.getProjectName(), s.getFlowName(), s.getSubmitUser(), s.getExecutionOptions(), s.getSlaOptions());
        actions.add((TriggerAction)executeAct);
        return actions;
    }

    private static Condition createTimeTriggerCondition(Schedule s) {
        HashMap<String, BasicTimeChecker> checkers = new HashMap<String, BasicTimeChecker>();
        BasicTimeChecker checker = new BasicTimeChecker("BasicTimeChecker_1", s.getFirstSchedTime(), s.getTimezone(), s.isRecurring(), s.skipPastOccurrences(), s.getPeriod());
        checkers.put(checker.getId(), checker);
        String expr = String.valueOf(checker.getId()) + ".eval()";
        Condition cond = new Condition(checkers, expr);
        return cond;
    }

    private static Condition createTimeExpireCondition(Schedule s) {
        HashMap<String, BasicTimeChecker> checkers = new HashMap<String, BasicTimeChecker>();
        BasicTimeChecker checker = new BasicTimeChecker("BasicTimeChecker_2", s.getFirstSchedTime(), s.getTimezone(), s.isRecurring(), s.skipPastOccurrences(), s.getPeriod());
        checkers.put(checker.getId(), checker);
        String expr = String.valueOf(checker.getId()) + ".eval()";
        Condition cond = new Condition(checkers, expr);
        return cond;
    }
}

