/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.Status;
import azkaban.flow.Edge;
import azkaban.flow.Flow;
import azkaban.flow.FlowProps;
import azkaban.flow.Node;
import azkaban.utils.JSONUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExecutableFlow {
    private int executionId = -1;
    private String flowId;
    private int projectId;
    private int version;
    private String executionPath;
    private HashMap<String, FlowProps> flowProps = new HashMap();
    private HashMap<String, ExecutableNode> executableNodes = new HashMap();
    private ArrayList<String> startNodes;
    private ArrayList<String> endNodes;
    private long submitTime = -1L;
    private long startTime = -1L;
    private long endTime = -1L;
    private long updateTime = -1L;
    private Status flowStatus = Status.READY;
    private String submitUser;
    private HashSet<String> proxyUsers = new HashSet();
    private ExecutionOptions executionOptions;

    public ExecutableFlow(Flow flow) {
        this.projectId = flow.getProjectId();
        this.flowId = flow.getId();
        this.version = flow.getVersion();
        this.setFlow(flow);
    }

    public ExecutableFlow(int executionId, Flow flow) {
        this.projectId = flow.getProjectId();
        this.flowId = flow.getId();
        this.version = flow.getVersion();
        this.executionId = executionId;
        this.setFlow(flow);
    }

    public ExecutableFlow() {
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public List<ExecutableNode> getExecutableNodes() {
        return new ArrayList<ExecutableNode>(this.executableNodes.values());
    }

    public ExecutableNode getExecutableNode(String id) {
        return this.executableNodes.get(id);
    }

    public Collection<FlowProps> getFlowProps() {
        return this.flowProps.values();
    }

    public void setProxyUsers(HashSet<String> proxyUsers) {
        this.proxyUsers = proxyUsers;
    }

    public HashSet<String> getProxyUsers() {
        return this.proxyUsers;
    }

    public void setExecutionOptions(ExecutionOptions options) {
        this.executionOptions = options;
    }

    public ExecutionOptions getExecutionOptions() {
        return this.executionOptions;
    }

    private void setFlow(Flow flow) {
        this.executionOptions = new ExecutionOptions();
        for (Node node : flow.getNodes()) {
            String id = node.getId();
            ExecutableNode exNode = new ExecutableNode(node, this);
            this.executableNodes.put(id, exNode);
        }
        for (Edge edge : flow.getEdges()) {
            ExecutableNode sourceNode = this.executableNodes.get(edge.getSourceId());
            ExecutableNode targetNode = this.executableNodes.get(edge.getTargetId());
            sourceNode.addOutNode(edge.getTargetId());
            targetNode.addInNode(edge.getSourceId());
        }
        if (flow.getSuccessEmails() != null) {
            this.executionOptions.setSuccessEmails(flow.getSuccessEmails());
        }
        if (flow.getFailureEmails() != null) {
            this.executionOptions.setFailureEmails(flow.getFailureEmails());
        }
        this.flowProps.putAll(flow.getAllFlowProps());
    }

    public List<String> getStartNodes() {
        if (this.startNodes == null) {
            this.startNodes = new ArrayList();
            for (ExecutableNode node : this.executableNodes.values()) {
                if (!node.getInNodes().isEmpty()) continue;
                this.startNodes.add(node.getJobId());
            }
        }
        return this.startNodes;
    }

    public List<String> getEndNodes() {
        if (this.endNodes == null) {
            this.endNodes = new ArrayList();
            for (ExecutableNode node : this.executableNodes.values()) {
                if (!node.getOutNodes().isEmpty()) continue;
                this.endNodes.add(node.getJobId());
            }
        }
        return this.endNodes;
    }

    public boolean setNodeStatus(String nodeId, Status status) {
        ExecutableNode exNode = this.executableNodes.get(nodeId);
        if (exNode == null) {
            return false;
        }
        exNode.setStatus(status);
        return true;
    }

    public void setProxyNodes(int externalExecutionId, String nodeId) {
        ExecutableNode exNode = this.executableNodes.get(nodeId);
        if (exNode == null) {
            return;
        }
        exNode.setExternalExecutionId(externalExecutionId);
    }

    public int getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(int executionId) {
        this.executionId = executionId;
        for (ExecutableNode node : this.executableNodes.values()) {
            node.setExecutionId(executionId);
        }
    }

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public String getExecutionPath() {
        return this.executionPath;
    }

    public void setExecutionPath(String executionPath) {
        this.executionPath = executionPath;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long time) {
        this.startTime = time;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long time) {
        this.endTime = time;
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    public void setSubmitTime(long time) {
        this.submitTime = time;
    }

    public Status getStatus() {
        return this.flowStatus;
    }

    public void setStatus(Status flowStatus) {
        this.flowStatus = flowStatus;
    }

    public Map<String, Object> toObject() {
        HashMap<String, Object> flowObj = new HashMap<String, Object>();
        flowObj.put("type", "executableflow");
        flowObj.put("executionId", this.executionId);
        flowObj.put("executionPath", this.executionPath);
        flowObj.put("flowId", this.flowId);
        flowObj.put("projectId", this.projectId);
        flowObj.put("submitTime", this.submitTime);
        flowObj.put("startTime", this.startTime);
        flowObj.put("endTime", this.endTime);
        flowObj.put("status", this.flowStatus.toString());
        flowObj.put("submitUser", this.submitUser);
        flowObj.put("version", this.version);
        flowObj.put("executionOptions", this.executionOptions.toObject());
        flowObj.put("version", this.version);
        ArrayList props = new ArrayList();
        for (FlowProps fprop : this.flowProps.values()) {
            HashMap<String, String> propObj = new HashMap<String, String>();
            String source = fprop.getSource();
            String inheritedSource = fprop.getInheritedSource();
            propObj.put("source", source);
            if (inheritedSource != null) {
                propObj.put("inherited", inheritedSource);
            }
            props.add(propObj);
        }
        flowObj.put("properties", props);
        ArrayList<Object> nodes = new ArrayList<Object>();
        for (ExecutableNode node : this.executableNodes.values()) {
            nodes.add(node.toObject());
        }
        flowObj.put("nodes", nodes);
        ArrayList<String> proxyUserList = new ArrayList<String>(this.proxyUsers);
        flowObj.put("proxyUsers", proxyUserList);
        return flowObj;
    }

    public Object toUpdateObject(long lastUpdateTime) {
        HashMap<String, Serializable> updateData = new HashMap<String, Serializable>();
        updateData.put("execId", Integer.valueOf(this.executionId));
        updateData.put("status", Integer.valueOf(this.flowStatus.getNumVal()));
        updateData.put("startTime", Long.valueOf(this.startTime));
        updateData.put("endTime", Long.valueOf(this.endTime));
        updateData.put("updateTime", Long.valueOf(this.updateTime));
        ArrayList updatedNodes = new ArrayList();
        for (ExecutableNode node : this.executableNodes.values()) {
            if (node.getUpdateTime() <= lastUpdateTime) continue;
            HashMap<String, Object> updatedNodeMap = new HashMap<String, Object>();
            updatedNodeMap.put("jobId", node.getJobId());
            updatedNodeMap.put("status", node.getStatus().getNumVal());
            updatedNodeMap.put("startTime", node.getStartTime());
            updatedNodeMap.put("endTime", node.getEndTime());
            updatedNodeMap.put("updateTime", node.getUpdateTime());
            updatedNodeMap.put("attempt", node.getAttempt());
            if (node.getAttempt() > 0) {
                ArrayList<Map<String, Object>> pastAttempts = new ArrayList<Map<String, Object>>();
                for (ExecutableNode.Attempt attempt : node.getPastAttemptList()) {
                    pastAttempts.add(attempt.toObject());
                }
                updatedNodeMap.put("pastAttempts", pastAttempts);
            }
            updatedNodes.add(updatedNodeMap);
        }
        updateData.put("nodes", updatedNodes);
        return updateData;
    }

    public void applyUpdateObject(Map<String, Object> updateData) {
        List updatedNodes = (List)updateData.get("nodes");
        for (Map node : updatedNodes) {
            String jobId = (String)node.get("jobId");
            Status status = Status.fromInteger((Integer)node.get("status"));
            long startTime = JSONUtils.getLongFromObject(node.get("startTime"));
            long endTime = JSONUtils.getLongFromObject(node.get("endTime"));
            long updateTime = JSONUtils.getLongFromObject(node.get("updateTime"));
            ExecutableNode exNode = this.executableNodes.get(jobId);
            exNode.setEndTime(endTime);
            exNode.setStartTime(startTime);
            exNode.setUpdateTime(updateTime);
            exNode.setStatus(status);
            int attempt = 0;
            if (node.containsKey("attempt") && (attempt = ((Integer)node.get("attempt")).intValue()) > 0) {
                exNode.updatePastAttempts((List)node.get("pastAttempts"));
            }
            exNode.setAttempt(attempt);
        }
        this.flowStatus = Status.fromInteger((Integer)updateData.get("status"));
        System.out.println("Updating status to " + (Object)((Object)this.flowStatus));
        this.startTime = JSONUtils.getLongFromObject(updateData.get("startTime"));
        this.endTime = JSONUtils.getLongFromObject(updateData.get("endTime"));
        this.updateTime = JSONUtils.getLongFromObject(updateData.get("updateTime"));
    }

    public static ExecutableFlow createExecutableFlowFromObject(Object obj) {
        ExecutableFlow exFlow = new ExecutableFlow();
        HashMap flowObj = (HashMap)obj;
        exFlow.executionId = (Integer)flowObj.get("executionId");
        exFlow.executionPath = (String)flowObj.get("executionPath");
        exFlow.flowId = (String)flowObj.get("flowId");
        exFlow.projectId = (Integer)flowObj.get("projectId");
        exFlow.submitTime = JSONUtils.getLongFromObject(flowObj.get("submitTime"));
        exFlow.startTime = JSONUtils.getLongFromObject(flowObj.get("startTime"));
        exFlow.endTime = JSONUtils.getLongFromObject(flowObj.get("endTime"));
        exFlow.flowStatus = Status.valueOf((String)flowObj.get("status"));
        exFlow.submitUser = (String)flowObj.get("submitUser");
        exFlow.version = (Integer)flowObj.get("version");
        exFlow.executionOptions = flowObj.containsKey("executionOptions") ? ExecutionOptions.createFromObject(flowObj.get("executionOptions")) : ExecutionOptions.createFromObject(flowObj);
        List nodes = (List)flowObj.get("nodes");
        for (Object nodeObj : nodes) {
            ExecutableNode node = ExecutableNode.createNodeFromObject(nodeObj, exFlow);
            exFlow.executableNodes.put(node.getJobId(), node);
        }
        List properties = (List)flowObj.get("properties");
        for (Object propNode : properties) {
            HashMap fprop = (HashMap)propNode;
            String source = (String)fprop.get("source");
            String inheritedSource = (String)fprop.get("inherited");
            FlowProps flowProps = new FlowProps(inheritedSource, source);
            exFlow.flowProps.put(source, flowProps);
        }
        if (flowObj.containsKey("proxyUsers")) {
            ArrayList proxyUserList = (ArrayList)flowObj.get("proxyUsers");
            exFlow.setProxyUsers(new HashSet<String>(proxyUserList));
        }
        return exFlow;
    }

    public void updateExecutableFlowFromObject(Object obj) {
        HashMap flowObj = (HashMap)obj;
        this.submitTime = JSONUtils.getLongFromObject(flowObj.get("submitTime"));
        this.startTime = JSONUtils.getLongFromObject(flowObj.get("startTime"));
        this.endTime = JSONUtils.getLongFromObject(flowObj.get("endTime"));
        this.flowStatus = Status.valueOf((String)flowObj.get("status"));
        List nodes = (List)flowObj.get("nodes");
        for (Object nodeObj : nodes) {
            HashMap nodeHash = (HashMap)nodeObj;
            String nodeId = (String)nodeHash.get("id");
            ExecutableNode node = this.executableNodes.get(nodeId);
            if (nodeId == null) {
                throw new RuntimeException("Node " + nodeId + " doesn't exist in flow.");
            }
            node.updateNodeFromObject(nodeObj);
        }
    }

    public Set<String> getSources() {
        HashSet<String> set = new HashSet<String>();
        for (ExecutableNode exNode : this.executableNodes.values()) {
            set.add(exNode.getJobPropsSource());
        }
        for (FlowProps props : this.flowProps.values()) {
            set.add(props.getSource());
        }
        return set;
    }

    public String getSubmitUser() {
        return this.submitUser;
    }

    public void setSubmitUser(String submitUser) {
        this.submitUser = submitUser;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

