/*
 * Decompiled with CFR 0.152.
 */
package azkaban.database;

import azkaban.database.AzkabanDataSource;
import azkaban.database.AzkabanDatabaseSetup;
import azkaban.database.DataSourceUtils;
import azkaban.utils.FileIOUtils;
import azkaban.utils.Props;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class AzkabanDatabaseSetup {
    private static final Logger logger = Logger.getLogger(AzkabanDatabaseSetup.class);
    public static final String DATABASE_CHECK_VERSION = "database.check.version";
    public static final String DATABASE_AUTO_UPDATE_TABLES = "database.auto.update.tables";
    public static final String DATABASE_SQL_SCRIPT_DIR = "database.sql.scripts.dir";
    private static final String DEFAULT_SCRIPT_PATH = "sql";
    private static final String CREATE_SCRIPT_PREFIX = "create.";
    private static final String UPDATE_SCRIPT_PREFIX = "update.";
    private static final String SQL_SCRIPT_SUFFIX = ".sql";
    private static String FETCH_PROPERTY_BY_TYPE = "SELECT name, value FROM properties WHERE type=?";
    private static final String INSERT_DB_PROPERTY = "INSERT INTO properties (name, type, value, modified_time) values (?,?,?,?)";
    private static final String UPDATE_DB_PROPERTY = "UPDATE properties SET value=?,modified_time=? WHERE name=? AND type=?";
    private AzkabanDataSource dataSource;
    private Map<String, String> tables;
    private Map<String, String> installedVersions;
    private Set<String> missingTables;
    private Map<String, List<String>> upgradeList;
    private Props dbProps;
    private String version;
    private boolean needsUpdating;
    private String scriptPath = null;

    public AzkabanDatabaseSetup(Props props) {
        this(DataSourceUtils.getDataSource((Props)props));
        this.scriptPath = props.getString(DATABASE_SQL_SCRIPT_DIR, DEFAULT_SCRIPT_PATH);
    }

    public AzkabanDatabaseSetup(AzkabanDataSource ds) {
        this.dataSource = ds;
        if (this.scriptPath == null) {
            this.scriptPath = DEFAULT_SCRIPT_PATH;
        }
    }

    public void loadTableInfo() throws IOException, SQLException {
        this.tables = new HashMap();
        this.installedVersions = new HashMap();
        this.missingTables = new HashSet();
        this.upgradeList = new HashMap();
        this.dbProps = this.loadDBProps();
        this.version = this.dbProps.getString("version");
        this.loadInstalledTables();
        this.loadTableVersion();
        this.findMissingTables();
        this.findOutOfDateTables();
        this.needsUpdating = !this.upgradeList.isEmpty() || !this.missingTables.isEmpty();
    }

    public boolean needsUpdating() {
        if (this.version == null) {
            throw new RuntimeException("Uninitialized. Call loadTableInfo first.");
        }
        return this.needsUpdating;
    }

    public void printUpgradePlan() {
        if (!this.tables.isEmpty()) {
            logger.info((Object)"The following are installed tables");
            for (Map.Entry installedTable : this.tables.entrySet()) {
                logger.info((Object)(" " + (String)installedTable.getKey() + " version:" + (String)installedTable.getValue()));
            }
        } else {
            logger.info((Object)"No installed tables found.");
        }
        if (!this.missingTables.isEmpty()) {
            logger.info((Object)"The following are missing tables that need to be installed");
            for (String table : this.missingTables) {
                logger.info((Object)(" " + table));
            }
        } else {
            logger.info((Object)"There are no missing tables.");
        }
        if (!this.upgradeList.isEmpty()) {
            logger.info((Object)"The following tables need to be updated.");
            for (Map.Entry upgradeTable : this.upgradeList.entrySet()) {
                String tableInfo = " " + (String)upgradeTable.getKey() + " versions:";
                for (String upVersion : (List)upgradeTable.getValue()) {
                    tableInfo = String.valueOf(tableInfo) + upVersion + ",";
                }
                logger.info((Object)tableInfo);
            }
        } else {
            logger.info((Object)"No tables need to be updated.");
        }
    }

    public void updateDatabase(boolean createTable, boolean updateTable) throws SQLException, IOException {
        if (!this.needsUpdating()) {
            logger.info((Object)"Nothing to be done.");
            return;
        }
        if (createTable && !this.missingTables.isEmpty()) {
            this.createNewTables();
        }
        if (updateTable && !this.upgradeList.isEmpty()) {
            this.updateTables();
        }
    }

    private Props loadDBProps() throws IOException {
        File dbPropsFile = new File(this.scriptPath, "database.properties");
        if (!dbPropsFile.exists()) {
            throw new IOException("Cannot find 'database.properties' file in " + dbPropsFile.getPath());
        }
        Props props = new Props(null, dbPropsFile);
        return props;
    }

    private void loadTableVersion() throws SQLException {
        logger.info((Object)"Searching for table versions in the properties table");
        if (this.tables.containsKey("properties")) {
            QueryRunner runner = new QueryRunner((DataSource)this.dataSource);
            Map map = (Map)runner.query(FETCH_PROPERTY_BY_TYPE, (ResultSetHandler)new PropertiesHandler(), new Object[]{DataSourceUtils.PropertyType.DB.getNumVal()});
            for (String key : map.keySet()) {
                String value = (String)map.get(key);
                if (!key.endsWith(".version")) continue;
                String tableName = key.substring(0, key.length() - ".version".length());
                this.installedVersions.put(tableName, value);
                if (!this.tables.containsKey(tableName)) continue;
                this.tables.put(tableName, value);
            }
        } else {
            logger.info((Object)"Properties table doesn't exist.");
        }
    }

    private void loadInstalledTables() throws SQLException {
        logger.info((Object)"Searching for installed tables");
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            ResultSet rs = conn.getMetaData().getTables(conn.getCatalog(), null, null, new String[]{"TABLE"});
            while (rs.next()) {
                this.tables.put(rs.getString("TABLE_NAME").toLowerCase(), "2.1");
            }
        }
        finally {
            DbUtils.commitAndCloseQuietly((Connection)conn);
        }
    }

    private void findMissingTables() {
        File[] createScripts;
        File directory = new File(this.scriptPath);
        File[] fileArray = createScripts = directory.listFiles((FileFilter)new FileIOUtils.PrefixSuffixFileFilter(CREATE_SCRIPT_PREFIX, SQL_SCRIPT_SUFFIX));
        int n = createScripts.length;
        int n2 = 0;
        while (n2 < n) {
            File script = fileArray[n2];
            String name = script.getName();
            String[] nameSplit = name.split("\\.");
            String tableName = nameSplit[1];
            if (!this.tables.containsKey(tableName)) {
                this.missingTables.add(tableName);
            }
            ++n2;
        }
    }

    private void findOutOfDateTables() {
        for (String key : this.tables.keySet()) {
            String version;
            List upgradeVersions = this.findOutOfDateTable(key, version = (String)this.tables.get(key));
            if (upgradeVersions == null || upgradeVersions.isEmpty()) continue;
            this.upgradeList.put(key, upgradeVersions);
        }
    }

    private List<String> findOutOfDateTable(String table, String version) {
        File directory = new File(this.scriptPath);
        ArrayList<String> versions = new ArrayList<String>();
        File[] createScripts = directory.listFiles((FileFilter)new FileIOUtils.PrefixSuffixFileFilter(UPDATE_SCRIPT_PREFIX + table, SQL_SCRIPT_SUFFIX));
        if (createScripts.length == 0) {
            return null;
        }
        String updateFileNameVersion = UPDATE_SCRIPT_PREFIX + table + "." + version;
        File[] fileArray = createScripts;
        int n = createScripts.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileName = file.getName();
            if (fileName.compareTo(updateFileNameVersion) > 0 && !fileName.startsWith(updateFileNameVersion)) {
                String[] split = fileName.split("\\.");
                String versionNum = "";
                int i = 2;
                while (i < split.length - 1) {
                    try {
                        Integer.parseInt(split[i]);
                        versionNum = String.valueOf(versionNum) + split[i] + ".";
                    }
                    catch (NumberFormatException e) {
                        break;
                    }
                    ++i;
                }
                if (versionNum.endsWith(".") && (versionNum = versionNum.substring(0, versionNum.length() - 1)).compareTo(version) == 0) {
                    versions.add(versionNum);
                }
            }
            ++n2;
        }
        Collections.sort(versions);
        return versions;
    }

    private void createNewTables() throws SQLException, IOException {
        Connection conn = this.dataSource.getConnection();
        conn.setAutoCommit(false);
        try {
            if (this.missingTables.contains("properties")) {
                this.runTableScripts(conn, "properties", this.version, this.dataSource.getDBType(), false);
            }
            for (String table : this.missingTables) {
                if (table.equals("properties")) continue;
                this.runTableScripts(conn, table, this.version, this.dataSource.getDBType(), false);
            }
        }
        finally {
            conn.close();
        }
    }

    private void updateTables() throws SQLException, IOException {
        Connection conn = this.dataSource.getConnection();
        conn.setAutoCommit(false);
        try {
            if (this.upgradeList.containsKey("properties")) {
                for (String version : (List)this.upgradeList.get("properties")) {
                    this.runTableScripts(conn, "properties", version, this.dataSource.getDBType(), true);
                }
            }
            for (String table : this.upgradeList.keySet()) {
                if (table.equals("properties")) continue;
                for (String version : (List)this.upgradeList.get(table)) {
                    this.runTableScripts(conn, table, version, this.dataSource.getDBType(), true);
                }
            }
        }
        finally {
            conn.close();
        }
    }

    private void runTableScripts(Connection conn, String table, String version, String dbType, boolean update) throws IOException, SQLException {
        String dbScript;
        String scriptName = "";
        if (update) {
            scriptName = UPDATE_SCRIPT_PREFIX + table + "." + version;
            logger.info((Object)("Update table " + table + " to version " + version));
        } else {
            scriptName = CREATE_SCRIPT_PREFIX + table;
            logger.info((Object)("Creating new table " + table + " version " + version));
        }
        String dbSpecificScript = String.valueOf(scriptName) + "." + dbType + SQL_SCRIPT_SUFFIX;
        File script = new File(this.scriptPath, dbSpecificScript);
        if (!script.exists() && !(script = new File(this.scriptPath, dbScript = String.valueOf(scriptName) + SQL_SCRIPT_SUFFIX)).exists()) {
            throw new IOException("Creation files do not exist for table " + table);
        }
        BufferedInputStream buff = null;
        try {
            buff = new BufferedInputStream(new FileInputStream(script));
            String queryStr = IOUtils.toString((InputStream)buff);
            String[] splitQuery = queryStr.split(";\\s*\n");
            QueryRunner runner = new QueryRunner();
            String[] stringArray = splitQuery;
            int n = splitQuery.length;
            int n2 = 0;
            while (n2 < n) {
                String query = stringArray[n2];
                runner.update(conn, query);
                ++n2;
            }
            if (table.equals("properties")) {
                conn.commit();
            }
            String propertyName = String.valueOf(table) + ".version";
            if (!this.installedVersions.containsKey(table)) {
                runner.update(conn, INSERT_DB_PROPERTY, new Object[]{propertyName, DataSourceUtils.PropertyType.DB.getNumVal(), version, System.currentTimeMillis()});
            } else {
                runner.update(conn, UPDATE_DB_PROPERTY, new Object[]{version, System.currentTimeMillis(), propertyName, DataSourceUtils.PropertyType.DB.getNumVal()});
            }
            conn.commit();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(buff);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)buff);
    }
}

