/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor.mail;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.mail.MailCreator;
import azkaban.utils.EmailMessage;
import azkaban.utils.Emailer;
import azkaban.utils.Utils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultMailCreator
implements MailCreator {
    public static final String DEFAULT_MAIL_CREATOR = "default";
    private static HashMap<String, MailCreator> registeredCreators = new HashMap();
    private static MailCreator defaultCreator = new DefaultMailCreator();

    static {
        DefaultMailCreator.registerCreator((String)"default", (MailCreator)defaultCreator);
    }

    public static void registerCreator(String name, MailCreator creator) {
        registeredCreators.put(name, creator);
    }

    public static MailCreator getCreator(String name) {
        MailCreator creator = (MailCreator)registeredCreators.get(name);
        if (creator == null) {
            creator = defaultCreator;
        }
        return creator;
    }

    public boolean createFirstErrorMessage(ExecutableFlow flow, EmailMessage message, String azkabanName, String clientHostname, String clientPortNumber, String ... vars) {
        ExecutionOptions option = flow.getExecutionOptions();
        List emailList = option.getFailureEmails();
        int execId = flow.getExecutionId();
        if (emailList != null && !emailList.isEmpty()) {
            message.addAllToAddress((Collection)emailList);
            message.setMimeType("text/html");
            message.setSubject("Flow '" + flow.getFlowId() + "' has failed on " + azkabanName);
            message.println((Object)("<h2 style=\"color:#FF0000\"> Execution '" + flow.getExecutionId() + "' of flow '" + flow.getFlowId() + "' has encountered a failure on " + azkabanName + "</h2>"));
            if (option.getFailureAction() == ExecutionOptions.FailureAction.CANCEL_ALL) {
                message.println((Object)"This flow is set to cancel all currently running jobs.");
            } else if (option.getFailureAction() == ExecutionOptions.FailureAction.FINISH_ALL_POSSIBLE) {
                message.println((Object)"This flow is set to complete all jobs that aren't blocked by the failure.");
            } else {
                message.println((Object)"This flow is set to complete all currently running jobs before stopping.");
            }
            message.println((Object)"<table>");
            message.println((Object)("<tr><td>Start Time</td><td>" + flow.getStartTime() + "</td></tr>"));
            message.println((Object)("<tr><td>End Time</td><td>" + flow.getEndTime() + "</td></tr>"));
            message.println((Object)("<tr><td>Duration</td><td>" + Utils.formatDuration((long)flow.getStartTime(), (long)flow.getEndTime()) + "</td></tr>"));
            message.println((Object)"</table>");
            message.println((Object)"");
            String executionUrl = "https://" + clientHostname + ":" + clientPortNumber + "/" + "executor?" + "execid=" + execId;
            message.println((Object)("<a href='\"" + executionUrl + "\">" + flow.getFlowId() + " Execution Link</a>"));
            message.println((Object)"");
            message.println((Object)"<h3>Reason</h3>");
            List failedJobs = Emailer.findFailedJobs((ExecutableFlow)flow);
            message.println((Object)"<ul>");
            for (String jobId : failedJobs) {
                message.println((Object)("<li><a href=\"" + executionUrl + "&job=" + jobId + "\">Failed job '" + jobId + "' Link</a></li>"));
            }
            message.println((Object)"</ul>");
            return true;
        }
        return false;
    }

    public boolean createErrorEmail(ExecutableFlow flow, EmailMessage message, String azkabanName, String clientHostname, String clientPortNumber, String ... vars) {
        ExecutionOptions option = flow.getExecutionOptions();
        List emailList = option.getFailureEmails();
        int execId = flow.getExecutionId();
        if (emailList != null && !emailList.isEmpty()) {
            message.addAllToAddress((Collection)emailList);
            message.setMimeType("text/html");
            message.setSubject("Flow '" + flow.getFlowId() + "' has failed on " + azkabanName);
            message.println((Object)("<h2 style=\"color:#FF0000\"> Execution '" + execId + "' of flow '" + flow.getFlowId() + "' has failed on " + azkabanName + "</h2>"));
            message.println((Object)"<table>");
            message.println((Object)("<tr><td>Start Time</td><td>" + flow.getStartTime() + "</td></tr>"));
            message.println((Object)("<tr><td>End Time</td><td>" + flow.getEndTime() + "</td></tr>"));
            message.println((Object)("<tr><td>Duration</td><td>" + Utils.formatDuration((long)flow.getStartTime(), (long)flow.getEndTime()) + "</td></tr>"));
            message.println((Object)"</table>");
            message.println((Object)"");
            String executionUrl = "https://" + clientHostname + ":" + clientPortNumber + "/" + "executor?" + "execid=" + execId;
            message.println((Object)("<a href='\"" + executionUrl + "\">" + flow.getFlowId() + " Execution Link</a>"));
            message.println((Object)"");
            message.println((Object)"<h3>Reason</h3>");
            List failedJobs = Emailer.findFailedJobs((ExecutableFlow)flow);
            message.println((Object)"<ul>");
            for (String jobId : failedJobs) {
                message.println((Object)("<li><a href=\"" + executionUrl + "&job=" + jobId + "\">Failed job '" + jobId + "' Link</a></li>"));
            }
            String[] stringArray = vars;
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                String reasons = stringArray[n2];
                message.println((Object)("<li>" + reasons + "</li>"));
                ++n2;
            }
            message.println((Object)"</ul>");
            return true;
        }
        return false;
    }

    public boolean createSuccessEmail(ExecutableFlow flow, EmailMessage message, String azkabanName, String clientHostname, String clientPortNumber, String ... vars) {
        ExecutionOptions option = flow.getExecutionOptions();
        List emailList = option.getSuccessEmails();
        int execId = flow.getExecutionId();
        if (emailList != null && !emailList.isEmpty()) {
            message.addAllToAddress((Collection)emailList);
            message.setMimeType("text/html");
            message.setSubject("Flow '" + flow.getFlowId() + "' has succeeded on " + azkabanName);
            message.println((Object)("<h2> Execution '" + flow.getExecutionId() + "' of flow '" + flow.getFlowId() + "' has succeeded on " + azkabanName + "</h2>"));
            message.println((Object)"<table>");
            message.println((Object)("<tr><td>Start Time</td><td>" + flow.getStartTime() + "</td></tr>"));
            message.println((Object)("<tr><td>End Time</td><td>" + flow.getEndTime() + "</td></tr>"));
            message.println((Object)("<tr><td>Duration</td><td>" + Utils.formatDuration((long)flow.getStartTime(), (long)flow.getEndTime()) + "</td></tr>"));
            message.println((Object)"</table>");
            message.println((Object)"");
            String executionUrl = "https://" + clientHostname + ":" + clientPortNumber + "/" + "executor?" + "execid=" + execId;
            message.println((Object)("<a href=\"" + executionUrl + "\">" + flow.getFlowId() + " Execution Link</a>"));
            return true;
        }
        return false;
    }
}

