/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.execapp.event;

import azkaban.execapp.event.BlockingStatus;
import azkaban.executor.Status;
import azkaban.test.execapp.event.BlockingStatusTest;
import org.junit.Assert;
import org.junit.Test;

public class BlockingStatusTest {
    @Test
    public void testFinishedBlock() {
        BlockingStatus status = new BlockingStatus(1, "test", Status.SKIPPED);
        WatchingThread thread = new WatchingThread(this, status);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Diff " + thread.getDiff());
        Assert.assertTrue((thread.getDiff() < 100L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnfinishedBlock() throws InterruptedException {
        BlockingStatus status = new BlockingStatus(1, "test", Status.QUEUED);
        WatchingThread thread = new WatchingThread(this, status);
        thread.start();
        BlockingStatusTest blockingStatusTest = this;
        synchronized (blockingStatusTest) {
            this.wait(3000L);
        }
        status.changeStatus(Status.SUCCEEDED);
        thread.join();
        System.out.println("Diff " + thread.getDiff());
        Assert.assertTrue((thread.getDiff() >= 3000L && thread.getDiff() < 3100L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnfinishedBlockSeveralChanges() throws InterruptedException {
        BlockingStatus status = new BlockingStatus(1, "test", Status.QUEUED);
        WatchingThread thread = new WatchingThread(this, status);
        thread.start();
        BlockingStatusTest blockingStatusTest = this;
        synchronized (blockingStatusTest) {
            this.wait(3000L);
        }
        status.changeStatus(Status.PAUSED);
        blockingStatusTest = this;
        synchronized (blockingStatusTest) {
            this.wait(1000L);
        }
        status.changeStatus(Status.FAILED);
        thread.join(1000L);
        System.out.println("Diff " + thread.getDiff());
        Assert.assertTrue((thread.getDiff() >= 4000L && thread.getDiff() < 4100L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleWatchers() throws InterruptedException {
        BlockingStatus status = new BlockingStatus(1, "test", Status.QUEUED);
        WatchingThread thread1 = new WatchingThread(this, status);
        thread1.start();
        BlockingStatusTest blockingStatusTest = this;
        synchronized (blockingStatusTest) {
            this.wait(2000L);
        }
        WatchingThread thread2 = new WatchingThread(this, status);
        thread2.start();
        BlockingStatusTest blockingStatusTest2 = this;
        synchronized (blockingStatusTest2) {
            this.wait(2000L);
        }
        status.changeStatus(Status.FAILED);
        thread2.join(1000L);
        thread1.join(1000L);
        System.out.println("Diff thread 1 " + thread1.getDiff());
        System.out.println("Diff thread 2 " + thread2.getDiff());
        Assert.assertTrue((thread1.getDiff() >= 4000L && thread1.getDiff() < 4100L ? 1 : 0) != 0);
        Assert.assertTrue((thread2.getDiff() >= 2000L && thread2.getDiff() < 2100L ? 1 : 0) != 0);
    }
}

