/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger;

import azkaban.trigger.ActionTypeLoader;
import azkaban.trigger.Condition;
import azkaban.trigger.ConditionChecker;
import azkaban.trigger.TriggerAction;
import azkaban.trigger.TriggerManagerException;
import azkaban.trigger.TriggerStatus;
import azkaban.utils.JSONUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;

public class Trigger {
    private static Logger logger = Logger.getLogger(Trigger.class);
    private int triggerId = -1;
    private long lastModifyTime;
    private long submitTime;
    private String submitUser;
    private String source;
    private TriggerStatus status = TriggerStatus.READY;
    private Condition triggerCondition;
    private Condition expireCondition;
    private List<TriggerAction> actions;
    private List<TriggerAction> expireActions;
    private Map<String, Object> info = new HashMap();
    private Map<String, Object> context = new HashMap();
    private static ActionTypeLoader actionTypeLoader;
    private boolean resetOnTrigger = true;
    private boolean resetOnExpire = true;
    private long nextCheckTime = -1L;

    private Trigger() throws TriggerManagerException {
        throw new TriggerManagerException("Triggers should always be specified");
    }

    public void updateNextCheckTime() {
        this.nextCheckTime = Math.min(this.triggerCondition.getNextCheckTime(), this.expireCondition.getNextCheckTime());
    }

    public long getNextCheckTime() {
        return this.nextCheckTime;
    }

    public void setNextCheckTime(long nct) {
        this.nextCheckTime = nct;
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    public String getSubmitUser() {
        return this.submitUser;
    }

    public TriggerStatus getStatus() {
        return this.status;
    }

    public void setStatus(TriggerStatus status) {
        this.status = status;
    }

    public Condition getTriggerCondition() {
        return this.triggerCondition;
    }

    public Condition getExpireCondition() {
        return this.expireCondition;
    }

    public List<TriggerAction> getActions() {
        return this.actions;
    }

    public List<TriggerAction> getExpireActions() {
        return this.expireActions;
    }

    public Map<String, Object> getInfo() {
        return this.info;
    }

    public void setInfo(Map<String, Object> info) {
        this.info = info;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    public Trigger(long lastModifyTime, long submitTime, String submitUser, String source, Condition triggerCondition, Condition expireCondition, List<TriggerAction> actions, List<TriggerAction> expireActions, Map<String, Object> info, Map<String, Object> context) {
        this.lastModifyTime = lastModifyTime;
        this.submitTime = submitTime;
        this.submitUser = submitUser;
        this.source = source;
        this.triggerCondition = triggerCondition;
        this.expireCondition = expireCondition;
        this.actions = actions;
        this.expireActions = expireActions;
        this.info = info;
        this.context = context;
    }

    public Trigger(long lastModifyTime, long submitTime, String submitUser, String source, Condition triggerCondition, Condition expireCondition, List<TriggerAction> actions, List<TriggerAction> expireActions) {
        this.lastModifyTime = lastModifyTime;
        this.submitTime = submitTime;
        this.submitUser = submitUser;
        this.source = source;
        this.triggerCondition = triggerCondition;
        this.expireCondition = expireCondition;
        this.actions = actions;
        this.expireActions = expireActions;
    }

    public Trigger(String submitUser, String source, Condition triggerCondition, Condition expireCondition, List<TriggerAction> actions, List<TriggerAction> expireActions) {
        this.lastModifyTime = DateTime.now().getMillis();
        this.submitTime = DateTime.now().getMillis();
        this.submitUser = submitUser;
        this.source = source;
        this.triggerCondition = triggerCondition;
        this.expireCondition = expireCondition;
        this.actions = actions;
        this.expireActions = expireActions;
    }

    public Trigger(String submitUser, String source, Condition triggerCondition, Condition expireCondition, List<TriggerAction> actions) {
        this.lastModifyTime = DateTime.now().getMillis();
        this.submitTime = DateTime.now().getMillis();
        this.submitUser = submitUser;
        this.source = source;
        this.triggerCondition = triggerCondition;
        this.expireCondition = expireCondition;
        this.actions = actions;
        this.expireActions = new ArrayList();
    }

    public Trigger(long lastModifyTime, long submitTime, String submitUser, String source, Condition triggerCondition, Condition expireCondition, List<TriggerAction> actions) {
        this.lastModifyTime = lastModifyTime;
        this.submitTime = submitTime;
        this.submitUser = submitUser;
        this.source = source;
        this.triggerCondition = triggerCondition;
        this.expireCondition = expireCondition;
        this.actions = actions;
        this.expireActions = new ArrayList();
    }

    public Trigger(int triggerId, long lastModifyTime, long submitTime, String submitUser, String source, Condition triggerCondition, Condition expireCondition, List<TriggerAction> actions, List<TriggerAction> expireActions, Map<String, Object> info, Map<String, Object> context) {
        this.triggerId = triggerId;
        this.lastModifyTime = lastModifyTime;
        this.submitTime = submitTime;
        this.submitUser = submitUser;
        this.source = source;
        this.triggerCondition = triggerCondition;
        this.expireCondition = expireCondition;
        this.actions = actions;
        this.expireActions = expireActions;
        this.info = info;
        this.context = context;
    }

    public Trigger(int triggerId, long lastModifyTime, long submitTime, String submitUser, String source, Condition triggerCondition, Condition expireCondition, List<TriggerAction> actions, List<TriggerAction> expireActions) {
        this.triggerId = triggerId;
        this.lastModifyTime = lastModifyTime;
        this.submitTime = submitTime;
        this.submitUser = submitUser;
        this.source = source;
        this.triggerCondition = triggerCondition;
        this.expireCondition = expireCondition;
        this.actions = actions;
        this.expireActions = expireActions;
    }

    public Trigger(int triggerId, long lastModifyTime, long submitTime, String submitUser, String source, Condition triggerCondition, Condition expireCondition, List<TriggerAction> actions) {
        this.triggerId = triggerId;
        this.lastModifyTime = lastModifyTime;
        this.submitTime = submitTime;
        this.submitUser = submitUser;
        this.source = source;
        this.triggerCondition = triggerCondition;
        this.expireCondition = expireCondition;
        this.actions = actions;
        this.expireActions = new ArrayList();
    }

    public static synchronized void setActionTypeLoader(ActionTypeLoader loader) {
        actionTypeLoader = loader;
    }

    public static ActionTypeLoader getActionTypeLoader() {
        return actionTypeLoader;
    }

    public boolean isResetOnTrigger() {
        return this.resetOnTrigger;
    }

    public void setResetOnTrigger(boolean resetOnTrigger) {
        this.resetOnTrigger = resetOnTrigger;
    }

    public boolean isResetOnExpire() {
        return this.resetOnExpire;
    }

    public void setResetOnExpire(boolean resetOnExpire) {
        this.resetOnExpire = resetOnExpire;
    }

    public long getLastModifyTime() {
        return this.lastModifyTime;
    }

    public void setLastModifyTime(long lastModifyTime) {
        this.lastModifyTime = lastModifyTime;
    }

    public void setTriggerId(int id) {
        this.triggerId = id;
    }

    public int getTriggerId() {
        return this.triggerId;
    }

    public boolean triggerConditionMet() {
        return this.triggerCondition.isMet();
    }

    public boolean expireConditionMet() {
        return this.expireCondition.isMet();
    }

    public void resetTriggerConditions() {
        this.triggerCondition.resetCheckers();
        this.updateNextCheckTime();
    }

    public void resetExpireCondition() {
        this.expireCondition.resetCheckers();
        this.updateNextCheckTime();
    }

    public List<TriggerAction> getTriggerActions() {
        return this.actions;
    }

    public Map<String, Object> toJson() {
        HashMap<String, Object> jsonObj = new HashMap<String, Object>();
        jsonObj.put("triggerCondition", this.triggerCondition.toJson());
        jsonObj.put("expireCondition", this.expireCondition.toJson());
        ArrayList actionsJson = new ArrayList();
        for (TriggerAction action : this.actions) {
            HashMap<String, Object> oneActionJson = new HashMap<String, Object>();
            oneActionJson.put("type", action.getType());
            oneActionJson.put("actionJson", action.toJson());
            actionsJson.add(oneActionJson);
        }
        jsonObj.put("actions", actionsJson);
        ArrayList expireActionsJson = new ArrayList();
        for (TriggerAction expireAction : this.expireActions) {
            HashMap<String, Object> oneExpireActionJson = new HashMap<String, Object>();
            oneExpireActionJson.put("type", expireAction.getType());
            oneExpireActionJson.put("actionJson", expireAction.toJson());
            expireActionsJson.add(oneExpireActionJson);
        }
        jsonObj.put("expireActions", expireActionsJson);
        jsonObj.put("resetOnTrigger", String.valueOf(this.resetOnTrigger));
        jsonObj.put("resetOnExpire", String.valueOf(this.resetOnExpire));
        jsonObj.put("submitUser", this.submitUser);
        jsonObj.put("source", this.source);
        jsonObj.put("submitTime", String.valueOf(this.submitTime));
        jsonObj.put("lastModifyTime", String.valueOf(this.lastModifyTime));
        jsonObj.put("triggerId", String.valueOf(this.triggerId));
        jsonObj.put("status", this.status.toString());
        jsonObj.put("info", this.info);
        jsonObj.put("context", this.context);
        return jsonObj;
    }

    public String getSource() {
        return this.source;
    }

    public static Trigger fromJson(Object obj) throws Exception {
        if (actionTypeLoader == null) {
            throw new Exception("Trigger Action Type loader not initialized.");
        }
        HashMap jsonObj = (HashMap)obj;
        Trigger trigger = null;
        try {
            logger.info((Object)("Decoding for " + JSONUtils.toJSON((Object)obj)));
            Condition triggerCond = Condition.fromJson(jsonObj.get("triggerCondition"));
            Condition expireCond = Condition.fromJson(jsonObj.get("expireCondition"));
            ArrayList<TriggerAction> actions = new ArrayList<TriggerAction>();
            List actionsJson = (List)jsonObj.get("actions");
            for (Object actObj : actionsJson) {
                HashMap oneActionJson = (HashMap)actObj;
                String type = (String)oneActionJson.get("type");
                TriggerAction act = actionTypeLoader.createActionFromJson(type, oneActionJson.get("actionJson"));
                actions.add(act);
            }
            ArrayList<TriggerAction> expireActions = new ArrayList<TriggerAction>();
            List expireActionsJson = (List)jsonObj.get("expireActions");
            for (Object expireActObj : expireActionsJson) {
                HashMap oneExpireActionJson = (HashMap)expireActObj;
                String type = (String)oneExpireActionJson.get("type");
                TriggerAction expireAct = actionTypeLoader.createActionFromJson(type, oneExpireActionJson.get("actionJson"));
                expireActions.add(expireAct);
            }
            boolean resetOnTrigger = Boolean.valueOf((String)jsonObj.get("resetOnTrigger"));
            boolean resetOnExpire = Boolean.valueOf((String)jsonObj.get("resetOnExpire"));
            String submitUser = (String)jsonObj.get("submitUser");
            String source = (String)jsonObj.get("source");
            long submitTime = Long.valueOf((String)jsonObj.get("submitTime"));
            long lastModifyTime = Long.valueOf((String)jsonObj.get("lastModifyTime"));
            int triggerId = Integer.valueOf((String)jsonObj.get("triggerId"));
            TriggerStatus status = TriggerStatus.valueOf((String)((String)jsonObj.get("status")));
            Map info = (Map)jsonObj.get("info");
            HashMap context = (HashMap)jsonObj.get("context");
            if (context == null) {
                context = new HashMap();
            }
            for (ConditionChecker checker : triggerCond.getCheckers().values()) {
                checker.setContext(context);
            }
            for (ConditionChecker checker : expireCond.getCheckers().values()) {
                checker.setContext(context);
            }
            for (TriggerAction action : actions) {
                action.setContext(context);
            }
            for (TriggerAction action : expireActions) {
                action.setContext(context);
            }
            trigger = new Trigger(triggerId, lastModifyTime, submitTime, submitUser, source, triggerCond, expireCond, actions, expireActions, info, context);
            trigger.setResetOnExpire(resetOnExpire);
            trigger.setResetOnTrigger(resetOnTrigger);
            trigger.setStatus(status);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"Failed to decode the trigger.", (Throwable)e);
            throw new Exception("Failed to decode the trigger.", e);
        }
        return trigger;
    }

    public String getDescription() {
        StringBuffer actionsString = new StringBuffer();
        for (TriggerAction act : this.actions) {
            actionsString.append(", ");
            actionsString.append(act.getDescription());
        }
        return "Trigger from " + this.getSource() + " with trigger condition of " + this.triggerCondition.getExpression() + " and expire condition of " + this.expireCondition.getExpression() + actionsString;
    }

    public void stopCheckers() {
        for (ConditionChecker checker : this.triggerCondition.getCheckers().values()) {
            checker.stopChecker();
        }
        for (ConditionChecker checker : this.expireCondition.getCheckers().values()) {
            checker.stopChecker();
        }
    }
}

