/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp.servlet;

import azkaban.project.ProjectManager;
import azkaban.user.Permission;
import azkaban.user.Role;
import azkaban.user.User;
import azkaban.user.UserManager;
import azkaban.webapp.AzkabanWebServer;
import azkaban.webapp.servlet.LoginAbstractAzkabanServlet;
import azkaban.webapp.servlet.Page;
import azkaban.webapp.session.Session;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ProjectServlet
extends LoginAbstractAzkabanServlet {
    private static final Logger logger = Logger.getLogger((String)ProjectServlet.class.getName());
    private static final String LOCKDOWN_CREATE_PROJECTS_KEY = "lockdown.create.projects";
    private static final long serialVersionUID = -1L;
    private UserManager userManager;
    private boolean lockdownCreateProjects = false;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        AzkabanWebServer server = (AzkabanWebServer)this.getApplication();
        this.userManager = server.getUserManager();
        this.lockdownCreateProjects = server.getServerProps().getBoolean(LOCKDOWN_CREATE_PROJECTS_KEY, false);
        if (this.lockdownCreateProjects) {
            logger.info((Object)"Creation of projects is locked down");
        }
    }

    protected void handleGet(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        String searchTerm;
        if (this.hasParam(req, "doaction") && this.getParam(req, "doaction").equals("search") && !(searchTerm = this.getParam(req, "searchterm")).equals("") && !searchTerm.equals(".*")) {
            this.handleFilter(req, resp, session, searchTerm);
            return;
        }
        User user = session.getUser();
        ProjectManager manager = ((AzkabanWebServer)this.getApplication()).getProjectManager();
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/index.vm");
        if (this.lockdownCreateProjects && !this.hasPermissionToCreateProject(user)) {
            page.add("hideCreateProject", (Object)true);
        }
        if (this.hasParam(req, "all")) {
            List projects = manager.getProjects();
            page.add("viewProjects", (Object)"all");
            page.add("projects", (Object)projects);
        } else if (this.hasParam(req, "group")) {
            List projects = manager.getGroupProjects(user);
            page.add("viewProjects", (Object)"group");
            page.add("projects", (Object)projects);
        } else {
            List projects = manager.getUserProjects(user);
            page.add("viewProjects", (Object)"personal");
            page.add("projects", (Object)projects);
        }
        page.render();
    }

    private void handleFilter(HttpServletRequest req, HttpServletResponse resp, Session session, String searchTerm) {
        User user = session.getUser();
        ProjectManager manager = ((AzkabanWebServer)this.getApplication()).getProjectManager();
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/index.vm");
        if (this.hasParam(req, "all")) {
            List projects = manager.getProjectsByRegex(searchTerm);
            page.add("allProjects", (Object)"");
            page.add("projects", (Object)projects);
            page.add("search_term", (Object)searchTerm);
        } else {
            List projects = manager.getUserProjectsByRegex(user, searchTerm);
            page.add("projects", (Object)projects);
            page.add("search_term", (Object)searchTerm);
        }
        page.render();
    }

    protected void handlePost(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
    }

    private boolean hasPermissionToCreateProject(User user) {
        for (String roleName : user.getRoles()) {
            Role role = this.userManager.getRole(roleName);
            Permission perm = role.getPermission();
            if (!perm.isPermissionSet(Permission.Type.ADMIN) && !perm.isPermissionSet(Permission.Type.CREATEPROJECTS)) continue;
            return true;
        }
        return false;
    }
}

