/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.utils.UndefinedPropertyException;
import azkaban.utils.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class Props {
    private final Map<String, String> _current = new HashMap();
    private Props _parent;
    private String source = null;

    public Props() {
        this(null);
    }

    public Props(Props parent) {
        this._parent = parent;
    }

    public Props(Props parent, String filepath) throws IOException {
        this(parent, new File(filepath));
    }

    public Props(Props parent, File file) throws IOException {
        this(parent);
        this.setSource(file.getPath());
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
        try {
            this.loadFrom((InputStream)input);
        }
        finally {
            ((InputStream)input).close();
        }
    }

    public Props(Props parent, InputStream inputStream) throws IOException {
        this(parent);
        this.loadFrom(inputStream);
    }

    private void loadFrom(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        this.put(properties);
    }

    public Props(Props parent, Map<String, String> ... props) {
        this(parent);
        int i = props.length - 1;
        while (i >= 0) {
            this.putAll(props[i]);
            --i;
        }
    }

    public Props(Props parent, Properties ... properties) {
        this(parent);
        int i = properties.length - 1;
        while (i >= 0) {
            this.put(properties[i]);
            --i;
        }
    }

    public Props(Props parent, Props props) {
        this(parent);
        if (props != null) {
            this.putAll(props);
        }
    }

    public void setEarliestAncestor(Props parent) {
        Props props = this.getEarliestAncestor();
        props.setParent(parent);
    }

    public Props getEarliestAncestor() {
        if (this._parent == null) {
            return this;
        }
        return this._parent.getEarliestAncestor();
    }

    public static Props of(String ... args) {
        return Props.of(null, (String[])args);
    }

    public static Props of(Props parent, String ... args) {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("Must have an equal number of keys and values.");
        }
        HashMap<String, String> vals = new HashMap<String, String>(args.length / 2);
        int i = 0;
        while (i < args.length) {
            vals.put(args[i], args[i + 1]);
            i += 2;
        }
        return new Props(parent, new Map[]{vals});
    }

    public void clearLocal() {
        this._current.clear();
    }

    public boolean containsKey(Object k) {
        return this._current.containsKey(k) || this._parent != null && this._parent.containsKey(k);
    }

    public boolean containsValue(Object value) {
        return this._current.containsValue(value) || this._parent != null && this._parent.containsValue(value);
    }

    public String get(Object key) {
        if (this._current.containsKey(key)) {
            return (String)this._current.get(key);
        }
        if (this._parent != null) {
            return this._parent.get(key);
        }
        return null;
    }

    public Set<String> localKeySet() {
        return this._current.keySet();
    }

    public Props getParent() {
        return this._parent;
    }

    public String put(String key, String value) {
        return this._current.put(key, value);
    }

    public void put(Properties properties) {
        for (String propName : properties.stringPropertyNames()) {
            this._current.put(propName, properties.getProperty(propName));
        }
    }

    public String put(String key, Integer value) {
        return this._current.put(key, value.toString());
    }

    public String put(String key, Long value) {
        return this._current.put(key, value.toString());
    }

    public String put(String key, Double value) {
        return this._current.put(key, value.toString());
    }

    public void putAll(Map<? extends String, ? extends String> m) {
        if (m == null) {
            return;
        }
        for (Map.Entry<? extends String, ? extends String> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(Props p) {
        if (p == null) {
            return;
        }
        for (String key : p.getKeySet()) {
            this.put(key, p.get((Object)key));
        }
    }

    public void putLocal(Props p) {
        for (String key : p.localKeySet()) {
            this.put(key, p.get((Object)key));
        }
    }

    public String removeLocal(Object s) {
        return (String)this._current.remove(s);
    }

    public int size() {
        return this.getKeySet().size();
    }

    public int localSize() {
        return this._current.size();
    }

    public Class<?> getClass(String key) {
        try {
            if (this.containsKey((Object)key)) {
                return Class.forName(this.get((Object)key));
            }
            throw new UndefinedPropertyException("Missing required property '" + key + "'");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Class<?> getClass(String key, boolean initialize, ClassLoader cl) {
        try {
            if (this.containsKey((Object)key)) {
                return Class.forName(this.get((Object)key), initialize, cl);
            }
            throw new UndefinedPropertyException("Missing required property '" + key + "'");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Class<?> getClass(String key, Class<?> defaultClass) {
        if (this.containsKey((Object)key)) {
            return this.getClass(key);
        }
        return defaultClass;
    }

    public String getString(String key, String defaultValue) {
        if (this.containsKey((Object)key)) {
            return this.get((Object)key);
        }
        return defaultValue;
    }

    public String getString(String key) {
        if (this.containsKey((Object)key)) {
            return this.get((Object)key);
        }
        throw new UndefinedPropertyException("Missing required property '" + key + "'");
    }

    public List<String> getStringList(String key) {
        return this.getStringList(key, "\\s*,\\s*");
    }

    public List<String> getStringList(String key, String sep) {
        String val = this.get((Object)key);
        if (val == null || val.trim().length() == 0) {
            return Collections.emptyList();
        }
        if (this.containsKey((Object)key)) {
            return Arrays.asList(val.split(sep));
        }
        throw new UndefinedPropertyException("Missing required property '" + key + "'");
    }

    public List<String> getStringList(String key, List<String> defaultValue) {
        if (this.containsKey((Object)key)) {
            return this.getStringList(key);
        }
        return defaultValue;
    }

    public List<String> getStringList(String key, List<String> defaultValue, String sep) {
        if (this.containsKey((Object)key)) {
            return this.getStringList(key, sep);
        }
        return defaultValue;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        if (this.containsKey((Object)key)) {
            return "true".equalsIgnoreCase(this.get((Object)key).trim());
        }
        return defaultValue;
    }

    public boolean getBoolean(String key) {
        if (this.containsKey((Object)key)) {
            return "true".equalsIgnoreCase(this.get((Object)key));
        }
        throw new UndefinedPropertyException("Missing required property '" + key + "'");
    }

    public long getLong(String name, long defaultValue) {
        if (this.containsKey((Object)name)) {
            return Long.parseLong(this.get((Object)name));
        }
        return defaultValue;
    }

    public long getLong(String name) {
        if (this.containsKey((Object)name)) {
            return Long.parseLong(this.get((Object)name));
        }
        throw new UndefinedPropertyException("Missing required property '" + name + "'");
    }

    public int getInt(String name, int defaultValue) {
        if (this.containsKey((Object)name)) {
            return Integer.parseInt(this.get((Object)name).trim());
        }
        return defaultValue;
    }

    public int getInt(String name) {
        if (this.containsKey((Object)name)) {
            return Integer.parseInt(this.get((Object)name).trim());
        }
        throw new UndefinedPropertyException("Missing required property '" + name + "'");
    }

    public double getDouble(String name, double defaultValue) {
        if (this.containsKey((Object)name)) {
            return Double.parseDouble(this.get((Object)name).trim());
        }
        return defaultValue;
    }

    public double getDouble(String name) {
        if (this.containsKey((Object)name)) {
            return Double.parseDouble(this.get((Object)name).trim());
        }
        throw new UndefinedPropertyException("Missing required property '" + name + "'");
    }

    public URI getUri(String name) {
        if (this.containsKey((Object)name)) {
            try {
                return new URI(this.get((Object)name));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        throw new UndefinedPropertyException("Missing required property '" + name + "'");
    }

    public URI getUri(String name, URI defaultValue) {
        if (this.containsKey((Object)name)) {
            return this.getUri(name);
        }
        return defaultValue;
    }

    public URI getUri(String name, String defaultValue) {
        try {
            return this.getUri(name, new URI(defaultValue));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void storeLocal(File file) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            this.storeLocal((OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    public Props local() {
        return new Props(null, new Map[]{this._current});
    }

    public void storeLocal(OutputStream out) throws IOException {
        Properties p = new Properties();
        for (String key : this._current.keySet()) {
            p.setProperty(key, this.get((Object)key));
        }
        p.store(out, null);
    }

    public Properties toProperties() {
        Properties p = new Properties();
        for (String key : this._current.keySet()) {
            p.setProperty(key, this.get((Object)key));
        }
        return p;
    }

    public void storeFlattened(File file) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            this.storeFlattened((OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    public void storeFlattened(OutputStream out) throws IOException {
        Properties p = new Properties();
        Props curr = this;
        while (curr != null) {
            for (String key : curr.localKeySet()) {
                if (p.containsKey(key)) continue;
                p.setProperty(key, this.get((Object)key));
            }
            curr = curr.getParent();
        }
        p.store(out, null);
    }

    public Map<String, String> getMapByPrefix(String prefix) {
        HashMap<String, String> values = new HashMap<String, String>();
        if (this._parent != null) {
            for (Map.Entry entry : this._parent.getMapByPrefix(prefix).entrySet()) {
                values.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        for (String string : this.localKeySet()) {
            if (!string.startsWith(prefix)) continue;
            values.put(string.substring(prefix.length()), this.get((Object)string));
        }
        return values;
    }

    public Set<String> getKeySet() {
        HashSet<String> keySet = new HashSet<String>();
        keySet.addAll(this.localKeySet());
        if (this._parent != null) {
            keySet.addAll(this._parent.getKeySet());
        }
        return keySet;
    }

    public void logProperties(Logger logger, String comment) {
        logger.info((Object)comment);
        for (String key : this.getKeySet()) {
            logger.info((Object)("  key=" + key + " value=" + this.get((Object)key)));
        }
    }

    public static Props clone(Props p) {
        return Props.copyNext((Props)p);
    }

    private static Props copyNext(Props source) {
        Props priorNodeCopy = null;
        if (source.getParent() != null) {
            priorNodeCopy = Props.copyNext((Props)source.getParent());
        }
        Props dest = new Props(priorNodeCopy);
        for (String key : source.localKeySet()) {
            dest.put(key, source.get((Object)key));
        }
        return dest;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != Props.class) {
            return false;
        }
        Props p = (Props)o;
        return this._current.equals(p._current) && Utils.equals((Object)this._parent, (Object)p._parent);
    }

    public boolean equalsProps(Props p) {
        if (p == null) {
            return false;
        }
        Set myKeySet = this.getKeySet();
        for (String s : myKeySet) {
            if (this.get((Object)s).equals(p.get((Object)s))) continue;
            return false;
        }
        return myKeySet.size() == p.getKeySet().size();
    }

    public int hashCode() {
        int code = this._current.hashCode();
        if (this._parent != null) {
            code += this._parent.hashCode();
        }
        return code;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        for (Map.Entry entry : this._current.entrySet()) {
            builder.append((String)entry.getKey());
            builder.append(": ");
            builder.append((String)entry.getValue());
            builder.append(", ");
        }
        if (this._parent != null) {
            builder.append(" parent = ");
            builder.append(this._parent.toString());
        }
        builder.append("}");
        return builder.toString();
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setParent(Props prop) {
        this._parent = prop;
    }
}

