/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.trigger;

import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManager;
import azkaban.executor.ExecutorManagerException;
import azkaban.test.execapp.MockExecutorLoader;
import azkaban.test.trigger.DummyTriggerAction;
import azkaban.test.trigger.MockTriggerLoader;
import azkaban.test.trigger.TriggerManagerDeadlockTest;
import azkaban.trigger.Condition;
import azkaban.trigger.Trigger;
import azkaban.trigger.TriggerLoader;
import azkaban.trigger.TriggerLoaderException;
import azkaban.trigger.TriggerManager;
import azkaban.trigger.TriggerManagerException;
import azkaban.trigger.builtin.CreateTriggerAction;
import azkaban.utils.Props;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TriggerManagerDeadlockTest {
    TriggerLoader loader;
    TriggerManager triggerManager;
    ExecutorLoader execLoader;

    @Before
    public void setup() throws ExecutorManagerException, TriggerManagerException {
        this.loader = new MockTriggerLoader();
        Props props = new Props();
        props.put("trigger.scan.interval", Integer.valueOf(1000));
        props.put("executor.port", Integer.valueOf(12321));
        this.execLoader = new MockExecutorLoader();
        HashMap alerters = new HashMap();
        ExecutorManager executorManager = new ExecutorManager(props, this.execLoader, alerters);
        this.triggerManager = new TriggerManager(props, this.loader, executorManager);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void deadlockTest() throws TriggerLoaderException, TriggerManagerException {
        int i = 0;
        while (i < 1000) {
            Trigger t = this.createSelfRegenTrigger();
            this.loader.addTrigger(t);
            ++i;
        }
        i = 0;
        while (i < 10000) {
            Trigger d = this.createDummyTrigger();
            this.triggerManager.insertTrigger(d);
            this.triggerManager.removeTrigger(d);
            ++i;
        }
        System.out.println("No dead lock.");
    }

    private Trigger createSelfRegenTrigger() {
        AlwaysOnChecker alwaysOnChecker = new AlwaysOnChecker(this, "alwaysOn", Boolean.TRUE);
        String triggerExpr = String.valueOf(alwaysOnChecker.getId()) + ".eval()";
        HashMap<String, AlwaysOnChecker> triggerCheckers = new HashMap<String, AlwaysOnChecker>();
        triggerCheckers.put(alwaysOnChecker.getId(), alwaysOnChecker);
        Condition triggerCond = new Condition(triggerCheckers, triggerExpr);
        CreateTriggerAction triggerAct = new CreateTriggerAction("dummyTrigger", this.createDummyTrigger());
        ArrayList<CreateTriggerAction> actions = new ArrayList<CreateTriggerAction>();
        actions.add(triggerAct);
        AlwaysOnChecker alwaysOffChecker = new AlwaysOnChecker(this, "alwaysOff", Boolean.FALSE);
        String expireExpr = String.valueOf(alwaysOffChecker.getId()) + ".eval()";
        HashMap<String, AlwaysOnChecker> expireCheckers = new HashMap<String, AlwaysOnChecker>();
        expireCheckers.put(alwaysOffChecker.getId(), alwaysOffChecker);
        Condition expireCond = new Condition(expireCheckers, expireExpr);
        Trigger t = new Trigger("azkaban", "azkabanTest", triggerCond, expireCond, actions);
        return t;
    }

    private Trigger createDummyTrigger() {
        AlwaysOnChecker alwaysOnChecker = new AlwaysOnChecker(this, "alwaysOn", Boolean.TRUE);
        String triggerExpr = String.valueOf(alwaysOnChecker.getId()) + ".eval()";
        HashMap<String, AlwaysOnChecker> triggerCheckers = new HashMap<String, AlwaysOnChecker>();
        triggerCheckers.put(alwaysOnChecker.getId(), alwaysOnChecker);
        Condition triggerCond = new Condition(triggerCheckers, triggerExpr);
        DummyTriggerAction triggerAct = new DummyTriggerAction("howdy!");
        ArrayList<DummyTriggerAction> actions = new ArrayList<DummyTriggerAction>();
        actions.add(triggerAct);
        AlwaysOnChecker alwaysOffChecker = new AlwaysOnChecker(this, "alwaysOff", Boolean.FALSE);
        String expireExpr = String.valueOf(alwaysOffChecker.getId()) + ".eval()";
        HashMap<String, AlwaysOnChecker> expireCheckers = new HashMap<String, AlwaysOnChecker>();
        expireCheckers.put(alwaysOffChecker.getId(), alwaysOffChecker);
        Condition expireCond = new Condition(expireCheckers, expireExpr);
        Trigger t = new Trigger("azkaban", "azkabanTest", triggerCond, expireCond, actions);
        return t;
    }
}

