/*
 * Decompiled with CFR 0.152.
 */
package azkaban.user;

import azkaban.user.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class User {
    private final String userid;
    private String email = "";
    private Set<String> roles = new HashSet();
    private Set<String> groups = new HashSet();
    private UserPermissions userPermissions;
    private HashMap<String, String> properties = new HashMap();

    public User(String userid) {
        this.userid = userid;
    }

    public String getUserId() {
        return this.userid;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public void setPermissions(UserPermissions checker) {
        this.userPermissions = checker;
    }

    public UserPermissions getPermissions() {
        return this.userPermissions;
    }

    public boolean hasPermission(String permission) {
        if (this.userPermissions == null) {
            return false;
        }
        return this.userPermissions.hasPermission(permission);
    }

    public List<String> getGroups() {
        return new ArrayList<String>(this.groups);
    }

    public void clearGroup() {
        this.groups.clear();
    }

    public void addGroup(String name) {
        this.groups.add(name);
    }

    public boolean isInGroup(String group) {
        return this.groups.contains(group);
    }

    public List<String> getRoles() {
        return new ArrayList<String>(this.roles);
    }

    public void addRole(String role) {
        this.roles.add(role);
    }

    public boolean hasRole(String role) {
        return this.roles.contains(role);
    }

    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    public String toString() {
        String groupStr = "[";
        for (String group : this.groups) {
            groupStr = String.valueOf(groupStr) + group + ",";
        }
        groupStr = String.valueOf(groupStr) + "]";
        return String.valueOf(this.userid) + ": " + groupStr;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.userid == null ? 0 : this.userid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return !(this.userid == null ? other.userid != null : !this.userid.equals(other.userid));
    }
}

