/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp.servlet;

import azkaban.project.Project;
import azkaban.user.Permission;
import azkaban.user.Role;
import azkaban.user.User;
import azkaban.user.UserManager;
import azkaban.user.UserManagerException;
import azkaban.webapp.servlet.AbstractAzkabanServlet;
import azkaban.webapp.servlet.MultipartParser;
import azkaban.webapp.servlet.Page;
import azkaban.webapp.session.Session;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public abstract class LoginAbstractAzkabanServlet
extends AbstractAzkabanServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)LoginAbstractAzkabanServlet.class.getName());
    private static final String SESSION_ID_NAME = "azkaban.browser.session.id";
    private static final int DEFAULT_UPLOAD_DISK_SPOOL_SIZE = 0x1400000;
    private static HashMap<String, String> contextType = new HashMap();
    private File webResourceDirectory = null;
    private MultipartParser multipartParser;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.multipartParser = new MultipartParser(0x1400000);
    }

    public void setResourceDirectory(File file) {
        this.webResourceDirectory = file;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Session session = this.getSessionFromRequest(req);
        if (this.hasParam(req, "logout")) {
            resp.sendRedirect(req.getContextPath());
            if (session != null) {
                this.getApplication().getSessionCache().removeSession(session.getSessionId());
            }
            return;
        }
        if (session != null) {
            logger.info((Object)("Found session " + session.getUser()));
            if (this.handleFileGet(req, resp)) {
                return;
            }
            this.handleGet(req, resp, session);
        } else if (this.hasParam(req, "ajax")) {
            HashMap<String, String> retVal = new HashMap<String, String>();
            retVal.put("error", "session");
            this.writeJSON(resp, retVal);
        } else {
            this.handleLogin(req, resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleFileGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.webResourceDirectory == null) {
            return false;
        }
        String prefix = req.getContextPath() + req.getServletPath();
        String path = req.getRequestURI().substring(prefix.length());
        int index = path.lastIndexOf(46);
        if (index == -1) {
            return false;
        }
        String extension = path.substring(index);
        if (contextType.containsKey(extension)) {
            File file = new File(this.webResourceDirectory, path);
            if (!file.exists() || !file.isFile()) {
                return false;
            }
            resp.setContentType(contextType.get(extension));
            ServletOutputStream output = resp.getOutputStream();
            BufferedInputStream input = null;
            try {
                input = new BufferedInputStream(new FileInputStream(file));
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
            output.flush();
            return true;
        }
        return false;
    }

    private Session getSessionFromRequest(HttpServletRequest req) throws ServletException {
        String remoteIp = req.getRemoteAddr();
        Cookie cookie = this.getCookieByName(req, SESSION_ID_NAME);
        String sessionId = null;
        if (cookie != null) {
            sessionId = cookie.getValue();
            logger.info((Object)("Session id " + sessionId));
        }
        if (sessionId == null && this.hasParam(req, "session.id")) {
            sessionId = this.getParam(req, "session.id");
        }
        return this.getSessionFromSessionId(sessionId, remoteIp);
    }

    private Session getSessionFromSessionId(String sessionId, String remoteIp) {
        if (sessionId == null) {
            return null;
        }
        Session session = this.getApplication().getSessionCache().getSession(sessionId);
        if (session == null || !remoteIp.equals(session.getIp())) {
            return null;
        }
        return session;
    }

    private void handleLogin(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleLogin(req, resp, null);
    }

    private void handleLogin(HttpServletRequest req, HttpServletResponse resp, String errorMsg) throws ServletException, IOException {
        Page page = this.newPage(req, resp, "azkaban/webapp/servlet/velocity/login.vm");
        if (errorMsg != null) {
            page.add("errorMsg", errorMsg);
        }
        page.render();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Session session = this.getSessionFromRequest(req);
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            Map<String, Object> params = this.multipartParser.parseMultipart(req);
            if (session == null) {
                String ip;
                String sessionId;
                if (params.containsKey("session.id") && (session = this.getSessionFromSessionId(sessionId = (String)params.get("session.id"), ip = req.getRemoteAddr())) != null) {
                    this.handleMultiformPost(req, resp, params, session);
                    return;
                }
                if (!params.containsKey("username") || !params.containsKey("password")) {
                    this.writeResponse(resp, "Login error. Need username and password");
                    return;
                }
                String username = (String)params.get("username");
                String password = (String)params.get("password");
                String ip2 = req.getRemoteAddr();
                try {
                    session = this.createSession(username, password, ip2);
                }
                catch (UserManagerException e) {
                    this.writeResponse(resp, "Login error: " + e.getMessage());
                    return;
                }
            }
            this.handleMultiformPost(req, resp, params, session);
        } else if (this.hasParam(req, "action") && this.getParam(req, "action").equals("login")) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            this.handleAjaxLoginAction(req, resp, obj);
            this.writeJSON(resp, obj);
        } else if (session == null) {
            if (this.hasParam(req, "username") && this.hasParam(req, "password")) {
                try {
                    session = this.createSession(req);
                }
                catch (UserManagerException e) {
                    this.writeResponse(resp, "Login error: " + e.getMessage());
                }
                this.handlePost(req, resp, session);
            } else if (this.isAjaxCall(req)) {
                String response = LoginAbstractAzkabanServlet.createJsonResponse("error", "Invalid Session. Need to re-login", "login", null);
                this.writeResponse(resp, response);
            } else {
                this.handleLogin(req, resp, "Enter username and password");
            }
        } else {
            this.handlePost(req, resp, session);
        }
    }

    private Session createSession(HttpServletRequest req) throws UserManagerException, ServletException {
        String username = this.getParam(req, "username");
        String password = this.getParam(req, "password");
        String ip = req.getRemoteAddr();
        return this.createSession(username, password, ip);
    }

    private Session createSession(String username, String password, String ip) throws UserManagerException, ServletException {
        UserManager manager = this.getApplication().getUserManager();
        User user = manager.getUser(username, password);
        String randomUID = UUID.randomUUID().toString();
        Session session = new Session(randomUID, user, ip);
        return session;
    }

    protected boolean hasPermission(Project project, User user, Permission.Type type) {
        UserManager userManager = this.getApplication().getUserManager();
        if (project.hasPermission(user, type)) {
            return true;
        }
        for (String roleName : user.getRoles()) {
            Role role = userManager.getRole(roleName);
            if (!role.getPermission().isPermissionSet(type) && !role.getPermission().isPermissionSet(Permission.Type.ADMIN)) continue;
            return true;
        }
        return false;
    }

    protected void handleAjaxLoginAction(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> ret) throws ServletException {
        if (this.hasParam(req, "username") && this.hasParam(req, "password")) {
            Session session = null;
            try {
                session = this.createSession(req);
            }
            catch (UserManagerException e) {
                ret.put("error", "Incorrect Login. " + e.getMessage());
                return;
            }
            Cookie cookie = new Cookie(SESSION_ID_NAME, session.getSessionId());
            cookie.setPath("/");
            resp.addCookie(cookie);
            this.getApplication().getSessionCache().addSession(session);
            ret.put("status", "success");
            ret.put("session.id", session.getSessionId());
        } else {
            ret.put("error", "Incorrect Login.");
        }
    }

    protected void writeResponse(HttpServletResponse resp, String response) throws IOException {
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).append(response);
        ((Writer)writer).flush();
    }

    protected boolean isAjaxCall(HttpServletRequest req) throws ServletException {
        String value = req.getHeader("X-Requested-With");
        if (value != null) {
            logger.info((Object)("has X-Requested-With " + value));
            return value.equals("XMLHttpRequest");
        }
        return false;
    }

    protected abstract void handleGet(HttpServletRequest var1, HttpServletResponse var2, Session var3) throws ServletException, IOException;

    protected abstract void handlePost(HttpServletRequest var1, HttpServletResponse var2, Session var3) throws ServletException, IOException;

    protected void handleMultiformPost(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> multipart, Session session) throws ServletException, IOException {
    }

    static {
        contextType.put(".js", "application/javascript");
        contextType.put(".css", "text/css");
        contextType.put(".png", "image/png");
        contextType.put(".jpeg", "image/jpeg");
        contextType.put(".jpg", "image/jpeg");
    }
}

