/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Properties;
import org.h2.mvstore.DataUtils;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;

public class MVStoreTool {
    public static void main(String ... stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!"-dump".equals(stringArray[i])) continue;
            String string = stringArray[++i];
            MVStoreTool.dump(string, new PrintWriter(System.out));
        }
    }

    public static void dump(String string, PrintWriter printWriter) throws IOException {
        if (!FileUtils.exists(string)) {
            printWriter.println("File not found: " + string);
            return;
        }
        FileChannel fileChannel = null;
        int n = 4096;
        try {
            fileChannel = FilePath.get(string).open("r");
            long l = fileChannel.size();
            byte[] byArray = new byte[n];
            fileChannel.read(ByteBuffer.wrap(byArray), 0L);
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(byArray));
            properties.load(new StringReader(new String(byArray, "UTF-8")));
            printWriter.println("file " + string);
            printWriter.println("    length " + l);
            printWriter.println("    " + properties);
            ByteBuffer byteBuffer = ByteBuffer.allocate(40);
            long l2 = 0L;
            while (l2 < l) {
                byteBuffer.rewind();
                DataUtils.readFully(fileChannel, l2, byteBuffer);
                byteBuffer.rewind();
                if (byteBuffer.get() != 99) {
                    l2 += (long)n;
                    continue;
                }
                int n2 = byteBuffer.getInt();
                int n3 = byteBuffer.getInt();
                int n4 = byteBuffer.getInt();
                long l3 = byteBuffer.getLong();
                long l4 = byteBuffer.getLong();
                long l5 = byteBuffer.getLong();
                printWriter.println("    chunk " + n3 + " at " + l2 + " length " + n2 + " pageCount " + n4 + " root " + l3 + " maxLength " + l4 + " maxLengthLive " + l5);
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n2);
                DataUtils.readFully(fileChannel, l2, byteBuffer2);
                int n5 = byteBuffer.position();
                l2 = (l2 + (long)n2 + (long)n) / (long)n * (long)n;
                n2 -= n5;
                while (n2 > 0) {
                    byteBuffer2.position(n5);
                    int n6 = byteBuffer2.getInt();
                    byteBuffer2.getShort();
                    long l6 = DataUtils.readVarInt(byteBuffer2);
                    int n7 = DataUtils.readVarInt(byteBuffer2);
                    byte by = byteBuffer2.get();
                    boolean bl = (by & 2) != 0;
                    boolean bl2 = (by & 1) != 0;
                    printWriter.println("        map " + l6 + " at " + n5 + " " + (bl2 ? "node" : "leaf") + " " + (bl ? "compressed " : "") + "len: " + n6 + " entries: " + n7);
                    n5 += n6;
                    n2 -= n6;
                }
            }
        }
        catch (IOException iOException) {
            printWriter.println("ERROR: " + iOException);
            throw iOException;
        }
        finally {
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
        printWriter.println();
        printWriter.flush();
    }
}

