/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.jobExecutor;

import azkaban.jobExecutor.ProcessJob;
import azkaban.utils.Props;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProcessJobTest {
    private ProcessJob job = null;
    private Props props = null;
    private Logger log = Logger.getLogger(ProcessJob.class);

    @Before
    public void setUp() {
        this.props = new Props();
        this.props.put("working.dir", ".");
        this.props.put("type", "command");
        this.props.put("fullPath", ".");
        this.job = new ProcessJob("TestProcess", this.props, this.props, this.log);
    }

    @Test
    public void testOneUnixCommand() throws Exception {
        this.props.put("command", "ls -al");
        this.props.put("working.dir", ".");
        this.job.run();
    }

    @Test
    public void testFailedUnixCommand() throws Exception {
        this.props.put("command", "xls -al");
        this.props.put("working.dir", ".");
        try {
            this.job.run();
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
            e.printStackTrace();
        }
    }

    @Test
    public void testMultipleUnixCommands() throws Exception {
        this.props.put("working.dir", ".");
        this.props.put("command", "pwd");
        this.props.put("command.1", "date");
        this.props.put("command.2", "whoami");
        this.job.run();
    }

    @Test
    public void testPartitionCommand() throws Exception {
        String test1 = "a b c";
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])ProcessJob.partitionCommandLine((String)test1));
        String test2 = "a 'b c'";
        Assert.assertArrayEquals((Object[])new String[]{"a", "b c"}, (Object[])ProcessJob.partitionCommandLine((String)test2));
        String test3 = "a e='b c'";
        Assert.assertArrayEquals((Object[])new String[]{"a", "e=b c"}, (Object[])ProcessJob.partitionCommandLine((String)test3));
    }
}

