/*
 * Decompiled with CFR 0.152.
 */
package azkaban.execapp;

import azkaban.execapp.FlowRunner;
import azkaban.execapp.JobRunner;
import azkaban.execapp.event.Event;
import azkaban.execapp.event.EventHandler;
import azkaban.execapp.event.EventListener;
import azkaban.execapp.event.FlowWatcher;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableFlowBase;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.flow.FlowProps;
import azkaban.jobtype.JobTypeManager;
import azkaban.project.ProjectLoader;
import azkaban.project.ProjectManagerException;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import azkaban.utils.SwapQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class FlowRunner
extends EventHandler
implements Runnable {
    private static final Layout DEFAULT_LAYOUT = new PatternLayout("%d{dd-MM-yyyy HH:mm:ss z} %c{1} %p - %m\n");
    private static final long CHECK_WAIT_MS = 300000L;
    private Logger logger;
    private Layout loggerLayout = DEFAULT_LAYOUT;
    private Appender flowAppender;
    private File logFile;
    private ExecutorService executorService;
    private ExecutorLoader executorLoader;
    private ProjectLoader projectLoader;
    private int execId;
    private File execDir;
    private final ExecutableFlow flow;
    private Thread flowRunnerThread;
    private int numJobThreads = 10;
    private ExecutionOptions.FailureAction failureAction;
    private Object mainSyncObj = new Object();
    private Map<String, Props> sharedProps = new HashMap();
    private Props globalProps;
    private final JobTypeManager jobtypeManager;
    private JobRunnerEventListener listener = new JobRunnerEventListener(this);
    private Set<JobRunner> activeJobRunners = Collections.newSetFromMap(new ConcurrentHashMap());
    private SwapQueue<ExecutableNode> finishedNodes;
    private Integer pipelineLevel = null;
    private Integer pipelineExecId = null;
    private FlowWatcher watcher = null;
    private Set<String> proxyUsers = null;
    private boolean validateUserProxy;
    private String jobLogFileSize = "5MB";
    private int jobLogNumFiles = 4;
    private boolean flowPaused = false;
    private boolean flowFailed = false;
    private boolean flowFinished = false;
    private boolean flowKilled = false;
    private boolean retryFailedJobs = false;
    private static /* synthetic */ int[] $SWITCH_TABLE$azkaban$executor$Status;

    public FlowRunner(ExecutableFlow flow, ExecutorLoader executorLoader, ProjectLoader projectLoader, JobTypeManager jobtypeManager) throws ExecutorManagerException {
        this(flow, executorLoader, projectLoader, jobtypeManager, null);
    }

    public FlowRunner(ExecutableFlow flow, ExecutorLoader executorLoader, ProjectLoader projectLoader, JobTypeManager jobtypeManager, ExecutorService executorService) throws ExecutorManagerException {
        this.execId = flow.getExecutionId();
        this.flow = flow;
        this.executorLoader = executorLoader;
        this.projectLoader = projectLoader;
        this.execDir = new File(flow.getExecutionPath());
        this.jobtypeManager = jobtypeManager;
        ExecutionOptions options = flow.getExecutionOptions();
        this.pipelineLevel = options.getPipelineLevel();
        this.pipelineExecId = options.getPipelineExecutionId();
        this.failureAction = options.getFailureAction();
        this.proxyUsers = flow.getProxyUsers();
        this.executorService = executorService;
        this.finishedNodes = new SwapQueue();
    }

    public FlowRunner setFlowWatcher(FlowWatcher watcher) {
        this.watcher = watcher;
        return this;
    }

    public FlowRunner setGlobalProps(Props globalProps) {
        this.globalProps = globalProps;
        return this;
    }

    public FlowRunner setNumJobThreads(int jobs) {
        this.numJobThreads = jobs;
        return this;
    }

    public FlowRunner setJobLogSettings(String jobLogFileSize, int jobLogNumFiles) {
        this.jobLogFileSize = jobLogFileSize;
        this.jobLogNumFiles = jobLogNumFiles;
        return this;
    }

    public FlowRunner setValidateProxyUser(boolean validateUserProxy) {
        this.validateUserProxy = validateUserProxy;
        return this;
    }

    public File getExecutionDir() {
        return this.execDir;
    }

    @Override
    public void run() {
        try {
            try {
                if (this.executorService == null) {
                    this.executorService = Executors.newFixedThreadPool(this.numJobThreads);
                }
                this.setupFlowExecution();
                this.flow.setStartTime(System.currentTimeMillis());
                this.updateFlowReference();
                this.logger.info((Object)"Updating initial flow directory.");
                this.updateFlow();
                this.logger.info((Object)"Fetching job and shared properties.");
                this.loadAllProperties();
                this.fireEventListeners(Event.create((Object)this, (Event.Type)Event.Type.FLOW_STARTED));
                this.runFlow();
            }
            catch (Throwable t) {
                if (this.logger != null) {
                    this.logger.error((Object)"An error has occurred during the running of the flow. Quiting.", t);
                }
                this.flow.setStatus(Status.FAILED);
                if (this.watcher != null) {
                    this.logger.info((Object)"Watcher is attached. Stopping watcher.");
                    this.watcher.stopWatcher();
                    this.logger.info((Object)("Watcher cancelled status is " + this.watcher.isWatchCancelled()));
                }
                this.flow.setEndTime(System.currentTimeMillis());
                this.logger.info((Object)("Setting end time for flow " + this.execId + " to " + System.currentTimeMillis()));
                this.closeLogger();
                this.updateFlow();
                this.fireEventListeners(Event.create((Object)this, (Event.Type)Event.Type.FLOW_FINISHED));
            }
        }
        finally {
            if (this.watcher != null) {
                this.logger.info((Object)"Watcher is attached. Stopping watcher.");
                this.watcher.stopWatcher();
                this.logger.info((Object)("Watcher cancelled status is " + this.watcher.isWatchCancelled()));
            }
            this.flow.setEndTime(System.currentTimeMillis());
            this.logger.info((Object)("Setting end time for flow " + this.execId + " to " + System.currentTimeMillis()));
            this.closeLogger();
            this.updateFlow();
            this.fireEventListeners(Event.create((Object)this, (Event.Type)Event.Type.FLOW_FINISHED));
        }
    }

    private void setupFlowExecution() {
        Map flowParam;
        int projectId = this.flow.getProjectId();
        int version = this.flow.getVersion();
        String flowId = this.flow.getFlowId();
        Props commonFlowProps = PropsUtils.addCommonFlowProperties((Props)this.globalProps, (ExecutableFlowBase)this.flow);
        if (this.flow.getJobSource() != null) {
            String source = this.flow.getJobSource();
            Props flowProps = (Props)this.sharedProps.get(source);
            flowProps.setParent(commonFlowProps);
            commonFlowProps = flowProps;
        }
        if ((flowParam = this.flow.getExecutionOptions().getFlowParameters()) != null && !flowParam.isEmpty()) {
            commonFlowProps = new Props(commonFlowProps, new Map[]{flowParam});
        }
        this.flow.setInputProps(commonFlowProps);
        this.createLogger(flowId);
        if (this.watcher != null) {
            this.watcher.setLogger(this.logger);
        }
        this.logger.info((Object)("Running execid:" + this.execId + " flow:" + flowId + " project:" + projectId + " version:" + version));
        if (this.pipelineExecId != null) {
            this.logger.info((Object)("Running simulateously with " + this.pipelineExecId + ". Pipelining level " + this.pipelineLevel));
        }
        this.flowRunnerThread = Thread.currentThread();
        this.flowRunnerThread.setName("FlowRunner-exec-" + this.flow.getExecutionId());
    }

    private void updateFlowReference() throws ExecutorManagerException {
        this.logger.info((Object)"Update active reference");
        if (!this.executorLoader.updateExecutableReference(this.execId, System.currentTimeMillis())) {
            throw new ExecutorManagerException("The executor reference doesn't exist. May have been killed prematurely.");
        }
    }

    private void updateFlow() {
        this.updateFlow(System.currentTimeMillis());
    }

    private synchronized void updateFlow(long time) {
        try {
            this.flow.setUpdateTime(time);
            this.executorLoader.updateExecutableFlow(this.flow);
        }
        catch (ExecutorManagerException e) {
            this.logger.error((Object)"Error updating flow.", (Throwable)e);
        }
    }

    private void createLogger(String flowId) {
        String loggerName = String.valueOf(this.execId) + "." + flowId;
        this.logger = Logger.getLogger((String)loggerName);
        String logName = "_flow." + loggerName + ".log";
        this.logFile = new File(this.execDir, logName);
        String absolutePath = this.logFile.getAbsolutePath();
        this.flowAppender = null;
        try {
            this.flowAppender = new FileAppender(this.loggerLayout, absolutePath, false);
            this.logger.addAppender(this.flowAppender);
        }
        catch (IOException e) {
            this.logger.error((Object)("Could not open log file in " + this.execDir), (Throwable)e);
        }
    }

    private void closeLogger() {
        if (this.logger != null) {
            this.logger.removeAppender(this.flowAppender);
            this.flowAppender.close();
            try {
                this.executorLoader.uploadLogFile(this.execId, "", 0, new File[]{this.logFile});
            }
            catch (ExecutorManagerException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadAllProperties() throws IOException {
        Props props;
        String source;
        for (FlowProps fprops : this.flow.getFlowProps()) {
            source = fprops.getSource();
            File propsPath = new File(this.execDir, source);
            props = new Props(null, propsPath);
            this.sharedProps.put(source, props);
        }
        for (FlowProps fprops : this.flow.getFlowProps()) {
            if (fprops.getInheritedSource() == null) continue;
            source = fprops.getSource();
            String inherit = fprops.getInheritedSource();
            props = (Props)this.sharedProps.get(source);
            Props inherits = (Props)this.sharedProps.get(inherit);
            props.setParent(inherits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFlow() throws Exception {
        this.logger.info((Object)"Starting flows");
        this.runReadyJob((ExecutableNode)this.flow);
        this.updateFlow();
        while (!this.flowFinished) {
            Object object = this.mainSyncObj;
            synchronized (object) {
                if (this.flowPaused) {
                    try {
                        this.mainSyncObj.wait(300000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
                if (this.retryFailedJobs) {
                    this.retryAllFailures();
                } else if (!this.progressGraph()) {
                    try {
                        this.mainSyncObj.wait(300000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        this.logger.info((Object)"Finishing up flow. Awaiting Termination");
        this.executorService.shutdown();
        this.updateFlow();
        this.logger.info((Object)"Finished Flow");
    }

    private void retryAllFailures() throws IOException {
        this.logger.info((Object)"Restarting all failed jobs");
        this.retryFailedJobs = false;
        this.flowKilled = false;
        this.flowFailed = false;
        this.flow.setStatus(Status.RUNNING);
        ArrayList retryJobs = new ArrayList();
        this.resetFailedState((ExecutableFlowBase)this.flow, retryJobs);
        for (ExecutableNode node : retryJobs) {
            if (node.getStatus() == Status.READY || node.getStatus() == Status.DISABLED) {
                this.runReadyJob(node);
            } else if (node.getStatus() == Status.SUCCEEDED) {
                for (String outNodeId : node.getOutNodes()) {
                    ExecutableFlowBase base = node.getParentFlow();
                    this.runReadyJob(base.getExecutableNode(outNodeId));
                }
            }
            this.runReadyJob(node);
        }
        this.updateFlow();
    }

    private boolean progressGraph() throws IOException {
        this.finishedNodes.swap();
        HashSet<ExecutableNode> nodesToCheck = new HashSet<ExecutableNode>();
        for (ExecutableNode node : this.finishedNodes) {
            Set outNodeIds = node.getOutNodes();
            ExecutableFlowBase parentFlow = node.getParentFlow();
            if (node.getStatus() == Status.FAILED) {
                if (!this.retryJobIfPossible(node)) {
                    this.propagateStatus(node.getParentFlow(), Status.FAILED_FINISHING);
                    if (this.failureAction == ExecutionOptions.FailureAction.CANCEL_ALL) {
                        this.kill();
                    }
                    this.flowFailed = true;
                } else {
                    nodesToCheck.add(node);
                    continue;
                }
            }
            if (outNodeIds.isEmpty()) {
                this.finalizeFlow(parentFlow);
                this.finishExecutableNode((ExecutableNode)parentFlow);
                if (!(parentFlow instanceof ExecutableFlow)) {
                    outNodeIds = parentFlow.getOutNodes();
                    parentFlow = parentFlow.getParentFlow();
                }
            }
            for (String nodeId : outNodeIds) {
                ExecutableNode outNode = parentFlow.getExecutableNode(nodeId);
                nodesToCheck.add(outNode);
            }
        }
        boolean jobsRun = false;
        for (ExecutableNode node : nodesToCheck) {
            if (Status.isStatusFinished((Status)node.getStatus()) || Status.isStatusRunning((Status)node.getStatus())) continue;
            jobsRun |= this.runReadyJob(node);
        }
        if (jobsRun || this.finishedNodes.getSize() > 0) {
            this.updateFlow();
            return true;
        }
        return false;
    }

    private boolean runReadyJob(ExecutableNode node) throws IOException {
        if (Status.isStatusFinished((Status)node.getStatus()) || Status.isStatusRunning((Status)node.getStatus())) {
            return false;
        }
        Status nextNodeStatus = this.getImpliedStatus(node);
        if (nextNodeStatus == null) {
            return false;
        }
        if (nextNodeStatus == Status.CANCELLED) {
            this.logger.info((Object)("Cancelling '" + node.getNestedId() + "' due to prior errors."));
            node.cancelNode(System.currentTimeMillis());
            this.finishExecutableNode(node);
        } else if (nextNodeStatus == Status.SKIPPED) {
            this.logger.info((Object)("Skipping disabled job '" + node.getId() + "'."));
            node.skipNode(System.currentTimeMillis());
            this.finishExecutableNode(node);
        } else if (nextNodeStatus == Status.READY) {
            if (node instanceof ExecutableFlowBase) {
                ExecutableFlowBase flow = (ExecutableFlowBase)node;
                this.logger.info((Object)("Running flow '" + flow.getNestedId() + "'."));
                flow.setStatus(Status.RUNNING);
                flow.setStartTime(System.currentTimeMillis());
                this.prepareJobProperties((ExecutableNode)flow);
                for (String startNodeId : ((ExecutableFlowBase)node).getStartNodes()) {
                    ExecutableNode startNode = flow.getExecutableNode(startNodeId);
                    this.runReadyJob(startNode);
                }
            } else {
                this.runExecutableNode(node);
            }
        }
        return true;
    }

    private boolean retryJobIfPossible(ExecutableNode node) {
        if (node instanceof ExecutableFlowBase) {
            return false;
        }
        if (node.getRetries() > node.getAttempt()) {
            this.logger.info((Object)("Job '" + node.getId() + "' will be retried. Attempt " + node.getAttempt() + " of " + node.getRetries()));
            node.setDelayedExecution(node.getRetryBackoff());
            node.resetForRetry();
            return true;
        }
        if (node.getRetries() > 0) {
            this.logger.info((Object)("Job '" + node.getId() + "' has run out of retry attempts"));
            node.setDelayedExecution(0L);
        }
        return false;
    }

    private void propagateStatus(ExecutableFlowBase base, Status status) {
        if (!Status.isStatusFinished((Status)base.getStatus())) {
            this.logger.info((Object)("Setting " + base.getNestedId() + " to " + status));
            base.setStatus(status);
            if (base.getParentFlow() != null) {
                this.propagateStatus(base.getParentFlow(), status);
            }
        }
    }

    private void finishExecutableNode(ExecutableNode node) {
        this.finishedNodes.add((Object)node);
        this.fireEventListeners(Event.create((Object)this, (Event.Type)Event.Type.JOB_FINISHED, (Object)node));
    }

    /*
     * Exception decompiling
     */
    private void finalizeFlow(ExecutableFlowBase flow) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void prepareJobProperties(ExecutableNode node) throws IOException {
        Props jobSource;
        Props outputProps;
        Map flowParam;
        Props shared;
        String sharedProps;
        if (node instanceof ExecutableFlow) {
            return;
        }
        Props props = null;
        ExecutableFlowBase parentFlow = node.getParentFlow();
        if (parentFlow != null) {
            props = parentFlow.getInputProps();
        }
        if ((sharedProps = node.getPropsSource()) != null && (shared = (Props)this.sharedProps.get(sharedProps)) != null) {
            shared = Props.clone((Props)shared);
            shared.setEarliestAncestor(props);
            props = shared;
        }
        if ((flowParam = this.flow.getExecutionOptions().getFlowParameters()) != null && !flowParam.isEmpty()) {
            props = new Props(props, new Map[]{flowParam});
        }
        if ((outputProps = this.collectOutputProps(node)) != null) {
            outputProps.setEarliestAncestor(props);
            props = outputProps;
        }
        if ((jobSource = this.loadJobProps(node)) != null) {
            jobSource.setParent(props);
            props = jobSource;
        }
        node.setInputProps(props);
    }

    private Props loadJobProps(ExecutableNode node) throws IOException {
        Props props = null;
        String source = node.getJobSource();
        if (source == null) {
            return null;
        }
        try {
            props = this.projectLoader.fetchProjectProperty(this.flow.getProjectId(), this.flow.getVersion(), String.valueOf(node.getId()) + ".jor");
        }
        catch (ProjectManagerException e) {
            e.printStackTrace();
            this.logger.error((Object)("Error loading job override property for job " + node.getId()));
        }
        File path = new File(this.execDir, source);
        if (props == null) {
            try {
                props = new Props(null, path);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.logger.error((Object)("Error loading job file " + source + " for job " + node.getId()));
            }
        }
        if (path.getPath() != null) {
            props.setSource(path.getPath());
        }
        return props;
    }

    private void runExecutableNode(ExecutableNode node) throws IOException {
        this.prepareJobProperties(node);
        node.setStatus(Status.QUEUED);
        JobRunner runner = this.createJobRunner(node);
        this.logger.info((Object)("Submitting job '" + node.getNestedId() + "' to run."));
        try {
            this.executorService.submit((Runnable)runner);
            this.activeJobRunners.add(runner);
        }
        catch (RejectedExecutionException e) {
            this.logger.error((Object)e);
        }
    }

    public Status getImpliedStatus(ExecutableNode node) {
        if (Status.isStatusRunning((Status)node.getStatus()) || node.getStatus() == Status.SUCCEEDED) {
            return null;
        }
        ExecutableFlowBase flow = node.getParentFlow();
        boolean shouldKill = false;
        for (String dependency : node.getInNodes()) {
            ExecutableNode dependencyNode = flow.getExecutableNode(dependency);
            Status depStatus = dependencyNode.getStatus();
            if (!Status.isStatusFinished((Status)depStatus)) {
                return null;
            }
            if (depStatus != Status.FAILED && depStatus != Status.CANCELLED && depStatus != Status.KILLED) continue;
            shouldKill = true;
        }
        if (node.getStatus() == Status.DISABLED || node.getStatus() == Status.SKIPPED) {
            return Status.SKIPPED;
        }
        if (this.flowFailed && this.failureAction == ExecutionOptions.FailureAction.FINISH_CURRENTLY_RUNNING) {
            return Status.CANCELLED;
        }
        if (shouldKill || this.isKilled()) {
            return Status.CANCELLED;
        }
        return Status.READY;
    }

    private Props collectOutputProps(ExecutableNode node) {
        Props previousOutput = null;
        for (String dependency : node.getInNodes()) {
            Props output = node.getParentFlow().getExecutableNode(dependency).getOutputProps();
            if (output == null) continue;
            output = Props.clone((Props)output);
            output.setParent(previousOutput);
            previousOutput = output;
        }
        return previousOutput;
    }

    private JobRunner createJobRunner(ExecutableNode node) {
        File path = new File(this.execDir, node.getJobSource());
        JobRunner jobRunner = new JobRunner(node, path.getParentFile(), this.executorLoader, this.jobtypeManager);
        if (this.watcher != null) {
            jobRunner.setPipeline(this.watcher, this.pipelineLevel.intValue());
        }
        if (this.validateUserProxy) {
            jobRunner.setValidatedProxyUsers(this.proxyUsers);
        }
        jobRunner.setDelayStart(node.getDelayedExecution());
        jobRunner.setLogSettings(this.logger, this.jobLogFileSize, this.jobLogNumFiles);
        jobRunner.addListener((EventListener)this.listener);
        return jobRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(String user) {
        Object object = this.mainSyncObj;
        synchronized (object) {
            if (!this.flowFinished) {
                this.logger.info((Object)("Flow paused by " + user));
                this.flowPaused = true;
                this.flow.setStatus(Status.PAUSED);
                this.updateFlow();
            } else {
                this.logger.info((Object)("Cannot pause finished flow. Called by user " + user));
            }
        }
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(String user) {
        Object object = this.mainSyncObj;
        synchronized (object) {
            if (!this.flowPaused) {
                this.logger.info((Object)"Cannot resume flow that isn't paused");
            } else {
                this.logger.info((Object)("Flow resumed by " + user));
                this.flowPaused = false;
                if (this.flowFailed) {
                    this.flow.setStatus(Status.FAILED_FINISHING);
                } else if (this.flowKilled) {
                    this.flow.setStatus(Status.KILLED);
                } else {
                    this.flow.setStatus(Status.RUNNING);
                }
                this.updateFlow();
            }
        }
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(String user) {
        Object object = this.mainSyncObj;
        synchronized (object) {
            this.logger.info((Object)("Flow killed by " + user));
            this.flow.setStatus(Status.KILLED);
            this.kill();
            this.updateFlow();
        }
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kill() {
        Object object = this.mainSyncObj;
        synchronized (object) {
            this.logger.info((Object)("Kill has been called on flow " + this.execId));
            this.flowPaused = false;
            this.flowKilled = true;
            if (this.watcher != null) {
                this.logger.info((Object)"Watcher is attached. Stopping watcher.");
                this.watcher.stopWatcher();
                this.logger.info((Object)("Watcher cancelled status is " + this.watcher.isWatchCancelled()));
            }
            this.logger.info((Object)("Killing " + this.activeJobRunners.size() + " jobs."));
            for (JobRunner runner : this.activeJobRunners) {
                runner.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryFailures(String user) {
        Object object = this.mainSyncObj;
        synchronized (object) {
            this.logger.info((Object)("Retrying failures invoked by " + user));
            this.retryFailedJobs = true;
            this.interrupt();
        }
    }

    /*
     * Exception decompiling
     */
    private void resetFailedState(ExecutableFlowBase flow, List<ExecutableNode> nodesToRetry) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void interrupt() {
        this.flowRunnerThread.interrupt();
    }

    public boolean isKilled() {
        return this.flowKilled;
    }

    public ExecutableFlow getExecutableFlow() {
        return this.flow;
    }

    public File getFlowLogFile() {
        return this.logFile;
    }

    public File getJobLogFile(String jobId, int attempt) {
        ExecutableNode node = this.flow.getExecutableNodePath(jobId);
        File path = new File(this.execDir, node.getJobSource());
        String logFileName = JobRunner.createLogFileName((ExecutableNode)node, (int)attempt);
        File logFile = new File(path.getParentFile(), logFileName);
        if (!logFile.exists()) {
            return null;
        }
        return logFile;
    }

    public File getJobAttachmentFile(String jobId, int attempt) {
        ExecutableNode node = this.flow.getExecutableNodePath(jobId);
        File path = new File(this.execDir, node.getJobSource());
        String attachmentFileName = JobRunner.createAttachmentFileName((ExecutableNode)node, (int)attempt);
        File attachmentFile = new File(path.getParentFile(), attachmentFileName);
        if (!attachmentFile.exists()) {
            return null;
        }
        return attachmentFile;
    }

    public File getJobMetaDataFile(String jobId, int attempt) {
        ExecutableNode node = this.flow.getExecutableNodePath(jobId);
        File path = new File(this.execDir, node.getJobSource());
        String metaDataFileName = JobRunner.createMetaDataFileName((ExecutableNode)node, (int)attempt);
        File metaDataFile = new File(path.getParentFile(), metaDataFileName);
        if (!metaDataFile.exists()) {
            return null;
        }
        return metaDataFile;
    }

    public boolean isRunnerThreadAlive() {
        if (this.flowRunnerThread != null) {
            return this.flowRunnerThread.isAlive();
        }
        return false;
    }

    public boolean isThreadPoolShutdown() {
        return this.executorService.isShutdown();
    }

    public int getNumRunningJobs() {
        return this.activeJobRunners.size();
    }

    static /* synthetic */ void access$0(FlowRunner flowRunner) {
        flowRunner.updateFlow();
    }

    static /* synthetic */ Object access$1(FlowRunner flowRunner) {
        return flowRunner.mainSyncObj;
    }

    static /* synthetic */ Logger access$2(FlowRunner flowRunner) {
        return flowRunner.logger;
    }

    static /* synthetic */ boolean access$3(FlowRunner flowRunner) {
        return flowRunner.flowPaused;
    }

    static /* synthetic */ ExecutionOptions.FailureAction access$4(FlowRunner flowRunner) {
        return flowRunner.failureAction;
    }

    static /* synthetic */ void access$5(FlowRunner flowRunner, boolean bl) {
        flowRunner.flowPaused = bl;
    }

    static /* synthetic */ SwapQueue access$6(FlowRunner flowRunner) {
        return flowRunner.finishedNodes;
    }

    static /* synthetic */ void access$7(FlowRunner flowRunner) {
        flowRunner.interrupt();
    }

    static /* synthetic */ int[] $SWITCH_TABLE$azkaban$executor$Status() {
        if ($SWITCH_TABLE$azkaban$executor$Status != null) {
            return $SWITCH_TABLE$azkaban$executor$Status;
        }
        int[] nArray = new int[Status.values().length];
        try {
            nArray[Status.CANCELLED.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.DISABLED.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.FAILED.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.FAILED_FINISHING.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.FAILED_SUCCEEDED.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.KILLED.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.PAUSED.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.PREPARING.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.QUEUED.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.READY.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.RUNNING.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.SKIPPED.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.SUCCEEDED.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$azkaban$executor$Status = nArray;
        return nArray;
    }
}

