/*
 * Decompiled with CFR 0.152.
 */
package azkaban.jobExecutor;

import azkaban.jobExecutor.AbstractProcessJob;
import azkaban.jobExecutor.utils.process.AzkabanProcess;
import azkaban.jobExecutor.utils.process.AzkabanProcessBuilder;
import azkaban.utils.Props;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class LongArgJob
extends AbstractProcessJob {
    private static final long KILL_TIME_MS = 5000L;
    private final AzkabanProcessBuilder builder;
    private volatile AzkabanProcess process;

    public LongArgJob(String jobid, String[] command, Props sysProps, Props jobProps, Logger log) {
        this(jobid, command, sysProps, jobProps, log, new HashSet<String>(0));
    }

    public LongArgJob(String jobid, String[] command, Props sysProps, Props jobProp, Logger log, Set<String> suppressedKeys) {
        super(jobid, sysProps, jobProp, log);
        this.builder = new AzkabanProcessBuilder(command).setEnv(this.getJobProps().getMapByPrefix("env.")).setWorkingDir(this.getCwd()).setLogger(this.getLog());
        this.appendProps(suppressedKeys);
    }

    @Override
    public void run() throws Exception {
        try {
            this.resolveProps();
        }
        catch (Exception e) {
            this.error("Bad property definition! " + e.getMessage());
        }
        long startMs = System.currentTimeMillis();
        this.info("Command: " + this.builder.getCommandString());
        if (this.builder.getEnv().size() > 0) {
            this.info("Environment variables: " + this.builder.getEnv());
        }
        this.info("Working directory: " + this.builder.getWorkingDir());
        File[] propFiles = this.initPropsFiles();
        boolean success = false;
        this.process = this.builder.build();
        try {
            this.process.run();
            success = true;
            this.process = null;
            this.info("Process completed " + (success ? "successfully" : "unsuccessfully") + " in " + (System.currentTimeMillis() - startMs) / 1000L + " seconds.");
        }
        catch (Exception e) {
            try {
                for (File file : propFiles) {
                    if (file == null || !file.exists()) continue;
                    file.delete();
                }
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.process = null;
                this.info("Process completed " + (success ? "successfully" : "unsuccessfully") + " in " + (System.currentTimeMillis() - startMs) / 1000L + " seconds.");
                throw throwable;
            }
        }
        this.generateProperties(propFiles[1]);
        for (File file : propFiles) {
            if (file == null || !file.exists()) continue;
            file.delete();
        }
    }

    protected AzkabanProcessBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public void cancel() throws InterruptedException {
        if (this.process == null) {
            throw new IllegalStateException("Not started.");
        }
        boolean killed = this.process.softKill(5000L, TimeUnit.MILLISECONDS);
        if (!killed) {
            this.warn("Kill with signal TERM failed. Killing with KILL signal.");
            this.process.hardKill();
        }
    }

    @Override
    public double getProgress() {
        return this.process != null && this.process.isComplete() ? 1.0 : 0.0;
    }

    private void appendProps(Set<String> suppressed) {
        AzkabanProcessBuilder builder = this.getBuilder();
        Props props = this.getJobProps();
        for (String key : props.getKeySet()) {
            if (suppressed.contains(key)) continue;
            builder.addArg("--" + key, props.get(key));
        }
    }
}

