/*
 * Decompiled with CFR 0.152.
 */
package azkaban.sla;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutorManager;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.sla.SLA;
import azkaban.sla.SLALoader;
import azkaban.sla.SLAManagerException;
import azkaban.sla.SlaMailer;
import azkaban.utils.Props;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;

public class SLAManager {
    private static Logger logger = Logger.getLogger(SLAManager.class);
    private SLALoader loader;
    private final SLARunner runner;
    private final ExecutorManager executorManager;
    private SlaMailer mailer;
    private long lastCheckTime = -1L;

    public SLAManager(ExecutorManager executorManager, SLALoader loader, Props props) throws SLAManagerException {
        this.executorManager = executorManager;
        this.loader = loader;
        this.mailer = new SlaMailer(props);
        this.runner = new SLARunner();
        List<SLA> SLAList = null;
        SLAList = loader.loadSLAs();
        for (SLA sla : SLAList) {
            this.runner.addRunnerSLA(sla);
        }
        this.runner.start();
    }

    public void shutdown() {
        this.runner.shutdown();
    }

    public void removeSLA(SLA s) throws SLAManagerException {
        logger.info((Object)("Removing SLA " + s.toString()));
        this.runner.removeRunnerSLA(s);
        this.loader.removeSLA(s);
    }

    public void submitSla(int execId, String id, DateTime checkTime, List<String> emails, List<SLA.SlaAction> slaActions, List<SLA.SlaSetting> jobSettings, SLA.SlaRule slaRule) throws SLAManagerException {
        SLA s = new SLA(execId, id, checkTime, emails, slaActions, jobSettings, slaRule);
        logger.info((Object)("Submitting SLA " + s.toString()));
        try {
            this.loader.insertSLA(s);
            this.runner.addRunnerSLA(s);
        }
        catch (SLAManagerException e) {
            throw new SLAManagerException("Failed to add new SLA!" + e.getCause());
        }
    }

    private void takeSLAFailActions(SLA s, ExecutableFlow exflow) {
        logger.info((Object)("SLA " + s.toString() + " missed! Taking predefined actions"));
        List<SLA.SlaAction> actions = s.getActions();
        for (SLA.SlaAction act : actions) {
            if (act.equals((Object)SLA.SlaAction.EMAIL)) {
                try {
                    this.sendSlaAlertEmail(s, exflow);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to send out SLA alert email. " + e.getCause()));
                }
                continue;
            }
            if (!act.equals((Object)SLA.SlaAction.KILL)) continue;
            try {
                this.executorManager.cancelFlow(exflow, "azkaban");
                this.sendSlaKillEmail(s, exflow);
            }
            catch (ExecutorManagerException e) {
                logger.error((Object)("Cancel flow failed." + e.getCause()));
            }
        }
    }

    private void takeSLASuccessActions(SLA s, ExecutableFlow exflow) {
    }

    private void sendSlaAlertEmail(SLA s, ExecutableFlow exflow) {
        String message = null;
        switch (s.getRule()) {
            case FINISH: {
                if (s.getJobName().equals("")) {
                    message = "Flow " + exflow.getFlowId() + " failed to finish with set SLA." + String.format("%n", new Object[0]);
                    message = message + "Flow started at " + new DateTime(exflow.getStartTime()).toDateTimeISO() + String.format("%n", new Object[0]);
                    message = message + "Flow status at " + s.getCheckTime().toDateTimeISO() + " is " + (Object)((Object)exflow.getStatus());
                    break;
                }
                ExecutableNode exnode = exflow.getExecutableNode(s.getJobName());
                message = "Job " + s.getJobName() + " of flow " + exflow.getFlowId() + " failed to finish with set SLA." + String.format("%n", new Object[0]);
                message = message + "Job started at " + new DateTime(exnode.getStartTime()).toDateTimeISO() + String.format("%n", new Object[0]);
                message = message + "Job status at " + s.getCheckTime().toDateTimeISO() + " is " + (Object)((Object)exnode.getStatus());
                break;
            }
            case SUCCESS: {
                if (s.getJobName().equals("")) {
                    message = "Flow " + exflow.getFlowId() + " didn't finish successfully with set SLA. " + String.format("%n", new Object[0]);
                    message = message + "Flow started at " + new DateTime(exflow.getStartTime()).toDateTimeISO() + String.format("  %n", new Object[0]);
                    message = message + "Flow status at " + s.getCheckTime().toDateTimeISO() + " is " + (Object)((Object)exflow.getStatus());
                    break;
                }
                ExecutableNode exnode = exflow.getExecutableNode(s.getJobName());
                message = "Job " + s.getJobName() + " of flow " + exflow.getFlowId() + " didn't finish successfully with set SLA." + String.format("%n", new Object[0]);
                message = message + "Job started at " + new DateTime(exnode.getStartTime()).toDateTimeISO() + String.format("%n", new Object[0]);
                message = message + "Job status at " + s.getCheckTime().toDateTimeISO() + " is " + (Object)((Object)exnode.getStatus());
                break;
            }
            default: {
                logger.error((Object)"Unknown SLA rules!");
                message = "Unknown SLA was not met!";
            }
        }
        this.mailer.sendSlaEmail(s, message);
    }

    private void sendSlaSuccessEmail(SLA s, ExecutableFlow exflow) {
        String message = null;
        switch (s.getRule()) {
            case FINISH: {
                if (s.getJobName().equals("")) {
                    message = "Flow " + exflow.getFlowId() + " finished within the set SLA." + String.format("%n", new Object[0]);
                    message = message + "Flow started at " + new DateTime(exflow.getStartTime()).toDateTimeISO() + String.format("%n", new Object[0]);
                    message = message + "Flow status at " + s.getCheckTime().toDateTimeISO() + " is " + (Object)((Object)exflow.getStatus());
                    break;
                }
                ExecutableNode exnode = exflow.getExecutableNode(s.getJobName());
                message = "Job " + s.getJobName() + " of flow " + exflow.getFlowId() + " finished within the set SLA." + String.format("%n", new Object[0]);
                message = message + "Job started at " + new DateTime(exnode.getStartTime()).toDateTimeISO() + String.format("%n", new Object[0]);
                message = message + "Job status at " + s.getCheckTime().toDateTimeISO() + " is " + (Object)((Object)exnode.getStatus());
                break;
            }
            case SUCCESS: {
                if (s.getJobName().equals("")) {
                    message = "Flow " + exflow.getFlowId() + " successfully finished within the set SLA." + String.format("%n", new Object[0]);
                    message = message + "Flow started at " + new DateTime(exflow.getStartTime()).toDateTimeISO() + String.format("  %n", new Object[0]);
                    message = message + "Flow status at " + s.getCheckTime().toDateTimeISO() + " is " + (Object)((Object)exflow.getStatus());
                    break;
                }
                ExecutableNode exnode = exflow.getExecutableNode(s.getJobName());
                message = "Job " + s.getJobName() + " of flow " + exflow.getFlowId() + " successfully finished within the set SLA." + String.format("%n", new Object[0]);
                message = message + "Job started at " + new DateTime(exnode.getStartTime()).toDateTimeISO() + String.format("%n", new Object[0]);
                message = message + "Job status at " + s.getCheckTime().toDateTimeISO() + " is " + (Object)((Object)exnode.getStatus());
                break;
            }
            default: {
                logger.error((Object)"Unknown SLA rules!");
                message = "Unknown SLA was not met!";
            }
        }
        this.mailer.sendSlaEmail(s, message);
    }

    private void sendSlaKillEmail(SLA s, ExecutableFlow exflow) {
        String message = null;
        switch (s.getRule()) {
            case FINISH: {
                if (s.getJobName().equals("")) {
                    message = "Flow " + exflow.getFlowId() + " failed to finish with set SLA and is killed. " + String.format("%n", new Object[0]);
                    message = message + "Flow started at " + new DateTime(exflow.getStartTime()).toDateTimeISO() + String.format("%n", new Object[0]);
                    message = message + "Flow status at " + s.getCheckTime().toDateTimeISO() + " is " + (Object)((Object)exflow.getStatus());
                    break;
                }
                ExecutableNode exnode = exflow.getExecutableNode(s.getJobName());
                message = "Job " + s.getJobName() + " of flow " + exflow.getFlowId() + " failed to finish with set SLA and is killed. " + String.format("%n", new Object[0]);
                message = message + "Job started at " + new DateTime(exnode.getStartTime()).toDateTimeISO() + String.format("%n", new Object[0]);
                message = message + "Job status at " + s.getCheckTime().toDateTimeISO() + " is " + (Object)((Object)exnode.getStatus());
                break;
            }
            case SUCCESS: {
                if (s.getJobName().equals("")) {
                    message = "Flow " + exflow.getFlowId() + " didn't finish successfully with set SLA and is killed. " + String.format("%n", new Object[0]);
                    message = message + "Flow started at " + new DateTime(exflow.getStartTime()).toDateTimeISO() + String.format("  %n", new Object[0]);
                    message = message + "Flow status at " + s.getCheckTime().toDateTimeISO() + " is " + (Object)((Object)exflow.getStatus());
                    break;
                }
                ExecutableNode exnode = exflow.getExecutableNode(s.getJobName());
                message = "Job " + s.getJobName() + " of flow " + exflow.getFlowId() + " didn't finish successfully with set SLA and is killed. " + String.format("%n", new Object[0]);
                message = message + "Job started at " + new DateTime(exnode.getStartTime()).toDateTimeISO() + String.format("%n", new Object[0]);
                message = message + "Job status at " + s.getCheckTime().toDateTimeISO() + " is " + (Object)((Object)exnode.getStatus());
                break;
            }
            default: {
                logger.error((Object)"Unknown SLA rules!");
                message = "Unknown SLA was not met!";
            }
        }
        this.mailer.sendSlaEmail(s, message);
    }

    public int getNumActiveSLA() {
        return this.runner.getRunnerSLAs().size();
    }

    public Thread.State getSLAThreadState() {
        return this.runner.getState();
    }

    public boolean isThreadActive() {
        return this.runner.isAlive();
    }

    public List<SLA> getSLAList() {
        return this.runner.getRunnerSLAs();
    }

    public long getLastCheckTime() {
        return this.lastCheckTime;
    }

    public class SLARunner
    extends Thread {
        private final PriorityBlockingQueue<SLA> SLAs;
        private AtomicBoolean stillAlive = new AtomicBoolean(true);
        private static final int TIMEOUT_MS = 60000;

        public SLARunner() {
            this.setName("SLAManagerThread");
            this.SLAs = new PriorityBlockingQueue<SLA>(1, new SLAComparator());
        }

        public void shutdown() {
            logger.error((Object)"Shutting down SLA runner thread");
            this.stillAlive.set(false);
            this.interrupt();
        }

        protected synchronized List<SLA> getRunnerSLAs() {
            return new ArrayList<SLA>(this.SLAs);
        }

        public synchronized void addRunnerSLA(SLA s) {
            logger.info((Object)("Adding " + s + " to SLA runner."));
            this.SLAs.add(s);
            this.interrupt();
        }

        public synchronized void removeRunnerSLA(SLA s) {
            logger.info((Object)("Removing " + s + " from the SLA runner."));
            this.SLAs.remove(s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.stillAlive.get()) {
                SLARunner sLARunner = this;
                synchronized (sLARunner) {
                    try {
                        SLAManager.this.lastCheckTime = System.currentTimeMillis();
                        SLA s = this.SLAs.peek();
                        if (s == null) {
                            try {
                                this.wait(60000L);
                            }
                            catch (InterruptedException e) {}
                        } else if (!new DateTime((Object)s.getCheckTime()).isAfterNow()) {
                            SLA runningSLA = this.SLAs.poll();
                            logger.info((Object)("Checking sla " + runningSLA.toString()));
                            int execId = s.getExecId();
                            ExecutableFlow exflow = SLAManager.this.executorManager.getExecutableFlow(execId);
                            if (runningSLA.getJobName().equals("") && runningSLA.getRule().equals((Object)SLA.SlaRule.WAITANDCHECKJOB)) {
                                List<SLA.SlaSetting> jobSettings = runningSLA.getJobSettings();
                                ArrayList<SLA.SlaSetting> removeSettings = new ArrayList<SLA.SlaSetting>();
                                for (SLA.SlaSetting set : jobSettings) {
                                    ExecutableNode node = exflow.getExecutableNode(set.getId());
                                    if (node != null) {
                                        if (node.getStartTime() == -1L && !SLAManager.this.executorManager.isFinished(exflow)) continue;
                                        SLAManager.this.submitSla(execId, set.getId(), new DateTime(node.getStartTime()).plus(set.getDuration()), runningSLA.getEmails(), set.getActions(), null, set.getRule());
                                        removeSettings.add(set);
                                        logger.info((Object)("Job " + set.getId() + " already started, monitoring SLA."));
                                        continue;
                                    }
                                    SLAManager.this.mailer.sendSlaEmail(s, "The SLA setting for flow/job is no longer valid as flow structure has changed. Execution " + s.getExecId());
                                    removeSettings.add(set);
                                }
                                for (SLA.SlaSetting remove : removeSettings) {
                                    jobSettings.remove(remove);
                                }
                                if (jobSettings.size() == 0) {
                                    this.removeRunnerSLA(runningSLA);
                                    SLAManager.this.loader.removeSLA(runningSLA);
                                } else {
                                    this.removeRunnerSLA(runningSLA);
                                    SLAManager.this.loader.removeSLA(runningSLA);
                                    runningSLA.setCheckTime(runningSLA.getCheckTime().plusMillis(60000));
                                    this.addRunnerSLA(runningSLA);
                                    SLAManager.this.loader.insertSLA(runningSLA);
                                }
                            } else {
                                if (!this.metSla(runningSLA, exflow)) {
                                    SLAManager.this.takeSLAFailActions(runningSLA, exflow);
                                } else {
                                    SLAManager.this.takeSLASuccessActions(runningSLA, exflow);
                                }
                                this.removeRunnerSLA(runningSLA);
                                SLAManager.this.loader.removeSLA(runningSLA);
                            }
                        } else {
                            long millisWait = Math.max(0L, s.getCheckTime().getMillis() - new DateTime().getMillis());
                            try {
                                this.wait(Math.min(millisWait, 60000L));
                            }
                            catch (InterruptedException e) {}
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"Unexpected exception has been thrown in scheduler", (Throwable)e);
                    }
                    catch (Throwable e) {
                        logger.error((Object)"Unexpected throwable has been thrown in scheduler", e);
                    }
                }
            }
        }

        private boolean metSla(SLA s, ExecutableFlow exflow) {
            Status status;
            long finishTime;
            SLA.SlaRule rule = s.getRule();
            if (s.getJobName().equals("")) {
                finishTime = exflow.getEndTime();
                status = exflow.getStatus();
            } else {
                ExecutableNode exnode = exflow.getExecutableNode(s.getJobName());
                finishTime = exnode.getEndTime();
                status = exnode.getStatus();
            }
            switch (rule) {
                case FINISH: {
                    return finishTime != -1L && finishTime < s.getCheckTime().getMillis();
                }
                case SUCCESS: {
                    return status == Status.SUCCEEDED && finishTime < s.getCheckTime().getMillis();
                }
            }
            logger.error((Object)"Unknown SLA rules!");
            return false;
        }

        private class SLAComparator
        implements Comparator<SLA> {
            private SLAComparator() {
            }

            @Override
            public int compare(SLA arg0, SLA arg1) {
                long second;
                long first = arg1.getCheckTime().getMillis();
                if (first == (second = arg0.getCheckTime().getMillis())) {
                    return 0;
                }
                if (first < second) {
                    return 1;
                }
                return -1;
            }
        }
    }
}

