/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp.servlet;

import azkaban.executor.ExecutionOptions;
import azkaban.flow.Flow;
import azkaban.flow.Node;
import azkaban.project.Project;
import azkaban.project.ProjectLogEvent;
import azkaban.project.ProjectManager;
import azkaban.scheduler.Schedule;
import azkaban.scheduler.ScheduleManager;
import azkaban.scheduler.ScheduleManagerException;
import azkaban.sla.SLA;
import azkaban.sla.SlaOptions;
import azkaban.user.Permission;
import azkaban.user.User;
import azkaban.webapp.AzkabanWebServer;
import azkaban.webapp.servlet.HttpRequestUtils;
import azkaban.webapp.servlet.LoginAbstractAzkabanServlet;
import azkaban.webapp.servlet.Page;
import azkaban.webapp.session.Session;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;

public class ScheduleServlet
extends LoginAbstractAzkabanServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ScheduleServlet.class);
    private ProjectManager projectManager;
    private ScheduleManager scheduleManager;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        AzkabanWebServer server = (AzkabanWebServer)this.getApplication();
        this.projectManager = server.getProjectManager();
        this.scheduleManager = server.getScheduleManager();
    }

    @Override
    protected void handleGet(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        if (this.hasParam(req, "ajax")) {
            this.handleAJAXAction(req, resp, session);
        } else {
            this.handleGetAllSchedules(req, resp, session);
        }
    }

    private void handleAJAXAction(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String ajaxName = this.getParam(req, "ajax");
        if (ajaxName.equals("slaInfo")) {
            this.ajaxSlaInfo(req, ret, session.getUser());
        } else if (ajaxName.equals("setSla")) {
            this.ajaxSetSla(req, ret, session.getUser());
        } else if (ajaxName.equals("scheduleFlow")) {
            this.ajaxScheduleFlow(req, ret, session.getUser());
        }
        if (ret != null) {
            this.writeJSON(resp, ret);
        }
    }

    private void ajaxSetSla(HttpServletRequest req, HashMap<String, Object> ret, User user) {
        try {
            int projectId = this.getIntParam(req, "projectId");
            String flowName = this.getParam(req, "flowName");
            Project project = this.projectManager.getProject(projectId);
            if (!this.hasPermission(project, user, Permission.Type.SCHEDULE)) {
                ret.put("error", "User " + user + " does not have permission to set SLA for this flow.");
                return;
            }
            Schedule sched = this.scheduleManager.getSchedule(projectId, flowName);
            SlaOptions slaOptions = new SlaOptions();
            String slaEmails = this.getParam(req, "slaEmails");
            String[] emailSplit = slaEmails.split("\\s*,\\s*|\\s*;\\s*|\\s+");
            Map<String, String> settings = this.getParamGroup(req, "settings");
            ArrayList<SLA.SlaSetting> slaSettings = new ArrayList<SLA.SlaSetting>();
            for (String set : settings.keySet()) {
                SLA.SlaSetting s;
                try {
                    s = this.parseSlaSetting(settings.get(set));
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
                if (s == null) continue;
                slaSettings.add(s);
            }
            if (slaSettings.size() > 0) {
                if (slaEmails.equals("")) {
                    ret.put("error", "Please put correct email settings for your SLA actions");
                    return;
                }
                slaOptions.setSlaEmails(Arrays.asList(emailSplit));
                slaOptions.setSettings(slaSettings);
            } else {
                slaOptions = null;
            }
            sched.setSlaOptions(slaOptions);
            this.scheduleManager.insertSchedule(sched);
            if (slaOptions != null) {
                this.projectManager.postProjectEvent(project, ProjectLogEvent.EventType.SLA, user.getUserId(), "SLA for flow " + flowName + " has been added/changed.");
            }
        }
        catch (ServletException e) {
            ret.put("error", e.getMessage());
        }
    }

    private SLA.SlaSetting parseSlaSetting(String set) throws ScheduleManagerException {
        String[] parts = set.split(",", -1);
        String id = parts[0];
        String rule = parts[1];
        String duration = parts[2];
        String emailAction = parts[3];
        String killAction = parts[4];
        if (emailAction.equals("true") || killAction.equals("true")) {
            ReadablePeriod dur;
            SLA.SlaSetting r = new SLA.SlaSetting();
            r.setId(id);
            r.setRule(SLA.SlaRule.valueOf(rule));
            try {
                dur = this.parseDuration(duration);
            }
            catch (Exception e) {
                throw new ScheduleManagerException("Unable to parse duration for a SLA that needs to take actions!", e);
            }
            r.setDuration(dur);
            ArrayList<SLA.SlaAction> actions = new ArrayList<SLA.SlaAction>();
            if (emailAction.equals("true")) {
                actions.add(SLA.SlaAction.EMAIL);
            }
            if (killAction.equals("true")) {
                actions.add(SLA.SlaAction.KILL);
            }
            r.setActions(actions);
            return r;
        }
        return null;
    }

    private ReadablePeriod parseDuration(String duration) {
        int hour = Integer.parseInt(duration.split(":")[0]);
        int min = Integer.parseInt(duration.split(":")[1]);
        return Minutes.minutes((int)(min + hour * 60)).toPeriod();
    }

    private void ajaxSlaInfo(HttpServletRequest req, HashMap<String, Object> ret, User user) {
        try {
            List<String> emails;
            int projId = this.getIntParam(req, "projId");
            String flowName = this.getParam(req, "flowName");
            Project project = this.getProjectAjaxByPermission(ret, projId, user, Permission.Type.READ);
            if (project == null) {
                ret.put("error", "Error loading project. Project " + projId + " doesn't exist");
                return;
            }
            Flow flow = project.getFlow(flowName);
            if (flow == null) {
                ret.put("error", "Error loading flow. Flow " + flowName + " doesn't exist in " + projId);
                return;
            }
            Schedule sched = this.scheduleManager.getSchedule(projId, flowName);
            SlaOptions slaOptions = sched.getSlaOptions();
            ExecutionOptions flowOptions = sched.getExecutionOptions();
            if (slaOptions != null) {
                ret.put("slaEmails", slaOptions.getSlaEmails());
                List<SLA.SlaSetting> settings = slaOptions.getSettings();
                ArrayList<Object> setObj = new ArrayList<Object>();
                for (SLA.SlaSetting set : settings) {
                    setObj.add(set.toObject());
                }
                ret.put("settings", setObj);
            } else if (flowOptions != null) {
                if (flowOptions.getFailureEmails() != null && (emails = flowOptions.getFailureEmails()).size() > 0) {
                    ret.put("slaEmails", emails);
                }
            } else if (flow.getFailureEmails() != null && (emails = flow.getFailureEmails()).size() > 0) {
                ret.put("slaEmails", emails);
            }
            List<Object> disabledJobs = flowOptions != null ? (flowOptions.getDisabledJobs() == null ? new ArrayList() : flowOptions.getDisabledJobs()) : new ArrayList();
            ArrayList<String> allJobs = new ArrayList<String>();
            for (Node n : flow.getNodes()) {
                if (disabledJobs.contains(n.getId())) continue;
                allJobs.add(n.getId());
            }
            ret.put("allJobNames", allJobs);
        }
        catch (ServletException e) {
            ret.put("error", (Object)e);
        }
    }

    protected Project getProjectAjaxByPermission(Map<String, Object> ret, int projectId, User user, Permission.Type type) {
        Project project = this.projectManager.getProject(projectId);
        if (project == null) {
            ret.put("error", "Project '" + project + "' not found.");
        } else if (!this.hasPermission(project, user, type)) {
            ret.put("error", "User '" + user.getUserId() + "' doesn't have " + type.name() + " permissions on " + project.getName());
        } else {
            return project;
        }
        return null;
    }

    private void handleGetAllSchedules(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/scheduledflowpage.vm");
        List<Schedule> schedules = this.scheduleManager.getSchedules();
        page.add("schedules", schedules);
        page.render();
    }

    @Override
    protected void handlePost(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        if (this.hasParam(req, "ajax")) {
            this.handleAJAXAction(req, resp, session);
        } else {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            if (this.hasParam(req, "action")) {
                String action = this.getParam(req, "action");
                if (action.equals("scheduleFlow")) {
                    this.ajaxScheduleFlow(req, ret, session.getUser());
                } else if (action.equals("removeSched")) {
                    this.ajaxRemoveSched(req, ret, session.getUser());
                }
            }
            if (ret.get("status") == "success") {
                this.setSuccessMessageInCookie(resp, (String)ret.get("message"));
            } else {
                this.setErrorMessageInCookie(resp, (String)ret.get("message"));
            }
            this.writeJSON(resp, ret);
        }
    }

    private void ajaxRemoveSched(HttpServletRequest req, Map<String, Object> ret, User user) throws ServletException {
        int projectId = this.getIntParam(req, "projectId");
        String flowName = this.getParam(req, "flowName");
        Schedule sched = this.scheduleManager.getSchedule(projectId, flowName);
        Project project = this.projectManager.getProject(projectId);
        if (project == null) {
            ret.put("message", "Project " + projectId + " does not exist");
            ret.put("status", "error");
            return;
        }
        if (!this.hasPermission(project, user, Permission.Type.SCHEDULE)) {
            ret.put("status", "error");
            ret.put("message", "Permission denied. Cannot remove schedule " + projectId + "." + flowName);
            return;
        }
        this.scheduleManager.removeSchedule(projectId, flowName);
        logger.info((Object)("User '" + user.getUserId() + " has removed schedule " + sched.getScheduleName()));
        this.projectManager.postProjectEvent(project, ProjectLogEvent.EventType.SCHEDULE, user.getUserId(), "Schedule " + sched.toString() + " has been removed.");
        ret.put("status", "success");
        ret.put("message", "flow " + flowName + " removed from Schedules.");
    }

    private void ajaxScheduleFlow(HttpServletRequest req, HashMap<String, Object> ret, User user) throws ServletException {
        DateTime firstSchedTime;
        String projectName = this.getParam(req, "projectName");
        String flowName = this.getParam(req, "flow");
        int projectId = this.getIntParam(req, "projectId");
        Project project = this.projectManager.getProject(projectId);
        if (project == null) {
            ret.put("message", "Project " + projectName + " does not exist");
            ret.put("status", "error");
            return;
        }
        if (!this.hasPermission(project, user, Permission.Type.SCHEDULE)) {
            ret.put("status", "error");
            ret.put("message", "Permission denied. Cannot execute " + flowName);
            return;
        }
        Flow flow = project.getFlow(flowName);
        if (flow == null) {
            ret.put("status", "error");
            ret.put("message", "Flow " + flowName + " cannot be found in project " + project);
            return;
        }
        String scheduleTime = this.getParam(req, "scheduleTime");
        String scheduleDate = this.getParam(req, "scheduleDate");
        try {
            firstSchedTime = this.parseDateTime(scheduleDate, scheduleTime);
        }
        catch (Exception e) {
            ret.put("error", "Invalid date and/or time '" + scheduleDate + " " + scheduleTime);
            return;
        }
        ReadablePeriod thePeriod = null;
        try {
            if (this.hasParam(req, "is_recurring") && this.getParam(req, "is_recurring").equals("on")) {
                thePeriod = Schedule.parsePeriodString(this.getParam(req, "period"));
            }
        }
        catch (Exception e) {
            ret.put("error", e.getMessage());
        }
        Schedule sched = this.scheduleManager.getSchedule(projectId, flowName);
        ExecutionOptions flowOptions = null;
        try {
            flowOptions = HttpRequestUtils.parseFlowOptions(req);
        }
        catch (Exception e) {
            ret.put("error", e.getMessage());
        }
        SlaOptions slaOptions = null;
        if (sched != null && sched.getSlaOptions() != null) {
            slaOptions = sched.getSlaOptions();
        }
        Schedule schedule = this.scheduleManager.scheduleFlow(projectId, projectName, flowName, "ready", firstSchedTime.getMillis(), firstSchedTime.getZone(), thePeriod, DateTime.now().getMillis(), firstSchedTime.getMillis(), firstSchedTime.getMillis(), user.getUserId(), flowOptions, slaOptions);
        logger.info((Object)("User '" + user.getUserId() + "' has scheduled " + "[" + projectName + flowName + " (" + projectId + ")" + "]."));
        this.projectManager.postProjectEvent(project, ProjectLogEvent.EventType.SCHEDULE, user.getUserId(), "Schedule " + schedule.toString() + " has been added.");
        ret.put("status", "success");
        ret.put("message", projectName + "." + flowName + " scheduled.");
    }

    private DateTime parseDateTime(String scheduleDate, String scheduleTime) {
        String[] parts = scheduleTime.split(",", -1);
        int hour = Integer.parseInt(parts[0]);
        int minutes = Integer.parseInt(parts[1]);
        boolean isPm = parts[2].equalsIgnoreCase("pm");
        DateTimeZone timezone = parts[3].equals("UTC") ? DateTimeZone.UTC : DateTimeZone.forID((String)"America/Los_Angeles");
        DateTime day = null;
        day = scheduleDate == null || scheduleDate.trim().length() == 0 ? new LocalDateTime().toDateTime() : DateTimeFormat.forPattern((String)"MM/dd/yyyy").withZone(timezone).parseDateTime(scheduleDate);
        if (isPm && hour < 12) {
            hour += 12;
        }
        DateTime firstSchedTime = day.withHourOfDay(hour %= 24).withMinuteOfHour(minutes).withSecondOfMinute(0);
        return firstSchedTime;
    }
}

