/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger;

import azkaban.trigger.ConditionChecker;
import azkaban.trigger.TriggerException;
import azkaban.trigger.builtin.BasicTimeChecker;
import azkaban.utils.Props;
import azkaban.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CheckerTypeLoader {
    private static Logger logger = Logger.getLogger(CheckerTypeLoader.class);
    public static final String DEFAULT_CONDITION_CHECKER_PLUGIN_DIR = "plugins/conditioncheckers";
    private static final String CHECKERTYPECONFFILE = "plugin.properties";
    private static final String COMMONCONFFILE = "common.properties";
    protected static Map<String, Class<? extends ConditionChecker>> checkerToClass = new HashMap<String, Class<? extends ConditionChecker>>();

    public void init(Props props) throws TriggerException {
        this.loadBuiltinCheckers();
        this.loadPluginCheckers(props);
    }

    public synchronized void registerCheckerType(String type, Class<? extends ConditionChecker> checkerClass) {
        logger.info((Object)("Registering checker " + type));
        if (!checkerToClass.containsKey(type)) {
            checkerToClass.put(type, checkerClass);
        }
    }

    private void loadPluginCheckers(Props props) throws TriggerException {
        String checkerDir = props.getString("azkaban.condition.checker.plugin.dir", DEFAULT_CONDITION_CHECKER_PLUGIN_DIR);
        File pluginDir = new File(checkerDir);
        if (!(pluginDir.exists() && pluginDir.isDirectory() && pluginDir.canRead())) {
            logger.info((Object)"No conditon checker plugins to load.");
            return;
        }
        logger.info((Object)("Loading plugin condition checkers from " + pluginDir));
        ClassLoader parentCl = this.getClass().getClassLoader();
        Props globalCheckerConf = null;
        File confFile = Utils.findFilefromDir(pluginDir, COMMONCONFFILE);
        try {
            globalCheckerConf = confFile != null ? new Props(null, confFile) : new Props();
        }
        catch (IOException e) {
            throw new TriggerException("Failed to get global properties." + e);
        }
        for (File dir : pluginDir.listFiles()) {
            if (!dir.isDirectory() || !dir.canRead()) continue;
            try {
                this.loadPluginTypes(globalCheckerConf, pluginDir, parentCl);
            }
            catch (Exception e) {
                logger.info((Object)("Plugin checkers failed to load. " + e.getCause()));
                throw new TriggerException("Failed to load all condition checkers!", e);
            }
        }
    }

    private void loadPluginTypes(Props globalConf, File dir, ClassLoader parentCl) throws TriggerException {
        Props checkerConf = null;
        File confFile = Utils.findFilefromDir(dir, CHECKERTYPECONFFILE);
        if (confFile == null) {
            logger.info((Object)("No checker type found in " + dir.getAbsolutePath()));
            return;
        }
        try {
            checkerConf = new Props(globalConf, confFile);
        }
        catch (IOException e) {
            throw new TriggerException("Failed to load config for the checker type", e);
        }
        String checkerName = dir.getName();
        String checkerClass = checkerConf.getString("checker.class");
        ArrayList<URL> resources = new ArrayList<URL>();
        for (File f : dir.listFiles()) {
            try {
                if (!f.getName().endsWith(".jar")) continue;
                resources.add(f.toURI().toURL());
                logger.info((Object)("adding to classpath " + f.toURI().toURL()));
            }
            catch (MalformedURLException e) {
                throw new TriggerException(e);
            }
        }
        URLClassLoader checkerCl = new URLClassLoader(resources.toArray(new URL[resources.size()]), parentCl);
        Class<?> clazz = null;
        try {
            clazz = checkerCl.loadClass(checkerClass);
            checkerToClass.put(checkerName, clazz);
        }
        catch (ClassNotFoundException e) {
            throw new TriggerException(e);
        }
        if (checkerConf.getBoolean("need.init")) {
            try {
                Utils.invokeStaticMethod(checkerCl, checkerClass, "init", checkerConf);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)("Failed to init the checker type " + checkerName));
                throw new TriggerException(e);
            }
        }
        logger.info((Object)("Loaded checker type " + checkerName + " " + checkerClass));
    }

    public static void registerBuiltinCheckers(Map<String, Class<? extends ConditionChecker>> builtinCheckers) {
        checkerToClass.putAll(checkerToClass);
        for (String type : builtinCheckers.keySet()) {
            logger.info((Object)("Loaded " + type + " checker."));
        }
    }

    private void loadBuiltinCheckers() {
        checkerToClass.put("BasicTimeChecker", BasicTimeChecker.class);
        logger.info((Object)"Loaded BasicTimeChecker type.");
    }

    public ConditionChecker createCheckerFromJson(String type, Object obj) throws Exception {
        ConditionChecker checker = null;
        Class<? extends ConditionChecker> checkerClass = checkerToClass.get(type);
        if (checkerClass == null) {
            throw new Exception("Checker type " + type + " not supported!");
        }
        checker = (ConditionChecker)Utils.invokeStaticMethod(checkerClass.getClassLoader(), checkerClass.getName(), "createFromJson", obj);
        return checker;
    }

    public ConditionChecker createChecker(String type, Object ... args) {
        ConditionChecker checker = null;
        Class<? extends ConditionChecker> checkerClass = checkerToClass.get(type);
        checker = (ConditionChecker)Utils.callConstructor(checkerClass, args);
        return checker;
    }

    public Map<String, Class<? extends ConditionChecker>> getSupportedCheckers() {
        return checkerToClass;
    }
}

