/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger;

import azkaban.trigger.TriggerManager;
import azkaban.trigger.TriggerManagerException;
import azkaban.triggerapp.AzkabanTriggerServer;
import azkaban.triggerapp.TriggerConnectorParams;
import azkaban.webapp.servlet.AbstractServiceServlet;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class TriggerManagerServlet
extends AbstractServiceServlet
implements TriggerConnectorParams {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)TriggerManagerServlet.class.getName());
    public static final String JSON_MIME_TYPE = "application/json";
    private AzkabanTriggerServer application;
    private TriggerManager triggerManager;
    public static final String WEB_PATH = "/triggermanager";

    @Override
    public void init(ServletConfig config) throws ServletException {
        this.application = (AzkabanTriggerServer)config.getServletContext().getAttribute("azkaban_app");
        if (this.application == null) {
            throw new IllegalStateException("No batch application is defined in the servlet context!");
        }
        this.triggerManager = this.application.getTriggerManager();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        try {
            if (!this.hasParam(req, "action")) {
                logger.error((Object)"Parameter action not set");
                respMap.put("error", "Parameter action not set");
            } else {
                String action = this.getParam(req, "action");
                if (action.equals("getupdate")) {
                    this.handleAjaxGetUpdateRequest(req, respMap);
                } else if (action.equals("ping")) {
                    respMap.put("status", "alive");
                } else {
                    int triggerId = Integer.parseInt(this.getParam(req, "triggerid"));
                    String user = this.getParam(req, "user", null);
                    logger.info((Object)("User " + user + " has called action " + action + " on " + triggerId));
                    if (action.equals("insert")) {
                        logger.info((Object)"Insert Trigger Action");
                        this.handleInsertTrigger(triggerId, user, req, resp, respMap);
                    } else if (action.equals("remove")) {
                        logger.info((Object)"Remove Trigger Action");
                        this.handleRemoveTrigger(triggerId, user, req, resp, respMap);
                    } else if (action.equals("update")) {
                        logger.info((Object)"Update Trigger Action");
                        this.handleUpdateTrigger(triggerId, user, req, respMap);
                    } else {
                        logger.error((Object)("action: '" + action + "' not supported."));
                        respMap.put("error", "action: '" + action + "' not supported.");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            respMap.put("error", e.getMessage());
        }
        this.writeJSON(resp, respMap);
        resp.flushBuffer();
    }

    private void handleAjaxGetUpdateRequest(HttpServletRequest req, HashMap<String, Object> respMap) {
        List<Integer> updates = null;
        try {
            long lastUpdateTime = this.getLongParam(req, "lastUpdateTime");
            updates = this.triggerManager.getTriggerUpdates(lastUpdateTime);
            if (updates.size() > 0) {
                System.out.println("got " + updates.size() + " updates");
            }
            respMap.put("updates", updates);
        }
        catch (Exception e) {
            logger.error((Object)e);
            respMap.put("error", e.getMessage());
        }
    }

    private void handleInsertTrigger(int triggerId, String user, HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> respMap) {
        try {
            this.triggerManager.insertTrigger(triggerId, user);
        }
        catch (TriggerManagerException e) {
            logger.error((Object)e);
            respMap.put("error", e.getMessage());
        }
    }

    private void handleUpdateTrigger(int triggerId, String user, HttpServletRequest req, HashMap<String, Object> respMap) {
        try {
            this.triggerManager.updateTrigger(triggerId, user);
        }
        catch (TriggerManagerException e) {
            logger.error((Object)e);
            respMap.put("error", e.getMessage());
        }
    }

    private void handleRemoveTrigger(int triggerId, String user, HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> respMap) {
        try {
            this.triggerManager.removeTrigger(triggerId, user);
        }
        catch (TriggerManagerException e) {
            logger.error((Object)e);
            respMap.put("error", e.getMessage());
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }
}

