/*
 * Decompiled with CFR 0.152.
 */
package azkaban.triggerapp;

import azkaban.executor.ExecutorMailer;
import azkaban.executor.ExecutorManager;
import azkaban.executor.ExecutorManagerAdapter;
import azkaban.executor.ExecutorManagerRemoteAdapter;
import azkaban.executor.JdbcExecutorLoader;
import azkaban.jmx.JmxExecutorManagerAdapter;
import azkaban.jmx.JmxJettyServer;
import azkaban.jmx.JmxTriggerManager;
import azkaban.project.JdbcProjectLoader;
import azkaban.project.ProjectManager;
import azkaban.trigger.JdbcTriggerLoader;
import azkaban.trigger.TriggerLoader;
import azkaban.trigger.TriggerManager;
import azkaban.trigger.TriggerManagerAdapter;
import azkaban.trigger.TriggerManagerException;
import azkaban.trigger.TriggerManagerServlet;
import azkaban.trigger.builtin.BasicTimeChecker;
import azkaban.trigger.builtin.CreateTriggerAction;
import azkaban.trigger.builtin.ExecuteFlowAction;
import azkaban.trigger.builtin.KillExecutionAction;
import azkaban.trigger.builtin.SlaAlertAction;
import azkaban.trigger.builtin.SlaChecker;
import azkaban.triggerapp.JMXHttpServlet;
import azkaban.utils.FileIOUtils;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import azkaban.utils.Utils;
import azkaban.webapp.AzkabanServer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import org.apache.log4j.Logger;
import org.joda.time.DateTimeZone;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;

public class AzkabanTriggerServer {
    private static final Logger logger = Logger.getLogger(AzkabanTriggerServer.class);
    private static final int MAX_FORM_CONTENT_SIZE = 0xA00000;
    public static final String AZKABAN_HOME = "AZKABAN_HOME";
    public static final String DEFAULT_CONF_PATH = "conf";
    public static final String AZKABAN_PROPERTIES_FILE = "azkaban.properties";
    public static final String AZKABAN_PRIVATE_PROPERTIES_FILE = "azkaban.private.properties";
    public static final String TRIGGER_PLUGIN_DIR = "trigger.plugin.dir";
    public static final int DEFAULT_PORT_NUMBER = 22321;
    public static final int DEFAULT_THREAD_NUMBER = 50;
    private static final String DEFAULT_TIMEZONE_ID = "default.timezone.id";
    private static AzkabanTriggerServer app;
    private TriggerLoader triggerLoader;
    private TriggerManager triggerManager;
    private ExecutorManager executorManager;
    private ProjectManager projectManager;
    private Props props;
    private Server server;
    private ArrayList<ObjectName> registeredMBeans = new ArrayList();
    private MBeanServer mbeanServer;

    public AzkabanTriggerServer(Props props) throws Exception {
        this.props = props;
        int portNumber = props.getInt("trigger.server.port", 22321);
        int maxThreads = props.getInt("trigger.server.maxThreads", 50);
        String hostname = props.getString("jetty.hostname", "localhost");
        props.put("server.hostname", hostname);
        props.put("server.port", portNumber);
        props.put("server.useSSL", String.valueOf(props.getBoolean("jetty.use.ssl", true)));
        this.server = new Server(portNumber);
        QueuedThreadPool httpThreadPool = new QueuedThreadPool(maxThreads);
        this.server.setThreadPool((ThreadPool)httpThreadPool);
        Context root = new Context((HandlerContainer)this.server, "/", 1);
        root.setMaxFormContentSize(0xA00000);
        root.addServlet(new ServletHolder((Servlet)new TriggerManagerServlet()), "/triggermanager");
        root.addServlet(new ServletHolder((Servlet)new JMXHttpServlet()), "/jmx");
        root.setAttribute("azkaban_app", (Object)this);
        this.triggerLoader = this.createTriggerLoader(props);
        this.projectManager = this.loadProjectManager(props);
        this.executorManager = this.loadExecutorManager(props);
        this.triggerManager = this.loadTriggerManager(props, this.triggerLoader);
        String triggerPluginDir = props.getString(TRIGGER_PLUGIN_DIR, "plugins/triggers");
        this.loadBuiltinCheckersAndActions();
        this.loadPluginCheckersAndActions(triggerPluginDir);
        this.configureMBeanServer();
        try {
            this.triggerManager.start();
            this.server.start();
        }
        catch (Exception e) {
            logger.warn((Object)e);
            Utils.croak(e.getMessage(), 1);
        }
        logger.info((Object)("Azkaban Trigger Server started on port " + portNumber));
    }

    private TriggerManager loadTriggerManager(Props props, TriggerLoader triggerLoader) throws Exception {
        TriggerManager trm;
        logger.info((Object)"Loading trigger manager");
        try {
            trm = new TriggerManager(props, triggerLoader);
        }
        catch (TriggerManagerException e) {
            throw new Exception(e);
        }
        return trm;
    }

    private TriggerManagerAdapter loadTriggerRunnerManagerAdapter(Props props, TriggerLoader triggerLoader) throws Exception {
        TriggerManager trmAdapter;
        block4: {
            String trmMode = props.getString("trigger.runner.manager.mode", "local");
            try {
                if (trmMode.equals("local")) {
                    trmAdapter = new TriggerManager(props, triggerLoader);
                    break block4;
                }
                if (trmMode.equals("remote")) {
                    trmAdapter = null;
                    break block4;
                }
                throw new TriggerManagerException("Unknown trigger runner manager mode " + trmMode);
            }
            catch (Exception e) {
                throw new Exception("Failed to load Trigger Runner Manager: " + e.getMessage());
            }
        }
        return trmAdapter;
    }

    private ExecutorManager loadExecutorManager(Props props) throws Exception {
        logger.info((Object)"Loading executor manager");
        JdbcExecutorLoader loader = new JdbcExecutorLoader(props);
        ExecutorManager execManager = new ExecutorManager(props, loader);
        return execManager;
    }

    private ExecutorManagerAdapter loadExecutorManagerAdapter(Props props) throws Exception {
        ExecutorManagerAdapter adapter;
        String executorMode = props.getString("executor.manager.mode", "local");
        if (executorMode.equals("local")) {
            adapter = this.loadExecutorManager(props);
        } else if (executorMode.equals("remote")) {
            JdbcExecutorLoader loader = new JdbcExecutorLoader(props);
            adapter = new ExecutorManagerRemoteAdapter(props, loader);
        } else {
            throw new Exception("Unknown ExecutorManager mode " + executorMode);
        }
        return adapter;
    }

    private ProjectManager loadProjectManager(Props props) {
        logger.info((Object)"Loading project manager");
        JdbcProjectLoader loader = new JdbcProjectLoader(props);
        ProjectManager manager = new ProjectManager(loader, props);
        return manager;
    }

    private void loadBuiltinCheckersAndActions() {
        logger.info((Object)"Loading built-in checker and action types");
        if (this.triggerManager instanceof TriggerManager) {
            SlaChecker.setExecutorManager(this.executorManager);
            ExecuteFlowAction.setExecutorManager(this.executorManager);
            ExecuteFlowAction.setProjectManager(this.projectManager);
            ExecuteFlowAction.setTriggerManager(this.triggerManager);
            KillExecutionAction.setExecutorManager(this.executorManager);
            SlaAlertAction.setExecutorManager(this.executorManager);
            Map<String, ExecutorManager.Alerter> alerters = this.loadAlerters(this.props);
            SlaAlertAction.setAlerters(alerters);
            SlaAlertAction.setExecutorManager(this.executorManager);
            CreateTriggerAction.setTriggerManager(this.triggerManager);
        }
        this.triggerManager.registerCheckerType("BasicTimeChecker", BasicTimeChecker.class);
        this.triggerManager.registerCheckerType("SlaChecker", SlaChecker.class);
        this.triggerManager.registerActionType("ExecuteFlowAction", ExecuteFlowAction.class);
        this.triggerManager.registerActionType("KillExecutionAction", KillExecutionAction.class);
        this.triggerManager.registerActionType("AlertAction", SlaAlertAction.class);
        this.triggerManager.registerActionType("CreateTriggerAction", CreateTriggerAction.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadPluginCheckersAndActions(String pluginPath) {
        logger.info((Object)"Loading plug-in checker and action types");
        File triggerPluginPath = new File(pluginPath);
        if (!triggerPluginPath.exists()) {
            logger.error((Object)("plugin path " + pluginPath + " doesn't exist!"));
            return;
        }
        ClassLoader parentLoader = this.getClass().getClassLoader();
        File[] pluginDirs = triggerPluginPath.listFiles();
        ArrayList<String> jarPaths = new ArrayList<String>();
        File[] arr$ = pluginDirs;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            block20: {
                Props pluginProps;
                File propertiesDir;
                File pluginDir;
                block25: {
                    block23: {
                        File propertiesFile;
                        block24: {
                            block22: {
                                block21: {
                                    if (i$ >= len$) {
                                        return;
                                    }
                                    pluginDir = arr$[i$];
                                    if (pluginDir.exists()) break block21;
                                    logger.error((Object)("Error! Trigger plugin path " + pluginDir.getPath() + " doesn't exist."));
                                    break block20;
                                }
                                if (pluginDir.isDirectory()) break block22;
                                logger.error((Object)("The plugin path " + pluginDir + " is not a directory."));
                                break block20;
                            }
                            propertiesDir = new File(pluginDir, DEFAULT_CONF_PATH);
                            pluginProps = null;
                            if (!propertiesDir.exists() || !propertiesDir.isDirectory()) break block23;
                            propertiesFile = new File(propertiesDir, "plugin.properties");
                            File propertiesOverrideFile = new File(propertiesDir, "override.properties");
                            if (!propertiesFile.exists()) break block24;
                            pluginProps = propertiesOverrideFile.exists() ? PropsUtils.loadProps(null, propertiesFile, propertiesOverrideFile) : PropsUtils.loadProps(null, propertiesFile);
                            break block25;
                        }
                        logger.error((Object)("Plugin conf file " + propertiesFile + " not found."));
                        break block20;
                    }
                    logger.error((Object)("Plugin conf path " + propertiesDir + " not found."));
                    break block20;
                }
                List<String> extLibClasspath = pluginProps.getStringList("trigger.external.classpaths", (List<String>)null);
                String pluginClass = pluginProps.getString("trigger.class");
                if (pluginClass == null) {
                    logger.error((Object)"Trigger class is not set.");
                } else {
                    logger.error((Object)("Plugin class " + pluginClass));
                }
                URLClassLoader urlClassLoader = null;
                File libDir = new File(pluginDir, "lib");
                if (!libDir.exists() || !libDir.isDirectory()) {
                    logger.error((Object)("Library path " + propertiesDir + " not found."));
                } else {
                    File[] files = libDir.listFiles();
                    ArrayList<URL> urls = new ArrayList<URL>();
                    for (int i = 0; i < files.length; ++i) {
                        try {
                            URL url = files[i].toURI().toURL();
                            urls.add(url);
                            continue;
                        }
                        catch (MalformedURLException e) {
                            logger.error((Object)e);
                        }
                    }
                    if (extLibClasspath != null) {
                        for (String extLib : extLibClasspath) {
                            try {
                                File file = new File(pluginDir, extLib);
                                URL url = file.toURI().toURL();
                                urls.add(url);
                            }
                            catch (MalformedURLException e) {
                                logger.error((Object)e);
                            }
                        }
                    }
                    urlClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), parentLoader);
                    Class<?> triggerClass = null;
                    try {
                        triggerClass = urlClassLoader.loadClass(pluginClass);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error((Object)("Class " + pluginClass + " not found."));
                        break block20;
                    }
                    String source = FileIOUtils.getSourcePathFromClass(triggerClass);
                    logger.info((Object)("Source jar " + source));
                    jarPaths.add("jar:file:" + source);
                    try {
                        Utils.invokeStaticMethod(urlClassLoader, pluginClass, "initiateCheckerTypes", pluginProps, app);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unable to initiate checker types for " + pluginClass));
                        break block20;
                    }
                    try {
                        Utils.invokeStaticMethod(urlClassLoader, pluginClass, "initiateActionTypes", pluginProps, app);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unable to initiate action types for " + pluginClass));
                    }
                }
            }
            ++i$;
        }
    }

    private Map<String, ExecutorManager.Alerter> loadAlerters(Props props) {
        HashMap<String, ExecutorManager.Alerter> allAlerters = new HashMap<String, ExecutorManager.Alerter>();
        ExecutorMailer mailAlerter = new ExecutorMailer(props);
        allAlerters.put("email", mailAlerter);
        String pluginDir = props.getString("alerter.plugin.dir", "plugins/alerter");
        allAlerters.putAll(this.loadPluginAlerters(pluginDir));
        return allAlerters;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, ExecutorManager.Alerter> loadPluginAlerters(String pluginPath) {
        File alerterPluginPath = new File(pluginPath);
        if (!alerterPluginPath.exists()) {
            return Collections.emptyMap();
        }
        HashMap<String, ExecutorManager.Alerter> installedAlerterPlugins = new HashMap<String, ExecutorManager.Alerter>();
        ClassLoader parentLoader = SlaAlertAction.class.getClass().getClassLoader();
        File[] pluginDirs = alerterPluginPath.listFiles();
        ArrayList<String> jarPaths = new ArrayList<String>();
        File[] arr$ = pluginDirs;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            block22: {
                Props pluginProps;
                File propertiesDir;
                File pluginDir;
                block26: {
                    block24: {
                        File propertiesFile;
                        block25: {
                            block23: {
                                if (i$ >= len$) {
                                    return installedAlerterPlugins;
                                }
                                pluginDir = arr$[i$];
                                if (pluginDir.isDirectory()) break block23;
                                logger.error((Object)("The plugin path " + pluginDir + " is not a directory."));
                                break block22;
                            }
                            propertiesDir = new File(pluginDir, DEFAULT_CONF_PATH);
                            pluginProps = null;
                            if (!propertiesDir.exists() || !propertiesDir.isDirectory()) break block24;
                            propertiesFile = new File(propertiesDir, "plugin.properties");
                            File propertiesOverrideFile = new File(propertiesDir, "override.properties");
                            if (!propertiesFile.exists()) break block25;
                            pluginProps = propertiesOverrideFile.exists() ? PropsUtils.loadProps(null, propertiesFile, propertiesOverrideFile) : PropsUtils.loadProps(null, propertiesFile);
                            break block26;
                        }
                        logger.error((Object)("Plugin conf file " + propertiesFile + " not found."));
                        break block22;
                    }
                    logger.error((Object)("Plugin conf path " + propertiesDir + " not found."));
                    break block22;
                }
                String pluginName = pluginProps.getString("alerter.name");
                List<String> extLibClasspath = pluginProps.getStringList("alerter.external.classpaths", (List<String>)null);
                String pluginClass = pluginProps.getString("alerter.class");
                if (pluginClass == null) {
                    logger.error((Object)"Alerter class is not set.");
                } else {
                    logger.info((Object)("Plugin class " + pluginClass));
                }
                URLClassLoader urlClassLoader = null;
                File libDir = new File(pluginDir, "lib");
                if (!libDir.exists() || !libDir.isDirectory()) {
                    logger.error((Object)("Library path " + propertiesDir + " not found."));
                } else {
                    File[] files = libDir.listFiles();
                    ArrayList<URL> urls = new ArrayList<URL>();
                    for (int i = 0; i < files.length; ++i) {
                        try {
                            URL url = files[i].toURI().toURL();
                            urls.add(url);
                            continue;
                        }
                        catch (MalformedURLException e) {
                            logger.error((Object)e);
                        }
                    }
                    if (extLibClasspath != null) {
                        for (String extLib : extLibClasspath) {
                            try {
                                File file = new File(pluginDir, extLib);
                                URL url = file.toURI().toURL();
                                urls.add(url);
                            }
                            catch (MalformedURLException e) {
                                logger.error((Object)e);
                            }
                        }
                    }
                    urlClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), parentLoader);
                    Class<?> alerterClass = null;
                    try {
                        alerterClass = urlClassLoader.loadClass(pluginClass);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error((Object)("Class " + pluginClass + " not found."));
                        break block22;
                    }
                    String source = FileIOUtils.getSourcePathFromClass(alerterClass);
                    logger.info((Object)("Source jar " + source));
                    jarPaths.add("jar:file:" + source);
                    Constructor<?> constructor = null;
                    try {
                        constructor = alerterClass.getConstructor(Props.class);
                    }
                    catch (NoSuchMethodException e) {
                        logger.error((Object)("Constructor not found in " + pluginClass));
                        break block22;
                    }
                    Object obj = null;
                    try {
                        obj = constructor.newInstance(pluginProps);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    if (!(obj instanceof ExecutorManager.Alerter)) {
                        logger.error((Object)"The object is not an Alerter");
                    } else {
                        ExecutorManager.Alerter plugin = obj;
                        installedAlerterPlugins.put(pluginName, plugin);
                    }
                }
            }
            ++i$;
        }
    }

    private TriggerLoader createTriggerLoader(Props props) {
        return new JdbcTriggerLoader(props);
    }

    public void stopServer() throws Exception {
        this.server.stop();
        this.server.destroy();
    }

    public Props getAzkabanProps() {
        return this.props;
    }

    public static void main(String[] args) throws Exception {
        logger.error((Object)"Starting Jetty Azkaban Trigger Server...");
        Props azkabanSettings = AzkabanServer.loadProps(args);
        if (azkabanSettings == null) {
            logger.error((Object)"Azkaban Properties not loaded.");
            logger.error((Object)"Exiting Azkaban Trigger Server...");
            return;
        }
        if (azkabanSettings.containsKey(DEFAULT_TIMEZONE_ID)) {
            String timezone = azkabanSettings.getString(DEFAULT_TIMEZONE_ID);
            TimeZone.setDefault(TimeZone.getTimeZone(timezone));
            DateTimeZone.setDefault((DateTimeZone)DateTimeZone.forID((String)timezone));
            logger.info((Object)("Setting timezone to " + timezone));
        }
        app = new AzkabanTriggerServer(azkabanSettings);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.info((Object)"Shutting down http server...");
                try {
                    app.stopServer();
                }
                catch (Exception e) {
                    logger.error((Object)"Error while shutting down http server.", (Throwable)e);
                }
                logger.info((Object)"kk thx bye.");
            }
        });
    }

    static Props loadConfigurationFromAzkabanHome() {
        String azkabanHome = System.getenv(AZKABAN_HOME);
        if (azkabanHome == null) {
            logger.error((Object)"AZKABAN_HOME not set. Will try default.");
            return null;
        }
        if (!new File(azkabanHome).isDirectory() || !new File(azkabanHome).canRead()) {
            logger.error((Object)(azkabanHome + " is not a readable directory."));
            return null;
        }
        File confPath = new File(azkabanHome, DEFAULT_CONF_PATH);
        if (!(confPath.exists() && confPath.isDirectory() && confPath.canRead())) {
            logger.error((Object)(azkabanHome + " does not contain a readable conf directory."));
            return null;
        }
        return AzkabanTriggerServer.loadAzkabanConfigurationFromDirectory(confPath);
    }

    private static Props loadAzkabanConfigurationFromDirectory(File dir) {
        File azkabanPrivatePropsFile = new File(dir, AZKABAN_PRIVATE_PROPERTIES_FILE);
        File azkabanPropsFile = new File(dir, AZKABAN_PROPERTIES_FILE);
        Props props = null;
        try {
            if (azkabanPrivatePropsFile.exists() && azkabanPrivatePropsFile.isFile()) {
                logger.info((Object)"Loading azkaban private properties file");
                props = new Props(null, azkabanPrivatePropsFile);
            }
            if (azkabanPropsFile.exists() && azkabanPropsFile.isFile()) {
                logger.info((Object)"Loading azkaban properties file");
                props = new Props(props, azkabanPropsFile);
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"File not found. Could not load azkaban config file", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"File found, but error reading. Could not load azkaban config file", (Throwable)e);
        }
        return props;
    }

    private void configureMBeanServer() {
        logger.info((Object)"Registering MBeans...");
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this.registerMbean("triggerServerJetty", new JmxJettyServer(this.server));
        this.registerMbean("triggerManager", new JmxTriggerManager(this.triggerManager));
        this.registerMbean("executorManager", new JmxExecutorManagerAdapter(this.executorManager));
    }

    public void close() {
        try {
            for (ObjectName name : this.registeredMBeans) {
                this.mbeanServer.unregisterMBean(name);
                logger.info((Object)("Jmx MBean " + name.getCanonicalName() + " unregistered."));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to cleanup MBeanServer", (Throwable)e);
        }
    }

    private void registerMbean(String name, Object mbean) {
        Class<?> mbeanClass = mbean.getClass();
        try {
            ObjectName mbeanName = new ObjectName(mbeanClass.getName() + ":name=" + name);
            this.mbeanServer.registerMBean(mbean, mbeanName);
            logger.info((Object)("Bean " + mbeanClass.getCanonicalName() + " registered."));
            this.registeredMBeans.add(mbeanName);
        }
        catch (Exception e) {
            logger.error((Object)("Error registering mbean " + mbeanClass.getCanonicalName()), (Throwable)e);
        }
        this.executorManager.shutdown();
        this.triggerManager.shutdown();
    }

    public List<ObjectName> getMbeanNames() {
        return this.registeredMBeans;
    }

    public MBeanInfo getMBeanInfo(ObjectName name) {
        try {
            return this.mbeanServer.getMBeanInfo(name);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public Object getMBeanAttribute(ObjectName name, String attribute) {
        try {
            return this.mbeanServer.getAttribute(name, attribute);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public TriggerManager getTriggerManager() {
        return this.triggerManager;
    }

    public ExecutorManager getExecutorManager() {
        return this.executorManager;
    }

    public ProjectManager getProjectManager() {
        return this.projectManager;
    }
}

