/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp;

import azkaban.database.AzkabanDatabaseUpdater;
import azkaban.execapp.AzkabanExecutorServer;
import azkaban.utils.Props;
import azkaban.webapp.AzkabanServer;
import azkaban.webapp.AzkabanWebServer;
import org.apache.log4j.Logger;

public class AzkabanSingleServer {
    private static final Logger logger = Logger.getLogger(AzkabanWebServer.class);

    public static void main(String[] args) throws Exception {
        logger.info((Object)"Starting Azkaban Server");
        Props props = AzkabanServer.loadProps(args);
        if (props == null) {
            logger.error((Object)"Properties not found. Need it to connect to the db.");
            logger.error((Object)"Exiting...");
            return;
        }
        boolean checkversion = props.getBoolean("database.check.version", true);
        if (checkversion) {
            boolean updateDB = props.getBoolean("database.auto.update.tables", true);
            String scriptDir = props.getString("database.sql.scripts.dir", "sql");
            AzkabanDatabaseUpdater.runDatabaseUpdater(props, scriptDir, updateDB);
        }
        AzkabanWebServer.main(args);
        logger.info((Object)"Azkaban Web Server started...");
        AzkabanExecutorServer.main(args);
        logger.info((Object)"Azkaban Exec Server started...");
    }
}

