/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp.servlet;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutorManagerAdapter;
import azkaban.executor.ExecutorManagerException;
import azkaban.project.Project;
import azkaban.project.ProjectManager;
import azkaban.webapp.AzkabanWebServer;
import azkaban.webapp.servlet.LoginAbstractAzkabanServlet;
import azkaban.webapp.servlet.Page;
import azkaban.webapp.session.Session;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.format.DateTimeFormat;

public class HistoryServlet
extends LoginAbstractAzkabanServlet {
    private static final long serialVersionUID = 1L;
    private ExecutorManagerAdapter executorManager;
    private ProjectManager projectManager;
    private ExecutorVMHelper vmHelper;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        AzkabanWebServer server = (AzkabanWebServer)this.getApplication();
        this.executorManager = server.getExecutorManager();
        this.projectManager = server.getProjectManager();
        this.vmHelper = new ExecutorVMHelper();
    }

    @Override
    protected void handleGet(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        if (this.hasParam(req, "ajax")) {
            this.handleAJAXAction(req, resp, session);
        } else if (this.hasParam(req, "days")) {
            this.handleHistoryDayPage(req, resp, session);
        } else if (this.hasParam(req, "timeline")) {
            this.handleHistoryTimelinePage(req, resp, session);
        } else {
            this.handleHistoryPage(req, resp, session);
        }
    }

    private void handleAJAXAction(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String ajaxName = this.getParam(req, "ajax");
        if (ajaxName.equals("fetch")) {
            this.fetchHistoryData(req, resp, ret);
        }
        if (ret != null) {
            this.writeJSON(resp, ret);
        }
    }

    private void fetchHistoryData(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret) throws ServletException {
    }

    private void handleHistoryPage(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException {
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/historypage.vm");
        int pageNum = this.getIntParam(req, "page", 1);
        int pageSize = this.getIntParam(req, "size", 16);
        page.add("vmutils", this.vmHelper);
        if (pageNum < 0) {
            pageNum = 1;
        }
        List<ExecutableFlow> history = null;
        if (this.hasParam(req, "advfilter")) {
            String projContain = this.getParam(req, "projcontain");
            String flowContain = this.getParam(req, "flowcontain");
            String userContain = this.getParam(req, "usercontain");
            int status = this.getIntParam(req, "status");
            String begin = this.getParam(req, "begin");
            long beginTime = begin == "" ? -1L : DateTimeFormat.forPattern((String)"MM/dd/yyyy-HH:mm").parseDateTime(begin).getMillis();
            String end = this.getParam(req, "end");
            long endTime = end == "" ? -1L : DateTimeFormat.forPattern((String)"MM/dd/yyyy-HH:mm").parseDateTime(end).getMillis();
            try {
                history = this.executorManager.getExecutableFlows(projContain, flowContain, userContain, status, beginTime, endTime, (pageNum - 1) * pageSize, pageSize);
            }
            catch (ExecutorManagerException e) {
                page.add("error", e.getMessage());
            }
        } else if (this.hasParam(req, "search")) {
            String searchTerm = this.getParam(req, "searchterm");
            try {
                history = this.executorManager.getExecutableFlows(searchTerm, (pageNum - 1) * pageSize, pageSize);
            }
            catch (ExecutorManagerException e) {
                page.add("error", e.getMessage());
            }
        } else {
            try {
                history = this.executorManager.getExecutableFlows((pageNum - 1) * pageSize, pageSize);
            }
            catch (ExecutorManagerException e) {
                e.printStackTrace();
            }
        }
        page.add("flowHistory", history);
        page.add("size", pageSize);
        page.add("page", pageNum);
        if (this.hasParam(req, "searchterm") && !this.getParam(req, "searchterm").equals("")) {
            page.add("search", "true");
            page.add("search_term", this.getParam(req, "searchterm"));
        }
        if (this.hasParam(req, "advfilter")) {
            page.add("advfilter", "true");
            page.add("projcontain", this.getParam(req, "projcontain"));
            page.add("flowcontain", this.getParam(req, "flowcontain"));
            page.add("usercontain", this.getParam(req, "usercontain"));
            page.add("status", this.getIntParam(req, "status"));
            page.add("begin", this.getParam(req, "begin"));
            page.add("end", this.getParam(req, "end"));
        }
        if (pageNum == 1) {
            page.add("previous", new PageSelection(1, pageSize, true, false));
        } else {
            page.add("previous", new PageSelection(pageNum - 1, pageSize, false, false));
        }
        page.add("next", new PageSelection(pageNum + 1, pageSize, false, false));
        int pageStartValue = 1;
        if (pageNum > 3) {
            pageStartValue = pageNum - 2;
        }
        page.add("page1", new PageSelection(pageStartValue, pageSize, false, pageStartValue == pageNum));
        page.add("page2", new PageSelection(pageStartValue, pageSize, false, ++pageStartValue == pageNum));
        page.add("page3", new PageSelection(pageStartValue, pageSize, false, ++pageStartValue == pageNum));
        page.add("page4", new PageSelection(pageStartValue, pageSize, false, ++pageStartValue == pageNum));
        page.add("page5", new PageSelection(pageStartValue, pageSize, false, ++pageStartValue == pageNum));
        ++pageStartValue;
        page.render();
    }

    private void handleHistoryTimelinePage(HttpServletRequest req, HttpServletResponse resp, Session session) {
    }

    private void handleHistoryDayPage(HttpServletRequest req, HttpServletResponse resp, Session session) {
    }

    @Override
    protected void handlePost(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
    }

    public class ExecutorVMHelper {
        public String getProjectName(int id) {
            Project project = HistoryServlet.this.projectManager.getProject(id);
            if (project == null) {
                return String.valueOf(id);
            }
            return project.getName();
        }
    }

    public class PageSelection {
        private int page;
        private int size;
        private boolean disabled;
        private boolean selected;

        public PageSelection(int page, int size, boolean disabled, boolean selected) {
            this.page = page;
            this.size = size;
            this.disabled = disabled;
            this.setSelected(selected);
        }

        public int getPage() {
            return this.page;
        }

        public int getSize() {
            return this.size;
        }

        public boolean getDisabled() {
            return this.disabled;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }
}

