/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp.servlet;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.ExecutorManagerAdapter;
import azkaban.executor.ExecutorManagerException;
import azkaban.flow.Flow;
import azkaban.flow.Node;
import azkaban.project.Project;
import azkaban.project.ProjectLogEvent;
import azkaban.project.ProjectManager;
import azkaban.scheduler.Schedule;
import azkaban.scheduler.ScheduleManager;
import azkaban.scheduler.ScheduleManagerException;
import azkaban.scheduler.ScheduleStatisticManager;
import azkaban.sla.SlaOption;
import azkaban.user.Permission;
import azkaban.user.User;
import azkaban.utils.JSONUtils;
import azkaban.utils.SplitterOutputStream;
import azkaban.utils.Utils;
import azkaban.webapp.AzkabanWebServer;
import azkaban.webapp.servlet.HttpRequestUtils;
import azkaban.webapp.servlet.LoginAbstractAzkabanServlet;
import azkaban.webapp.servlet.Page;
import azkaban.webapp.session.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;

public class ScheduleServlet
extends LoginAbstractAzkabanServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ScheduleServlet.class);
    private ProjectManager projectManager;
    private ScheduleManager scheduleManager;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        AzkabanWebServer server = (AzkabanWebServer)this.getApplication();
        this.projectManager = server.getProjectManager();
        this.scheduleManager = server.getScheduleManager();
    }

    @Override
    protected void handleGet(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        if (this.hasParam(req, "ajax")) {
            this.handleAJAXAction(req, resp, session);
        } else if (this.hasParam(req, "calendar")) {
            this.handleGetScheduleCalendar(req, resp, session);
        } else {
            this.handleGetAllSchedules(req, resp, session);
        }
    }

    private void handleAJAXAction(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String ajaxName = this.getParam(req, "ajax");
        if (ajaxName.equals("slaInfo")) {
            this.ajaxSlaInfo(req, ret, session.getUser());
        } else if (ajaxName.equals("setSla")) {
            this.ajaxSetSla(req, ret, session.getUser());
        } else if (ajaxName.equals("loadFlow")) {
            this.ajaxLoadFlows(req, ret, session.getUser());
        } else if (ajaxName.equals("loadHistory")) {
            this.ajaxLoadHistory(req, resp, session.getUser());
            ret = null;
        } else if (ajaxName.equals("scheduleFlow")) {
            this.ajaxScheduleFlow(req, ret, session.getUser());
        }
        if (ret != null) {
            this.writeJSON(resp, ret);
        }
    }

    private void ajaxSetSla(HttpServletRequest req, HashMap<String, Object> ret, User user) {
        try {
            int scheduleId = this.getIntParam(req, "scheduleId");
            Schedule sched = this.scheduleManager.getSchedule(scheduleId);
            Project project = this.projectManager.getProject(sched.getProjectId());
            if (!this.hasPermission(project, user, Permission.Type.SCHEDULE)) {
                ret.put("error", "User " + user + " does not have permission to set SLA for this flow.");
                return;
            }
            String emailStr = this.getParam(req, "slaEmails");
            String[] emailSplit = emailStr.split("\\s*,\\s*|\\s*;\\s*|\\s+");
            List<String> slaEmails = Arrays.asList(emailSplit);
            Map<String, String> settings = this.getParamGroup(req, "settings");
            ArrayList<SlaOption> slaOptions = new ArrayList<SlaOption>();
            for (String set : settings.keySet()) {
                SlaOption sla;
                try {
                    sla = this.parseSlaSetting(settings.get(set));
                    sla.getInfo().put("FlowName", sched.getFlowName());
                    sla.getInfo().put("EmailList", slaEmails);
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
                if (sla == null) continue;
                sla.getInfo().put("SlaEmails", slaEmails);
                slaOptions.add(sla);
            }
            sched.setSlaOptions(slaOptions);
            this.scheduleManager.insertSchedule(sched);
            if (slaOptions != null) {
                this.projectManager.postProjectEvent(project, ProjectLogEvent.EventType.SLA, user.getUserId(), "SLA for flow " + sched.getFlowName() + " has been added/changed.");
            }
        }
        catch (ServletException e) {
            ret.put("error", e.getMessage());
        }
        catch (ScheduleManagerException e) {
            ret.put("error", e.getMessage());
        }
    }

    private SlaOption parseSlaSetting(String set) throws ScheduleManagerException {
        logger.info((Object)("Tryint to set sla with the following set: " + set));
        ArrayList<String> slaActions = new ArrayList<String>();
        HashMap<String, Object> slaInfo = new HashMap<String, Object>();
        String[] parts = set.split(",", -1);
        String id = parts[0];
        String rule = parts[1];
        String duration = parts[2];
        String emailAction = parts[3];
        String killAction = parts[4];
        if (emailAction.equals("true") || killAction.equals("true")) {
            ReadablePeriod dur;
            String slaType;
            if (emailAction.equals("true")) {
                slaActions.add("SlaAlert");
                slaInfo.put("SlaAlertType", "email");
            }
            if (killAction.equals("true")) {
                slaActions.add("SlaCancelFlow");
            }
            if (id.equals("")) {
                slaType = rule.equals("SUCCESS") ? "FlowSucceed" : "FlowFinish";
            } else {
                slaInfo.put("JobName", id);
                slaType = rule.equals("SUCCESS") ? "JobSucceed" : "JobFinish";
            }
            try {
                dur = this.parseDuration(duration);
            }
            catch (Exception e) {
                throw new ScheduleManagerException("Unable to parse duration for a SLA that needs to take actions!", e);
            }
            slaInfo.put("Duration", Utils.createPeriodString(dur));
            SlaOption r = new SlaOption(slaType, slaActions, slaInfo);
            logger.info((Object)("Parsing sla as id:" + id + " type:" + slaType + " rule:" + rule + " Duration:" + duration + " actions:" + slaActions));
            return r;
        }
        return null;
    }

    private ReadablePeriod parseDuration(String duration) {
        int hour = Integer.parseInt(duration.split(":")[0]);
        int min = Integer.parseInt(duration.split(":")[1]);
        return Minutes.minutes((int)(min + hour * 60)).toPeriod();
    }

    private void ajaxSlaInfo(HttpServletRequest req, HashMap<String, Object> ret, User user) {
        try {
            List<String> emails;
            int scheduleId = this.getIntParam(req, "scheduleId");
            Schedule sched = this.scheduleManager.getSchedule(scheduleId);
            Project project = this.getProjectAjaxByPermission(ret, sched.getProjectId(), user, Permission.Type.READ);
            if (project == null) {
                ret.put("error", "Error loading project. Project " + sched.getProjectId() + " doesn't exist");
                return;
            }
            Flow flow = project.getFlow(sched.getFlowName());
            if (flow == null) {
                ret.put("error", "Error loading flow. Flow " + sched.getFlowName() + " doesn't exist in " + sched.getProjectId());
                return;
            }
            List<SlaOption> slaOptions = sched.getSlaOptions();
            ExecutionOptions flowOptions = sched.getExecutionOptions();
            if (slaOptions != null && slaOptions.size() > 0) {
                ret.put("slaEmails", slaOptions.get(0).getInfo().get("EmailList"));
                ArrayList<Object> setObj = new ArrayList<Object>();
                for (SlaOption sla : slaOptions) {
                    setObj.add(sla.toWebObject());
                }
                ret.put("settings", setObj);
            } else if (flowOptions != null) {
                if (flowOptions.getFailureEmails() != null && (emails = flowOptions.getFailureEmails()).size() > 0) {
                    ret.put("slaEmails", emails);
                }
            } else if (flow.getFailureEmails() != null && (emails = flow.getFailureEmails()).size() > 0) {
                ret.put("slaEmails", emails);
            }
            List<Object> disabledJobs = flowOptions != null ? (flowOptions.getDisabledJobs() == null ? new ArrayList() : flowOptions.getDisabledJobs()) : new ArrayList();
            ArrayList<String> allJobs = new ArrayList<String>();
            for (Node n : flow.getNodes()) {
                if (disabledJobs.contains(n.getId())) continue;
                allJobs.add(n.getId());
            }
            ret.put("allJobNames", allJobs);
        }
        catch (ServletException e) {
            ret.put("error", (Object)e);
        }
        catch (ScheduleManagerException e) {
            ret.put("error", e);
        }
    }

    protected Project getProjectAjaxByPermission(Map<String, Object> ret, int projectId, User user, Permission.Type type) {
        Project project = this.projectManager.getProject(projectId);
        if (project == null) {
            ret.put("error", "Project '" + project + "' not found.");
        } else if (!this.hasPermission(project, user, type)) {
            ret.put("error", "User '" + user.getUserId() + "' doesn't have " + type.name() + " permissions on " + project.getName());
        } else {
            return project;
        }
        return null;
    }

    private void handleGetAllSchedules(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        List<Schedule> schedules;
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/scheduledflowpage.vm");
        try {
            schedules = this.scheduleManager.getSchedules();
        }
        catch (ScheduleManagerException e) {
            throw new ServletException((Throwable)e);
        }
        page.add("schedules", schedules);
        page.render();
    }

    private void handleGetScheduleCalendar(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        List<Schedule> schedules;
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/scheduledflowcalendarpage.vm");
        try {
            schedules = this.scheduleManager.getSchedules();
        }
        catch (ScheduleManagerException e) {
            throw new ServletException((Throwable)e);
        }
        page.add("schedules", schedules);
        page.render();
    }

    @Override
    protected void handlePost(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        if (this.hasParam(req, "ajax")) {
            this.handleAJAXAction(req, resp, session);
        } else {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            if (this.hasParam(req, "action")) {
                String action = this.getParam(req, "action");
                if (action.equals("scheduleFlow")) {
                    this.ajaxScheduleFlow(req, ret, session.getUser());
                } else if (action.equals("removeSched")) {
                    this.ajaxRemoveSched(req, ret, session.getUser());
                }
            }
            if (ret.get("status") == "success") {
                this.setSuccessMessageInCookie(resp, (String)ret.get("message"));
            } else {
                this.setErrorMessageInCookie(resp, (String)ret.get("message"));
            }
            this.writeJSON(resp, ret);
        }
    }

    private void ajaxLoadFlows(HttpServletRequest req, HashMap<String, Object> ret, User user) throws ServletException {
        List<Schedule> schedules;
        try {
            schedules = this.scheduleManager.getSchedules();
        }
        catch (ScheduleManagerException e) {
            throw new ServletException((Throwable)e);
        }
        if (schedules.size() <= 0) {
            return;
        }
        ArrayList<HashMap<String, Object>> output = new ArrayList<HashMap<String, Object>>();
        ret.put("items", output);
        for (Schedule schedule : schedules) {
            try {
                this.writeScheduleData(output, schedule);
            }
            catch (ScheduleManagerException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    private void writeScheduleData(List<HashMap<String, Object>> output, Schedule schedule) throws ScheduleManagerException {
        Map<String, Object> stats = ScheduleStatisticManager.getStatistics(schedule.getScheduleId(), (AzkabanWebServer)this.getApplication());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("scheduleid", schedule.getScheduleId());
        data.put("flowname", schedule.getFlowName());
        data.put("projectname", schedule.getProjectName());
        data.put("time", schedule.getFirstSchedTime());
        DateTime time = DateTime.now();
        long period = 0L;
        if (schedule.getPeriod() != null) {
            period = time.plus(schedule.getPeriod()).getMillis() - time.getMillis();
        }
        data.put("period", period);
        int length = 3600000;
        if (stats.get("average") != null && stats.get("average") instanceof Integer && (length = ((Integer)stats.get("average")).intValue()) == 0) {
            length = 3600000;
        }
        data.put("length", length);
        data.put("history", false);
        data.put("stats", stats);
        output.add(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ajaxLoadHistory(HttpServletRequest req, HttpServletResponse resp, User user) throws ServletException, IOException {
        resp.setContentType("application/json");
        long today = DateTime.now().withTime(0, 0, 0, 0).getMillis();
        long startTime = this.getLongParam(req, "startTime");
        DateTime start = new DateTime(startTime);
        startTime = start.withTime(0, 0, 0, 0).getMillis();
        boolean useCache = false;
        if (startTime < today) {
            useCache = true;
        }
        long endTime = startTime + 86400000L;
        int loadAll = this.getIntParam(req, "loadAll");
        File cache = new File("cache/schedule-history/" + startTime + ".cache");
        cache.getParentFile().mkdirs();
        if (useCache) {
            boolean cacheExists = false;
            ScheduleServlet scheduleServlet = this;
            synchronized (scheduleServlet) {
                cacheExists = cache.exists() && cache.isFile();
            }
            if (cacheExists) {
                FileInputStream cacheInput = new FileInputStream(cache);
                Utils.copyStream(cacheInput, (OutputStream)resp.getOutputStream());
                return;
            }
        }
        List<ExecutableFlow> history = null;
        try {
            AzkabanWebServer server = (AzkabanWebServer)this.getApplication();
            ExecutorManagerAdapter executorManager = server.getExecutorManager();
            history = executorManager.getExecutableFlows(null, null, null, 0, startTime, endTime, -1, -1);
        }
        catch (ExecutorManagerException e) {
            // empty catch block
        }
        HashMap<String, ArrayList<HashMap<String, Object>>> ret = new HashMap<String, ArrayList<HashMap<String, Object>>>();
        ArrayList<HashMap<String, Object>> output = new ArrayList<HashMap<String, Object>>();
        ret.put("items", output);
        for (ExecutableFlow historyItem : history) {
            if (historyItem.getScheduleId() < 0 && loadAll == 0) continue;
            this.writeHistoryData(output, historyItem);
        }
        Object i$ = this;
        synchronized (i$) {
            if (!useCache || cache.exists()) {
                JSONUtils.toJSON(ret, (OutputStream)resp.getOutputStream(), false);
                return;
            }
        }
        File cacheTemp = new File("cache/schedule-history/" + startTime + ".tmp");
        cacheTemp.createNewFile();
        FileOutputStream cacheOutput = new FileOutputStream(cacheTemp);
        JSONUtils.toJSON(ret, new SplitterOutputStream(new OutputStream[]{cacheOutput, resp.getOutputStream()}), false);
        ScheduleServlet scheduleServlet = this;
        synchronized (scheduleServlet) {
            cacheTemp.renameTo(cache);
        }
    }

    private void writeHistoryData(List<HashMap<String, Object>> output, ExecutableFlow history) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("scheduleid", history.getScheduleId());
        Project project = this.projectManager.getProject(history.getProjectId());
        data.put("flowname", history.getFlowId());
        data.put("projectname", project.getName());
        data.put("time", history.getStartTime());
        data.put("period", "0");
        long endTime = history.getEndTime();
        if (endTime == -1L) {
            endTime = System.currentTimeMillis();
        }
        data.put("length", endTime - history.getStartTime());
        data.put("history", true);
        data.put("status", history.getStatus().getNumVal());
        output.add(data);
    }

    private void ajaxRemoveSched(HttpServletRequest req, Map<String, Object> ret, User user) throws ServletException {
        Schedule sched;
        int scheduleId = this.getIntParam(req, "scheduleId");
        try {
            sched = this.scheduleManager.getSchedule(scheduleId);
        }
        catch (ScheduleManagerException e) {
            throw new ServletException((Throwable)e);
        }
        if (sched == null) {
            ret.put("message", "Schedule with ID " + scheduleId + " does not exist");
            ret.put("status", "error");
            return;
        }
        Project project = this.projectManager.getProject(sched.getProjectId());
        if (project == null) {
            ret.put("message", "Project " + sched.getProjectId() + " does not exist");
            ret.put("status", "error");
            return;
        }
        if (!this.hasPermission(project, user, Permission.Type.SCHEDULE)) {
            ret.put("status", "error");
            ret.put("message", "Permission denied. Cannot remove schedule with id " + scheduleId);
            return;
        }
        this.scheduleManager.removeSchedule(sched);
        logger.info((Object)("User '" + user.getUserId() + " has removed schedule " + sched.getScheduleName()));
        this.projectManager.postProjectEvent(project, ProjectLogEvent.EventType.SCHEDULE, user.getUserId(), "Schedule " + sched.toString() + " has been removed.");
        ret.put("status", "success");
        ret.put("message", "flow " + sched.getFlowName() + " removed from Schedules.");
    }

    private void ajaxScheduleFlow(HttpServletRequest req, HashMap<String, Object> ret, User user) throws ServletException {
        DateTime firstSchedTime;
        String projectName = this.getParam(req, "projectName");
        String flowName = this.getParam(req, "flow");
        int projectId = this.getIntParam(req, "projectId");
        Project project = this.projectManager.getProject(projectId);
        if (project == null) {
            ret.put("message", "Project " + projectName + " does not exist");
            ret.put("status", "error");
            return;
        }
        if (!this.hasPermission(project, user, Permission.Type.SCHEDULE)) {
            ret.put("status", "error");
            ret.put("message", "Permission denied. Cannot execute " + flowName);
            return;
        }
        Flow flow = project.getFlow(flowName);
        if (flow == null) {
            ret.put("status", "error");
            ret.put("message", "Flow " + flowName + " cannot be found in project " + project);
            return;
        }
        String scheduleTime = this.getParam(req, "scheduleTime");
        String scheduleDate = this.getParam(req, "scheduleDate");
        try {
            firstSchedTime = this.parseDateTime(scheduleDate, scheduleTime);
        }
        catch (Exception e) {
            ret.put("error", "Invalid date and/or time '" + scheduleDate + " " + scheduleTime);
            return;
        }
        ReadablePeriod thePeriod = null;
        try {
            if (this.hasParam(req, "is_recurring") && this.getParam(req, "is_recurring").equals("on")) {
                thePeriod = Schedule.parsePeriodString(this.getParam(req, "period"));
            }
        }
        catch (Exception e) {
            ret.put("error", e.getMessage());
        }
        ExecutionOptions flowOptions = null;
        try {
            flowOptions = HttpRequestUtils.parseFlowOptions(req);
        }
        catch (Exception e) {
            ret.put("error", e.getMessage());
        }
        List<SlaOption> slaOptions = null;
        Schedule schedule = this.scheduleManager.scheduleFlow(-1, projectId, projectName, flowName, "ready", firstSchedTime.getMillis(), firstSchedTime.getZone(), thePeriod, DateTime.now().getMillis(), firstSchedTime.getMillis(), firstSchedTime.getMillis(), user.getUserId(), flowOptions, slaOptions);
        logger.info((Object)("User '" + user.getUserId() + "' has scheduled " + "[" + projectName + flowName + " (" + projectId + ")" + "]."));
        this.projectManager.postProjectEvent(project, ProjectLogEvent.EventType.SCHEDULE, user.getUserId(), "Schedule " + schedule.toString() + " has been added.");
        ret.put("status", "success");
        ret.put("message", projectName + "." + flowName + " scheduled.");
    }

    private DateTime parseDateTime(String scheduleDate, String scheduleTime) {
        String[] parts = scheduleTime.split(",", -1);
        int hour = Integer.parseInt(parts[0]);
        int minutes = Integer.parseInt(parts[1]);
        boolean isPm = parts[2].equalsIgnoreCase("pm");
        DateTimeZone timezone = parts[3].equals("UTC") ? DateTimeZone.UTC : DateTimeZone.forID((String)"America/Los_Angeles");
        DateTime day = null;
        day = scheduleDate == null || scheduleDate.trim().length() == 0 ? new LocalDateTime().toDateTime() : DateTimeFormat.forPattern((String)"MM/dd/yyyy").withZone(timezone).parseDateTime(scheduleDate);
        hour %= 12;
        if (isPm) {
            hour += 12;
        }
        DateTime firstSchedTime = day.withHourOfDay(hour).withMinuteOfHour(minutes).withSecondOfMinute(0);
        return firstSchedTime;
    }
}

