/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.alert.Alerter;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.Status;
import azkaban.executor.mail.DefaultMailCreator;
import azkaban.executor.mail.MailCreator;
import azkaban.sla.SlaOption;
import azkaban.utils.AbstractMailer;
import azkaban.utils.EmailMessage;
import azkaban.utils.Props;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;

public class Emailer
extends AbstractMailer
implements Alerter {
    private static Logger logger = Logger.getLogger(Emailer.class);
    private boolean testMode = false;
    private String clientHostname;
    private String clientPortNumber;
    private String mailHost;
    private String mailUser;
    private String mailPassword;
    private String mailSender;
    private String azkabanName;

    public Emailer(Props props) {
        super(props);
        this.azkabanName = props.getString("azkaban.name", "azkaban");
        this.mailHost = props.getString("mail.host", "localhost");
        this.mailUser = props.getString("mail.user", "");
        this.mailPassword = props.getString("mail.password", "");
        this.mailSender = props.getString("mail.sender", "");
        int mailTimeout = props.getInt("mail.timeout.millis", 10000);
        EmailMessage.setTimeout((int)mailTimeout);
        int connectionTimeout = props.getInt("mail.connection.timeout.millis", 10000);
        EmailMessage.setConnectionTimeout((int)connectionTimeout);
        this.clientHostname = props.getString("jetty.hostname", "localhost");
        this.clientPortNumber = props.getBoolean("jetty.use.ssl", true) ? props.getString("jetty.ssl.port") : props.getString("jetty.port");
        this.testMode = props.getBoolean("test.mode", false);
    }

    private void sendSlaAlertEmail(SlaOption slaOption, String slaMessage) {
        String subject = "Sla Violation Alert on " + this.getAzkabanName();
        String body = slaMessage;
        List emailList = (List)slaOption.getInfo().get("EmailList");
        if (emailList != null && !emailList.isEmpty()) {
            EmailMessage message = super.createEmailMessage(subject, "text/html", (Collection)emailList);
            message.setBody(body);
            if (!this.testMode) {
                try {
                    message.sendEmail();
                }
                catch (MessagingException e) {
                    logger.error((Object)"Email message send failed", (Throwable)e);
                }
            }
        }
    }

    public void sendFirstErrorMessage(ExecutableFlow flow) {
        EmailMessage message = new EmailMessage(this.mailHost, this.mailUser, this.mailPassword);
        message.setFromAddress(this.mailSender);
        ExecutionOptions option = flow.getExecutionOptions();
        MailCreator mailCreator = DefaultMailCreator.getCreator((String)option.getMailCreator());
        logger.debug((Object)("ExecutorMailer using mail creator:" + mailCreator.getClass().getCanonicalName()));
        boolean mailCreated = mailCreator.createFirstErrorMessage(flow, message, this.azkabanName, this.clientHostname, this.clientPortNumber, new String[0]);
        if (mailCreated && !this.testMode) {
            try {
                message.sendEmail();
            }
            catch (MessagingException e) {
                logger.error((Object)"Email message send failed", (Throwable)e);
            }
        }
    }

    public void sendErrorEmail(ExecutableFlow flow, String ... extraReasons) {
        EmailMessage message = new EmailMessage(this.mailHost, this.mailUser, this.mailPassword);
        message.setFromAddress(this.mailSender);
        ExecutionOptions option = flow.getExecutionOptions();
        MailCreator mailCreator = DefaultMailCreator.getCreator((String)option.getMailCreator());
        logger.debug((Object)("ExecutorMailer using mail creator:" + mailCreator.getClass().getCanonicalName()));
        boolean mailCreated = mailCreator.createErrorEmail(flow, message, this.azkabanName, this.clientHostname, this.clientPortNumber, extraReasons);
        if (mailCreated && !this.testMode) {
            try {
                message.sendEmail();
            }
            catch (MessagingException e) {
                logger.error((Object)"Email message send failed", (Throwable)e);
            }
        }
    }

    public void sendSuccessEmail(ExecutableFlow flow) {
        EmailMessage message = new EmailMessage(this.mailHost, this.mailUser, this.mailPassword);
        message.setFromAddress(this.mailSender);
        ExecutionOptions option = flow.getExecutionOptions();
        MailCreator mailCreator = DefaultMailCreator.getCreator((String)option.getMailCreator());
        logger.debug((Object)("ExecutorMailer using mail creator:" + mailCreator.getClass().getCanonicalName()));
        boolean mailCreated = mailCreator.createSuccessEmail(flow, message, this.azkabanName, this.clientHostname, this.clientPortNumber, new String[0]);
        if (mailCreated && !this.testMode) {
            try {
                message.sendEmail();
            }
            catch (MessagingException e) {
                logger.error((Object)"Email message send failed", (Throwable)e);
            }
        }
    }

    public static List<String> findFailedJobs(ExecutableFlow flow) {
        ArrayList<String> failedJobs = new ArrayList<String>();
        for (ExecutableNode node : flow.getExecutableNodes()) {
            if (node.getStatus() != Status.FAILED) continue;
            failedJobs.add(node.getId());
        }
        return failedJobs;
    }

    public void alertOnSuccess(ExecutableFlow exflow) throws Exception {
        this.sendSuccessEmail(exflow);
    }

    public void alertOnError(ExecutableFlow exflow, String ... extraReasons) throws Exception {
        this.sendErrorEmail(exflow, extraReasons);
    }

    public void alertOnFirstError(ExecutableFlow exflow) throws Exception {
        this.sendFirstErrorMessage(exflow);
    }

    public void alertOnSla(SlaOption slaOption, String slaMessage) throws Exception {
        this.sendSlaAlertEmail(slaOption, slaMessage);
    }
}

