/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.execapp;

import azkaban.execapp.JobRunner;
import azkaban.execapp.event.Event;
import azkaban.execapp.event.EventListener;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableFlowBase;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.Status;
import azkaban.jobtype.JobTypeManager;
import azkaban.test.execapp.EventCollectorListener;
import azkaban.test.execapp.MockExecutorLoader;
import azkaban.test.executor.JavaJob;
import azkaban.test.executor.SleepJavaJob;
import azkaban.utils.Props;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JobRunnerTest {
    private File workingDir;
    private JobTypeManager jobtypeManager;
    private Logger logger = Logger.getLogger((String)"JobRunnerTest");

    @Before
    public void setUp() throws Exception {
        System.out.println("Create temp dir");
        this.workingDir = new File("_AzkabanTestDir_" + System.currentTimeMillis());
        if (this.workingDir.exists()) {
            FileUtils.deleteDirectory((File)this.workingDir);
        }
        this.workingDir.mkdirs();
        this.jobtypeManager = new JobTypeManager(null, this.getClass().getClassLoader());
        this.jobtypeManager.registerJobType("java", JavaJob.class);
    }

    @After
    public void tearDown() throws IOException {
        System.out.println("Teardown temp dir");
        if (this.workingDir != null) {
            FileUtils.deleteDirectory((File)this.workingDir);
            this.workingDir = null;
        }
    }

    @Test
    public void testBasicRun() {
        MockExecutorLoader loader = new MockExecutorLoader();
        EventCollectorListener eventCollector = new EventCollectorListener();
        JobRunner runner = this.createJobRunner(1, "testJob", 1, false, (ExecutorLoader)loader, eventCollector);
        ExecutableNode node = runner.getNode();
        eventCollector.handleEvent(Event.create(null, (Event.Type)Event.Type.JOB_STARTED));
        Assert.assertTrue((runner.getStatus() != Status.SUCCEEDED || runner.getStatus() != Status.FAILED ? 1 : 0) != 0);
        runner.run();
        eventCollector.handleEvent(Event.create(null, (Event.Type)Event.Type.JOB_FINISHED));
        Assert.assertTrue((runner.getStatus() == node.getStatus() ? 1 : 0) != 0);
        Assert.assertTrue((String)("Node status is " + node.getStatus()), (node.getStatus() == Status.SUCCEEDED ? 1 : 0) != 0);
        Assert.assertTrue((node.getStartTime() > 0L && node.getEndTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((node.getEndTime() - node.getStartTime() > 1000L ? 1 : 0) != 0);
        File logFile = new File(runner.getLogFilePath());
        Props outputProps = runner.getNode().getOutputProps();
        Assert.assertTrue((outputProps != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)logFile.exists());
        Assert.assertTrue((loader.getNodeUpdateCount(node.getId()) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)eventCollector.checkOrdering());
        try {
            eventCollector.checkEventExists(new Event.Type[]{Event.Type.JOB_STARTED, Event.Type.JOB_STATUS_CHANGED, Event.Type.JOB_FINISHED});
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testFailedRun() {
        MockExecutorLoader loader = new MockExecutorLoader();
        EventCollectorListener eventCollector = new EventCollectorListener();
        JobRunner runner = this.createJobRunner(1, "testJob", 1, true, (ExecutorLoader)loader, eventCollector);
        ExecutableNode node = runner.getNode();
        Assert.assertTrue((runner.getStatus() != Status.SUCCEEDED || runner.getStatus() != Status.FAILED ? 1 : 0) != 0);
        runner.run();
        Assert.assertTrue((runner.getStatus() == node.getStatus() ? 1 : 0) != 0);
        Assert.assertTrue((node.getStatus() == Status.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((node.getStartTime() > 0L && node.getEndTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((node.getEndTime() - node.getStartTime() > 1000L ? 1 : 0) != 0);
        File logFile = new File(runner.getLogFilePath());
        Props outputProps = runner.getNode().getOutputProps();
        Assert.assertTrue((outputProps == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)logFile.exists());
        Assert.assertTrue((boolean)eventCollector.checkOrdering());
        Assert.assertTrue((!runner.isKilled() ? 1 : 0) != 0);
        Assert.assertTrue((loader.getNodeUpdateCount(node.getId()) == 3 ? 1 : 0) != 0);
        try {
            eventCollector.checkEventExists(new Event.Type[]{Event.Type.JOB_STARTED, Event.Type.JOB_STATUS_CHANGED, Event.Type.JOB_FINISHED});
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDisabledRun() {
        MockExecutorLoader loader = new MockExecutorLoader();
        EventCollectorListener eventCollector = new EventCollectorListener();
        JobRunner runner = this.createJobRunner(1, "testJob", 1, false, (ExecutorLoader)loader, eventCollector);
        ExecutableNode node = runner.getNode();
        node.setStatus(Status.DISABLED);
        Assert.assertTrue((runner.getStatus() == Status.DISABLED ? 1 : 0) != 0);
        runner.run();
        Assert.assertTrue((runner.getStatus() == node.getStatus() ? 1 : 0) != 0);
        Assert.assertTrue((node.getStatus() == Status.SKIPPED ? 1 : 0) != 0);
        Assert.assertTrue((node.getStartTime() > 0L && node.getEndTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((node.getEndTime() - node.getStartTime() < 10L ? 1 : 0) != 0);
        Props outputProps = runner.getNode().getOutputProps();
        Assert.assertTrue((outputProps == null ? 1 : 0) != 0);
        Assert.assertTrue((runner.getLogFilePath() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)eventCollector.checkOrdering());
        Assert.assertTrue((loader.getNodeUpdateCount(node.getId()) == null ? 1 : 0) != 0);
        try {
            eventCollector.checkEventExists(new Event.Type[]{Event.Type.JOB_STARTED, Event.Type.JOB_FINISHED});
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPreKilledRun() {
        MockExecutorLoader loader = new MockExecutorLoader();
        EventCollectorListener eventCollector = new EventCollectorListener();
        JobRunner runner = this.createJobRunner(1, "testJob", 1, false, (ExecutorLoader)loader, eventCollector);
        ExecutableNode node = runner.getNode();
        node.setStatus(Status.KILLED);
        Assert.assertTrue((runner.getStatus() == Status.KILLED ? 1 : 0) != 0);
        runner.run();
        Assert.assertTrue((runner.getStatus() == node.getStatus() ? 1 : 0) != 0);
        Assert.assertTrue((node.getStatus() == Status.KILLED ? 1 : 0) != 0);
        Assert.assertTrue((node.getStartTime() > 0L && node.getEndTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((node.getEndTime() - node.getStartTime() < 10L ? 1 : 0) != 0);
        Assert.assertTrue((loader.getNodeUpdateCount(node.getId()) == null ? 1 : 0) != 0);
        Props outputProps = runner.getNode().getOutputProps();
        Assert.assertTrue((outputProps == null ? 1 : 0) != 0);
        Assert.assertTrue((runner.getLogFilePath() == null ? 1 : 0) != 0);
        Assert.assertTrue((!runner.isKilled() ? 1 : 0) != 0);
        try {
            eventCollector.checkEventExists(new Event.Type[]{Event.Type.JOB_STARTED, Event.Type.JOB_FINISHED});
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelRun() {
        MockExecutorLoader loader = new MockExecutorLoader();
        EventCollectorListener eventCollector = new EventCollectorListener();
        JobRunner runner = this.createJobRunner(13, "testJob", 10, false, (ExecutorLoader)loader, eventCollector);
        ExecutableNode node = runner.getNode();
        Assert.assertTrue((runner.getStatus() != Status.SUCCEEDED || runner.getStatus() != Status.FAILED ? 1 : 0) != 0);
        Thread thread = new Thread((Runnable)runner);
        thread.start();
        JobRunnerTest jobRunnerTest = this;
        synchronized (jobRunnerTest) {
            try {
                this.wait(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            runner.kill();
            try {
                this.wait(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Assert.assertTrue((runner.getStatus() == node.getStatus() ? 1 : 0) != 0);
        Assert.assertTrue((String)("Status is " + node.getStatus()), (node.getStatus() == Status.KILLED ? 1 : 0) != 0);
        Assert.assertTrue((node.getStartTime() > 0L && node.getEndTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((node.getEndTime() - node.getStartTime() < 3000L ? 1 : 0) != 0);
        Assert.assertTrue((loader.getNodeUpdateCount(node.getId()) == 3 ? 1 : 0) != 0);
        File logFile = new File(runner.getLogFilePath());
        Props outputProps = runner.getNode().getOutputProps();
        Assert.assertTrue((outputProps == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)logFile.exists());
        Assert.assertTrue((boolean)eventCollector.checkOrdering());
        Assert.assertTrue((boolean)runner.isKilled());
        try {
            eventCollector.checkEventExists(new Event.Type[]{Event.Type.JOB_STARTED, Event.Type.JOB_STATUS_CHANGED, Event.Type.JOB_FINISHED});
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDelayedExecutionJob() {
        MockExecutorLoader loader = new MockExecutorLoader();
        EventCollectorListener eventCollector = new EventCollectorListener();
        JobRunner runner = this.createJobRunner(1, "testJob", 1, false, (ExecutorLoader)loader, eventCollector);
        runner.setDelayStart(5000L);
        long startTime = System.currentTimeMillis();
        ExecutableNode node = runner.getNode();
        eventCollector.handleEvent(Event.create(null, (Event.Type)Event.Type.JOB_STARTED));
        Assert.assertTrue((runner.getStatus() != Status.SUCCEEDED || runner.getStatus() != Status.FAILED ? 1 : 0) != 0);
        runner.run();
        eventCollector.handleEvent(Event.create(null, (Event.Type)Event.Type.JOB_FINISHED));
        Assert.assertTrue((runner.getStatus() == node.getStatus() ? 1 : 0) != 0);
        Assert.assertTrue((String)("Node status is " + node.getStatus()), (node.getStatus() == Status.SUCCEEDED ? 1 : 0) != 0);
        Assert.assertTrue((node.getStartTime() > 0L && node.getEndTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((node.getEndTime() - node.getStartTime() > 1000L ? 1 : 0) != 0);
        Assert.assertTrue((node.getStartTime() - startTime >= 5000L ? 1 : 0) != 0);
        File logFile = new File(runner.getLogFilePath());
        Props outputProps = runner.getNode().getOutputProps();
        Assert.assertTrue((outputProps != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)logFile.exists());
        Assert.assertFalse((boolean)runner.isKilled());
        Assert.assertTrue((loader.getNodeUpdateCount(node.getId()) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)eventCollector.checkOrdering());
        try {
            eventCollector.checkEventExists(new Event.Type[]{Event.Type.JOB_STARTED, Event.Type.JOB_STATUS_CHANGED, Event.Type.JOB_FINISHED});
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelayedExecutionCancelledJob() {
        MockExecutorLoader loader = new MockExecutorLoader();
        EventCollectorListener eventCollector = new EventCollectorListener();
        JobRunner runner = this.createJobRunner(1, "testJob", 1, false, (ExecutorLoader)loader, eventCollector);
        runner.setDelayStart(5000L);
        long startTime = System.currentTimeMillis();
        ExecutableNode node = runner.getNode();
        eventCollector.handleEvent(Event.create(null, (Event.Type)Event.Type.JOB_STARTED));
        Assert.assertTrue((runner.getStatus() != Status.SUCCEEDED || runner.getStatus() != Status.FAILED ? 1 : 0) != 0);
        Thread thread = new Thread((Runnable)runner);
        thread.start();
        JobRunnerTest jobRunnerTest = this;
        synchronized (jobRunnerTest) {
            try {
                this.wait(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            runner.kill();
            try {
                this.wait(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        eventCollector.handleEvent(Event.create(null, (Event.Type)Event.Type.JOB_FINISHED));
        Assert.assertTrue((runner.getStatus() == node.getStatus() ? 1 : 0) != 0);
        Assert.assertTrue((String)("Node status is " + node.getStatus()), (node.getStatus() == Status.KILLED ? 1 : 0) != 0);
        Assert.assertTrue((node.getStartTime() > 0L && node.getEndTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((node.getEndTime() - node.getStartTime() < 1000L ? 1 : 0) != 0);
        Assert.assertTrue((node.getStartTime() - startTime >= 2000L ? 1 : 0) != 0);
        Assert.assertTrue((node.getStartTime() - startTime <= 5000L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)runner.isKilled());
        File logFile = new File(runner.getLogFilePath());
        Props outputProps = runner.getNode().getOutputProps();
        Assert.assertTrue((outputProps == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)logFile.exists());
        Assert.assertTrue((boolean)eventCollector.checkOrdering());
        try {
            eventCollector.checkEventExists(new Event.Type[]{Event.Type.JOB_FINISHED});
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private Props createProps(int sleepSec, boolean fail) {
        Props props = new Props();
        props.put("type", "java");
        props.put("job.class", SleepJavaJob.class.getName());
        props.put("seconds", Integer.valueOf(sleepSec));
        props.put("working.dir", this.workingDir.getPath());
        props.put("fail", String.valueOf(fail));
        return props;
    }

    private JobRunner createJobRunner(int execId, String name, int time, boolean fail, ExecutorLoader loader, EventCollectorListener listener) {
        ExecutableFlow flow = new ExecutableFlow();
        flow.setExecutionId(execId);
        ExecutableNode node = new ExecutableNode();
        node.setId(name);
        node.setParentFlow((ExecutableFlowBase)flow);
        Props props = this.createProps(time, fail);
        node.setInputProps(props);
        HashSet<String> proxyUsers = new HashSet<String>();
        proxyUsers.add(flow.getSubmitUser());
        JobRunner runner = new JobRunner(node, this.workingDir, loader, this.jobtypeManager);
        runner.setLogSettings(this.logger, "5MB", 4);
        runner.addListener((EventListener)listener);
        return runner;
    }
}

