/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.ConditionIn;
import org.h2.expression.ConditionNot;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionAndOr
extends Condition {
    public static final int AND = 0;
    public static final int OR = 1;
    private final int andOrType;
    private Expression left;
    private Expression right;

    public ConditionAndOr(int n, Expression expression, Expression expression2) {
        this.andOrType = n;
        this.left = expression;
        this.right = expression2;
        if (SysProperties.CHECK && (expression == null || expression2 == null)) {
            DbException.throwInternalError();
        }
    }

    @Override
    public String getSQL() {
        String string;
        switch (this.andOrType) {
            case 0: {
                string = this.left.getSQL() + "\n    AND " + this.right.getSQL();
                break;
            }
            case 1: {
                string = this.left.getSQL() + "\n    OR " + this.right.getSQL();
                break;
            }
            default: {
                throw DbException.throwInternalError("andOrType=" + this.andOrType);
            }
        }
        return "(" + string + ")";
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (this.andOrType == 0) {
            this.left.createIndexConditions(session, tableFilter);
            this.right.createIndexConditions(session, tableFilter);
        }
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        Expression expression;
        Expression expression2 = this.left.getNotIfPossible(session);
        if (expression2 == null) {
            expression2 = new ConditionNot(this.left);
        }
        if ((expression = this.right.getNotIfPossible(session)) == null) {
            expression = new ConditionNot(this.right);
        }
        int n = this.andOrType == 0 ? 1 : 0;
        return new ConditionAndOr(n, expression2, expression);
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.left.getValue(session);
        switch (this.andOrType) {
            case 0: {
                if (Boolean.FALSE.equals(value.getBoolean())) {
                    return value;
                }
                Value value2 = this.right.getValue(session);
                if (Boolean.FALSE.equals(value2.getBoolean())) {
                    return value2;
                }
                if (value == ValueNull.INSTANCE) {
                    return value;
                }
                if (value2 == ValueNull.INSTANCE) {
                    return value2;
                }
                return ValueBoolean.get(true);
            }
            case 1: {
                if (Boolean.TRUE.equals(value.getBoolean())) {
                    return value;
                }
                Value value3 = this.right.getValue(session);
                if (Boolean.TRUE.equals(value3.getBoolean())) {
                    return value3;
                }
                if (value == ValueNull.INSTANCE) {
                    return value;
                }
                if (value3 == ValueNull.INSTANCE) {
                    return value3;
                }
                return ValueBoolean.get(false);
            }
        }
        throw DbException.throwInternalError("type=" + this.andOrType);
    }

    @Override
    public Expression optimize(Session session) {
        Object object;
        Expression expression;
        Expression expression2;
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        int n = this.left.getCost();
        int n2 = this.right.getCost();
        if (n2 < n) {
            expression2 = this.left;
            this.left = this.right;
            this.right = expression2;
        }
        if (session.getDatabase().getSettings().optimizeTwoEquals && this.andOrType == 0 && this.left instanceof Comparison && this.right instanceof Comparison && (expression = ((Comparison)(expression2 = (Comparison)this.left)).getAdditional(session, (Comparison)(object = (Comparison)this.right), true)) != null) {
            expression = expression.optimize(session);
            ConditionAndOr conditionAndOr = new ConditionAndOr(0, this, expression);
            return conditionAndOr;
        }
        if (this.andOrType == 1 && session.getDatabase().getSettings().optimizeOr) {
            if (this.left instanceof Comparison && this.right instanceof Comparison) {
                expression2 = (Comparison)this.left;
                object = (Comparison)this.right;
                expression = ((Comparison)expression2).getAdditional(session, (Comparison)object, false);
                if (expression != null) {
                    return expression.optimize(session);
                }
            } else if (this.left instanceof ConditionIn && this.right instanceof Comparison ? (expression2 = ((ConditionIn)this.left).getAdditional((Comparison)this.right)) != null : this.right instanceof ConditionIn && this.left instanceof Comparison && (expression2 = ((ConditionIn)this.right).getAdditional((Comparison)this.left)) != null) {
                return expression2.optimize(session);
            }
        }
        expression2 = this.left.isConstant() ? this.left.getValue(session) : null;
        Object object2 = object = this.right.isConstant() ? this.right.getValue(session) : null;
        if (expression2 == null && object == null) {
            return this;
        }
        if (expression2 != null && object != null) {
            return ValueExpression.get(this.getValue(session));
        }
        switch (this.andOrType) {
            case 0: {
                if (expression2 != null) {
                    if (Boolean.FALSE.equals(((Value)((Object)expression2)).getBoolean())) {
                        return ValueExpression.get((Value)((Object)expression2));
                    }
                    if (!Boolean.TRUE.equals(((Value)((Object)expression2)).getBoolean())) break;
                    return this.right;
                }
                if (object == null) break;
                if (Boolean.FALSE.equals(((Value)object).getBoolean())) {
                    return ValueExpression.get((Value)object);
                }
                if (!Boolean.TRUE.equals(((Value)object).getBoolean())) break;
                return this.left;
            }
            case 1: {
                if (expression2 != null) {
                    if (Boolean.TRUE.equals(((Value)((Object)expression2)).getBoolean())) {
                        return ValueExpression.get((Value)((Object)expression2));
                    }
                    if (!Boolean.FALSE.equals(((Value)((Object)expression2)).getBoolean())) break;
                    return this.right;
                }
                if (object == null) break;
                if (Boolean.TRUE.equals(((Value)object).getBoolean())) {
                    return ValueExpression.get((Value)object);
                }
                if (!Boolean.FALSE.equals(((Value)object).getBoolean())) break;
                return this.left;
            }
            default: {
                DbException.throwInternalError("type=" + this.andOrType);
            }
        }
        return this;
    }

    @Override
    public void addFilterConditions(TableFilter tableFilter, boolean bl) {
        if (this.andOrType == 0) {
            this.left.addFilterConditions(tableFilter, bl);
            this.right.addFilterConditions(tableFilter, bl);
        } else {
            super.addFilterConditions(tableFilter, bl);
        }
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.left.mapColumns(columnResolver, n);
        this.right.mapColumns(columnResolver, n);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.right.setEvaluatable(tableFilter, bl);
    }

    @Override
    public void updateAggregate(Session session) {
        this.left.updateAggregate(session);
        this.right.updateAggregate(session);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.right.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + this.right.getCost();
    }

    public Expression getExpression(boolean bl) {
        return bl ? this.left : this.right;
    }
}

