/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.trigger;

import azkaban.test.trigger.DummyTriggerAction;
import azkaban.test.trigger.ThresholdChecker;
import azkaban.test.trigger.TriggerManagerTest;
import azkaban.trigger.Condition;
import azkaban.trigger.Trigger;
import azkaban.trigger.TriggerException;
import azkaban.trigger.TriggerLoader;
import azkaban.trigger.TriggerManager;
import azkaban.trigger.TriggerManagerException;
import azkaban.utils.Props;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TriggerManagerTest {
    private TriggerLoader triggerLoader;

    @Before
    public void setup() throws TriggerException, TriggerManagerException {
        this.triggerLoader = new MockTriggerLoader(this);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void TriggerManagerSimpleTest() throws TriggerManagerException {
        Props props = new Props();
        props.put("trigger.scan.interval", Integer.valueOf(4000));
        TriggerManager triggerManager = new TriggerManager(props, this.triggerLoader, null);
        triggerManager.registerCheckerType("ThresholdChecker", ThresholdChecker.class);
        triggerManager.registerActionType("DummyAction", DummyTriggerAction.class);
        ThresholdChecker.setVal((int)1);
        triggerManager.insertTrigger(this.createDummyTrigger("test1", "triggerLoader", 10), "testUser");
        List triggers = triggerManager.getTriggers();
        Assert.assertTrue((triggers.size() == 1 ? 1 : 0) != 0);
        Trigger t1 = (Trigger)triggers.get(0);
        t1.setResetOnTrigger(false);
        triggerManager.updateTrigger(t1, "testUser");
        ThresholdChecker checker1 = (ThresholdChecker)t1.getTriggerCondition().getCheckers().values().toArray()[0];
        Assert.assertTrue((boolean)t1.getSource().equals("triggerLoader"));
        Trigger t2 = this.createDummyTrigger("test2: add new trigger", "addNewTriggerTest", 20);
        triggerManager.insertTrigger(t2, "testUser");
        ThresholdChecker checker2 = (ThresholdChecker)t2.getTriggerCondition().getCheckers().values().toArray()[0];
        ThresholdChecker.setVal((int)15);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Assert.assertTrue((!checker1.isCheckerMet() ? 1 : 0) != 0);
        Assert.assertTrue((!checker2.isCheckerMet() ? 1 : 0) != 0);
        Assert.assertTrue((!checker1.isCheckerReset() ? 1 : 0) != 0);
        Assert.assertTrue((!checker2.isCheckerReset() ? 1 : 0) != 0);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Assert.assertTrue((boolean)checker1.isCheckerMet());
        Assert.assertTrue((!checker2.isCheckerMet() ? 1 : 0) != 0);
        Assert.assertTrue((!checker1.isCheckerReset() ? 1 : 0) != 0);
        Assert.assertTrue((!checker2.isCheckerReset() ? 1 : 0) != 0);
        ThresholdChecker.setVal((int)25);
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Assert.assertTrue((boolean)checker1.isCheckerMet());
        Assert.assertTrue((!checker1.isCheckerReset() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)checker2.isCheckerReset());
        triggers = triggerManager.getTriggers();
        Assert.assertTrue((triggers.size() == 1 ? 1 : 0) != 0);
    }

    private Trigger createDummyTrigger(String message, String source, int threshold) {
        HashMap<String, ThresholdChecker> checkers = new HashMap<String, ThresholdChecker>();
        ThresholdChecker checker = new ThresholdChecker("ThresholdChecker", threshold);
        checkers.put(checker.getId(), checker);
        ArrayList<DummyTriggerAction> actions = new ArrayList<DummyTriggerAction>();
        DummyTriggerAction act = new DummyTriggerAction(message);
        actions.add(act);
        String expr = String.valueOf(checker.getId()) + ".eval()";
        Condition triggerCond = new Condition(checkers, expr);
        Condition expireCond = new Condition(checkers, expr);
        Trigger fakeTrigger = new Trigger(DateTime.now().getMillis(), DateTime.now().getMillis(), "azkaban", source, triggerCond, expireCond, actions);
        fakeTrigger.setResetOnTrigger(true);
        fakeTrigger.setResetOnExpire(true);
        return fakeTrigger;
    }
}

