/*
 * Decompiled with CFR 0.152.
 */
package azkaban.jobExecutor;

import azkaban.jobExecutor.AbstractProcessJob;
import azkaban.jobExecutor.utils.process.AzkabanProcess;
import azkaban.jobExecutor.utils.process.AzkabanProcessBuilder;
import azkaban.utils.Props;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ProcessJob
extends AbstractProcessJob {
    public static final String COMMAND = "command";
    private static final long KILL_TIME_MS = 5000L;
    private volatile AzkabanProcess process;

    public ProcessJob(String jobId, Props sysProps, Props jobProps, Logger log) {
        super(jobId, sysProps, jobProps, log);
    }

    @Override
    public void run() throws Exception {
        try {
            this.resolveProps();
        }
        catch (Exception e) {
            this.error("Bad property definition! " + e.getMessage());
        }
        List<String> commands = null;
        try {
            commands = this.getCommandList();
        }
        catch (Exception e) {
            this.error("Job set up failed " + e.getCause());
        }
        long startMs = System.currentTimeMillis();
        this.info(commands.size() + " commands to execute.");
        File[] propFiles = this.initPropsFiles();
        Map<String, String> envVars = this.getEnvironmentVariables();
        for (String command : commands) {
            this.info("Command: " + command);
            AzkabanProcessBuilder builder = new AzkabanProcessBuilder(ProcessJob.partitionCommandLine(command)).setEnv(envVars).setWorkingDir(this.getCwd()).setLogger(this.getLog());
            if (builder.getEnv().size() > 0) {
                this.info("Environment variables: " + builder.getEnv());
            }
            this.info("Working directory: " + builder.getWorkingDir());
            boolean success = false;
            this.process = builder.build();
            try {
                this.process.run();
                success = true;
                this.process = null;
                this.info("Process completed " + (success ? "successfully" : "unsuccessfully") + " in " + (System.currentTimeMillis() - startMs) / 1000L + " seconds.");
            }
            catch (Throwable e) {
                try {
                    for (File file : propFiles) {
                        if (file == null || !file.exists()) continue;
                        file.delete();
                    }
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.process = null;
                    this.info("Process completed " + (success ? "successfully" : "unsuccessfully") + " in " + (System.currentTimeMillis() - startMs) / 1000L + " seconds.");
                    throw throwable;
                }
            }
        }
        this.generateProperties(propFiles[1]);
    }

    protected List<String> getCommandList() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.jobProps.getString(COMMAND));
        int i = 1;
        while (this.jobProps.containsKey("command." + i)) {
            commands.add(this.jobProps.getString("command." + i));
            ++i;
        }
        return commands;
    }

    @Override
    public void cancel() throws InterruptedException {
        if (this.process == null) {
            throw new IllegalStateException("Not started.");
        }
        boolean killed = this.process.softKill(5000L, TimeUnit.MILLISECONDS);
        if (!killed) {
            this.warn("Kill with signal TERM failed. Killing with KILL signal.");
            this.process.hardKill();
        }
    }

    @Override
    public double getProgress() {
        return this.process != null && this.process.isComplete() ? 1.0 : 0.0;
    }

    public int getProcessId() {
        return this.process.getProcessId();
    }

    public String getPath() {
        return this._jobPath == null ? "" : this._jobPath;
    }

    public static String[] partitionCommandLine(String command) {
        ArrayList<String> commands = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer(command.length());
        boolean isApos = false;
        boolean isQuote = false;
        block5: for (int index = 0; index < command.length(); ++index) {
            char c = command.charAt(index);
            switch (c) {
                case ' ': {
                    if (!isQuote && !isApos) {
                        String arg = buffer.toString();
                        buffer = new StringBuffer(command.length() - index);
                        if (arg.length() <= 0) continue block5;
                        commands.add(arg);
                        continue block5;
                    }
                    buffer.append(c);
                    continue block5;
                }
                case '\'': {
                    if (!isQuote) {
                        isApos = !isApos;
                        continue block5;
                    }
                    buffer.append(c);
                    continue block5;
                }
                case '\"': {
                    if (!isApos) {
                        isQuote = !isQuote;
                        continue block5;
                    }
                    buffer.append(c);
                    continue block5;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        if (buffer.length() > 0) {
            String arg = buffer.toString();
            commands.add(arg);
        }
        return commands.toArray(new String[commands.size()]);
    }
}

