/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp.servlet;

import azkaban.executor.ConnectorParams;
import azkaban.executor.ExecutorManagerAdapter;
import azkaban.trigger.TriggerManager;
import azkaban.user.Permission;
import azkaban.user.Role;
import azkaban.user.User;
import azkaban.user.UserManager;
import azkaban.webapp.AzkabanWebServer;
import azkaban.webapp.servlet.LoginAbstractAzkabanServlet;
import azkaban.webapp.servlet.Page;
import azkaban.webapp.session.Session;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class JMXHttpServlet
extends LoginAbstractAzkabanServlet
implements ConnectorParams {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)JMXHttpServlet.class.getName());
    private UserManager userManager;
    private AzkabanWebServer server;
    private ExecutorManagerAdapter executorManager;
    private TriggerManager triggerManager;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.server = (AzkabanWebServer)this.getApplication();
        this.userManager = this.server.getUserManager();
        this.executorManager = this.server.getExecutorManager();
        this.triggerManager = this.server.getTriggerManager();
    }

    protected void handleGet(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        if (this.hasParam(req, "ajax")) {
            Map<String, String> ret = new HashMap<String, Object>();
            if (!this.hasPermission(session.getUser(), Permission.Type.METRICS)) {
                ret.put("error", "User " + session.getUser().getUserId() + " has no permission.");
                this.writeJSON(resp, ret, true);
                return;
            }
            String ajax = this.getParam(req, "ajax");
            if ("getAllExecutorAttributes".equals(ajax)) {
                if (!this.hasParam(req, "mBean") || !this.hasParam(req, "hostPort")) {
                    ret.put("error", "Parameters 'mBean' and 'hostPort' must be set");
                    this.writeJSON(resp, ret, true);
                    return;
                }
                String hostPort = this.getParam(req, "hostPort");
                String mbean = this.getParam(req, "mBean");
                Map result = this.executorManager.callExecutorJMX(hostPort, "getAllMBeanAttributes", mbean);
                ret = result;
            } else if ("getMBeans".equals(ajax)) {
                ret.put("mbeans", (String)((Object)this.server.getMbeanNames()));
            } else if ("getMBeanInfo".equals(ajax)) {
                if (this.hasParam(req, "mBean")) {
                    String mbeanName = this.getParam(req, "mBean");
                    try {
                        ObjectName name = new ObjectName(mbeanName);
                        MBeanInfo info = this.server.getMBeanInfo(name);
                        ret.put("attributes", (String)info.getAttributes());
                        ret.put("description", info.getDescription());
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                        ret.put("error", "'" + mbeanName + "' is not a valid mBean name");
                    }
                } else {
                    ret.put("error", "No 'mbean' name parameter specified");
                }
            } else if ("getAttribute".equals(ajax)) {
                if (!this.hasParam(req, "mBean") || !this.hasParam(req, "attribute")) {
                    ret.put("error", "Parameters 'mbean' and 'attribute' must be set");
                } else {
                    String mbeanName = this.getParam(req, "mBean");
                    String attribute = this.getParam(req, "attribute");
                    try {
                        ObjectName name = new ObjectName(mbeanName);
                        Object obj = this.server.getMBeanAttribute(name, attribute);
                        ret.put("value", (String)obj);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                        ret.put("error", "'" + mbeanName + "' is not a valid mBean name");
                    }
                }
            } else if ("getAllMBeanAttributes".equals(ajax)) {
                if (!this.hasParam(req, "mBean")) {
                    ret.put("error", "Parameters 'mbean' must be set");
                } else {
                    String mbeanName = this.getParam(req, "mBean");
                    try {
                        ObjectName name = new ObjectName(mbeanName);
                        MBeanInfo info = this.server.getMBeanInfo(name);
                        MBeanAttributeInfo[] mbeanAttrs = info.getAttributes();
                        HashMap<String, Object> attributes = new HashMap<String, Object>();
                        MBeanAttributeInfo[] mBeanAttributeInfoArray = mbeanAttrs;
                        int n = mbeanAttrs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MBeanAttributeInfo attrInfo = mBeanAttributeInfoArray[n2];
                            Object obj = this.server.getMBeanAttribute(name, attrInfo.getName());
                            attributes.put(attrInfo.getName(), obj);
                            ++n2;
                        }
                        ret.put("attributes", (String)((Object)attributes));
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                        ret.put("error", "'" + mbeanName + "' is not a valid mBean name");
                    }
                }
            } else {
                ret.put("commands", (String)new String[]{"getMBeans", "getMBeanInfo&mBean=<name>", "getAttribute&mBean=<name>&attribute=<attributename>"});
            }
            this.writeJSON(resp, ret, true);
        } else {
            this.handleJMXPage(req, resp, session);
        }
    }

    private void handleJMXPage(HttpServletRequest req, HttpServletResponse resp, Session session) throws IOException {
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/jmxpage.vm");
        if (!this.hasPermission(session.getUser(), Permission.Type.METRICS)) {
            page.add("errorMsg", (Object)("User " + session.getUser().getUserId() + " has no permission."));
            page.render();
            return;
        }
        page.add("mbeans", (Object)this.server.getMbeanNames());
        HashMap executorMBeans = new HashMap();
        for (String hostPort : this.executorManager.getAllActiveExecutorServerHosts()) {
            try {
                Map mbeans = this.executorManager.callExecutorJMX(hostPort, "getMBeans", null);
                executorMBeans.put(hostPort, mbeans.get("mbeans"));
            }
            catch (IOException e) {
                logger.error((Object)("Cannot contact executor " + hostPort), (Throwable)e);
            }
        }
        page.add("executorRemoteMBeans", executorMBeans);
        HashMap<String, Map> triggerserverMBeans = new HashMap<String, Map>();
        triggerserverMBeans.put(this.triggerManager.getJMX().getPrimaryServerHost(), this.triggerManager.getJMX().getAllJMXMbeans());
        page.add("triggerserverRemoteMBeans", triggerserverMBeans);
        page.render();
    }

    protected void handlePost(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
    }

    protected boolean hasPermission(User user, Permission.Type type) {
        for (String roleName : user.getRoles()) {
            Role role = this.userManager.getRole(roleName);
            if (!role.getPermission().isPermissionSet(type) && !role.getPermission().isPermissionSet(Permission.Type.ADMIN)) continue;
            return true;
        }
        return false;
    }
}

