/*
 * Decompiled with CFR 0.152.
 */
package azkaban.jobExecutor;

import azkaban.jobExecutor.ProcessJob;
import azkaban.utils.Props;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class JavaProcessJob
extends ProcessJob {
    public static final String CLASSPATH = "classpath";
    public static final String GLOBAL_CLASSPATH = "global.classpaths";
    public static final String JAVA_CLASS = "java.class";
    public static final String INITIAL_MEMORY_SIZE = "Xms";
    public static final String MAX_MEMORY_SIZE = "Xmx";
    public static final String MAIN_ARGS = "main.args";
    public static final String JVM_PARAMS = "jvm.args";
    public static final String GLOBAL_JVM_PARAMS = "global.jvm.args";
    public static final String DEFAULT_INITIAL_MEMORY_SIZE = "64M";
    public static final String DEFAULT_MAX_MEMORY_SIZE = "256M";
    public static String JAVA_COMMAND = "java";

    public JavaProcessJob(String jobid, Props sysProps, Props jobProps, Logger logger) {
        super(jobid, sysProps, jobProps, logger);
    }

    protected List<String> getCommandList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.createCommandLine());
        return list;
    }

    protected String createCommandLine() {
        String command = String.valueOf(JAVA_COMMAND) + " ";
        command = String.valueOf(command) + this.getJVMArguments() + " ";
        command = String.valueOf(command) + "-Xms" + this.getInitialMemorySize() + " ";
        command = String.valueOf(command) + "-Xmx" + this.getMaxMemorySize() + " ";
        command = String.valueOf(command) + "-cp " + this.createArguments(this.getClassPaths(), ":") + " ";
        command = String.valueOf(command) + this.getJavaClass() + " ";
        command = String.valueOf(command) + this.getMainArguments();
        return command;
    }

    protected String getJavaClass() {
        return this.getJobProps().getString(JAVA_CLASS);
    }

    protected String getClassPathParam() {
        List classPath = this.getClassPaths();
        if (classPath == null || classPath.size() == 0) {
            return "";
        }
        return "-cp " + this.createArguments(classPath, ":") + " ";
    }

    protected List<String> getClassPaths() {
        List classPaths = this.getJobProps().getStringList(CLASSPATH, null, ",");
        ArrayList<String> classpathList = new ArrayList<String>();
        if (this.getJobProps().containsKey((Object)GLOBAL_CLASSPATH)) {
            List globalClasspath = this.getJobProps().getStringList(GLOBAL_CLASSPATH);
            for (String global : globalClasspath) {
                this.getLog().info((Object)("Adding to global classpath:" + global));
                classpathList.add(global);
            }
        }
        if (classPaths == null) {
            File path = new File(this.getPath());
            this.getLog().info((Object)("No classpath specified. Trying to load classes from " + path));
            if (path != null) {
                File[] fileArray = path.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.getName().endsWith(".jar")) {
                        classpathList.add(file.getName());
                    }
                    ++n2;
                }
            }
        } else {
            classpathList.addAll(classPaths);
        }
        return classpathList;
    }

    protected String getInitialMemorySize() {
        return this.getJobProps().getString(INITIAL_MEMORY_SIZE, DEFAULT_INITIAL_MEMORY_SIZE);
    }

    protected String getMaxMemorySize() {
        return this.getJobProps().getString(MAX_MEMORY_SIZE, DEFAULT_MAX_MEMORY_SIZE);
    }

    protected String getMainArguments() {
        return this.getJobProps().getString(MAIN_ARGS, "");
    }

    protected String getJVMArguments() {
        String globalJVMArgs = this.getJobProps().getString(GLOBAL_JVM_PARAMS, null);
        if (globalJVMArgs == null) {
            return this.getJobProps().getString(JVM_PARAMS, "");
        }
        return String.valueOf(globalJVMArgs) + " " + this.getJobProps().getString(JVM_PARAMS, "");
    }

    protected String createArguments(List<String> arguments, String separator) {
        if (arguments != null && arguments.size() > 0) {
            String param = "";
            for (String arg : arguments) {
                param = String.valueOf(param) + arg + separator;
            }
            return param.substring(0, param.length() - 1);
        }
        return "";
    }
}

