/*
 * Decompiled with CFR 0.152.
 */
package azkaban.migration.scheduler;

import azkaban.database.DataSourceUtils;
import azkaban.migration.scheduler.JdbcScheduleLoader;
import azkaban.migration.scheduler.Schedule;
import azkaban.migration.scheduler.ScheduleLoader;
import azkaban.migration.scheduler.ScheduleManagerException;
import azkaban.utils.GZIPUtils;
import azkaban.utils.JSONUtils;
import azkaban.utils.Props;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.log4j.Logger;
import org.joda.time.ReadablePeriod;

@Deprecated
public class JdbcScheduleLoader
implements ScheduleLoader {
    private static Logger logger = Logger.getLogger(JdbcScheduleLoader.class);
    private DataSource dataSource;
    private EncodingType defaultEncodingType = EncodingType.GZIP;
    private static final String scheduleTableName = "schedules";
    private static String SELECT_ALL_SCHEDULES = "SELECT project_id, project_name, flow_name, status, first_sched_time, timezone, period, last_modify_time, next_exec_time, submit_time, submit_user, enc_type, schedule_options FROM schedules";
    private static String INSERT_SCHEDULE = "INSERT INTO schedules ( project_id, project_name, flow_name, status, first_sched_time, timezone, period, last_modify_time, next_exec_time, submit_time, submit_user, enc_type, schedule_options) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static String REMOVE_SCHEDULE_BY_KEY = "DELETE FROM schedules WHERE project_id=? AND flow_name=?";
    private static String UPDATE_SCHEDULE_BY_KEY = "UPDATE schedules SET status=?, first_sched_time=?, timezone=?, period=?, last_modify_time=?, next_exec_time=?, submit_time=?, submit_user=?, enc_type=?, schedule_options=? WHERE project_id=? AND flow_name=?";
    private static String UPDATE_NEXT_EXEC_TIME = "UPDATE schedules SET next_exec_time=? WHERE project_id=? AND flow_name=?";

    private Connection getConnection() throws ScheduleManagerException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (Exception e) {
            DbUtils.closeQuietly((Connection)connection);
            throw new ScheduleManagerException("Error getting DB connection.", (Throwable)e);
        }
        return connection;
    }

    public EncodingType getDefaultEncodingType() {
        return this.defaultEncodingType;
    }

    public void setDefaultEncodingType(EncodingType defaultEncodingType) {
        this.defaultEncodingType = defaultEncodingType;
    }

    public JdbcScheduleLoader(Props props) {
        String databaseType = props.getString("database.type");
        if (databaseType.equals("mysql")) {
            int port = props.getInt("mysql.port");
            String host = props.getString("mysql.host");
            String database = props.getString("mysql.database");
            String user = props.getString("mysql.user");
            String password = props.getString("mysql.password");
            int numConnections = props.getInt("mysql.numconnections");
            this.dataSource = DataSourceUtils.getMySQLDataSource((String)host, (Integer)port, (String)database, (String)user, (String)password, (Integer)numConnections);
        }
    }

    public List<Schedule> loadSchedules() throws ScheduleManagerException {
        List schedules;
        logger.info((Object)"Loading all schedules from db.");
        Connection connection = this.getConnection();
        QueryRunner runner = new QueryRunner();
        ScheduleResultHandler handler = new ScheduleResultHandler(this);
        try {
            try {
                schedules = (List)runner.query(connection, SELECT_ALL_SCHEDULES, (ResultSetHandler)handler);
            }
            catch (SQLException e) {
                logger.error((Object)(String.valueOf(SELECT_ALL_SCHEDULES) + " failed."));
                DbUtils.closeQuietly((Connection)connection);
                throw new ScheduleManagerException("Loading schedules from db failed. ", (Throwable)e);
            }
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
        logger.info((Object)"Now trying to update the schedules");
        Iterator scheduleIterator = schedules.iterator();
        while (scheduleIterator.hasNext()) {
            Schedule sched = (Schedule)scheduleIterator.next();
            if (!sched.updateTime()) {
                logger.info((Object)("Schedule " + sched.getScheduleName() + " was scheduled before azkaban start, skipping it."));
                scheduleIterator.remove();
                this.removeSchedule(sched);
                continue;
            }
            logger.info((Object)"Recurring schedule, need to update next exec time");
            try {
                this.updateNextExecTime(sched);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ScheduleManagerException("Update next execution time failed.", (Throwable)e);
            }
            logger.info((Object)("Schedule " + sched.getScheduleName() + " loaded and updated."));
        }
        logger.info((Object)("Loaded " + schedules.size() + " schedules."));
        return schedules;
    }

    public void removeSchedule(Schedule s) throws ScheduleManagerException {
        logger.info((Object)("Removing schedule " + s.getScheduleName() + " from db."));
        QueryRunner runner = new QueryRunner(this.dataSource);
        try {
            int removes = runner.update(REMOVE_SCHEDULE_BY_KEY, new Object[]{s.getProjectId(), s.getFlowName()});
            if (removes == 0) {
                throw new ScheduleManagerException("No schedule has been removed.");
            }
        }
        catch (SQLException e) {
            logger.error((Object)(String.valueOf(REMOVE_SCHEDULE_BY_KEY) + " failed."));
            throw new ScheduleManagerException("Remove schedule " + s.getScheduleName() + " from db failed. ", (Throwable)e);
        }
    }

    public void insertSchedule(Schedule s) throws ScheduleManagerException {
        logger.info((Object)("Inserting schedule " + s.getScheduleName() + " into db."));
        this.insertSchedule(s, this.defaultEncodingType);
    }

    public void insertSchedule(Schedule s, EncodingType encType) throws ScheduleManagerException {
        String json = JSONUtils.toJSON((Object)s.optionsToObject());
        byte[] data = null;
        try {
            byte[] stringData;
            data = stringData = json.getBytes("UTF-8");
            if (encType == EncodingType.GZIP) {
                data = GZIPUtils.gzipBytes((byte[])stringData);
            }
            logger.debug((Object)("NumChars: " + json.length() + " UTF-8:" + stringData.length + " Gzip:" + data.length));
        }
        catch (IOException e) {
            throw new ScheduleManagerException("Error encoding the schedule options. " + s.getScheduleName());
        }
        QueryRunner runner = new QueryRunner(this.dataSource);
        try {
            int inserts = runner.update(INSERT_SCHEDULE, new Object[]{s.getProjectId(), s.getProjectName(), s.getFlowName(), s.getStatus(), s.getFirstSchedTime(), s.getTimezone().getID(), Schedule.createPeriodString((ReadablePeriod)s.getPeriod()), s.getLastModifyTime(), s.getNextExecTime(), s.getSubmitTime(), s.getSubmitUser(), encType.getNumVal(), data});
            if (inserts == 0) {
                throw new ScheduleManagerException("No schedule has been inserted.");
            }
        }
        catch (SQLException e) {
            logger.error((Object)(String.valueOf(INSERT_SCHEDULE) + " failed."));
            throw new ScheduleManagerException("Insert schedule " + s.getScheduleName() + " into db failed. ", (Throwable)e);
        }
    }

    public void updateNextExecTime(Schedule s) throws ScheduleManagerException {
        logger.info((Object)("Update schedule " + s.getScheduleName() + " into db. "));
        Connection connection = this.getConnection();
        QueryRunner runner = new QueryRunner();
        try {
            try {
                runner.update(connection, UPDATE_NEXT_EXEC_TIME, new Object[]{s.getNextExecTime(), s.getProjectId(), s.getFlowName()});
            }
            catch (SQLException e) {
                e.printStackTrace();
                logger.error((Object)(String.valueOf(UPDATE_NEXT_EXEC_TIME) + " failed."), (Throwable)e);
                throw new ScheduleManagerException("Update schedule " + s.getScheduleName() + " into db failed. ", (Throwable)e);
            }
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    public void updateSchedule(Schedule s) throws ScheduleManagerException {
        logger.info((Object)("Updating schedule " + s.getScheduleName() + " into db."));
        this.updateSchedule(s, this.defaultEncodingType);
    }

    public void updateSchedule(Schedule s, EncodingType encType) throws ScheduleManagerException {
        String json = JSONUtils.toJSON((Object)s.optionsToObject());
        byte[] data = null;
        try {
            byte[] stringData;
            data = stringData = json.getBytes("UTF-8");
            if (encType == EncodingType.GZIP) {
                data = GZIPUtils.gzipBytes((byte[])stringData);
            }
            logger.debug((Object)("NumChars: " + json.length() + " UTF-8:" + stringData.length + " Gzip:" + data.length));
        }
        catch (IOException e) {
            throw new ScheduleManagerException("Error encoding the schedule options " + s.getScheduleName());
        }
        QueryRunner runner = new QueryRunner(this.dataSource);
        try {
            int updates = runner.update(UPDATE_SCHEDULE_BY_KEY, new Object[]{s.getStatus(), s.getFirstSchedTime(), s.getTimezone().getID(), Schedule.createPeriodString((ReadablePeriod)s.getPeriod()), s.getLastModifyTime(), s.getNextExecTime(), s.getSubmitTime(), s.getSubmitUser(), encType.getNumVal(), data, s.getProjectId(), s.getFlowName()});
            if (updates == 0) {
                throw new ScheduleManagerException("No schedule has been updated.");
            }
        }
        catch (SQLException e) {
            logger.error((Object)(String.valueOf(UPDATE_SCHEDULE_BY_KEY) + " failed."));
            throw new ScheduleManagerException("Update schedule " + s.getScheduleName() + " into db failed. ", (Throwable)e);
        }
    }
}

