#!/bin/bash

if [ "$(whoami)" != 'root' ]; then
    echo "You have no permission to run $0 as non-root user."
    exit 1;
fi

export JAVA_HOME=/usr/lib/jvm/java-8-oracle
export JAVA_OPTS="-Xms4096m -Xmx6124m"

host="localhost"
versions=$(echo applications/cached/*/)
applications="*"
if [[ ! -z $1 ]]; then
	host=$1
	if [[ ! -z $2 ]]; then
		versions=$2
		if [[ ! -z $3 ]]; then
			applications=$3
		fi
	fi
fi

echo "Running in host $host for the applications $applications among the versions $versions"
for workload in {1..10}; do
	for user in 1 5 10 25 50; do
		for version in $versions; do
			version=${version%/}
			if [[ $applications = "*" ]]; then
				existing_applications=$(echo applications/cached/$version/*/)
			else
				existing_applications=$applications
			fi
			echo "Running applications $existing_applications with $user users and workload $workload"
			for application in $existing_applications; do
				application=${application%/}
				echo "Running $application with $user users and workload $workload"
				if [[ $host = "localhost" ]]; then
					export CACHE_EVENTS=/caching-approaches-comparison/applications/output/$application-$version-${user}user-${workload}workload-cache
					docker-compose -f applications/cached/$version/$application/docker-compose.yml up -d --build
				else
					echo "caching-approaches-comparison export CACHE_EVENTS=/caching-approaches-comparison/applications/output/$application-$version-${user}user-${workload}workload-cache" | netcat -w0 $host 5000
					echo "caching-approaches-comparison docker-compose -f applications/cached/$version/$application/docker-compose.yml up -d --build" | netcat -w0 $host 5000
				fi
				bash -c 'while ! curl -s '$host:8080' > /dev/null; do sleep 5; done'
				if [[ ! -f applications/workloads/$application-execution-${user}user-${workload}workload.json ]]; then
					echo "Generating workload"
					java -jar adapters/RequestsSimulator/target/RequestsSimulator-1.0.jar --profile=applications/workloads/$application.json --time=3600000 --users=$user --log=applications/workloads/$application-execution-${user}user-${workload}workload.json --throughput=applications/output/$application-${user}user-${workload}workload-requests > applications/output/$application-${user}user-${workload}workload-simulator.log 2>&1
				else
					echo "Repeating workload"
					java -jar adapters/RequestsSimulator/target/RequestsSimulator-1.0.jar --profile=applications/workloads/$application.json --execute=applications/workloads/$application-execution-${user}user-${workload}workload.json --throughput=applications/output/$application-$version-${user}user-${workload}workload-requests > applications/output/$application-$version-${user}user-${workload}workload-simulator.log 2>&1
				fi
				if [[ $host = "localhost" ]]; then
					docker-compose -f applications/cached/$version/$application/docker-compose.yml down -v
				else
					echo "caching-approaches-comparison docker-compose -f applications/cached/$version/$application/docker-compose.yml down -v" | netcat -w0 $host 5000
					sleep 11
				fi
			done
		done
	done
done