library(ggplot2)

sizes <- read.csv("../applications/output/cache-size-distribution.csv")

print("=== cache-size ===")
pdf("cache-size.pdf")

iter_applications = unique(sizes$application)
for (iter_application in iter_applications) {
	slice_application <- subset(sizes, application == iter_application)
	plot <- ggplot(slice_application, aes(x = time, y = size, group = name)) +
	geom_line(aes(colour = name)) +
	scale_colour_grey(start = 0.1, end = 0.6) +
	facet_grid(version ~ users, scales = "free") +
	theme(legend.position = "bottom") +
	ggtitle(iter_application)
	print(plot)
}

slice <- aggregate(formula = size~application+version+users+time, data = sizes, FUN = sum)

print("=== cache-size-aggregated ===")
pdf("cache-size-aggregated.pdf")

plot <- ggplot(slice, aes(x = time, y = size)) +
	geom_line(aes(colour = factor(users))) +
	scale_colour_grey(start = 0.1, end = 0.6) +
	facet_grid(application ~ version, scales = "free") +
	theme(legend.position = "bottom")
print(plot)