library(ggplot2)
library(ggforce)

requests <- read.csv2("../applications/output/requests-handled.csv", header=TRUE, sep=",", dec=".")

print("median")

median <- aggregate(formula = requests~application+version+users+execution, data = requests, FUN = length)
median <- reshape(median, idvar = c("application", "version", "users"), timevar = "execution", direction = "wide")
median[, "median"] <- apply(median[, 4:length(median)], 1, FUN = function(x) which.min(abs(x - median(x))))
median[, "reference"] <- paste(median$application, median$version, median$users, median$median)

print("cumulative curve comparison")

slice <- requests
slice <- subset(slice, paste(slice$application, slice$version, slice$users, slice$execution) %in% median$reference)

pdf("requests-handled.pdf")

iter_applications = unique(slice$application)
for(i in 1:ceiling(length(iter_applications) / 3)) {
	plot <- ggplot(slice, aes(x = time, y = requests, group = factor(version))) + 
		geom_line(aes(linetype = factor(version), colour = factor(version))) +
		scale_colour_grey(start = 0.1, end = 0.6) +
		facet_wrap_paginate(application ~ users, scales = "free", ncol = 3, nrow = 3, page = i) +
		theme(legend.position = "bottom")
	print(plot)
}