DROP DATABASE IF EXISTS SALESMANAGER;
CREATE DATABASE IF NOT EXISTS SALESMANAGER;
USE SALESMANAGER;
-- MySQL dump 10.13  Distrib 5.7.22, for Linux (x86_64)
--
-- Host: localhost    Database: SALESMANAGER
-- ------------------------------------------------------
-- Server version	5.7.22-0ubuntu0.17.10.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `CATEGORY`
--

DROP TABLE IF EXISTS `CATEGORY`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CATEGORY` (
  `CATEGORY_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `CATEGORY_IMAGE` varchar(100) DEFAULT NULL,
  `CATEGORY_STATUS` bit(1) DEFAULT NULL,
  `CODE` varchar(100) NOT NULL,
  `DEPTH` int(11) DEFAULT NULL,
  `LINEAGE` varchar(255) DEFAULT NULL,
  `SORT_ORDER` int(11) DEFAULT NULL,
  `VISIBLE` bit(1) DEFAULT NULL,
  `MERCHANT_ID` int(11) NOT NULL,
  `PARENT_ID` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`CATEGORY_ID`),
  UNIQUE KEY `UK_3mq9i6qmgquvoieslx39pej6x` (`MERCHANT_ID`,`CODE`),
  KEY `FK_by5aj5to9lgmfvlhn4fb5b242` (`PARENT_ID`),
  CONSTRAINT `FK_b5718wl9wilwj9k8je1k2jeo` FOREIGN KEY (`MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`),
  CONSTRAINT `FK_by5aj5to9lgmfvlhn4fb5b242` FOREIGN KEY (`PARENT_ID`) REFERENCES `CATEGORY` (`CATEGORY_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CATEGORY`
--

LOCK TABLES `CATEGORY` WRITE;
/*!40000 ALTER TABLE `CATEGORY` DISABLE KEYS */;
INSERT INTO `CATEGORY` VALUES (1,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'\0','computerbooks',0,'/',0,'',1,NULL),(2,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'\0','novels',0,'/',0,'\0',1,NULL),(3,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'\0','tech',1,'/1/',0,'\0',1,1),(4,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'\0','web',1,'/1/',0,'',1,1),(5,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'\0','fiction',1,'/2/',0,'',1,2),(6,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'\0','business',0,'/',0,'',1,NULL),(7,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'\0','cloud',2,'/1/3/',0,'',1,3);
/*!40000 ALTER TABLE `CATEGORY` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CATEGORY_DESCRIPTION`
--

DROP TABLE IF EXISTS `CATEGORY_DESCRIPTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CATEGORY_DESCRIPTION` (
  `DESCRIPTION_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `DESCRIPTION` longtext,
  `NAME` varchar(120) NOT NULL,
  `TITLE` varchar(100) DEFAULT NULL,
  `CATEGORY_HIGHLIGHT` varchar(255) DEFAULT NULL,
  `META_DESCRIPTION` varchar(255) DEFAULT NULL,
  `META_KEYWORDS` varchar(255) DEFAULT NULL,
  `META_TITLE` varchar(120) DEFAULT NULL,
  `SEF_URL` varchar(120) DEFAULT NULL,
  `LANGUAGE_ID` int(11) NOT NULL,
  `CATEGORY_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`DESCRIPTION_ID`),
  UNIQUE KEY `UK_buesqq6cyx7e5hy3mf30cfieq` (`CATEGORY_ID`,`LANGUAGE_ID`),
  KEY `FK_i17o4f83r3q77m1wpwqxj3qeh` (`LANGUAGE_ID`),
  CONSTRAINT `FK_by2tlirq8wuhx2ml9ashsjwv2` FOREIGN KEY (`CATEGORY_ID`) REFERENCES `CATEGORY` (`CATEGORY_ID`),
  CONSTRAINT `FK_i17o4f83r3q77m1wpwqxj3qeh` FOREIGN KEY (`LANGUAGE_ID`) REFERENCES `LANGUAGE` (`LANGUAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CATEGORY_DESCRIPTION`
--

LOCK TABLES `CATEGORY_DESCRIPTION` WRITE;
/*!40000 ALTER TABLE `CATEGORY_DESCRIPTION` DISABLE KEYS */;
INSERT INTO `CATEGORY_DESCRIPTION` VALUES (600,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'Computer Books',NULL,NULL,NULL,NULL,NULL,'computer-books',1,1),(601,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'Livres d\'informatique',NULL,NULL,NULL,NULL,NULL,'livres-informatiques',2,1),(602,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'Novels',NULL,NULL,NULL,NULL,NULL,'novels',1,2),(603,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'Romans',NULL,NULL,NULL,NULL,NULL,'romans',2,2),(604,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'Technology',NULL,NULL,NULL,NULL,NULL,'technology',1,3),(605,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'Technologie',NULL,NULL,NULL,NULL,NULL,'technologie',2,3),(606,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'Web',NULL,NULL,NULL,NULL,NULL,'the-web',1,4),(607,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'Web',NULL,NULL,NULL,NULL,NULL,'le-web',2,4),(608,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'Fiction',NULL,NULL,NULL,NULL,NULL,'fiction',1,5),(609,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'Sc Fiction',NULL,NULL,NULL,NULL,NULL,'fiction',2,5),(610,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'Business',NULL,NULL,NULL,NULL,NULL,'business',1,6),(611,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'Affaires',NULL,NULL,NULL,NULL,NULL,'affaires',2,6),(612,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'Cloud computing',NULL,NULL,NULL,NULL,NULL,'cloud-computing',1,7),(613,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'Programmation pour le cloud',NULL,NULL,NULL,NULL,NULL,'programmation-cloud',2,7);
/*!40000 ALTER TABLE `CATEGORY_DESCRIPTION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CONTENT`
--

DROP TABLE IF EXISTS `CONTENT`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CONTENT` (
  `CONTENT_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `CODE` varchar(100) NOT NULL,
  `CONTENT_POSITION` varchar(10) DEFAULT NULL,
  `CONTENT_TYPE` varchar(10) DEFAULT NULL,
  `PRODUCT_GROUP` varchar(255) DEFAULT NULL,
  `SORT_ORDER` int(11) DEFAULT NULL,
  `VISIBLE` bit(1) DEFAULT NULL,
  `MERCHANT_ID` int(11) NOT NULL,
  PRIMARY KEY (`CONTENT_ID`),
  UNIQUE KEY `UK_t1v2ld0mrwviquqourql4uub0` (`MERCHANT_ID`,`CODE`),
  CONSTRAINT `FK_l2s62g3nt07rx5tdfhsap7t7h` FOREIGN KEY (`MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CONTENT`
--

LOCK TABLES `CONTENT` WRITE;
/*!40000 ALTER TABLE `CONTENT` DISABLE KEYS */;
/*!40000 ALTER TABLE `CONTENT` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CONTENT_DESCRIPTION`
--

DROP TABLE IF EXISTS `CONTENT_DESCRIPTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CONTENT_DESCRIPTION` (
  `DESCRIPTION_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `DESCRIPTION` longtext,
  `NAME` varchar(120) NOT NULL,
  `TITLE` varchar(100) DEFAULT NULL,
  `META_DESCRIPTION` varchar(255) DEFAULT NULL,
  `META_KEYWORDS` varchar(255) DEFAULT NULL,
  `META_TITLE` varchar(255) DEFAULT NULL,
  `SEF_URL` varchar(120) DEFAULT NULL,
  `LANGUAGE_ID` int(11) NOT NULL,
  `CONTENT_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`DESCRIPTION_ID`),
  UNIQUE KEY `UK_n0w5r7ctbp88r4rvk7ayklofm` (`CONTENT_ID`,`LANGUAGE_ID`),
  KEY `FK_f9ivw889okp1hujbvfq072ll2` (`LANGUAGE_ID`),
  CONSTRAINT `FK_4ds7m2jymx6n57xxp0qp268oi` FOREIGN KEY (`CONTENT_ID`) REFERENCES `CONTENT` (`CONTENT_ID`),
  CONSTRAINT `FK_f9ivw889okp1hujbvfq072ll2` FOREIGN KEY (`LANGUAGE_ID`) REFERENCES `LANGUAGE` (`LANGUAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CONTENT_DESCRIPTION`
--

LOCK TABLES `CONTENT_DESCRIPTION` WRITE;
/*!40000 ALTER TABLE `CONTENT_DESCRIPTION` DISABLE KEYS */;
/*!40000 ALTER TABLE `CONTENT_DESCRIPTION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `COUNTRY`
--

DROP TABLE IF EXISTS `COUNTRY`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `COUNTRY` (
  `COUNTRY_ID` int(11) NOT NULL,
  `COUNTRY_ISOCODE` varchar(255) NOT NULL,
  `COUNTRY_SUPPORTED` bit(1) DEFAULT NULL,
  `GEOZONE_ID` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`COUNTRY_ID`),
  UNIQUE KEY `UK_dqb99v22pt27v0tgeqo958e6x` (`COUNTRY_ISOCODE`),
  KEY `FK_2lbinu04sww6iku2vis3qrj75` (`GEOZONE_ID`),
  CONSTRAINT `FK_2lbinu04sww6iku2vis3qrj75` FOREIGN KEY (`GEOZONE_ID`) REFERENCES `GEOZONE` (`GEOZONE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `COUNTRY`
--

LOCK TABLES `COUNTRY` WRITE;
/*!40000 ALTER TABLE `COUNTRY` DISABLE KEYS */;
INSERT INTO `COUNTRY` VALUES (1,'AL','',NULL),(2,'DZ','',NULL),(3,'AR','',NULL),(4,'AU','',NULL),(5,'AT','',NULL),(6,'BH','',NULL),(7,'BY','',NULL),(8,'BE','',NULL),(9,'BO','',NULL),(10,'BA','',NULL),(11,'BR','',NULL),(12,'BG','',NULL),(13,'CA','',NULL),(14,'CL','',NULL),(15,'CN','',NULL),(16,'CO','',NULL),(17,'CR','',NULL),(18,'HR','',NULL),(19,'CU','',NULL),(20,'CY','',NULL),(21,'CZ','',NULL),(22,'DK','',NULL),(23,'DO','',NULL),(24,'EC','',NULL),(25,'EG','',NULL),(26,'SV','',NULL),(27,'EE','',NULL),(28,'FI','',NULL),(29,'FR','',NULL),(30,'DE','',NULL),(31,'GR','',NULL),(32,'GT','',NULL),(33,'HN','',NULL),(34,'HK','',NULL),(35,'HU','',NULL),(36,'IS','',NULL),(37,'IN','',NULL),(38,'ID','',NULL),(39,'IQ','',NULL),(40,'IE','',NULL),(41,'IL','',NULL),(42,'IT','',NULL),(43,'JP','',NULL),(44,'JO','',NULL),(45,'KR','',NULL),(46,'KW','',NULL),(47,'LV','',NULL),(48,'LB','',NULL),(49,'LY','',NULL),(50,'LT','',NULL),(51,'LU','',NULL),(52,'MK','',NULL),(53,'MY','',NULL),(54,'MT','',NULL),(55,'MX','',NULL),(56,'ME','',NULL),(57,'MA','',NULL),(58,'NL','',NULL),(59,'NZ','',NULL),(60,'NI','',NULL),(61,'NO','',NULL),(62,'OM','',NULL),(63,'PA','',NULL),(64,'PY','',NULL),(65,'PE','',NULL),(66,'PH','',NULL),(67,'PL','',NULL),(68,'PT','',NULL),(69,'PR','',NULL),(70,'QA','',NULL),(71,'RO','',NULL),(72,'RU','',NULL),(73,'SA','',NULL),(74,'RS','',NULL),(75,'SG','',NULL),(76,'SK','',NULL),(77,'SI','',NULL),(78,'ZA','',NULL),(79,'ES','',NULL),(80,'SD','',NULL),(81,'SE','',NULL),(82,'CH','',NULL),(83,'SY','',NULL),(84,'TW','',NULL),(85,'TH','',NULL),(86,'TN','',NULL),(87,'TR','',NULL),(88,'UA','',NULL),(89,'AE','',NULL),(90,'GB','',NULL),(91,'US','',NULL),(92,'UY','',NULL),(93,'VE','',NULL),(94,'VN','',NULL),(95,'YE','',NULL);
/*!40000 ALTER TABLE `COUNTRY` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `COUNTRY_DESCRIPTION`
--

DROP TABLE IF EXISTS `COUNTRY_DESCRIPTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `COUNTRY_DESCRIPTION` (
  `DESCRIPTION_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `DESCRIPTION` longtext,
  `NAME` varchar(120) NOT NULL,
  `TITLE` varchar(100) DEFAULT NULL,
  `LANGUAGE_ID` int(11) NOT NULL,
  `COUNTRY_ID` int(11) NOT NULL,
  PRIMARY KEY (`DESCRIPTION_ID`),
  UNIQUE KEY `UK_t7nshki1rbp6157ed0v6cx4y4` (`COUNTRY_ID`,`LANGUAGE_ID`),
  KEY `FK_gxbf63g476n3u9ovtrlnjveuu` (`LANGUAGE_ID`),
  CONSTRAINT `FK_dlhty043oqoecr3f37uqvhj8w` FOREIGN KEY (`COUNTRY_ID`) REFERENCES `COUNTRY` (`COUNTRY_ID`),
  CONSTRAINT `FK_gxbf63g476n3u9ovtrlnjveuu` FOREIGN KEY (`LANGUAGE_ID`) REFERENCES `LANGUAGE` (`LANGUAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `COUNTRY_DESCRIPTION`
--

LOCK TABLES `COUNTRY_DESCRIPTION` WRITE;
/*!40000 ALTER TABLE `COUNTRY_DESCRIPTION` DISABLE KEYS */;
INSERT INTO `COUNTRY_DESCRIPTION` VALUES (1,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Albania',NULL,1,1),(2,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Albanie',NULL,2,1),(3,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Algeria',NULL,1,2),(4,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Algérie',NULL,2,2),(5,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Argentina',NULL,1,3),(6,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Argentine',NULL,2,3),(7,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Australia',NULL,1,4),(8,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Australie',NULL,2,4),(9,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Austria',NULL,1,5),(10,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Autriche',NULL,2,5),(11,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Bahrain',NULL,1,6),(12,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Bahreïn',NULL,2,6),(13,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Belarus',NULL,1,7),(14,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Biélo-Russie',NULL,2,7),(15,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Belgium',NULL,1,8),(16,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Belgique',NULL,2,8),(17,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Bolivia',NULL,1,9),(18,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Bolivie',NULL,2,9),(19,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Bosnia and Herzegovina',NULL,1,10),(20,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Bosnie-Herzégovine',NULL,2,10),(21,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Brazil',NULL,1,11),(22,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Brésil',NULL,2,11),(23,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Bulgaria',NULL,1,12),(24,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Bulgarie',NULL,2,12),(25,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Canada',NULL,1,13),(26,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Canada',NULL,2,13),(27,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Chile',NULL,1,14),(28,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Chili',NULL,2,14),(29,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'China',NULL,1,15),(30,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Chine',NULL,2,15),(31,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Colombia',NULL,1,16),(32,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Colombie',NULL,2,16),(33,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Costa Rica',NULL,1,17),(34,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Costa Rica',NULL,2,17),(35,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Croatia',NULL,1,18),(36,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Croatie',NULL,2,18),(37,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Cuba',NULL,1,19),(38,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Cuba',NULL,2,19),(39,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Cyprus',NULL,1,20),(40,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Chypre',NULL,2,20),(41,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Czech Republic',NULL,1,21),(42,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'République Tchèque',NULL,2,21),(43,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Denmark',NULL,1,22),(44,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Danemark',NULL,2,22),(45,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Dominican Republic',NULL,1,23),(46,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'République Dominicaine',NULL,2,23),(47,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Ecuador',NULL,1,24),(48,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Equateur',NULL,2,24),(49,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Egypt',NULL,1,25),(50,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Egypte',NULL,2,25),(51,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'El Salvador',NULL,1,26),(52,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'El Salvador',NULL,2,26),(53,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Estonia',NULL,1,27),(54,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Estonie',NULL,2,27),(55,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Finland',NULL,1,28),(56,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Finlande',NULL,2,28),(57,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'France',NULL,1,29),(58,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'France',NULL,2,29),(59,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Germany',NULL,1,30),(60,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Allemagne',NULL,2,30),(61,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Greece',NULL,1,31),(62,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Grèce',NULL,2,31),(63,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Guatemala',NULL,1,32),(64,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Guatemala',NULL,2,32),(65,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Honduras',NULL,1,33),(66,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Honduras',NULL,2,33),(67,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Hong Kong',NULL,1,34),(68,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Hong-Kong',NULL,2,34),(69,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Hungary',NULL,1,35),(70,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Hongrie',NULL,2,35),(71,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Iceland',NULL,1,36),(72,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Islande',NULL,2,36),(73,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'India',NULL,1,37),(74,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Inde',NULL,2,37),(75,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Indonesia',NULL,1,38),(76,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Indonésie',NULL,2,38),(77,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Iraq',NULL,1,39),(78,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Irak',NULL,2,39),(79,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Ireland',NULL,1,40),(80,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Irlande',NULL,2,40),(81,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Israel',NULL,1,41),(82,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Israël',NULL,2,41),(83,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Italy',NULL,1,42),(84,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Italie',NULL,2,42),(85,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Japan',NULL,1,43),(86,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Japon',NULL,2,43),(87,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Jordan',NULL,1,44),(88,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Jordanie',NULL,2,44),(89,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'South Korea',NULL,1,45),(90,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Corée du Sud',NULL,2,45),(91,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Kuwait',NULL,1,46),(92,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Koweit',NULL,2,46),(93,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Latvia',NULL,1,47),(94,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Lettonie',NULL,2,47),(95,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Lebanon',NULL,1,48),(96,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Liban',NULL,2,48),(97,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Libya',NULL,1,49),(98,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Libye',NULL,2,49),(99,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Lithuania',NULL,1,50),(100,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Lithuanie',NULL,2,50),(101,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Luxembourg',NULL,1,51),(102,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Luxembourg',NULL,2,51),(103,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Macedonia',NULL,1,52),(104,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Macédoine',NULL,2,52),(105,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Malaysia',NULL,1,53),(106,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Malaisie',NULL,2,53),(107,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Malta',NULL,1,54),(108,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Malte',NULL,2,54),(109,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Mexico',NULL,1,55),(110,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Mexique',NULL,2,55),(111,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Montenegro',NULL,1,56),(112,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Monténégro',NULL,2,56),(113,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Morocco',NULL,1,57),(114,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Maroc',NULL,2,57),(115,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Netherlands',NULL,1,58),(116,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Pays-Bas',NULL,2,58),(117,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'New Zealand',NULL,1,59),(118,'2019-06-22 04:10:51','2019-06-22 04:10:51',NULL,NULL,'Nouvelle-Zélande',NULL,2,59),(119,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Nicaragua',NULL,1,60),(120,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Nicaragua',NULL,2,60),(121,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Norway',NULL,1,61),(122,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Norvège',NULL,2,61),(123,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Oman',NULL,1,62),(124,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Oman',NULL,2,62),(125,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Panama',NULL,1,63),(126,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Panama',NULL,2,63),(127,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Paraguay',NULL,1,64),(128,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Paraguay',NULL,2,64),(129,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Peru',NULL,1,65),(130,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Pérou',NULL,2,65),(131,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Philippines',NULL,1,66),(132,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Philippines',NULL,2,66),(133,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Poland',NULL,1,67),(134,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Pologne',NULL,2,67),(135,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Portugal',NULL,1,68),(136,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Portugal',NULL,2,68),(137,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Puerto Rico',NULL,1,69),(138,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Porto Rico',NULL,2,69),(139,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Qatar',NULL,1,70),(140,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Qatar',NULL,2,70),(141,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Romania',NULL,1,71),(142,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Roumanie',NULL,2,71),(143,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Russia',NULL,1,72),(144,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Russie',NULL,2,72),(145,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Saudi Arabia',NULL,1,73),(146,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Arabie Saoudite',NULL,2,73),(147,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Serbia',NULL,1,74),(148,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Serbie',NULL,2,74),(149,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Singapore',NULL,1,75),(150,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Singapour',NULL,2,75),(151,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Slovakia',NULL,1,76),(152,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Slovaquie',NULL,2,76),(153,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Slovenia',NULL,1,77),(154,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Slovénie',NULL,2,77),(155,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'South Africa',NULL,1,78),(156,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Afrique du Sud',NULL,2,78),(157,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Spain',NULL,1,79),(158,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Espagne',NULL,2,79),(159,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Sudan',NULL,1,80),(160,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Soudan',NULL,2,80),(161,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Sweden',NULL,1,81),(162,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Suède',NULL,2,81),(163,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Switzerland',NULL,1,82),(164,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Suisse',NULL,2,82),(165,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Syria',NULL,1,83),(166,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Syrie',NULL,2,83),(167,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Taiwan',NULL,1,84),(168,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Taiwan',NULL,2,84),(169,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Thailand',NULL,1,85),(170,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Thaïlande',NULL,2,85),(171,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Tunisia',NULL,1,86),(172,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Tunisie',NULL,2,86),(173,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Turkey',NULL,1,87),(174,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Turquie',NULL,2,87),(175,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Ukraine',NULL,1,88),(176,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Ukraine',NULL,2,88),(177,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'United Arab Emirates',NULL,1,89),(178,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Emirats Arabes Unis',NULL,2,89),(179,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'United Kingdom',NULL,1,90),(180,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Royaume-Uni',NULL,2,90),(181,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'United States',NULL,1,91),(182,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Etats-Unis',NULL,2,91),(183,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Uruguay',NULL,1,92),(184,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Uruguay',NULL,2,92),(185,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Venezuela',NULL,1,93),(186,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Vénézuela',NULL,2,93),(187,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Vietnam',NULL,1,94),(188,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Vietnam',NULL,2,94),(189,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Yemen',NULL,1,95),(190,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Yémen',NULL,2,95);
/*!40000 ALTER TABLE `COUNTRY_DESCRIPTION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CURRENCY`
--

DROP TABLE IF EXISTS `CURRENCY`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CURRENCY` (
  `CURRENCY_ID` bigint(20) NOT NULL,
  `CURRENCY_CODE` varchar(255) DEFAULT NULL,
  `CURRENCY_CURRENCY_CODE` varchar(255) NOT NULL,
  `CURRENCY_NAME` varchar(255) DEFAULT NULL,
  `CURRENCY_SUPPORTED` bit(1) DEFAULT NULL,
  PRIMARY KEY (`CURRENCY_ID`),
  UNIQUE KEY `UK_m7ku15ekud52vp67ry73a36te` (`CURRENCY_CURRENCY_CODE`),
  UNIQUE KEY `UK_1ubr7n96hjajamtggqp090a4x` (`CURRENCY_CODE`),
  UNIQUE KEY `UK_7r1k69cbk5giewqr5c9r4v6f` (`CURRENCY_NAME`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CURRENCY`
--

LOCK TABLES `CURRENCY` WRITE;
/*!40000 ALTER TABLE `CURRENCY` DISABLE KEYS */;
INSERT INTO `CURRENCY` VALUES (1,'FJD','FJD','FJD',''),(2,'MXN','MXN','MXN',''),(3,'STD','STD','STD',''),(4,'LVL','LVL','LVL',''),(5,'SCR','SCR','SCR',''),(6,'CDF','CDF','CDF',''),(7,'BBD','BBD','BBD',''),(8,'GTQ','GTQ','GTQ',''),(9,'CLP','CLP','CLP',''),(10,'HNL','HNL','HNL',''),(11,'UGX','UGX','UGX',''),(12,'ZAR','ZAR','ZAR',''),(13,'MXV','MXV','MXV',''),(14,'TND','TND','TND',''),(15,'BSD','BSD','BSD',''),(16,'SLL','SLL','SLL',''),(17,'SDG','SDG','SDG',''),(18,'IQD','IQD','IQD',''),(19,'CUP','CUP','CUP',''),(20,'GMD','GMD','GMD',''),(21,'TWD','TWD','TWD',''),(22,'RSD','RSD','RSD',''),(23,'DOP','DOP','DOP',''),(24,'KMF','KMF','KMF',''),(25,'MYR','MYR','MYR',''),(26,'FKP','FKP','FKP',''),(27,'XOF','XOF','XOF',''),(28,'GEL','GEL','GEL',''),(29,'UYU','UYU','UYU',''),(30,'MAD','MAD','MAD',''),(31,'CVE','CVE','CVE',''),(32,'AZN','AZN','AZN',''),(33,'OMR','OMR','OMR',''),(34,'PGK','PGK','PGK',''),(35,'KES','KES','KES',''),(36,'SEK','SEK','SEK',''),(37,'BTN','BTN','BTN',''),(38,'UAH','UAH','UAH',''),(39,'GNF','GNF','GNF',''),(40,'ERN','ERN','ERN',''),(41,'MZN','MZN','MZN',''),(42,'SVC','SVC','SVC',''),(43,'ARS','ARS','ARS',''),(44,'QAR','QAR','QAR',''),(45,'IRR','IRR','IRR',''),(46,'MRO','MRO','MRO',''),(47,'CNY','CNY','CNY',''),(48,'XPF','XPF','XPF',''),(49,'THB','THB','THB',''),(50,'UZS','UZS','UZS',''),(51,'BDT','BDT','BDT',''),(52,'LYD','LYD','LYD',''),(53,'BMD','BMD','BMD',''),(54,'KWD','KWD','KWD',''),(55,'PHP','PHP','PHP',''),(56,'RUB','RUB','RUB',''),(57,'PYG','PYG','PYG',''),(58,'ISK','ISK','ISK',''),(59,'JMD','JMD','JMD',''),(60,'COP','COP','COP',''),(61,'USD','USD','USD',''),(62,'MKD','MKD','MKD',''),(63,'DZD','DZD','DZD',''),(64,'PAB','PAB','PAB',''),(65,'SGD','SGD','SGD',''),(66,'ETB','ETB','ETB',''),(67,'KGS','KGS','KGS',''),(68,'SOS','SOS','SOS',''),(69,'VUV','VUV','VUV',''),(70,'VEF','VEF','VEF',''),(71,'LAK','LAK','LAK',''),(72,'BND','BND','BND',''),(73,'ZMK','ZMK','ZMK',''),(74,'XAF','XAF','XAF',''),(75,'LRD','LRD','LRD',''),(76,'HRK','HRK','HRK',''),(77,'CHF','CHF','CHF',''),(78,'ALL','ALL','ALL',''),(79,'DJF','DJF','DJF',''),(80,'TZS','TZS','TZS',''),(81,'VND','VND','VND',''),(82,'AUD','AUD','AUD',''),(83,'ILS','ILS','ILS',''),(84,'GHS','GHS','GHS',''),(85,'GYD','GYD','GYD',''),(86,'KPW','KPW','KPW',''),(87,'BOB','BOB','BOB',''),(88,'KHR','KHR','KHR',''),(89,'MDL','MDL','MDL',''),(90,'IDR','IDR','IDR',''),(91,'KYD','KYD','KYD',''),(92,'AMD','AMD','AMD',''),(93,'BWP','BWP','BWP',''),(94,'SHP','SHP','SHP',''),(95,'TRY','TRY','TRY',''),(96,'LBP','LBP','LBP',''),(97,'TJS','TJS','TJS',''),(98,'JOD','JOD','JOD',''),(99,'HKD','HKD','HKD',''),(100,'RWF','RWF','RWF',''),(101,'AED','AED','AED',''),(102,'EUR','EUR','EUR',''),(103,'LSL','LSL','LSL',''),(104,'DKK','DKK','DKK',''),(105,'CAD','CAD','CAD',''),(106,'BOV','BOV','BOV',''),(107,'BGN','BGN','BGN',''),(108,'MMK','MMK','MMK',''),(109,'NOK','NOK','NOK',''),(110,'MUR','MUR','MUR',''),(111,'SYP','SYP','SYP',''),(112,'GIP','GIP','GIP',''),(113,'RON','RON','RON',''),(114,'LKR','LKR','LKR',''),(115,'NGN','NGN','NGN',''),(116,'CRC','CRC','CRC',''),(117,'CZK','CZK','CZK',''),(118,'PKR','PKR','PKR',''),(119,'XCD','XCD','XCD',''),(120,'ANG','ANG','ANG',''),(121,'HTG','HTG','HTG',''),(122,'BHD','BHD','BHD',''),(123,'KZT','KZT','KZT',''),(124,'SRD','SRD','SRD',''),(125,'SZL','SZL','SZL',''),(126,'LTL','LTL','LTL',''),(127,'SAR','SAR','SAR',''),(128,'TTD','TTD','TTD',''),(129,'YER','YER','YER',''),(130,'MVR','MVR','MVR',''),(131,'AFN','AFN','AFN',''),(132,'INR','INR','INR',''),(133,'AWG','AWG','AWG',''),(134,'KRW','KRW','KRW',''),(135,'NPR','NPR','NPR',''),(136,'JPY','JPY','JPY',''),(137,'MNT','MNT','MNT',''),(138,'AOA','AOA','AOA',''),(139,'PLN','PLN','PLN',''),(140,'GBP','GBP','GBP',''),(141,'SBD','SBD','SBD',''),(142,'HUF','HUF','HUF',''),(143,'BYR','BYR','BYR',''),(144,'BIF','BIF','BIF',''),(145,'MWK','MWK','MWK',''),(146,'MGA','MGA','MGA',''),(147,'XDR','XDR','XDR',''),(148,'BZD','BZD','BZD',''),(149,'BAM','BAM','BAM',''),(150,'EGP','EGP','EGP',''),(151,'MOP','MOP','MOP',''),(152,'NAD','NAD','NAD',''),(153,'NIO','NIO','NIO',''),(154,'PEN','PEN','PEN',''),(155,'NZD','NZD','NZD',''),(156,'WST','WST','WST',''),(157,'CLF','CLF','CLF',''),(158,'BRL','BRL','BRL','');
/*!40000 ALTER TABLE `CURRENCY` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CUSTMER_OPTIN`
--

DROP TABLE IF EXISTS `CUSTMER_OPTIN`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CUSTMER_OPTIN` (
  `CUSTOMER_OPTIN_ID` bigint(20) NOT NULL,
  `EMAIL` varchar(255) DEFAULT NULL,
  `FIRST` varchar(255) DEFAULT NULL,
  `LAST` varchar(255) DEFAULT NULL,
  `OPTIN_DATE` datetime DEFAULT NULL,
  `VALUE` longtext,
  `OPTIN_ID` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`CUSTOMER_OPTIN_ID`),
  UNIQUE KEY `UK_qg32yy79qajfig2uwr9wj88s9` (`EMAIL`,`OPTIN_ID`),
  KEY `FK_1f4gg9fca0srf7dnoqxglvtel` (`OPTIN_ID`),
  CONSTRAINT `FK_1f4gg9fca0srf7dnoqxglvtel` FOREIGN KEY (`OPTIN_ID`) REFERENCES `OPTIN` (`OPTIN_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CUSTMER_OPTIN`
--

LOCK TABLES `CUSTMER_OPTIN` WRITE;
/*!40000 ALTER TABLE `CUSTMER_OPTIN` DISABLE KEYS */;
/*!40000 ALTER TABLE `CUSTMER_OPTIN` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CUSTOMER`
--

DROP TABLE IF EXISTS `CUSTOMER`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CUSTOMER` (
  `CUSTOMER_ID` bigint(20) NOT NULL,
  `CUSTOMER_ANONYMOUS` bit(1) DEFAULT NULL,
  `BILLING_STREET_ADDRESS` varchar(256) DEFAULT NULL,
  `BILLING_CITY` varchar(100) DEFAULT NULL,
  `BILLING_COMPANY` varchar(100) DEFAULT NULL,
  `BILLING_FIRST_NAME` varchar(64) NOT NULL,
  `BILLING_LAST_NAME` varchar(64) NOT NULL,
  `BILLING_POSTCODE` varchar(20) DEFAULT NULL,
  `BILLING_STATE` varchar(100) DEFAULT NULL,
  `BILLING_TELEPHONE` varchar(32) DEFAULT NULL,
  `CUSTOMER_COMPANY` varchar(100) DEFAULT NULL,
  `CUSTOMER_DOB` datetime DEFAULT NULL,
  `DELIVERY_STREET_ADDRESS` varchar(256) DEFAULT NULL,
  `DELIVERY_CITY` varchar(100) DEFAULT NULL,
  `DELIVERY_COMPANY` varchar(100) DEFAULT NULL,
  `DELIVERY_FIRST_NAME` varchar(64) DEFAULT NULL,
  `DELIVERY_LAST_NAME` varchar(64) DEFAULT NULL,
  `DELIVERY_POSTCODE` varchar(20) DEFAULT NULL,
  `DELIVERY_STATE` varchar(100) DEFAULT NULL,
  `DELIVERY_TELEPHONE` varchar(32) DEFAULT NULL,
  `CUSTOMER_EMAIL_ADDRESS` varchar(96) NOT NULL,
  `CUSTOMER_GENDER` varchar(1) DEFAULT NULL,
  `CUSTOMER_NICK` varchar(96) DEFAULT NULL,
  `CUSTOMER_PASSWORD` varchar(60) DEFAULT NULL,
  `BILLING_COUNTRY_ID` int(11) NOT NULL,
  `BILLING_ZONE_ID` bigint(20) DEFAULT NULL,
  `LANGUAGE_ID` int(11) NOT NULL,
  `DELIVERY_COUNTRY_ID` int(11) DEFAULT NULL,
  `DELIVERY_ZONE_ID` bigint(20) DEFAULT NULL,
  `MERCHANT_ID` int(11) NOT NULL,
  PRIMARY KEY (`CUSTOMER_ID`),
  KEY `FK_3j13fd0w8fcubko0fdv53w18j` (`BILLING_COUNTRY_ID`),
  KEY `FK_72ork8lgtlvgwi0iwf0khdhv7` (`BILLING_ZONE_ID`),
  KEY `FK_eyy3eqwvkp4nudh4r02afghhs` (`LANGUAGE_ID`),
  KEY `FK_k7gt46oima5w2h4wq84hhg19c` (`DELIVERY_COUNTRY_ID`),
  KEY `FK_2atbo3aje6mi15gk8p7a5qvxb` (`DELIVERY_ZONE_ID`),
  KEY `FK_j00dj3m9tcac4sua8ajqln77a` (`MERCHANT_ID`),
  CONSTRAINT `FK_2atbo3aje6mi15gk8p7a5qvxb` FOREIGN KEY (`DELIVERY_ZONE_ID`) REFERENCES `ZONE` (`ZONE_ID`),
  CONSTRAINT `FK_3j13fd0w8fcubko0fdv53w18j` FOREIGN KEY (`BILLING_COUNTRY_ID`) REFERENCES `COUNTRY` (`COUNTRY_ID`),
  CONSTRAINT `FK_72ork8lgtlvgwi0iwf0khdhv7` FOREIGN KEY (`BILLING_ZONE_ID`) REFERENCES `ZONE` (`ZONE_ID`),
  CONSTRAINT `FK_eyy3eqwvkp4nudh4r02afghhs` FOREIGN KEY (`LANGUAGE_ID`) REFERENCES `LANGUAGE` (`LANGUAGE_ID`),
  CONSTRAINT `FK_j00dj3m9tcac4sua8ajqln77a` FOREIGN KEY (`MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`),
  CONSTRAINT `FK_k7gt46oima5w2h4wq84hhg19c` FOREIGN KEY (`DELIVERY_COUNTRY_ID`) REFERENCES `COUNTRY` (`COUNTRY_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CUSTOMER`
--

LOCK TABLES `CUSTOMER` WRITE;
/*!40000 ALTER TABLE `CUSTOMER` DISABLE KEYS */;
INSERT INTO `CUSTOMER` VALUES
(1,'\0','358 Du Languadoc','Boucherville','CSTI Consulting','Leonardo','DiCaprio','J4B-8J9',NULL,NULL,'CSTI Consulting','2019-06-22 04:11:09','358 Du Languadoc','Boucherville',NULL,'Leonardo','DiCaprio','J4B-8J9',NULL,NULL,'test@shopizer.com','M','usern1','$2a$11$1STTbK8e6iGFuN.Zget7ae8Tp/N9KwhJKvZbQ8ULPNp9h/a6zzHyG',13,8,1,13,8,1),
(2,'\0','358 Du Languadoc','Boucherville','CSTI Consulting','2','2','J4B-8J9',NULL,NULL,'CSTI Consulting','2019-06-22 04:11:09','358 Du Languadoc','Boucherville',NULL,'Leonardo','DiCaprio','J4B-8J9',NULL,NULL,'2@shopizer.com','F','usern2','$2a$11$M0jdbo2a9uAurYw5lTbNnud/dhiDaVAUVw5Ht7WQyMiVz16Twrzeq',13,8,1,13,8,1),
(3,'\0','358 Du Languadoc','Boucherville','CSTI Consulting','3','3','J4B-8J9',NULL,NULL,'CSTI Consulting','2019-06-22 04:11:09','358 Du Languadoc','Boucherville',NULL,'Leonardo','DiCaprio','J4B-8J9',NULL,NULL,'3@shopizer.com','M','usern3','$2a$11$M0jdbo2a9uAurYw5lTbNnud/dhiDaVAUVw5Ht7WQyMiVz16Twrzeq',13,8,1,13,8,1),
(4,'\0','358 Du Languadoc','Boucherville','CSTI Consulting','4','4','J4B-8J9',NULL,NULL,'CSTI Consulting','2019-06-22 04:11:09','358 Du Languadoc','Boucherville',NULL,'Leonardo','DiCaprio','J4B-8J9',NULL,NULL,'4@shopizer.com','M','usern4','$2a$11$M0jdbo2a9uAurYw5lTbNnud/dhiDaVAUVw5Ht7WQyMiVz16Twrzeq',13,8,1,13,8,1),
(5,'\0','358 Du Languadoc','Boucherville','CSTI Consulting','5','5','J4B-8J9',NULL,NULL,'CSTI Consulting','2019-06-22 04:11:09','358 Du Languadoc','Boucherville',NULL,'Leonardo','DiCaprio','J4B-8J9',NULL,NULL,'5@shopizer.com','M','usern5','$2a$11$M0jdbo2a9uAurYw5lTbNnud/dhiDaVAUVw5Ht7WQyMiVz16Twrzeq',13,8,1,13,8,1),
(6,'\0','358 Du Languadoc','Boucherville','CSTI Consulting','6','6','J4B-8J9',NULL,NULL,'CSTI Consulting','2019-06-22 04:11:09','358 Du Languadoc','Boucherville',NULL,'Leonardo','DiCaprio','J4B-8J9',NULL,NULL,'6@shopizer.com','M','usern6','$2a$11$M0jdbo2a9uAurYw5lTbNnud/dhiDaVAUVw5Ht7WQyMiVz16Twrzeq',13,8,1,13,8,1),
(7,'\0','358 Du Languadoc','Boucherville','CSTI Consulting','7','7','J4B-8J9',NULL,NULL,'CSTI Consulting','2019-06-22 04:11:09','358 Du Languadoc','Boucherville',NULL,'Leonardo','DiCaprio','J4B-8J9',NULL,NULL,'7@shopizer.com','M','usern7','$2a$11$M0jdbo2a9uAurYw5lTbNnud/dhiDaVAUVw5Ht7WQyMiVz16Twrzeq',13,8,1,13,8,1),
(8,'\0','358 Du Languadoc','Boucherville','CSTI Consulting','8','8','J4B-8J9',NULL,NULL,'CSTI Consulting','2019-06-22 04:11:09','358 Du Languadoc','Boucherville',NULL,'Leonardo','DiCaprio','J4B-8J9',NULL,NULL,'8@shopizer.com','F','usern8','$2a$11$M0jdbo2a9uAurYw5lTbNnud/dhiDaVAUVw5Ht7WQyMiVz16Twrzeq',13,8,1,13,8,1),
(9,'\0','358 Du Languadoc','Boucherville','CSTI Consulting','9','9','J4B-8J9',NULL,NULL,'CSTI Consulting','2019-06-22 04:11:09','358 Du Languadoc','Boucherville',NULL,'Leonardo','DiCaprio','J4B-8J9',NULL,NULL,'9@shopizer.com','F','usern9','$2a$11$M0jdbo2a9uAurYw5lTbNnud/dhiDaVAUVw5Ht7WQyMiVz16Twrzeq',13,8,1,13,8,1);
/*!40000 ALTER TABLE `CUSTOMER` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CUSTOMER_ATTRIBUTE`
--

DROP TABLE IF EXISTS `CUSTOMER_ATTRIBUTE`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CUSTOMER_ATTRIBUTE` (
  `CUSTOMER_ATTRIBUTE_ID` bigint(20) NOT NULL,
  `CUSTOMER_ATTR_TXT_VAL` varchar(255) DEFAULT NULL,
  `CUSTOMER_ID` bigint(20) NOT NULL,
  `OPTION_ID` bigint(20) NOT NULL,
  `OPTION_VALUE_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`CUSTOMER_ATTRIBUTE_ID`),
  UNIQUE KEY `UK_46kbpre88yh963gewm3kmdni1` (`OPTION_ID`,`CUSTOMER_ID`),
  KEY `FK_29fkuiaadeus36gasl9q1tsq3` (`CUSTOMER_ID`),
  KEY `FK_caeovxjxl3iya5jmoauqsxf9k` (`OPTION_VALUE_ID`),
  CONSTRAINT `FK_29fkuiaadeus36gasl9q1tsq3` FOREIGN KEY (`CUSTOMER_ID`) REFERENCES `CUSTOMER` (`CUSTOMER_ID`),
  CONSTRAINT `FK_apotuxwjsvba5y88au4xyw0nh` FOREIGN KEY (`OPTION_ID`) REFERENCES `CUSTOMER_OPTION` (`CUSTOMER_OPTION_ID`),
  CONSTRAINT `FK_caeovxjxl3iya5jmoauqsxf9k` FOREIGN KEY (`OPTION_VALUE_ID`) REFERENCES `CUSTOMER_OPTION_VALUE` (`CUSTOMER_OPTION_VALUE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CUSTOMER_ATTRIBUTE`
--

LOCK TABLES `CUSTOMER_ATTRIBUTE` WRITE;
/*!40000 ALTER TABLE `CUSTOMER_ATTRIBUTE` DISABLE KEYS */;
/*!40000 ALTER TABLE `CUSTOMER_ATTRIBUTE` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CUSTOMER_GROUP`
--

DROP TABLE IF EXISTS `CUSTOMER_GROUP`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CUSTOMER_GROUP` (
  `CUSTOMER_ID` bigint(20) NOT NULL,
  `GROUP_ID` int(11) NOT NULL,
  KEY `FK_7dgmjiv744ak7617blnsqm560` (`GROUP_ID`),
  KEY `FK_kmd61ih4bv0aaofdyel8d2se1` (`CUSTOMER_ID`),
  CONSTRAINT `FK_7dgmjiv744ak7617blnsqm560` FOREIGN KEY (`GROUP_ID`) REFERENCES `SM_GROUP` (`GROUP_ID`),
  CONSTRAINT `FK_kmd61ih4bv0aaofdyel8d2se1` FOREIGN KEY (`CUSTOMER_ID`) REFERENCES `CUSTOMER` (`CUSTOMER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CUSTOMER_GROUP`
--

LOCK TABLES `CUSTOMER_GROUP` WRITE;
/*!40000 ALTER TABLE `CUSTOMER_GROUP` DISABLE KEYS */;
/*!40000 ALTER TABLE `CUSTOMER_GROUP` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CUSTOMER_OPTION`
--

DROP TABLE IF EXISTS `CUSTOMER_OPTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CUSTOMER_OPTION` (
  `CUSTOMER_OPTION_ID` bigint(20) NOT NULL,
  `CUSTOMER_OPT_ACTIVE` bit(1) DEFAULT NULL,
  `CUSTOMER_OPT_CODE` varchar(255) NOT NULL,
  `CUSTOMER_OPTION_TYPE` varchar(10) DEFAULT NULL,
  `CUSTOMER_OPT_PUBLIC` bit(1) DEFAULT NULL,
  `SORT_ORDER` int(11) DEFAULT NULL,
  `MERCHANT_ID` int(11) NOT NULL,
  PRIMARY KEY (`CUSTOMER_OPTION_ID`),
  UNIQUE KEY `UK_rov34a6g4dhhiqukvhp1ggm0u` (`MERCHANT_ID`,`CUSTOMER_OPT_CODE`),
  KEY `CUST_OPT_CODE_IDX` (`CUSTOMER_OPT_CODE`),
  CONSTRAINT `FK_c8hb7w6e4rle5vfjf4p96sh80` FOREIGN KEY (`MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CUSTOMER_OPTION`
--

LOCK TABLES `CUSTOMER_OPTION` WRITE;
/*!40000 ALTER TABLE `CUSTOMER_OPTION` DISABLE KEYS */;
/*!40000 ALTER TABLE `CUSTOMER_OPTION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CUSTOMER_OPTION_DESC`
--

DROP TABLE IF EXISTS `CUSTOMER_OPTION_DESC`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CUSTOMER_OPTION_DESC` (
  `DESCRIPTION_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `DESCRIPTION` longtext,
  `NAME` varchar(120) NOT NULL,
  `TITLE` varchar(100) DEFAULT NULL,
  `CUSTOMER_OPTION_COMMENT` longtext,
  `LANGUAGE_ID` int(11) NOT NULL,
  `CUSTOMER_OPTION_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`DESCRIPTION_ID`),
  UNIQUE KEY `UK_6ovl4t1ciag1wubtcebaoo7vi` (`CUSTOMER_OPTION_ID`,`LANGUAGE_ID`),
  KEY `FK_i3pt01q982o6f1eelf2wgg16a` (`LANGUAGE_ID`),
  CONSTRAINT `FK_i3pt01q982o6f1eelf2wgg16a` FOREIGN KEY (`LANGUAGE_ID`) REFERENCES `LANGUAGE` (`LANGUAGE_ID`),
  CONSTRAINT `FK_p7u6vmiivmpui2sytdt41u2ye` FOREIGN KEY (`CUSTOMER_OPTION_ID`) REFERENCES `CUSTOMER_OPTION` (`CUSTOMER_OPTION_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CUSTOMER_OPTION_DESC`
--

LOCK TABLES `CUSTOMER_OPTION_DESC` WRITE;
/*!40000 ALTER TABLE `CUSTOMER_OPTION_DESC` DISABLE KEYS */;
/*!40000 ALTER TABLE `CUSTOMER_OPTION_DESC` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CUSTOMER_OPTION_SET`
--

DROP TABLE IF EXISTS `CUSTOMER_OPTION_SET`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CUSTOMER_OPTION_SET` (
  `CUSTOMER_OPTIONSET_ID` bigint(20) NOT NULL,
  `SORT_ORDER` int(11) DEFAULT NULL,
  `CUSTOMER_OPTION_ID` bigint(20) NOT NULL,
  `CUSTOMER_OPTION_VALUE_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`CUSTOMER_OPTIONSET_ID`),
  UNIQUE KEY `UK_4peli2ritnnq2xqpyq188srm6` (`CUSTOMER_OPTION_ID`,`CUSTOMER_OPTION_VALUE_ID`),
  KEY `FK_8rommesmavdij4j64u80rnpf5` (`CUSTOMER_OPTION_VALUE_ID`),
  CONSTRAINT `FK_8rommesmavdij4j64u80rnpf5` FOREIGN KEY (`CUSTOMER_OPTION_VALUE_ID`) REFERENCES `CUSTOMER_OPTION_VALUE` (`CUSTOMER_OPTION_VALUE_ID`),
  CONSTRAINT `FK_nw8syffq9lv0p0nc0vvlecbba` FOREIGN KEY (`CUSTOMER_OPTION_ID`) REFERENCES `CUSTOMER_OPTION` (`CUSTOMER_OPTION_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CUSTOMER_OPTION_SET`
--

LOCK TABLES `CUSTOMER_OPTION_SET` WRITE;
/*!40000 ALTER TABLE `CUSTOMER_OPTION_SET` DISABLE KEYS */;
/*!40000 ALTER TABLE `CUSTOMER_OPTION_SET` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CUSTOMER_OPTION_VALUE`
--

DROP TABLE IF EXISTS `CUSTOMER_OPTION_VALUE`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CUSTOMER_OPTION_VALUE` (
  `CUSTOMER_OPTION_VALUE_ID` bigint(20) NOT NULL,
  `CUSTOMER_OPT_VAL_CODE` varchar(255) NOT NULL,
  `CUSTOMER_OPT_VAL_IMAGE` varchar(255) DEFAULT NULL,
  `SORT_ORDER` int(11) DEFAULT NULL,
  `MERCHANT_ID` int(11) NOT NULL,
  PRIMARY KEY (`CUSTOMER_OPTION_VALUE_ID`),
  UNIQUE KEY `UK_cb1fmv71nrx7m1rlx1ff5qvdt` (`MERCHANT_ID`,`CUSTOMER_OPT_VAL_CODE`),
  KEY `CUST_OPT_VAL_CODE_IDX` (`CUSTOMER_OPT_VAL_CODE`),
  CONSTRAINT `FK_qbur9hs0qbtgl3f85l4c6s3yd` FOREIGN KEY (`MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CUSTOMER_OPTION_VALUE`
--

LOCK TABLES `CUSTOMER_OPTION_VALUE` WRITE;
/*!40000 ALTER TABLE `CUSTOMER_OPTION_VALUE` DISABLE KEYS */;
/*!40000 ALTER TABLE `CUSTOMER_OPTION_VALUE` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `CUSTOMER_OPT_VAL_DESCRIPTION`
--

DROP TABLE IF EXISTS `CUSTOMER_OPT_VAL_DESCRIPTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `CUSTOMER_OPT_VAL_DESCRIPTION` (
  `DESCRIPTION_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `DESCRIPTION` longtext,
  `NAME` varchar(120) NOT NULL,
  `TITLE` varchar(100) DEFAULT NULL,
  `LANGUAGE_ID` int(11) NOT NULL,
  `CUSTOMER_OPT_VAL_ID` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`DESCRIPTION_ID`),
  UNIQUE KEY `UK_ge7f2t1d31r87wnk09h9u1tnv` (`CUSTOMER_OPT_VAL_ID`,`LANGUAGE_ID`),
  KEY `FK_5tan60tg9d812ti5hg0ch784f` (`LANGUAGE_ID`),
  CONSTRAINT `FK_5tan60tg9d812ti5hg0ch784f` FOREIGN KEY (`LANGUAGE_ID`) REFERENCES `LANGUAGE` (`LANGUAGE_ID`),
  CONSTRAINT `FK_sj4lco1gcmplvqlgfdbdpmtyn` FOREIGN KEY (`CUSTOMER_OPT_VAL_ID`) REFERENCES `CUSTOMER_OPTION_VALUE` (`CUSTOMER_OPTION_VALUE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `CUSTOMER_OPT_VAL_DESCRIPTION`
--

LOCK TABLES `CUSTOMER_OPT_VAL_DESCRIPTION` WRITE;
/*!40000 ALTER TABLE `CUSTOMER_OPT_VAL_DESCRIPTION` DISABLE KEYS */;
/*!40000 ALTER TABLE `CUSTOMER_OPT_VAL_DESCRIPTION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `FILE_HISTORY`
--

DROP TABLE IF EXISTS `FILE_HISTORY`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `FILE_HISTORY` (
  `FILE_HISTORY_ID` bigint(20) NOT NULL,
  `ACCOUNTED_DATE` datetime DEFAULT NULL,
  `DATE_ADDED` datetime NOT NULL,
  `DATE_DELETED` datetime DEFAULT NULL,
  `DOWNLOAD_COUNT` int(11) NOT NULL,
  `FILE_ID` bigint(20) DEFAULT NULL,
  `FILESIZE` int(11) NOT NULL,
  `MERCHANT_ID` int(11) NOT NULL,
  PRIMARY KEY (`FILE_HISTORY_ID`),
  UNIQUE KEY `UK_av35sb3v4nxq8v1n1rkxufir` (`MERCHANT_ID`,`FILE_ID`),
  CONSTRAINT `FK_5p2nkrcj0b8k5r3mv3lijif45` FOREIGN KEY (`MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `FILE_HISTORY`
--

LOCK TABLES `FILE_HISTORY` WRITE;
/*!40000 ALTER TABLE `FILE_HISTORY` DISABLE KEYS */;
/*!40000 ALTER TABLE `FILE_HISTORY` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `GEOZONE`
--

DROP TABLE IF EXISTS `GEOZONE`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `GEOZONE` (
  `GEOZONE_ID` bigint(20) NOT NULL,
  `GEOZONE_CODE` varchar(255) DEFAULT NULL,
  `GEOZONE_NAME` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`GEOZONE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `GEOZONE`
--

LOCK TABLES `GEOZONE` WRITE;
/*!40000 ALTER TABLE `GEOZONE` DISABLE KEYS */;
/*!40000 ALTER TABLE `GEOZONE` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `GEOZONE_DESCRIPTION`
--

DROP TABLE IF EXISTS `GEOZONE_DESCRIPTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `GEOZONE_DESCRIPTION` (
  `DESCRIPTION_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `DESCRIPTION` longtext,
  `NAME` varchar(120) NOT NULL,
  `TITLE` varchar(100) DEFAULT NULL,
  `LANGUAGE_ID` int(11) NOT NULL,
  `GEOZONE_ID` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`DESCRIPTION_ID`),
  UNIQUE KEY `UK_soq8o99w3c8ys3ntamt5i4mat` (`GEOZONE_ID`,`LANGUAGE_ID`),
  KEY `FK_1lcbkc4tt49q5qbue3m9p29c2` (`LANGUAGE_ID`),
  CONSTRAINT `FK_1lcbkc4tt49q5qbue3m9p29c2` FOREIGN KEY (`LANGUAGE_ID`) REFERENCES `LANGUAGE` (`LANGUAGE_ID`),
  CONSTRAINT `FK_m2xipv66da4ujekwbwxuyhmb8` FOREIGN KEY (`GEOZONE_ID`) REFERENCES `GEOZONE` (`GEOZONE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `GEOZONE_DESCRIPTION`
--

LOCK TABLES `GEOZONE_DESCRIPTION` WRITE;
/*!40000 ALTER TABLE `GEOZONE_DESCRIPTION` DISABLE KEYS */;
/*!40000 ALTER TABLE `GEOZONE_DESCRIPTION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `LANGUAGE`
--

DROP TABLE IF EXISTS `LANGUAGE`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `LANGUAGE` (
  `LANGUAGE_ID` int(11) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `CODE` varchar(255) NOT NULL,
  `SORT_ORDER` int(11) DEFAULT NULL,
  PRIMARY KEY (`LANGUAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LANGUAGE`
--

LOCK TABLES `LANGUAGE` WRITE;
/*!40000 ALTER TABLE `LANGUAGE` DISABLE KEYS */;
INSERT INTO `LANGUAGE` VALUES (1,'2019-06-22 04:10:50','2019-06-22 04:10:50',NULL,'en',NULL),(2,'2019-06-22 04:10:50','2019-06-22 04:10:50',NULL,'fr',NULL);
/*!40000 ALTER TABLE `LANGUAGE` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MANUFACTURER`
--

DROP TABLE IF EXISTS `MANUFACTURER`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `MANUFACTURER` (
  `MANUFACTURER_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `CODE` varchar(100) NOT NULL,
  `MANUFACTURER_IMAGE` varchar(255) DEFAULT NULL,
  `SORT_ORDER` int(11) DEFAULT NULL,
  `MERCHANT_ID` int(11) NOT NULL,
  PRIMARY KEY (`MANUFACTURER_ID`),
  UNIQUE KEY `UK_6brqfdkga7jc78n8dh3v595y3` (`MERCHANT_ID`,`CODE`),
  CONSTRAINT `FK_6a0xjjrya6f08ys6bm5tr84q5` FOREIGN KEY (`MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MANUFACTURER`
--

LOCK TABLES `MANUFACTURER` WRITE;
/*!40000 ALTER TABLE `MANUFACTURER` DISABLE KEYS */;
INSERT INTO `MANUFACTURER` VALUES (1,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,'oreilley',NULL,0,1),(2,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,'sams',NULL,0,1),(3,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,'packt',NULL,0,1),(4,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,'manning',NULL,0,1),(5,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,'novells',NULL,0,1);
/*!40000 ALTER TABLE `MANUFACTURER` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MANUFACTURER_DESCRIPTION`
--

DROP TABLE IF EXISTS `MANUFACTURER_DESCRIPTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `MANUFACTURER_DESCRIPTION` (
  `DESCRIPTION_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `DESCRIPTION` longtext,
  `NAME` varchar(120) NOT NULL,
  `TITLE` varchar(100) DEFAULT NULL,
  `DATE_LAST_CLICK` datetime DEFAULT NULL,
  `MANUFACTURERS_URL` varchar(255) DEFAULT NULL,
  `URL_CLICKED` int(11) DEFAULT NULL,
  `LANGUAGE_ID` int(11) NOT NULL,
  `MANUFACTURER_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`DESCRIPTION_ID`),
  UNIQUE KEY `UK_lpv09p83sc887clxe04nroup6` (`MANUFACTURER_ID`,`LANGUAGE_ID`),
  KEY `FK_886779uo5mvsjx1aflijs3ldi` (`LANGUAGE_ID`),
  CONSTRAINT `FK_1o49ome5ymq7n6xabxylr6fmg` FOREIGN KEY (`MANUFACTURER_ID`) REFERENCES `MANUFACTURER` (`MANUFACTURER_ID`),
  CONSTRAINT `FK_886779uo5mvsjx1aflijs3ldi` FOREIGN KEY (`LANGUAGE_ID`) REFERENCES `LANGUAGE` (`LANGUAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MANUFACTURER_DESCRIPTION`
--

LOCK TABLES `MANUFACTURER_DESCRIPTION` WRITE;
/*!40000 ALTER TABLE `MANUFACTURER_DESCRIPTION` DISABLE KEYS */;
INSERT INTO `MANUFACTURER_DESCRIPTION` VALUES (650,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'O\'Reilley',NULL,NULL,NULL,NULL,1,1),(651,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'Sams',NULL,NULL,NULL,NULL,1,2),(652,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'Packt',NULL,NULL,NULL,NULL,1,3),(653,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'Manning',NULL,NULL,NULL,NULL,1,4),(654,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'Novells publishing',NULL,NULL,NULL,NULL,1,5);
/*!40000 ALTER TABLE `MANUFACTURER_DESCRIPTION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MERCHANT_CONFIGURATION`
--

DROP TABLE IF EXISTS `MERCHANT_CONFIGURATION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `MERCHANT_CONFIGURATION` (
  `MERCHANT_CONFIG_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `CONFIG_KEY` varchar(255) DEFAULT NULL,
  `TYPE` varchar(255) DEFAULT NULL,
  `VALUE` longtext,
  `MERCHANT_ID` int(11) DEFAULT NULL,
  PRIMARY KEY (`MERCHANT_CONFIG_ID`),
  UNIQUE KEY `UK_j0c3h8onw3m6hjcr3yylst9fb` (`MERCHANT_ID`,`CONFIG_KEY`),
  CONSTRAINT `FK_4hwqhy43w922otscgfah9d30a` FOREIGN KEY (`MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MERCHANT_CONFIGURATION`
--

LOCK TABLES `MERCHANT_CONFIGURATION` WRITE;
/*!40000 ALTER TABLE `MERCHANT_CONFIGURATION` DISABLE KEYS */;
INSERT INTO `MERCHANT_CONFIGURATION` VALUES (1,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,'CONFIG','CONFIG','{\"allowPurchaseItems\":true,\"displayContactUs\":false,\"displayCustomerAgreement\":false,\"defaultSearchConfigPath\":{},\"displayCustomerSection\":false,\"displayAddToCartOnFeaturedItems\":true,\"testMode\":false,\"displayStoreAddress\":false,\"displaySearchBox\":true,\"debugMode\":false,\"useDefaultSearchConfig\":{}}',1);
/*!40000 ALTER TABLE `MERCHANT_CONFIGURATION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MERCHANT_LANGUAGE`
--

DROP TABLE IF EXISTS `MERCHANT_LANGUAGE`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `MERCHANT_LANGUAGE` (
  `stores_MERCHANT_ID` int(11) NOT NULL,
  `languages_LANGUAGE_ID` int(11) NOT NULL,
  KEY `FK_53o35arh6914xpjlfkk9fg7hr` (`languages_LANGUAGE_ID`),
  KEY `FK_otl5jb3ntlujif2krkk7f1hfc` (`stores_MERCHANT_ID`),
  CONSTRAINT `FK_53o35arh6914xpjlfkk9fg7hr` FOREIGN KEY (`languages_LANGUAGE_ID`) REFERENCES `LANGUAGE` (`LANGUAGE_ID`),
  CONSTRAINT `FK_otl5jb3ntlujif2krkk7f1hfc` FOREIGN KEY (`stores_MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MERCHANT_LANGUAGE`
--

LOCK TABLES `MERCHANT_LANGUAGE` WRITE;
/*!40000 ALTER TABLE `MERCHANT_LANGUAGE` DISABLE KEYS */;
INSERT INTO `MERCHANT_LANGUAGE` VALUES (1,1);
/*!40000 ALTER TABLE `MERCHANT_LANGUAGE` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MERCHANT_LOG`
--

DROP TABLE IF EXISTS `MERCHANT_LOG`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `MERCHANT_LOG` (
  `MERCHANT_LOG_ID` bigint(20) NOT NULL,
  `LOG` longtext,
  `MODULE` varchar(25) DEFAULT NULL,
  `MERCHANT_ID` int(11) NOT NULL,
  PRIMARY KEY (`MERCHANT_LOG_ID`),
  KEY `FK_g76deolju6sf5ikvoe5ir23q3` (`MERCHANT_ID`),
  CONSTRAINT `FK_g76deolju6sf5ikvoe5ir23q3` FOREIGN KEY (`MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MERCHANT_LOG`
--

LOCK TABLES `MERCHANT_LOG` WRITE;
/*!40000 ALTER TABLE `MERCHANT_LOG` DISABLE KEYS */;
/*!40000 ALTER TABLE `MERCHANT_LOG` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MERCHANT_STORE`
--

DROP TABLE IF EXISTS `MERCHANT_STORE`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `MERCHANT_STORE` (
  `MERCHANT_ID` int(11) NOT NULL,
  `STORE_CODE` varchar(100) NOT NULL,
  `CONTINUESHOPPINGURL` varchar(150) DEFAULT NULL,
  `CURRENCY_FORMAT_NATIONAL` bit(1) DEFAULT NULL,
  `DOMAIN_NAME` varchar(80) DEFAULT NULL,
  `IN_BUSINESS_SINCE` date DEFAULT NULL,
  `INVOICE_TEMPLATE` varchar(25) DEFAULT NULL,
  `SEIZEUNITCODE` varchar(5) DEFAULT NULL,
  `STORE_EMAIL` varchar(60) NOT NULL,
  `STORE_LOGO` varchar(100) DEFAULT NULL,
  `STORE_TEMPLATE` varchar(25) DEFAULT NULL,
  `STORE_ADDRESS` varchar(255) DEFAULT NULL,
  `STORE_CITY` varchar(100) NOT NULL,
  `STORE_NAME` varchar(100) NOT NULL,
  `STORE_PHONE` varchar(50) NOT NULL,
  `STORE_POSTAL_CODE` varchar(15) NOT NULL,
  `STORE_STATE_PROV` varchar(100) DEFAULT NULL,
  `USE_CACHE` bit(1) DEFAULT NULL,
  `WEIGHTUNITCODE` varchar(5) DEFAULT NULL,
  `COUNTRY_ID` int(11) NOT NULL,
  `CURRENCY_ID` bigint(20) NOT NULL,
  `LANGUAGE_ID` int(11) NOT NULL,
  `ZONE_ID` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`MERCHANT_ID`),
  UNIQUE KEY `UK_4pvtsnqv4nlao8725n9ldpguf` (`STORE_CODE`),
  KEY `FK_4k1mv6pikwues6f2uhnju0aj6` (`COUNTRY_ID`),
  KEY `FK_4uyyjjys5buui6oe3vp84k5ip` (`CURRENCY_ID`),
  KEY `FK_tcj9cbm9ur5itu2c6wrct1dnq` (`LANGUAGE_ID`),
  KEY `FK_141243r2vth00rq0lyem39abo` (`ZONE_ID`),
  CONSTRAINT `FK_141243r2vth00rq0lyem39abo` FOREIGN KEY (`ZONE_ID`) REFERENCES `ZONE` (`ZONE_ID`),
  CONSTRAINT `FK_4k1mv6pikwues6f2uhnju0aj6` FOREIGN KEY (`COUNTRY_ID`) REFERENCES `COUNTRY` (`COUNTRY_ID`),
  CONSTRAINT `FK_4uyyjjys5buui6oe3vp84k5ip` FOREIGN KEY (`CURRENCY_ID`) REFERENCES `CURRENCY` (`CURRENCY_ID`),
  CONSTRAINT `FK_tcj9cbm9ur5itu2c6wrct1dnq` FOREIGN KEY (`LANGUAGE_ID`) REFERENCES `LANGUAGE` (`LANGUAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MERCHANT_STORE`
--

LOCK TABLES `MERCHANT_STORE` WRITE;
/*!40000 ALTER TABLE `MERCHANT_STORE` DISABLE KEYS */;
INSERT INTO `MERCHANT_STORE` VALUES (1,'DEFAULT',NULL,'\0','localhost:8080','2019-06-22',NULL,'IN','test@test.com',NULL,'bootstrap','1234 Street address','My city','Default store','888-888-8888','H2H-2H2',NULL,'\0','LB',13,105,1,8);
/*!40000 ALTER TABLE `MERCHANT_STORE` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MODULE_CONFIGURATION`
--

DROP TABLE IF EXISTS `MODULE_CONFIGURATION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `MODULE_CONFIGURATION` (
  `MODULE_CONF_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `CODE` varchar(255) NOT NULL,
  `DETAILS` longtext,
  `CONFIGURATION` longtext,
  `CUSTOM_IND` bit(1) DEFAULT NULL,
  `IMAGE` varchar(255) DEFAULT NULL,
  `MODULE` varchar(255) DEFAULT NULL,
  `REGIONS` varchar(255) DEFAULT NULL,
  `TYPE` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`MODULE_CONF_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MODULE_CONFIGURATION`
--

LOCK TABLES `MODULE_CONFIGURATION` WRITE;
/*!40000 ALTER TABLE `MODULE_CONFIGURATION` DISABLE KEYS */;
INSERT INTO `MODULE_CONFIGURATION` VALUES (1,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'usps',NULL,'[{\"scheme\":\"http\",\"host\":\"testing.shippingapis.com\",\"port\":\"80\",\"uri\":\"/ShippingAPI.dll\",\"env\":\"TEST\",\"config1\":null,\"config2\":null},{\"scheme\":\"http\",\"host\":\"production.shippingapis.com\",\"port\":\"80\",\"uri\":\"/ShippingAPI.dll\",\"env\":\"PROD\",\"config1\":null,\"config2\":null}]','\0','usps.jpg','SHIPPING','[\"US\"]',NULL),(2,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'canadapost',NULL,'[{\"scheme\":\"https\",\"host\":\"ct.soa-gw.canadapost.ca\",\"port\":\"443\",\"uri\":\"/rs/ship/price\",\"env\":\"TEST\",\"config1\":null,\"config2\":null},{\"scheme\":\"https\",\"host\":\"soa-gw.canadapost.ca\",\"port\":\"443\",\"uri\":\"/rs/ship/price\",\"env\":\"PROD\",\"config1\":null,\"config2\":null}]','\0','canadapost.jpg','SHIPPING','[\"CA\"]',NULL),(3,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'ups','{\"01\":\"UPS Next Day Air\",\"02\":\"UPS Second Day Air\",\"03\":\"UPS Ground\",\"07\":\"UPS Worldwide Express\",\"08\":\"UPS Worldwide Expedited\",\"11\":\"UPS Standard\",\"12\":\"UPS Three-Day Select\",\"13\":\"UPS Next Day Air Saver\",\"14\":\"UPS Next Day Air Early A.M.\",\"54\":\"UPS Worldwide Express Plus\",\"59\":\"UPS Second Day Air A.M.\",\"69\":\"UPS Saver\"}','[{\"scheme\":\"https\",\"host\":\"wwwcie.ups.com\",\"port\":\"443\",\"uri\":\"/ups.app/xml/Rate\",\"env\":\"TEST\",\"config1\":null,\"config2\":null},{\"scheme\":\"https\",\"host\":\"onlinetools.ups.com\",\"port\":\"443\",\"uri\":\"/xml/Rate\",\"env\":\"PROD\",\"config1\":null,\"config2\":null}]','\0','ups.jpg','SHIPPING','[\"US\",\"CA\",\"FR\",\"GB\"]',NULL),(4,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'weightBased',NULL,NULL,'',NULL,'SHIPPING','[\"*\"]',NULL),(5,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'customQuotesRules',NULL,NULL,'\0',NULL,'SHIPPING','[\"*\"]',NULL),(6,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'priceByDistance',NULL,NULL,'\0',NULL,'SHIPPING','[\"*\"]',NULL),(7,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'storePickUp',NULL,NULL,'\0',NULL,'SHIPPING','[\"*\"]',NULL),(8,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'moneyorder',NULL,NULL,'\0','moneyorder.gif','PAYMENT','[\"*\"]','moneyorder'),(9,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'paypal-express-checkout',NULL,'[{\"scheme\":\"\",\"host\":\"\",\"port\":\"\",\"uri\":\"\",\"env\":\"TEST\",\"config1\":\"https://www.sandbox.paypal.com/cgi-bin/webscr?cmd=_express-checkout&token=\",\"config2\":null},{\"scheme\":\"\",\"host\":\"\",\"port\":\"\",\"uri\":\"\",\"env\":\"PROD\",\"config1\":\"https://www.paypal.com/cgi-bin/webscr?cmd=_express-checkout&token=\",\"config2\":null}]','\0','icon-paypal.png','PAYMENT','[\"*\"]','paypal'),(10,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'beanstream',NULL,'[{\"scheme\":\"https\",\"host\":\"www.beanstream.com\",\"port\":\"443\",\"uri\":\"/scripts/process_transaction.asp\",\"env\":\"TEST\",\"config1\":null,\"config2\":null},{\"scheme\":\"https\",\"host\":\"www.beanstream.com\",\"port\":\"443\",\"uri\":\"/scripts/process_transaction.asp\",\"env\":\"PROD\",\"config1\":null,\"config2\":null}]','\0','beanstream.gif','PAYMENT','[\"US\",\"CA\",\"GB\"]','creditcard'),(11,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'stripe',NULL,'[{\"scheme\":\"https\",\"host\":\"www.stripe.com\",\"port\":\"443\",\"uri\":\"/\",\"env\":\"TEST\",\"config1\":null,\"config2\":null},{\"scheme\":\"https\",\"host\":\"www.stripe.com\",\"port\":\"443\",\"uri\":\"/\",\"env\":\"PROD\",\"config1\":null,\"config2\":null}]','\0','stripe.png','PAYMENT','[\"US\",\"CA\",\"GB\",\"AU\",\"FI\",\"DK\",\"IE\",\"NO\",\"SE\"]','creditcard');
/*!40000 ALTER TABLE `MODULE_CONFIGURATION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `OPTIN`
--

DROP TABLE IF EXISTS `OPTIN`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `OPTIN` (
  `OPTIN_ID` bigint(20) NOT NULL,
  `CODE` varchar(255) NOT NULL,
  `DESCRIPTION` varchar(255) DEFAULT NULL,
  `END_DATE` datetime DEFAULT NULL,
  `START_DATE` datetime DEFAULT NULL,
  `MERCHANT_ID` int(11) DEFAULT NULL,
  PRIMARY KEY (`OPTIN_ID`),
  UNIQUE KEY `UK_manlx6siq6ddf14cud40k8gw6` (`MERCHANT_ID`,`CODE`),
  CONSTRAINT `FK_78lse42pdfcesqv7t666puqqi` FOREIGN KEY (`MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `OPTIN`
--

LOCK TABLES `OPTIN` WRITE;
/*!40000 ALTER TABLE `OPTIN` DISABLE KEYS */;
/*!40000 ALTER TABLE `OPTIN` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ORDERS`
--

DROP TABLE IF EXISTS `ORDERS`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ORDERS` (
  `ORDER_ID` bigint(20) NOT NULL,
  `BILLING_STREET_ADDRESS` varchar(256) DEFAULT NULL,
  `BILLING_CITY` varchar(100) DEFAULT NULL,
  `BILLING_COMPANY` varchar(100) DEFAULT NULL,
  `BILLING_FIRST_NAME` varchar(64) NOT NULL,
  `BILLING_LAST_NAME` varchar(64) NOT NULL,
  `BILLING_POSTCODE` varchar(20) DEFAULT NULL,
  `BILLING_STATE` varchar(100) DEFAULT NULL,
  `BILLING_TELEPHONE` varchar(32) DEFAULT NULL,
  `CHANNEL` varchar(255) DEFAULT NULL,
  `CONFIRMED_ADDRESS` bit(1) DEFAULT NULL,
  `CARD_TYPE` varchar(255) DEFAULT NULL,
  `CC_CVV` varchar(255) DEFAULT NULL,
  `CC_EXPIRES` varchar(255) DEFAULT NULL,
  `CC_NUMBER` varchar(255) DEFAULT NULL,
  `CC_OWNER` varchar(255) DEFAULT NULL,
  `CURRENCY_VALUE` decimal(19,2) DEFAULT NULL,
  `CUSTOMER_AGREED` bit(1) DEFAULT NULL,
  `CUSTOMER_EMAIL_ADDRESS` varchar(50) NOT NULL,
  `CUSTOMER_ID` bigint(20) DEFAULT NULL,
  `DATE_PURCHASED` date DEFAULT NULL,
  `DELIVERY_STREET_ADDRESS` varchar(256) DEFAULT NULL,
  `DELIVERY_CITY` varchar(100) DEFAULT NULL,
  `DELIVERY_COMPANY` varchar(100) DEFAULT NULL,
  `DELIVERY_FIRST_NAME` varchar(64) DEFAULT NULL,
  `DELIVERY_LAST_NAME` varchar(64) DEFAULT NULL,
  `DELIVERY_POSTCODE` varchar(20) DEFAULT NULL,
  `DELIVERY_STATE` varchar(100) DEFAULT NULL,
  `DELIVERY_TELEPHONE` varchar(32) DEFAULT NULL,
  `IP_ADDRESS` varchar(255) DEFAULT NULL,
  `LAST_MODIFIED` datetime DEFAULT NULL,
  `LOCALE` varchar(255) DEFAULT NULL,
  `ORDER_DATE_FINISHED` datetime DEFAULT NULL,
  `ORDER_TYPE` varchar(255) DEFAULT NULL,
  `PAYMENT_MODULE_CODE` varchar(255) DEFAULT NULL,
  `PAYMENT_TYPE` varchar(255) DEFAULT NULL,
  `SHIPPING_MODULE_CODE` varchar(255) DEFAULT NULL,
  `ORDER_STATUS` varchar(255) DEFAULT NULL,
  `ORDER_TOTAL` decimal(19,2) DEFAULT NULL,
  `BILLING_COUNTRY_ID` int(11) NOT NULL,
  `BILLING_ZONE_ID` bigint(20) DEFAULT NULL,
  `CURRENCY_ID` bigint(20) DEFAULT NULL,
  `DELIVERY_COUNTRY_ID` int(11) DEFAULT NULL,
  `DELIVERY_ZONE_ID` bigint(20) DEFAULT NULL,
  `MERCHANTID` int(11) DEFAULT NULL,
  PRIMARY KEY (`ORDER_ID`),
  KEY `FK_fnbc9pw6waewb1yraliutnhh1` (`BILLING_COUNTRY_ID`),
  KEY `FK_8e0096usk6ubo6g1m4g02cdg9` (`BILLING_ZONE_ID`),
  KEY `FK_ib790h1pasu1n7mye2hxl3i99` (`CURRENCY_ID`),
  KEY `FK_4lkaw8wsvt2mfmwna70lctuu8` (`DELIVERY_COUNTRY_ID`),
  KEY `FK_hq0mw7hixmta7q34ohl1g18wl` (`DELIVERY_ZONE_ID`),
  KEY `FK_3b8cm7lvbxjbtepjn64nnbtc0` (`MERCHANTID`),
  CONSTRAINT `FK_3b8cm7lvbxjbtepjn64nnbtc0` FOREIGN KEY (`MERCHANTID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`),
  CONSTRAINT `FK_4lkaw8wsvt2mfmwna70lctuu8` FOREIGN KEY (`DELIVERY_COUNTRY_ID`) REFERENCES `COUNTRY` (`COUNTRY_ID`),
  CONSTRAINT `FK_8e0096usk6ubo6g1m4g02cdg9` FOREIGN KEY (`BILLING_ZONE_ID`) REFERENCES `ZONE` (`ZONE_ID`),
  CONSTRAINT `FK_fnbc9pw6waewb1yraliutnhh1` FOREIGN KEY (`BILLING_COUNTRY_ID`) REFERENCES `COUNTRY` (`COUNTRY_ID`),
  CONSTRAINT `FK_hq0mw7hixmta7q34ohl1g18wl` FOREIGN KEY (`DELIVERY_ZONE_ID`) REFERENCES `ZONE` (`ZONE_ID`),
  CONSTRAINT `FK_ib790h1pasu1n7mye2hxl3i99` FOREIGN KEY (`CURRENCY_ID`) REFERENCES `CURRENCY` (`CURRENCY_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ORDERS`
--

LOCK TABLES `ORDERS` WRITE;
/*!40000 ALTER TABLE `ORDERS` DISABLE KEYS */;
INSERT INTO `ORDERS` VALUES (1,'358 Du Languadoc','Boucherville','CSTI Consulting','Leonardo','DiCaprio','J4B-8J9',NULL,NULL,NULL,'\0',NULL,NULL,NULL,NULL,NULL,0.98,'\0','leo@shopizer.com',1,'2019-06-22','358 Du Languadoc','Boucherville',NULL,'Leonardo','DiCaprio','J4B-8J9',NULL,NULL,'ipAddress','2019-06-22 04:11:09','en_US','2019-06-22 04:11:09','ORDER','paypal','PAYPAL',NULL,'DELIVERED',23.99,13,8,105,13,8,1);
/*!40000 ALTER TABLE `ORDERS` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ORDER_ACCOUNT`
--

DROP TABLE IF EXISTS `ORDER_ACCOUNT`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ORDER_ACCOUNT` (
  `ORDER_ACCOUNT_ID` bigint(20) NOT NULL,
  `ORDER_ACCOUNT_BILL_DAY` int(11) NOT NULL,
  `ORDER_ACCOUNT_END_DATE` date DEFAULT NULL,
  `ORDER_ACCOUNT_START_DATE` date NOT NULL,
  `ORDER_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`ORDER_ACCOUNT_ID`),
  KEY `FK_jwovcys19bo3gyrko0kj0dh4l` (`ORDER_ID`),
  CONSTRAINT `FK_jwovcys19bo3gyrko0kj0dh4l` FOREIGN KEY (`ORDER_ID`) REFERENCES `ORDERS` (`ORDER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ORDER_ACCOUNT`
--

LOCK TABLES `ORDER_ACCOUNT` WRITE;
/*!40000 ALTER TABLE `ORDER_ACCOUNT` DISABLE KEYS */;
/*!40000 ALTER TABLE `ORDER_ACCOUNT` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ORDER_ACCOUNT_PRODUCT`
--

DROP TABLE IF EXISTS `ORDER_ACCOUNT_PRODUCT`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ORDER_ACCOUNT_PRODUCT` (
  `ORDER_ACCOUNT_PRODUCT_ID` bigint(20) NOT NULL,
  `ORDER_ACCOUNT_PRODUCT_ACCNT_DT` date DEFAULT NULL,
  `ORDER_ACCOUNT_PRODUCT_END_DT` date DEFAULT NULL,
  `ORDER_ACCOUNT_PRODUCT_EOT` datetime DEFAULT NULL,
  `ORDER_ACCOUNT_PRODUCT_L_ST_DT` datetime DEFAULT NULL,
  `ORDER_ACCOUNT_PRODUCT_L_TRX_ST` int(11) NOT NULL,
  `ORDER_ACCOUNT_PRODUCT_PM_FR_TY` int(11) NOT NULL,
  `ORDER_ACCOUNT_PRODUCT_ST_DT` date NOT NULL,
  `ORDER_ACCOUNT_PRODUCT_STATUS` int(11) NOT NULL,
  `ORDER_ACCOUNT_ID` bigint(20) NOT NULL,
  `ORDER_PRODUCT_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`ORDER_ACCOUNT_PRODUCT_ID`),
  KEY `FK_rh6ota16guhs9w00trr64087g` (`ORDER_ACCOUNT_ID`),
  KEY `FK_pcotjac5eu4pmsl4dhaq024po` (`ORDER_PRODUCT_ID`),
  CONSTRAINT `FK_pcotjac5eu4pmsl4dhaq024po` FOREIGN KEY (`ORDER_PRODUCT_ID`) REFERENCES `ORDER_PRODUCT` (`ORDER_PRODUCT_ID`),
  CONSTRAINT `FK_rh6ota16guhs9w00trr64087g` FOREIGN KEY (`ORDER_ACCOUNT_ID`) REFERENCES `ORDER_ACCOUNT` (`ORDER_ACCOUNT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ORDER_ACCOUNT_PRODUCT`
--

LOCK TABLES `ORDER_ACCOUNT_PRODUCT` WRITE;
/*!40000 ALTER TABLE `ORDER_ACCOUNT_PRODUCT` DISABLE KEYS */;
/*!40000 ALTER TABLE `ORDER_ACCOUNT_PRODUCT` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ORDER_PRODUCT`
--

DROP TABLE IF EXISTS `ORDER_PRODUCT`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ORDER_PRODUCT` (
  `ORDER_PRODUCT_ID` bigint(20) NOT NULL,
  `ONETIME_CHARGE` decimal(19,2) NOT NULL,
  `PRODUCT_NAME` varchar(64) NOT NULL,
  `PRODUCT_QUANTITY` int(11) DEFAULT NULL,
  `PRODUCT_SKU` varchar(255) DEFAULT NULL,
  `ORDER_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`ORDER_PRODUCT_ID`),
  KEY `FK_4nsxta166qmi0u7v02p6gtnxa` (`ORDER_ID`),
  CONSTRAINT `FK_4nsxta166qmi0u7v02p6gtnxa` FOREIGN KEY (`ORDER_ID`) REFERENCES `ORDERS` (`ORDER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ORDER_PRODUCT`
--

LOCK TABLES `ORDER_PRODUCT` WRITE;
/*!40000 ALTER TABLE `ORDER_PRODUCT` DISABLE KEYS */;
INSERT INTO `ORDER_PRODUCT` VALUES (1,19.99,'Product name',1,'TB12345',1);
/*!40000 ALTER TABLE `ORDER_PRODUCT` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ORDER_PRODUCT_ATTRIBUTE`
--

DROP TABLE IF EXISTS `ORDER_PRODUCT_ATTRIBUTE`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ORDER_PRODUCT_ATTRIBUTE` (
  `ORDER_PRODUCT_ATTRIBUTE_ID` bigint(20) NOT NULL,
  `PRODUCT_ATTRIBUTE_IS_FREE` bit(1) NOT NULL,
  `PRODUCT_ATTRIBUTE_NAME` varchar(255) DEFAULT NULL,
  `PRODUCT_ATTRIBUTE_PRICE` decimal(15,4) NOT NULL,
  `PRODUCT_ATTRIBUTE_VAL_NAME` varchar(255) DEFAULT NULL,
  `PRODUCT_ATTRIBUTE_WEIGHT` decimal(15,4) DEFAULT NULL,
  `PRODUCT_OPTION_ID` bigint(20) NOT NULL,
  `PRODUCT_OPTION_VALUE_ID` bigint(20) NOT NULL,
  `ORDER_PRODUCT_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`ORDER_PRODUCT_ATTRIBUTE_ID`),
  KEY `FK_5rjwlj26iv0e3vnuajjiniek7` (`ORDER_PRODUCT_ID`),
  CONSTRAINT `FK_5rjwlj26iv0e3vnuajjiniek7` FOREIGN KEY (`ORDER_PRODUCT_ID`) REFERENCES `ORDER_PRODUCT` (`ORDER_PRODUCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ORDER_PRODUCT_ATTRIBUTE`
--

LOCK TABLES `ORDER_PRODUCT_ATTRIBUTE` WRITE;
/*!40000 ALTER TABLE `ORDER_PRODUCT_ATTRIBUTE` DISABLE KEYS */;
/*!40000 ALTER TABLE `ORDER_PRODUCT_ATTRIBUTE` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ORDER_PRODUCT_DOWNLOAD`
--

DROP TABLE IF EXISTS `ORDER_PRODUCT_DOWNLOAD`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ORDER_PRODUCT_DOWNLOAD` (
  `ORDER_PRODUCT_DOWNLOAD_ID` bigint(20) NOT NULL,
  `DOWNLOAD_COUNT` int(11) NOT NULL,
  `DOWNLOAD_MAXDAYS` int(11) NOT NULL,
  `ORDER_PRODUCT_FILENAME` varchar(255) NOT NULL,
  `ORDER_PRODUCT_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`ORDER_PRODUCT_DOWNLOAD_ID`),
  KEY `FK_52kb521ve197of5311bu3ee5b` (`ORDER_PRODUCT_ID`),
  CONSTRAINT `FK_52kb521ve197of5311bu3ee5b` FOREIGN KEY (`ORDER_PRODUCT_ID`) REFERENCES `ORDER_PRODUCT` (`ORDER_PRODUCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ORDER_PRODUCT_DOWNLOAD`
--

LOCK TABLES `ORDER_PRODUCT_DOWNLOAD` WRITE;
/*!40000 ALTER TABLE `ORDER_PRODUCT_DOWNLOAD` DISABLE KEYS */;
INSERT INTO `ORDER_PRODUCT_DOWNLOAD` VALUES (1,1,31,'Your digital file name',1);
/*!40000 ALTER TABLE `ORDER_PRODUCT_DOWNLOAD` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ORDER_PRODUCT_PRICE`
--

DROP TABLE IF EXISTS `ORDER_PRODUCT_PRICE`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ORDER_PRODUCT_PRICE` (
  `ORDER_PRODUCT_PRICE_ID` bigint(20) NOT NULL,
  `DEFAULT_PRICE` bit(1) NOT NULL,
  `PRODUCT_PRICE` decimal(19,2) NOT NULL,
  `PRODUCT_PRICE_CODE` varchar(64) NOT NULL,
  `PRODUCT_PRICE_NAME` varchar(255) DEFAULT NULL,
  `PRODUCT_PRICE_SPECIAL` decimal(19,2) DEFAULT NULL,
  `PRD_PRICE_SPECIAL_END_DT` datetime DEFAULT NULL,
  `PRD_PRICE_SPECIAL_ST_DT` datetime DEFAULT NULL,
  `ORDER_PRODUCT_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`ORDER_PRODUCT_PRICE_ID`),
  KEY `FK_shr0wnakwvod5vksceh64umfy` (`ORDER_PRODUCT_ID`),
  CONSTRAINT `FK_shr0wnakwvod5vksceh64umfy` FOREIGN KEY (`ORDER_PRODUCT_ID`) REFERENCES `ORDER_PRODUCT` (`ORDER_PRODUCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ORDER_PRODUCT_PRICE`
--

LOCK TABLES `ORDER_PRODUCT_PRICE` WRITE;
/*!40000 ALTER TABLE `ORDER_PRODUCT_PRICE` DISABLE KEYS */;
INSERT INTO `ORDER_PRODUCT_PRICE` VALUES (1,'',19.99,'baseprice','Base Price',NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `ORDER_PRODUCT_PRICE` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ORDER_STATUS_HISTORY`
--

DROP TABLE IF EXISTS `ORDER_STATUS_HISTORY`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ORDER_STATUS_HISTORY` (
  `ORDER_STATUS_HISTORY_ID` bigint(20) NOT NULL,
  `COMMENTS` longtext,
  `CUSTOMER_NOTIFIED` int(11) DEFAULT NULL,
  `DATE_ADDED` datetime NOT NULL,
  `status` varchar(255) DEFAULT NULL,
  `ORDER_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`ORDER_STATUS_HISTORY_ID`),
  KEY `FK_n14slyp7y649y5rhbmikw3pi0` (`ORDER_ID`),
  CONSTRAINT `FK_n14slyp7y649y5rhbmikw3pi0` FOREIGN KEY (`ORDER_ID`) REFERENCES `ORDERS` (`ORDER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ORDER_STATUS_HISTORY`
--

LOCK TABLES `ORDER_STATUS_HISTORY` WRITE;
/*!40000 ALTER TABLE `ORDER_STATUS_HISTORY` DISABLE KEYS */;
INSERT INTO `ORDER_STATUS_HISTORY` VALUES (1,'We received your order',1,'2019-06-22 04:11:09','ORDERED',1);
/*!40000 ALTER TABLE `ORDER_STATUS_HISTORY` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ORDER_TOTAL`
--

DROP TABLE IF EXISTS `ORDER_TOTAL`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ORDER_TOTAL` (
  `ORDER_ACCOUNT_ID` bigint(20) NOT NULL,
  `MODULE` varchar(60) DEFAULT NULL,
  `CODE` varchar(255) NOT NULL,
  `ORDER_TOTAL_TYPE` varchar(255) DEFAULT NULL,
  `ORDER_VALUE_TYPE` varchar(255) DEFAULT NULL,
  `SORT_ORDER` int(11) NOT NULL,
  `TEXT` longtext,
  `TITLE` varchar(255) DEFAULT NULL,
  `VALUE` decimal(15,4) NOT NULL,
  `ORDER_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`ORDER_ACCOUNT_ID`),
  KEY `FK_khquiwoxp3mpaolsy0hslfjch` (`ORDER_ID`),
  CONSTRAINT `FK_khquiwoxp3mpaolsy0hslfjch` FOREIGN KEY (`ORDER_ID`) REFERENCES `ORDERS` (`ORDER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ORDER_TOTAL`
--

LOCK TABLES `ORDER_TOTAL` WRITE;
/*!40000 ALTER TABLE `ORDER_TOTAL` DISABLE KEYS */;
INSERT INTO `ORDER_TOTAL` VALUES (1,'summary','subtotal',NULL,'ONE_TIME',0,'Summary','Summary',19.9900,1),(2,'tax','tax',NULL,'ONE_TIME',1,'Tax','Tax',4.0000,1),(3,'total','total',NULL,'ONE_TIME',2,'Total','Total',23.9900,1);
/*!40000 ALTER TABLE `ORDER_TOTAL` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PERMISSION`
--

DROP TABLE IF EXISTS `PERMISSION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PERMISSION` (
  `PERMISSION_ID` int(11) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `PERMISSION_NAME` varchar(255) NOT NULL,
  PRIMARY KEY (`PERMISSION_ID`),
  UNIQUE KEY `UK_ss26hgwetkj8ms5y5jn2co4j3` (`PERMISSION_NAME`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PERMISSION`
--

LOCK TABLES `PERMISSION` WRITE;
/*!40000 ALTER TABLE `PERMISSION` DISABLE KEYS */;
INSERT INTO `PERMISSION` VALUES (1,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'STORE_ADMIN'),(2,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'SUPERADMIN'),(3,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'ADMIN'),(4,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'AUTH'),(5,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'PRODUCTS'),(6,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'ORDER'),(7,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'CONTENT'),(8,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'STORE'),(9,'2019-06-22 04:10:56','2019-06-22 04:10:57',NULL,'TAX'),(10,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,'PAYMENT'),(11,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,'CUSTOMER'),(12,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,'SHIPPING'),(13,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,'AUTH_CUSTOMER');
/*!40000 ALTER TABLE `PERMISSION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PERMISSION_GROUP`
--

DROP TABLE IF EXISTS `PERMISSION_GROUP`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PERMISSION_GROUP` (
  `PERMISSION_ID` int(11) NOT NULL,
  `GROUP_ID` int(11) NOT NULL,
  KEY `FK_pj2gjygldr9p81w673a27taw3` (`GROUP_ID`),
  KEY `FK_nngtfydo0o1i7w2lv6k4csut` (`PERMISSION_ID`),
  CONSTRAINT `FK_nngtfydo0o1i7w2lv6k4csut` FOREIGN KEY (`PERMISSION_ID`) REFERENCES `PERMISSION` (`PERMISSION_ID`),
  CONSTRAINT `FK_pj2gjygldr9p81w673a27taw3` FOREIGN KEY (`GROUP_ID`) REFERENCES `SM_GROUP` (`GROUP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PERMISSION_GROUP`
--

LOCK TABLES `PERMISSION_GROUP` WRITE;
/*!40000 ALTER TABLE `PERMISSION_GROUP` DISABLE KEYS */;
INSERT INTO `PERMISSION_GROUP` VALUES (1,1),(1,2),(2,1),(3,1),(3,2),(4,1),(4,2),(4,3),(4,4),(4,5),(5,1),(5,2),(5,3),(6,1),(6,2),(6,5),(7,1),(7,2),(7,6),(8,1),(8,2),(8,4),(9,1),(9,2),(9,4),(10,1),(10,2),(10,4),(11,1),(11,2),(11,4),(12,1),(12,2),(12,4),(13,7);
/*!40000 ALTER TABLE `PERMISSION_GROUP` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PRODUCT`
--

DROP TABLE IF EXISTS `PRODUCT`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PRODUCT` (
  `PRODUCT_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `AVAILABLE` bit(1) DEFAULT NULL,
  `DATE_AVAILABLE` datetime DEFAULT NULL,
  `PREORDER` bit(1) DEFAULT NULL,
  `PRODUCT_HEIGHT` decimal(19,2) DEFAULT NULL,
  `PRODUCT_FREE` bit(1) DEFAULT NULL,
  `PRODUCT_LENGTH` decimal(19,2) DEFAULT NULL,
  `QUANTITY_ORDERED` int(11) DEFAULT NULL,
  `REVIEW_AVG` decimal(19,2) DEFAULT NULL,
  `REVIEW_COUNT` int(11) DEFAULT NULL,
  `PRODUCT_SHIP` bit(1) DEFAULT NULL,
  `PRODUCT_VIRTUAL` bit(1) DEFAULT NULL,
  `PRODUCT_WEIGHT` decimal(19,2) DEFAULT NULL,
  `PRODUCT_WIDTH` decimal(19,2) DEFAULT NULL,
  `REF_SKU` varchar(255) DEFAULT NULL,
  `SKU` varchar(255) NOT NULL,
  `SORT_ORDER` int(11) DEFAULT NULL,
  `MANUFACTURER_ID` bigint(20) DEFAULT NULL,
  `MERCHANT_ID` int(11) NOT NULL,
  `TAX_CLASS_ID` bigint(20) DEFAULT NULL,
  `PRODUCT_TYPE_ID` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`PRODUCT_ID`),
  UNIQUE KEY `UK_s8ofsn9pehdrstjg52j5qabxh` (`MERCHANT_ID`,`SKU`),
  KEY `FK_t03uwph4r4si70siiqafff3qj` (`MANUFACTURER_ID`),
  KEY `FK_pm6ef7y9lxy9xeav2dvcr4n4p` (`TAX_CLASS_ID`),
  KEY `FK_nor0i9e2avl4yyioivxyxpr28` (`PRODUCT_TYPE_ID`),
  CONSTRAINT `FK_a1p3pj01g4ojbdf1i93iavwoo` FOREIGN KEY (`MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`),
  CONSTRAINT `FK_nor0i9e2avl4yyioivxyxpr28` FOREIGN KEY (`PRODUCT_TYPE_ID`) REFERENCES `PRODUCT_TYPE` (`PRODUCT_TYPE_ID`),
  CONSTRAINT `FK_pm6ef7y9lxy9xeav2dvcr4n4p` FOREIGN KEY (`TAX_CLASS_ID`) REFERENCES `TAX_CLASS` (`TAX_CLASS_ID`),
  CONSTRAINT `FK_t03uwph4r4si70siiqafff3qj` FOREIGN KEY (`MANUFACTURER_ID`) REFERENCES `MANUFACTURER` (`MANUFACTURER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PRODUCT`
--

LOCK TABLES `PRODUCT` WRITE;
/*!40000 ALTER TABLE `PRODUCT` DISABLE KEYS */;
INSERT INTO `PRODUCT` VALUES (1,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,'','2019-06-22 04:10:57','\0',10.00,'\0',3.00,NULL,NULL,NULL,'','\0',NULL,6.00,NULL,'TB12345',0,4,1,NULL,1),(2,'2019-06-22 04:11:08','2019-06-22 04:11:08',NULL,'','2019-06-22 04:11:08','\0',4.00,'\0',3.00,NULL,NULL,NULL,'','\0',NULL,1.00,NULL,'TB2468',0,3,1,NULL,1),(3,'2019-06-22 04:11:09','2019-06-22 04:11:09',NULL,'','2019-06-22 04:11:09','\0',4.00,'\0',3.00,NULL,NULL,NULL,'','\0',NULL,1.00,NULL,'NB1111',0,1,1,NULL,1),(4,'2019-06-22 04:11:09','2019-06-22 04:11:09',NULL,'','2019-06-22 04:11:09','\0',4.00,'\0',3.00,NULL,NULL,NULL,'','\0',NULL,1.00,NULL,'SF333345',0,2,1,NULL,1),(5,'2019-06-22 04:11:09','2019-06-22 04:11:09',NULL,'','2019-06-22 04:11:09','\0',4.00,'\0',3.00,NULL,NULL,NULL,'','\0',NULL,1.00,NULL,'SF333346',0,3,1,NULL,1),(6,'2019-06-22 04:11:09','2019-06-22 04:11:09',NULL,'','2019-06-22 04:11:09','\0',4.00,'\0',3.00,NULL,NULL,NULL,'','\0',NULL,1.00,NULL,'LL333444',0,5,1,NULL,1);
/*!40000 ALTER TABLE `PRODUCT` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PRODUCT_ATTRIBUTE`
--

DROP TABLE IF EXISTS `PRODUCT_ATTRIBUTE`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PRODUCT_ATTRIBUTE` (
  `PRODUCT_ATTRIBUTE_ID` bigint(20) NOT NULL,
  `PRODUCT_ATTRIBUTE_DEFAULT` bit(1) DEFAULT NULL,
  `PRODUCT_ATTRIBUTE_DISCOUNTED` bit(1) DEFAULT NULL,
  `PRODUCT_ATTRIBUTE_FOR_DISP` bit(1) DEFAULT NULL,
  `PRODUCT_ATTRIBUTE_REQUIRED` bit(1) DEFAULT NULL,
  `PRODUCT_ATTRIBUTE_FREE` bit(1) DEFAULT NULL,
  `PRODUCT_ATRIBUTE_PRICE` decimal(19,2) DEFAULT NULL,
  `PRODUCT_ATTRIBUTE_WEIGHT` decimal(19,2) DEFAULT NULL,
  `PRODUCT_ATTRIBUTE_SORT_ORD` int(11) DEFAULT NULL,
  `PRODUCT_ID` bigint(20) NOT NULL,
  `OPTION_ID` bigint(20) NOT NULL,
  `OPTION_VALUE_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`PRODUCT_ATTRIBUTE_ID`),
  UNIQUE KEY `UK_o0c6cfxcfejwfa2877gfgpuco` (`OPTION_ID`,`OPTION_VALUE_ID`,`PRODUCT_ID`),
  KEY `FK_6h8m6ocg2jhu3bfieqa0dupb1` (`PRODUCT_ID`),
  KEY `FK_g2h5gdhgcbn7b3cr26sj6ax4c` (`OPTION_VALUE_ID`),
  CONSTRAINT `FK_6h8m6ocg2jhu3bfieqa0dupb1` FOREIGN KEY (`PRODUCT_ID`) REFERENCES `PRODUCT` (`PRODUCT_ID`),
  CONSTRAINT `FK_g2h5gdhgcbn7b3cr26sj6ax4c` FOREIGN KEY (`OPTION_VALUE_ID`) REFERENCES `PRODUCT_OPTION_VALUE` (`PRODUCT_OPTION_VALUE_ID`),
  CONSTRAINT `FK_r9u2iot9wkbn263up3pj9stc1` FOREIGN KEY (`OPTION_ID`) REFERENCES `PRODUCT_OPTION` (`PRODUCT_OPTION_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PRODUCT_ATTRIBUTE`
--

LOCK TABLES `PRODUCT_ATTRIBUTE` WRITE;
/*!40000 ALTER TABLE `PRODUCT_ATTRIBUTE` DISABLE KEYS */;
/*!40000 ALTER TABLE `PRODUCT_ATTRIBUTE` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PRODUCT_AVAILABILITY`
--

DROP TABLE IF EXISTS `PRODUCT_AVAILABILITY`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PRODUCT_AVAILABILITY` (
  `PRODUCT_AVAIL_ID` bigint(20) NOT NULL,
  `DATE_AVAILABLE` date DEFAULT NULL,
  `FREE_SHIPPING` bit(1) DEFAULT NULL,
  `QUANTITY` int(11) NOT NULL,
  `QUANTITY_ORD_MAX` int(11) DEFAULT NULL,
  `QUANTITY_ORD_MIN` int(11) DEFAULT NULL,
  `STATUS` bit(1) DEFAULT NULL,
  `REGION` varchar(255) DEFAULT NULL,
  `REGION_VARIANT` varchar(255) DEFAULT NULL,
  `PRODUCT_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`PRODUCT_AVAIL_ID`),
  KEY `FK_g32kj493ntgjnky10l88q8ba7` (`PRODUCT_ID`),
  CONSTRAINT `FK_g32kj493ntgjnky10l88q8ba7` FOREIGN KEY (`PRODUCT_ID`) REFERENCES `PRODUCT` (`PRODUCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PRODUCT_AVAILABILITY`
--

LOCK TABLES `PRODUCT_AVAILABILITY` WRITE;
/*!40000 ALTER TABLE `PRODUCT_AVAILABILITY` DISABLE KEYS */;
INSERT INTO `PRODUCT_AVAILABILITY` VALUES (1,'2019-06-22','\0',100,0,0,'','*',NULL,1),(2,'2019-06-22','\0',100,0,0,'','*',NULL,2),(3,'2019-06-22','\0',100,0,0,'','*',NULL,3),(4,'2019-06-22','\0',100,0,0,'','*',NULL,4),(5,'2019-06-22','\0',100,0,0,'','*',NULL,5),(6,'2019-06-22','\0',100,0,0,'','*',NULL,6);
/*!40000 ALTER TABLE `PRODUCT_AVAILABILITY` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PRODUCT_CATEGORY`
--

DROP TABLE IF EXISTS `PRODUCT_CATEGORY`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PRODUCT_CATEGORY` (
  `PRODUCT_ID` bigint(20) NOT NULL,
  `CATEGORY_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`PRODUCT_ID`,`CATEGORY_ID`),
  KEY `FK_j0abhuuifvojg9079r0njja07` (`CATEGORY_ID`),
  CONSTRAINT `FK_cu9i33d6dbyo4s8jmfepoyn59` FOREIGN KEY (`PRODUCT_ID`) REFERENCES `PRODUCT` (`PRODUCT_ID`),
  CONSTRAINT `FK_j0abhuuifvojg9079r0njja07` FOREIGN KEY (`CATEGORY_ID`) REFERENCES `CATEGORY` (`CATEGORY_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PRODUCT_CATEGORY`
--

LOCK TABLES `PRODUCT_CATEGORY` WRITE;
/*!40000 ALTER TABLE `PRODUCT_CATEGORY` DISABLE KEYS */;
INSERT INTO `PRODUCT_CATEGORY` VALUES (1,3),(2,3),(4,3),(5,3),(1,4),(2,4),(6,6),(3,7);
/*!40000 ALTER TABLE `PRODUCT_CATEGORY` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PRODUCT_DESCRIPTION`
--

DROP TABLE IF EXISTS `PRODUCT_DESCRIPTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PRODUCT_DESCRIPTION` (
  `DESCRIPTION_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `DESCRIPTION` longtext,
  `NAME` varchar(120) NOT NULL,
  `TITLE` varchar(100) DEFAULT NULL,
  `META_DESCRIPTION` varchar(255) DEFAULT NULL,
  `META_KEYWORDS` varchar(255) DEFAULT NULL,
  `META_TITLE` varchar(255) DEFAULT NULL,
  `DOWNLOAD_LNK` varchar(255) DEFAULT NULL,
  `PRODUCT_HIGHLIGHT` varchar(255) DEFAULT NULL,
  `SEF_URL` varchar(255) DEFAULT NULL,
  `LANGUAGE_ID` int(11) NOT NULL,
  `PRODUCT_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`DESCRIPTION_ID`),
  UNIQUE KEY `UK_q4dnkx5b776ayqas2h4rr2d8q` (`PRODUCT_ID`,`LANGUAGE_ID`),
  KEY `FK_adhnr56rrg1b3v9ufoey6vjfs` (`LANGUAGE_ID`),
  CONSTRAINT `FK_adhnr56rrg1b3v9ufoey6vjfs` FOREIGN KEY (`LANGUAGE_ID`) REFERENCES `LANGUAGE` (`LANGUAGE_ID`),
  CONSTRAINT `FK_aruidfgmbeki4pu5ipjdd5j7p` FOREIGN KEY (`PRODUCT_ID`) REFERENCES `PRODUCT` (`PRODUCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PRODUCT_DESCRIPTION`
--

LOCK TABLES `PRODUCT_DESCRIPTION` WRITE;
/*!40000 ALTER TABLE `PRODUCT_DESCRIPTION` DISABLE KEYS */;
INSERT INTO `PRODUCT_DESCRIPTION` VALUES (750,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'Spring in Action',NULL,NULL,NULL,NULL,NULL,NULL,'Spring-in-Action',1,1),(751,'2019-06-22 04:11:08','2019-06-22 04:11:08',NULL,NULL,'Node Web Development',NULL,NULL,NULL,NULL,NULL,NULL,'Node-Web-Development',1,2),(752,'2019-06-22 04:11:09','2019-06-22 04:11:09',NULL,NULL,'Programming for PAAS',NULL,NULL,NULL,NULL,NULL,NULL,'programming-for-paas',1,3),(753,'2019-06-22 04:11:09','2019-06-22 04:11:09',NULL,NULL,'Android development',NULL,NULL,NULL,NULL,NULL,NULL,'android-application-development',1,4),(754,'2019-06-22 04:11:09','2019-06-22 04:11:09',NULL,NULL,'Android 3.0 Cookbook',NULL,NULL,NULL,NULL,NULL,NULL,'android-3-cookbook',1,5),(755,'2019-06-22 04:11:09','2019-06-22 04:11:09',NULL,NULL,'The Big Switch',NULL,NULL,NULL,NULL,NULL,NULL,'the-big-switch',1,6);
/*!40000 ALTER TABLE `PRODUCT_DESCRIPTION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PRODUCT_DIGITAL`
--

DROP TABLE IF EXISTS `PRODUCT_DIGITAL`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PRODUCT_DIGITAL` (
  `PRODUCT_DIGITAL_ID` bigint(20) NOT NULL,
  `FILE_NAME` varchar(255) NOT NULL,
  `PRODUCT_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`PRODUCT_DIGITAL_ID`),
  UNIQUE KEY `UK_juk1qgkh9v5w7ghvb18krwo8v` (`PRODUCT_ID`,`FILE_NAME`),
  CONSTRAINT `FK_7nmms6pbk5w9yvqm874hw1a1r` FOREIGN KEY (`PRODUCT_ID`) REFERENCES `PRODUCT` (`PRODUCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PRODUCT_DIGITAL`
--

LOCK TABLES `PRODUCT_DIGITAL` WRITE;
/*!40000 ALTER TABLE `PRODUCT_DIGITAL` DISABLE KEYS */;
/*!40000 ALTER TABLE `PRODUCT_DIGITAL` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PRODUCT_IMAGE`
--

DROP TABLE IF EXISTS `PRODUCT_IMAGE`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PRODUCT_IMAGE` (
  `PRODUCT_IMAGE_ID` bigint(20) NOT NULL,
  `DEFAULT_IMAGE` bit(1) DEFAULT NULL,
  `IMAGE_CROP` bit(1) DEFAULT NULL,
  `IMAGE_TYPE` int(11) DEFAULT NULL,
  `PRODUCT_IMAGE` varchar(255) DEFAULT NULL,
  `PRODUCT_IMAGE_URL` varchar(255) DEFAULT NULL,
  `PRODUCT_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`PRODUCT_IMAGE_ID`),
  KEY `FK_dmpwg0pdbotjf8h0ca15tx3qm` (`PRODUCT_ID`),
  CONSTRAINT `FK_dmpwg0pdbotjf8h0ca15tx3qm` FOREIGN KEY (`PRODUCT_ID`) REFERENCES `PRODUCT` (`PRODUCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PRODUCT_IMAGE`
--

LOCK TABLES `PRODUCT_IMAGE` WRITE;
/*!40000 ALTER TABLE `PRODUCT_IMAGE` DISABLE KEYS */;
INSERT INTO `PRODUCT_IMAGE` VALUES (1,'','\0',0,'spring.png',NULL,1),(2,'','\0',0,'node.jpg',NULL,2),(3,'','\0',0,'paas.JPG',NULL,3),(4,'','\0',0,'android.jpg',NULL,4),(5,'','\0',0,'android2.jpg',NULL,5),(6,'','\0',0,'google.jpg',NULL,6);
/*!40000 ALTER TABLE `PRODUCT_IMAGE` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PRODUCT_IMAGE_DESCRIPTION`
--

DROP TABLE IF EXISTS `PRODUCT_IMAGE_DESCRIPTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PRODUCT_IMAGE_DESCRIPTION` (
  `DESCRIPTION_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `DESCRIPTION` longtext,
  `NAME` varchar(120) NOT NULL,
  `TITLE` varchar(100) DEFAULT NULL,
  `ALT_TAG` varchar(100) DEFAULT NULL,
  `LANGUAGE_ID` int(11) NOT NULL,
  `PRODUCT_IMAGE_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`DESCRIPTION_ID`),
  UNIQUE KEY `UK_n7yhdj6ccydgf201gibb882cd` (`PRODUCT_IMAGE_ID`,`LANGUAGE_ID`),
  KEY `FK_ro5t1gks1imat7hji5p7hessp` (`LANGUAGE_ID`),
  CONSTRAINT `FK_1sdajmriuthbewh872gji4qgt` FOREIGN KEY (`PRODUCT_IMAGE_ID`) REFERENCES `PRODUCT_IMAGE` (`PRODUCT_IMAGE_ID`),
  CONSTRAINT `FK_ro5t1gks1imat7hji5p7hessp` FOREIGN KEY (`LANGUAGE_ID`) REFERENCES `LANGUAGE` (`LANGUAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PRODUCT_IMAGE_DESCRIPTION`
--

LOCK TABLES `PRODUCT_IMAGE_DESCRIPTION` WRITE;
/*!40000 ALTER TABLE `PRODUCT_IMAGE_DESCRIPTION` DISABLE KEYS */;
/*!40000 ALTER TABLE `PRODUCT_IMAGE_DESCRIPTION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PRODUCT_OPTION`
--

DROP TABLE IF EXISTS `PRODUCT_OPTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PRODUCT_OPTION` (
  `PRODUCT_OPTION_ID` bigint(20) NOT NULL,
  `PRODUCT_OPTION_CODE` varchar(255) NOT NULL,
  `PRODUCT_OPTION_SORT_ORD` int(11) DEFAULT NULL,
  `PRODUCT_OPTION_TYPE` varchar(10) DEFAULT NULL,
  `PRODUCT_OPTION_READ` bit(1) DEFAULT NULL,
  `MERCHANT_ID` int(11) NOT NULL,
  PRIMARY KEY (`PRODUCT_OPTION_ID`),
  UNIQUE KEY `UK_hfcw5oi9ulljlog1b7ns1r9tu` (`MERCHANT_ID`,`PRODUCT_OPTION_CODE`),
  KEY `PRD_OPTION_CODE_IDX` (`PRODUCT_OPTION_CODE`),
  CONSTRAINT `FK_4w5ar6nahg63cj3vbm00xr7r7` FOREIGN KEY (`MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PRODUCT_OPTION`
--

LOCK TABLES `PRODUCT_OPTION` WRITE;
/*!40000 ALTER TABLE `PRODUCT_OPTION` DISABLE KEYS */;
/*!40000 ALTER TABLE `PRODUCT_OPTION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PRODUCT_OPTION_DESC`
--

DROP TABLE IF EXISTS `PRODUCT_OPTION_DESC`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PRODUCT_OPTION_DESC` (
  `DESCRIPTION_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `DESCRIPTION` longtext,
  `NAME` varchar(120) NOT NULL,
  `TITLE` varchar(100) DEFAULT NULL,
  `PRODUCT_OPTION_COMMENT` longtext,
  `LANGUAGE_ID` int(11) NOT NULL,
  `PRODUCT_OPTION_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`DESCRIPTION_ID`),
  UNIQUE KEY `UK_mkcm8isyyyqbjd1yyb8mrpkuw` (`PRODUCT_OPTION_ID`,`LANGUAGE_ID`),
  KEY `FK_23nqig56qilwn2f6d76cl5ubx` (`LANGUAGE_ID`),
  CONSTRAINT `FK_23nqig56qilwn2f6d76cl5ubx` FOREIGN KEY (`LANGUAGE_ID`) REFERENCES `LANGUAGE` (`LANGUAGE_ID`),
  CONSTRAINT `FK_aa0fbx3v56bjbxwipag3bbdev` FOREIGN KEY (`PRODUCT_OPTION_ID`) REFERENCES `PRODUCT_OPTION` (`PRODUCT_OPTION_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PRODUCT_OPTION_DESC`
--

LOCK TABLES `PRODUCT_OPTION_DESC` WRITE;
/*!40000 ALTER TABLE `PRODUCT_OPTION_DESC` DISABLE KEYS */;
/*!40000 ALTER TABLE `PRODUCT_OPTION_DESC` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PRODUCT_OPTION_VALUE`
--

DROP TABLE IF EXISTS `PRODUCT_OPTION_VALUE`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PRODUCT_OPTION_VALUE` (
  `PRODUCT_OPTION_VALUE_ID` bigint(20) NOT NULL,
  `PRODUCT_OPTION_VAL_CODE` varchar(255) NOT NULL,
  `PRODUCT_OPT_FOR_DISP` bit(1) DEFAULT NULL,
  `PRODUCT_OPT_VAL_IMAGE` varchar(255) DEFAULT NULL,
  `PRODUCT_OPT_VAL_SORT_ORD` int(11) DEFAULT NULL,
  `MERCHANT_ID` int(11) NOT NULL,
  PRIMARY KEY (`PRODUCT_OPTION_VALUE_ID`),
  UNIQUE KEY `UK_ixbpi4hxrhljh935c3xfvnvsh` (`MERCHANT_ID`,`PRODUCT_OPTION_VAL_CODE`),
  KEY `PRD_OPTION_VAL_CODE_IDX` (`PRODUCT_OPTION_VAL_CODE`),
  CONSTRAINT `FK_9q3e32t980pm3xfonwcb94e9t` FOREIGN KEY (`MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PRODUCT_OPTION_VALUE`
--

LOCK TABLES `PRODUCT_OPTION_VALUE` WRITE;
/*!40000 ALTER TABLE `PRODUCT_OPTION_VALUE` DISABLE KEYS */;
/*!40000 ALTER TABLE `PRODUCT_OPTION_VALUE` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PRODUCT_OPTION_VALUE_DESCRIPTION`
--

DROP TABLE IF EXISTS `PRODUCT_OPTION_VALUE_DESCRIPTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PRODUCT_OPTION_VALUE_DESCRIPTION` (
  `DESCRIPTION_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `DESCRIPTION` longtext,
  `NAME` varchar(120) NOT NULL,
  `TITLE` varchar(100) DEFAULT NULL,
  `LANGUAGE_ID` int(11) NOT NULL,
  `PRODUCT_OPTION_VALUE_ID` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`DESCRIPTION_ID`),
  UNIQUE KEY `UK_asgc60ot1wy0uho96n0j8429p` (`PRODUCT_OPTION_VALUE_ID`,`LANGUAGE_ID`),
  KEY `FK_hmjmi3k2k2xts6r1b3h59p7dj` (`LANGUAGE_ID`),
  CONSTRAINT `FK_4igjaqwi959o699j6o8jhfftl` FOREIGN KEY (`PRODUCT_OPTION_VALUE_ID`) REFERENCES `PRODUCT_OPTION_VALUE` (`PRODUCT_OPTION_VALUE_ID`),
  CONSTRAINT `FK_hmjmi3k2k2xts6r1b3h59p7dj` FOREIGN KEY (`LANGUAGE_ID`) REFERENCES `LANGUAGE` (`LANGUAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PRODUCT_OPTION_VALUE_DESCRIPTION`
--

LOCK TABLES `PRODUCT_OPTION_VALUE_DESCRIPTION` WRITE;
/*!40000 ALTER TABLE `PRODUCT_OPTION_VALUE_DESCRIPTION` DISABLE KEYS */;
/*!40000 ALTER TABLE `PRODUCT_OPTION_VALUE_DESCRIPTION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PRODUCT_PRICE`
--

DROP TABLE IF EXISTS `PRODUCT_PRICE`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PRODUCT_PRICE` (
  `PRODUCT_PRICE_ID` bigint(20) NOT NULL,
  `PRODUCT_PRICE_CODE` varchar(255) NOT NULL,
  `DEFAULT_PRICE` bit(1) DEFAULT NULL,
  `PRODUCT_PRICE_AMOUNT` decimal(19,2) NOT NULL,
  `PRODUCT_PRICE_SPECIAL_AMOUNT` decimal(19,2) DEFAULT NULL,
  `PRODUCT_PRICE_SPECIAL_END_DATE` date DEFAULT NULL,
  `PRODUCT_PRICE_SPECIAL_ST_DATE` date DEFAULT NULL,
  `PRODUCT_PRICE_TYPE` varchar(20) DEFAULT NULL,
  `PRODUCT_AVAIL_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`PRODUCT_PRICE_ID`),
  KEY `FK_bt21fp36gai74hfosfo02wucx` (`PRODUCT_AVAIL_ID`),
  CONSTRAINT `FK_bt21fp36gai74hfosfo02wucx` FOREIGN KEY (`PRODUCT_AVAIL_ID`) REFERENCES `PRODUCT_AVAILABILITY` (`PRODUCT_AVAIL_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PRODUCT_PRICE`
--

LOCK TABLES `PRODUCT_PRICE` WRITE;
/*!40000 ALTER TABLE `PRODUCT_PRICE` DISABLE KEYS */;
INSERT INTO `PRODUCT_PRICE` VALUES (1,'base','',39.99,NULL,NULL,NULL,'ONE_TIME',1),(2,'base','',29.99,NULL,NULL,NULL,'ONE_TIME',2),(3,'base','',19.99,NULL,NULL,NULL,'ONE_TIME',3),(4,'base','',18.99,NULL,NULL,NULL,'ONE_TIME',4),(5,'base','',18.99,NULL,NULL,NULL,'ONE_TIME',5),(6,'base','',18.99,NULL,NULL,NULL,'ONE_TIME',6);
/*!40000 ALTER TABLE `PRODUCT_PRICE` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PRODUCT_PRICE_DESCRIPTION`
--

DROP TABLE IF EXISTS `PRODUCT_PRICE_DESCRIPTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PRODUCT_PRICE_DESCRIPTION` (
  `DESCRIPTION_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `DESCRIPTION` longtext,
  `NAME` varchar(120) NOT NULL,
  `TITLE` varchar(100) DEFAULT NULL,
  `LANGUAGE_ID` int(11) NOT NULL,
  `PRODUCT_PRICE_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`DESCRIPTION_ID`),
  UNIQUE KEY `UK_frsw8d41sxxogvxxoyd8nwaxu` (`PRODUCT_PRICE_ID`,`LANGUAGE_ID`),
  KEY `FK_fykbb1jc6rp1nsiaaj9ur40um` (`LANGUAGE_ID`),
  CONSTRAINT `FK_2xu1k5v5blwc7w6x65g4ww0au` FOREIGN KEY (`PRODUCT_PRICE_ID`) REFERENCES `PRODUCT_PRICE` (`PRODUCT_PRICE_ID`),
  CONSTRAINT `FK_fykbb1jc6rp1nsiaaj9ur40um` FOREIGN KEY (`LANGUAGE_ID`) REFERENCES `LANGUAGE` (`LANGUAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PRODUCT_PRICE_DESCRIPTION`
--

LOCK TABLES `PRODUCT_PRICE_DESCRIPTION` WRITE;
/*!40000 ALTER TABLE `PRODUCT_PRICE_DESCRIPTION` DISABLE KEYS */;
INSERT INTO `PRODUCT_PRICE_DESCRIPTION` VALUES (700,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,NULL,'Base price',NULL,1,1),(701,'2019-06-22 04:11:08','2019-06-22 04:11:08',NULL,NULL,'Base price',NULL,1,2),(702,'2019-06-22 04:11:09','2019-06-22 04:11:09',NULL,NULL,'Base price',NULL,1,3),(703,'2019-06-22 04:11:09','2019-06-22 04:11:09',NULL,NULL,'Base price',NULL,1,4),(704,'2019-06-22 04:11:09','2019-06-22 04:11:09',NULL,NULL,'Base price',NULL,1,5),(705,'2019-06-22 04:11:09','2019-06-22 04:11:09',NULL,NULL,'Base price',NULL,1,6);
/*!40000 ALTER TABLE `PRODUCT_PRICE_DESCRIPTION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PRODUCT_RELATIONSHIP`
--

DROP TABLE IF EXISTS `PRODUCT_RELATIONSHIP`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PRODUCT_RELATIONSHIP` (
  `PRODUCT_RELATIONSHIP_ID` bigint(20) NOT NULL,
  `ACTIVE` bit(1) DEFAULT NULL,
  `CODE` varchar(255) DEFAULT NULL,
  `PRODUCT_ID` bigint(20) DEFAULT NULL,
  `RELATED_PRODUCT_ID` bigint(20) DEFAULT NULL,
  `MERCHANT_ID` int(11) NOT NULL,
  PRIMARY KEY (`PRODUCT_RELATIONSHIP_ID`),
  KEY `FK_soi25dq8dn9vmk1yiggivp2fl` (`PRODUCT_ID`),
  KEY `FK_d1m8psp38jc0nk5ux56918eik` (`RELATED_PRODUCT_ID`),
  KEY `FK_jlyfte1wuvqgdxwwt2fnbg47g` (`MERCHANT_ID`),
  CONSTRAINT `FK_d1m8psp38jc0nk5ux56918eik` FOREIGN KEY (`RELATED_PRODUCT_ID`) REFERENCES `PRODUCT` (`PRODUCT_ID`),
  CONSTRAINT `FK_jlyfte1wuvqgdxwwt2fnbg47g` FOREIGN KEY (`MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`),
  CONSTRAINT `FK_soi25dq8dn9vmk1yiggivp2fl` FOREIGN KEY (`PRODUCT_ID`) REFERENCES `PRODUCT` (`PRODUCT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PRODUCT_RELATIONSHIP`
--

LOCK TABLES `PRODUCT_RELATIONSHIP` WRITE;
/*!40000 ALTER TABLE `PRODUCT_RELATIONSHIP` DISABLE KEYS */;
INSERT INTO `PRODUCT_RELATIONSHIP` VALUES (1,'','FEATURED_ITEM',NULL,1,1),(2,'','FEATURED_ITEM',NULL,6,1),(3,'','FEATURED_ITEM',NULL,5,1),(4,'','FEATURED_ITEM',NULL,2,1);
/*!40000 ALTER TABLE `PRODUCT_RELATIONSHIP` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PRODUCT_REVIEW`
--

DROP TABLE IF EXISTS `PRODUCT_REVIEW`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PRODUCT_REVIEW` (
  `PRODUCT_REVIEW_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `REVIEW_DATE` datetime DEFAULT NULL,
  `REVIEWS_RATING` double DEFAULT NULL,
  `REVIEWS_READ` bigint(20) DEFAULT NULL,
  `STATUS` int(11) DEFAULT NULL,
  `CUSTOMERS_ID` bigint(20) DEFAULT NULL,
  `PRODUCT_ID` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`PRODUCT_REVIEW_ID`),
  KEY `FK_pvhck0hgg98k948igph4wtjo1` (`CUSTOMERS_ID`),
  KEY `FK_i1vhr6iv0i07sy5ogjcb7n8un` (`PRODUCT_ID`),
  CONSTRAINT `FK_i1vhr6iv0i07sy5ogjcb7n8un` FOREIGN KEY (`PRODUCT_ID`) REFERENCES `PRODUCT` (`PRODUCT_ID`),
  CONSTRAINT `FK_pvhck0hgg98k948igph4wtjo1` FOREIGN KEY (`CUSTOMERS_ID`) REFERENCES `CUSTOMER` (`CUSTOMER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PRODUCT_REVIEW`
--

LOCK TABLES `PRODUCT_REVIEW` WRITE;
/*!40000 ALTER TABLE `PRODUCT_REVIEW` DISABLE KEYS */;
/*!40000 ALTER TABLE `PRODUCT_REVIEW` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PRODUCT_REVIEW_DESCRIPTION`
--

DROP TABLE IF EXISTS `PRODUCT_REVIEW_DESCRIPTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PRODUCT_REVIEW_DESCRIPTION` (
  `DESCRIPTION_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `DESCRIPTION` longtext,
  `NAME` varchar(120) NOT NULL,
  `TITLE` varchar(100) DEFAULT NULL,
  `LANGUAGE_ID` int(11) NOT NULL,
  `PRODUCT_REVIEW_ID` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`DESCRIPTION_ID`),
  UNIQUE KEY `UK_qno5wjdtcj8pm3ykkkh7t4rxj` (`PRODUCT_REVIEW_ID`,`LANGUAGE_ID`),
  KEY `FK_n52r1gofhi1sfancu7ld7xp09` (`LANGUAGE_ID`),
  CONSTRAINT `FK_m7su4leperkhlinccx5ec3kja` FOREIGN KEY (`PRODUCT_REVIEW_ID`) REFERENCES `PRODUCT_REVIEW` (`PRODUCT_REVIEW_ID`),
  CONSTRAINT `FK_n52r1gofhi1sfancu7ld7xp09` FOREIGN KEY (`LANGUAGE_ID`) REFERENCES `LANGUAGE` (`LANGUAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PRODUCT_REVIEW_DESCRIPTION`
--

LOCK TABLES `PRODUCT_REVIEW_DESCRIPTION` WRITE;
/*!40000 ALTER TABLE `PRODUCT_REVIEW_DESCRIPTION` DISABLE KEYS */;
/*!40000 ALTER TABLE `PRODUCT_REVIEW_DESCRIPTION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PRODUCT_TYPE`
--

DROP TABLE IF EXISTS `PRODUCT_TYPE`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PRODUCT_TYPE` (
  `PRODUCT_TYPE_ID` bigint(20) NOT NULL,
  `PRD_TYPE_ADD_TO_CART` bit(1) DEFAULT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `PRD_TYPE_CODE` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`PRODUCT_TYPE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PRODUCT_TYPE`
--

LOCK TABLES `PRODUCT_TYPE` WRITE;
/*!40000 ALTER TABLE `PRODUCT_TYPE` DISABLE KEYS */;
INSERT INTO `PRODUCT_TYPE` VALUES (1,NULL,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'GENERAL');
/*!40000 ALTER TABLE `PRODUCT_TYPE` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHIPING_ORIGIN`
--

DROP TABLE IF EXISTS `SHIPING_ORIGIN`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHIPING_ORIGIN` (
  `SHIP_ORIGIN_ID` bigint(20) NOT NULL,
  `ACTIVE` bit(1) DEFAULT NULL,
  `STREET_ADDRESS` varchar(256) NOT NULL,
  `CITY` varchar(100) NOT NULL,
  `POSTCODE` varchar(20) NOT NULL,
  `STATE` varchar(100) DEFAULT NULL,
  `COUNTRY_ID` int(11) DEFAULT NULL,
  `MERCHANT_ID` int(11) NOT NULL,
  `ZONE_ID` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`SHIP_ORIGIN_ID`),
  KEY `FK_74fk2wqic6o7iayx04ojn63du` (`COUNTRY_ID`),
  KEY `FK_8lvfncpkdnd2ivn245u3792k3` (`MERCHANT_ID`),
  KEY `FK_qubd75iis2h2u0pmncwp2ergp` (`ZONE_ID`),
  CONSTRAINT `FK_74fk2wqic6o7iayx04ojn63du` FOREIGN KEY (`COUNTRY_ID`) REFERENCES `COUNTRY` (`COUNTRY_ID`),
  CONSTRAINT `FK_8lvfncpkdnd2ivn245u3792k3` FOREIGN KEY (`MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`),
  CONSTRAINT `FK_qubd75iis2h2u0pmncwp2ergp` FOREIGN KEY (`ZONE_ID`) REFERENCES `ZONE` (`ZONE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHIPING_ORIGIN`
--

LOCK TABLES `SHIPING_ORIGIN` WRITE;
/*!40000 ALTER TABLE `SHIPING_ORIGIN` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHIPING_ORIGIN` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHOPPING_CART`
--

DROP TABLE IF EXISTS `SHOPPING_CART`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHOPPING_CART` (
  `SHP_CART_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `CUSTOMER_ID` bigint(20) DEFAULT NULL,
  `SHP_CART_CODE` varchar(255) NOT NULL,
  `MERCHANT_ID` int(11) NOT NULL,
  PRIMARY KEY (`SHP_CART_ID`),
  UNIQUE KEY `UK_8ld8p40fwrjobi7t3n95pna35` (`SHP_CART_CODE`),
  KEY `SHP_CART_CODE_IDX` (`SHP_CART_CODE`),
  KEY `SHP_CART_CUSTOMER_IDX` (`CUSTOMER_ID`),
  KEY `FK_q71ctu5sjtuird3f07paim1f2` (`MERCHANT_ID`),
  CONSTRAINT `FK_q71ctu5sjtuird3f07paim1f2` FOREIGN KEY (`MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHOPPING_CART`
--

LOCK TABLES `SHOPPING_CART` WRITE;
/*!40000 ALTER TABLE `SHOPPING_CART` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHOPPING_CART` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHOPPING_CART_ATTR_ITEM`
--

DROP TABLE IF EXISTS `SHOPPING_CART_ATTR_ITEM`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHOPPING_CART_ATTR_ITEM` (
  `SHP_CART_ATTR_ITEM_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `PRODUCT_ATTR_ID` bigint(20) NOT NULL,
  `SHP_CART_ITEM_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`SHP_CART_ATTR_ITEM_ID`),
  KEY `FK_sc176ct7c75smml3pppgd6x7n` (`SHP_CART_ITEM_ID`),
  CONSTRAINT `FK_sc176ct7c75smml3pppgd6x7n` FOREIGN KEY (`SHP_CART_ITEM_ID`) REFERENCES `SHOPPING_CART_ITEM` (`SHP_CART_ITEM_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHOPPING_CART_ATTR_ITEM`
--

LOCK TABLES `SHOPPING_CART_ATTR_ITEM` WRITE;
/*!40000 ALTER TABLE `SHOPPING_CART_ATTR_ITEM` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHOPPING_CART_ATTR_ITEM` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHOPPING_CART_ITEM`
--

DROP TABLE IF EXISTS `SHOPPING_CART_ITEM`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHOPPING_CART_ITEM` (
  `SHP_CART_ITEM_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `PRODUCT_ID` bigint(20) NOT NULL,
  `QUANTITY` int(11) DEFAULT NULL,
  `SHP_CART_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`SHP_CART_ITEM_ID`),
  KEY `FK_8nwkbdvovjbaqovh1omtdqd4s` (`SHP_CART_ID`),
  CONSTRAINT `FK_8nwkbdvovjbaqovh1omtdqd4s` FOREIGN KEY (`SHP_CART_ID`) REFERENCES `SHOPPING_CART` (`SHP_CART_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHOPPING_CART_ITEM`
--

LOCK TABLES `SHOPPING_CART_ITEM` WRITE;
/*!40000 ALTER TABLE `SHOPPING_CART_ITEM` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHOPPING_CART_ITEM` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SM_GROUP`
--

DROP TABLE IF EXISTS `SM_GROUP`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SM_GROUP` (
  `GROUP_ID` int(11) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `GROUP_NAME` varchar(255) NOT NULL,
  `GROUP_TYPE` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`GROUP_ID`),
  UNIQUE KEY `UK_t83rjsoml3o785oj37lpqpyko` (`GROUP_NAME`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SM_GROUP`
--

LOCK TABLES `SM_GROUP` WRITE;
/*!40000 ALTER TABLE `SM_GROUP` DISABLE KEYS */;
INSERT INTO `SM_GROUP` VALUES (1,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'SUPERADMIN','ADMIN'),(2,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'ADMIN','ADMIN'),(3,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'ADMIN_CATALOGUE','ADMIN'),(4,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'ADMIN_STORE','ADMIN'),(5,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'ADMIN_ORDER','ADMIN'),(6,'2019-06-22 04:10:56','2019-06-22 04:10:56',NULL,'ADMIN_CONTENT','ADMIN'),(7,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,'CUSTOMER','ADMIN');
/*!40000 ALTER TABLE `SM_GROUP` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SM_SEQUENCER`
--

DROP TABLE IF EXISTS `SM_SEQUENCER`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SM_SEQUENCER` (
  `SEQ_NAME` varchar(255) DEFAULT NULL,
  `SEQ_COUNT` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SM_SEQUENCER`
--

LOCK TABLES `SM_SEQUENCER` WRITE;
/*!40000 ALTER TABLE `SM_SEQUENCER` DISABLE KEYS */;
INSERT INTO `SM_SEQUENCER` VALUES ('LANG_SEQ_NEXT_VAL',1),('COUNTRY_SEQ_NEXT_VAL',2),('DESCRIPTION_SEQ_NEXT_VAL',16),('ZONE_SEQ_NEXT_VAL',4),('CURRENCY_SEQ_NEXT_VAL',4),('PRD_TYPE_SEQ_NEXT_VAL',1),('MOD_CONF_SEQ_NEXT_VAL',1),('STORE_SEQ_NEXT_VAL',1),('TX_CLASS_SEQ_NEXT_VAL',1),('GROUP_SEQ_NEXT_VAL',1),('PERMISSION_SEQ_NEXT_VAL',1),('USER_SEQ_NEXT_VAL',1),('MERCH_CONF_SEQ_NEXT_VAL',1),('CATEGORY_SEQ_NEXT_VAL',1),('MANUFACT_SEQ_NEXT_VAL',1),('PRODUCT_SEQ_NEXT_VAL',1),('PRODUCT_AVAIL_SEQ_NEXT_VAL',1),('PRODUCT_PRICE_SEQ_NEXT_VAL',1),('PRODUCT_IMG_SEQ_NEXT_VAL',1),('PRODUCT_RELATION_SEQ_NEXT_VAL',1),('CUSTOMER_SEQ_NEXT_VAL',1),('ORDER_ID_SEQ_NEXT_VAL',1),('STATUS_HIST_ID_NEXT_VALUE',1),('ORDER_PRODUCT_ID_NEXT_VALUE',1),('ORDER_PRODUCT_DL_ID_NEXT_VALUE',1),('ORDER_PRD_PRICE_ID_NEXT_VAL',1),('ORDER_TOTAL_ID_NEXT_VALUE',1),('SYST_CONF_SEQ_NEXT_VAL',1);
/*!40000 ALTER TABLE `SM_SEQUENCER` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SM_TRANSACTION`
--

DROP TABLE IF EXISTS `SM_TRANSACTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SM_TRANSACTION` (
  `TRANSACTION_ID` bigint(20) NOT NULL,
  `AMOUNT` decimal(19,2) DEFAULT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `DETAILS` longtext,
  `PAYMENT_TYPE` varchar(255) DEFAULT NULL,
  `TRANSACTION_DATE` datetime DEFAULT NULL,
  `TRANSACTION_TYPE` varchar(255) DEFAULT NULL,
  `ORDER_ID` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`TRANSACTION_ID`),
  KEY `FK_ajwett661pbjo6u9tk74ochve` (`ORDER_ID`),
  CONSTRAINT `FK_ajwett661pbjo6u9tk74ochve` FOREIGN KEY (`ORDER_ID`) REFERENCES `ORDERS` (`ORDER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SM_TRANSACTION`
--

LOCK TABLES `SM_TRANSACTION` WRITE;
/*!40000 ALTER TABLE `SM_TRANSACTION` DISABLE KEYS */;
/*!40000 ALTER TABLE `SM_TRANSACTION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SYSTEM_CONFIGURATION`
--

DROP TABLE IF EXISTS `SYSTEM_CONFIGURATION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SYSTEM_CONFIGURATION` (
  `SYSTEM_CONFIG_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `CONFIG_KEY` varchar(255) DEFAULT NULL,
  `VALUE` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`SYSTEM_CONFIG_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SYSTEM_CONFIGURATION`
--

LOCK TABLES `SYSTEM_CONFIGURATION` WRITE;
/*!40000 ALTER TABLE `SYSTEM_CONFIGURATION` DISABLE KEYS */;
INSERT INTO `SYSTEM_CONFIGURATION` VALUES (1,'2019-06-22 04:11:09','2019-06-22 04:11:09','SYSTEM','TEST_DATA_LOADED','true');
/*!40000 ALTER TABLE `SYSTEM_CONFIGURATION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SYSTEM_NOTIFICATION`
--

DROP TABLE IF EXISTS `SYSTEM_NOTIFICATION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SYSTEM_NOTIFICATION` (
  `SYSTEM_NOTIF_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `END_DATE` date DEFAULT NULL,
  `CONFIG_KEY` varchar(255) DEFAULT NULL,
  `START_DATE` date DEFAULT NULL,
  `VALUE` varchar(255) DEFAULT NULL,
  `MERCHANT_ID` int(11) DEFAULT NULL,
  `USER_ID` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`SYSTEM_NOTIF_ID`),
  UNIQUE KEY `UK_npdnlc390vgr2mhepib1mtrmr` (`MERCHANT_ID`,`CONFIG_KEY`),
  KEY `FK_jw5seps7hq717mgsqjrequeou` (`USER_ID`),
  CONSTRAINT `FK_6pow79mefofmd6svpdb47p1tq` FOREIGN KEY (`MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`),
  CONSTRAINT `FK_jw5seps7hq717mgsqjrequeou` FOREIGN KEY (`USER_ID`) REFERENCES `USER` (`USER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SYSTEM_NOTIFICATION`
--

LOCK TABLES `SYSTEM_NOTIFICATION` WRITE;
/*!40000 ALTER TABLE `SYSTEM_NOTIFICATION` DISABLE KEYS */;
/*!40000 ALTER TABLE `SYSTEM_NOTIFICATION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `TAX_CLASS`
--

DROP TABLE IF EXISTS `TAX_CLASS`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `TAX_CLASS` (
  `TAX_CLASS_ID` bigint(20) NOT NULL,
  `TAX_CLASS_CODE` varchar(10) NOT NULL,
  `TAX_CLASS_TITLE` varchar(32) NOT NULL,
  `MERCHANT_ID` int(11) DEFAULT NULL,
  PRIMARY KEY (`TAX_CLASS_ID`),
  UNIQUE KEY `UK_a4q5q57a8oeh2ojeo8dhr935k` (`MERCHANT_ID`,`TAX_CLASS_CODE`),
  CONSTRAINT `FK_hs8kji9qd3y9sc8yb38k8fefb` FOREIGN KEY (`MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `TAX_CLASS`
--

LOCK TABLES `TAX_CLASS` WRITE;
/*!40000 ALTER TABLE `TAX_CLASS` DISABLE KEYS */;
INSERT INTO `TAX_CLASS` VALUES (1,'DEFAULT','DEFAULT',1);
/*!40000 ALTER TABLE `TAX_CLASS` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `TAX_RATE`
--

DROP TABLE IF EXISTS `TAX_RATE`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `TAX_RATE` (
  `TAX_RATE_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `TAX_CODE` varchar(255) NOT NULL,
  `PIGGYBACK` bit(1) DEFAULT NULL,
  `STORE_STATE_PROV` varchar(100) DEFAULT NULL,
  `TAX_PRIORITY` int(11) DEFAULT NULL,
  `TAX_RATE` decimal(7,4) NOT NULL,
  `COUNTRY_ID` int(11) NOT NULL,
  `MERCHANT_ID` int(11) NOT NULL,
  `PARENT_ID` bigint(20) DEFAULT NULL,
  `TAX_CLASS_ID` bigint(20) NOT NULL,
  `ZONE_ID` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`TAX_RATE_ID`),
  UNIQUE KEY `UK_8gh6l9n0xq03b91sglp62oelu` (`TAX_CODE`,`MERCHANT_ID`),
  KEY `FK_4dk6cmp3gpa7y7wuwbesvpetb` (`COUNTRY_ID`),
  KEY `FK_35a95oa56qeqjqltvfh5wo2h7` (`MERCHANT_ID`),
  KEY `FK_5g3sbaqbfh5fny7ehf58pk869` (`PARENT_ID`),
  KEY `FK_q45avgtx0scd4e5m2m3k6i3rv` (`TAX_CLASS_ID`),
  KEY `FK_d505g6bra836ja1kamcnhkiju` (`ZONE_ID`),
  CONSTRAINT `FK_35a95oa56qeqjqltvfh5wo2h7` FOREIGN KEY (`MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`),
  CONSTRAINT `FK_4dk6cmp3gpa7y7wuwbesvpetb` FOREIGN KEY (`COUNTRY_ID`) REFERENCES `COUNTRY` (`COUNTRY_ID`),
  CONSTRAINT `FK_5g3sbaqbfh5fny7ehf58pk869` FOREIGN KEY (`PARENT_ID`) REFERENCES `TAX_RATE` (`TAX_RATE_ID`),
  CONSTRAINT `FK_d505g6bra836ja1kamcnhkiju` FOREIGN KEY (`ZONE_ID`) REFERENCES `ZONE` (`ZONE_ID`),
  CONSTRAINT `FK_q45avgtx0scd4e5m2m3k6i3rv` FOREIGN KEY (`TAX_CLASS_ID`) REFERENCES `TAX_CLASS` (`TAX_CLASS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `TAX_RATE`
--

LOCK TABLES `TAX_RATE` WRITE;
/*!40000 ALTER TABLE `TAX_RATE` DISABLE KEYS */;
/*!40000 ALTER TABLE `TAX_RATE` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `TAX_RATE_DESCRIPTION`
--

DROP TABLE IF EXISTS `TAX_RATE_DESCRIPTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `TAX_RATE_DESCRIPTION` (
  `DESCRIPTION_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `DESCRIPTION` longtext,
  `NAME` varchar(120) NOT NULL,
  `TITLE` varchar(100) DEFAULT NULL,
  `LANGUAGE_ID` int(11) NOT NULL,
  `TAX_RATE_ID` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`DESCRIPTION_ID`),
  UNIQUE KEY `UK_t3xg8pl88yacdxg49nb46effg` (`TAX_RATE_ID`,`LANGUAGE_ID`),
  KEY `FK_5g26jyni5x8li9apet7eo5atg` (`LANGUAGE_ID`),
  CONSTRAINT `FK_5g26jyni5x8li9apet7eo5atg` FOREIGN KEY (`LANGUAGE_ID`) REFERENCES `LANGUAGE` (`LANGUAGE_ID`),
  CONSTRAINT `FK_ld9jwc8vxb7ftku6yxx2mkjbf` FOREIGN KEY (`TAX_RATE_ID`) REFERENCES `TAX_RATE` (`TAX_RATE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `TAX_RATE_DESCRIPTION`
--

LOCK TABLES `TAX_RATE_DESCRIPTION` WRITE;
/*!40000 ALTER TABLE `TAX_RATE_DESCRIPTION` DISABLE KEYS */;
/*!40000 ALTER TABLE `TAX_RATE_DESCRIPTION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `USER`
--

DROP TABLE IF EXISTS `USER`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `USER` (
  `USER_ID` bigint(20) NOT NULL,
  `ACTIVE` bit(1) DEFAULT NULL,
  `ADMIN_EMAIL` varchar(255) NOT NULL,
  `ADMIN_NAME` varchar(100) NOT NULL,
  `ADMIN_PASSWORD` varchar(60) NOT NULL,
  `ADMIN_A1` varchar(255) DEFAULT NULL,
  `ADMIN_A2` varchar(255) DEFAULT NULL,
  `ADMIN_A3` varchar(255) DEFAULT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `ADMIN_FIRST_NAME` varchar(255) DEFAULT NULL,
  `LAST_ACCESS` datetime DEFAULT NULL,
  `ADMIN_LAST_NAME` varchar(255) DEFAULT NULL,
  `LOGIN_ACCESS` datetime DEFAULT NULL,
  `ADMIN_Q1` varchar(255) DEFAULT NULL,
  `ADMIN_Q2` varchar(255) DEFAULT NULL,
  `ADMIN_Q3` varchar(255) DEFAULT NULL,
  `LANGUAGE_ID` int(11) DEFAULT NULL,
  `MERCHANT_ID` int(11) NOT NULL,
  PRIMARY KEY (`USER_ID`),
  UNIQUE KEY `UK_7rbcj0gstolij2mp5g3xc7xfu` (`ADMIN_NAME`),
  KEY `FK_k7sh5ke7r2tlfe6nllvpa7ynu` (`LANGUAGE_ID`),
  KEY `FK_650chnyaktynqq6ykvjp39h0v` (`MERCHANT_ID`),
  CONSTRAINT `FK_650chnyaktynqq6ykvjp39h0v` FOREIGN KEY (`MERCHANT_ID`) REFERENCES `MERCHANT_STORE` (`MERCHANT_ID`),
  CONSTRAINT `FK_k7sh5ke7r2tlfe6nllvpa7ynu` FOREIGN KEY (`LANGUAGE_ID`) REFERENCES `LANGUAGE` (`LANGUAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `USER`
--

LOCK TABLES `USER` WRITE;
/*!40000 ALTER TABLE `USER` DISABLE KEYS */;
INSERT INTO `USER` VALUES (1,'','admin@shopizer.com','admin','$2a$11$Ne0/ZF6e7/qsXFAvH/bWz.3DElJMpKyZKyyMT7zmzdYYR58ec/dC.',NULL,NULL,NULL,'2019-06-22 04:10:57','2019-06-22 04:10:57',NULL,'Administrator',NULL,'User',NULL,NULL,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `USER` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `USER_GROUP`
--

DROP TABLE IF EXISTS `USER_GROUP`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `USER_GROUP` (
  `USER_ID` bigint(20) NOT NULL,
  `GROUP_ID` int(11) NOT NULL,
  KEY `FK_4ex9p3ihrxoysn8k46kh965sf` (`GROUP_ID`),
  KEY `FK_3at466hpmis1abruuh3x6nftg` (`USER_ID`),
  CONSTRAINT `FK_3at466hpmis1abruuh3x6nftg` FOREIGN KEY (`USER_ID`) REFERENCES `USER` (`USER_ID`),
  CONSTRAINT `FK_4ex9p3ihrxoysn8k46kh965sf` FOREIGN KEY (`GROUP_ID`) REFERENCES `SM_GROUP` (`GROUP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `USER_GROUP`
--

LOCK TABLES `USER_GROUP` WRITE;
/*!40000 ALTER TABLE `USER_GROUP` DISABLE KEYS */;
INSERT INTO `USER_GROUP` VALUES (1,1),(1,2);
/*!40000 ALTER TABLE `USER_GROUP` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ZONE`
--

DROP TABLE IF EXISTS `ZONE`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ZONE` (
  `ZONE_ID` bigint(20) NOT NULL,
  `ZONE_CODE` varchar(255) NOT NULL,
  `COUNTRY_ID` int(11) NOT NULL,
  PRIMARY KEY (`ZONE_ID`),
  UNIQUE KEY `UK_4tq3p5w8k4h4easyf5t3n1jdr` (`ZONE_CODE`),
  KEY `FK_7u7308kmafqhsvht9xwaba9h8` (`COUNTRY_ID`),
  CONSTRAINT `FK_7u7308kmafqhsvht9xwaba9h8` FOREIGN KEY (`COUNTRY_ID`) REFERENCES `COUNTRY` (`COUNTRY_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ZONE`
--

LOCK TABLES `ZONE` WRITE;
/*!40000 ALTER TABLE `ZONE` DISABLE KEYS */;
INSERT INTO `ZONE` VALUES (1,'Guipuzcoa',79),(2,'HI',91),(3,'PR',91),(4,'Zamora',79),(5,'Vizcaya',79),(6,'Albacete',79),(7,'Lleida',79),(8,'QC',13),(9,'NRW',30),(10,'IA',91),(11,'ID',91),(12,'YT',13),(13,'Leon',79),(14,'ACorua',79),(15,'Castellon',79),(16,'LasPalmas',79),(17,'Pontevedra',79),(18,'AA',91),(19,'Teruel',79),(20,'AB',13),(21,'AC',91),(22,'IL',91),(23,'AE',91),(24,'AF',91),(25,'IN',91),(26,'AG',82),(27,'A Corua',79),(28,'AI',82),(29,'AK',91),(30,'Caceres',79),(31,'Segovia',79),(32,'AL',91),(33,'AM',91),(34,'ZG',82),(35,'Malaga',79),(36,'ZH',82),(37,'LaRioja',79),(38,'AP',91),(39,'Melilla',79),(40,'AR',91),(41,'AS',91),(42,'NSW',4),(43,'Madrid',79),(44,'RI',91),(45,'AZ',91),(46,'Ceuta',79),(47,'BC',13),(48,'Huelva',79),(49,'BE',82),(50,'Huesca',79),(51,'ARCH',82),(52,'BL',82),(53,'JU',82),(54,'Asturias',79),(55,'SA',4),(56,'SB',5),(57,'TIAT',5),(58,'SC',91),(59,'THE',30),(60,'SD',91),(61,'BS',82),(62,'Cordoba',79),(63,'Tarragona',79),(64,'Valladolid',79),(65,'SG',82),(66,'SH',82),(67,'WAAU',4),(68,'SK',13),(69,'NDS',30),(70,'SO',82),(71,'CA',91),(72,'NTAU',4),(73,'ST',5),(74,'KN',5),(75,'Jaen',79),(76,'CiudadReal',79),(77,'SZ',82),(78,'Alava',79),(79,'KS',91),(80,'CO',91),(81,'KY',91),(82,'BER',30),(83,'CT',91),(84,'ACT',4),(85,'TG',82),(86,'LA',91),(87,'HAM',30),(88,'TI',82),(89,'Lugo',79),(90,'NECH',82),(91,'TN',91),(92,'Toledo',79),(93,'DC',91),(94,'Palencia',79),(95,'DE',91),(96,'TX',91),(97,'TAS',4),(98,'QLD',4),(99,'LU',82),(100,'Burgos',79),(101,'Cadiz',79),(102,'SantaCruzdeTenerife',79),(103,'MA',91),(104,'MB',13),(105,'MD',91),(106,'Girona',79),(107,'ME',91),(108,'Alicante',79),(109,'Guadalajara',79),(110,'Cantabria',79),(111,'MH',91),(112,'MI',91),(113,'UR',82),(114,'UT',91),(115,'MN',91),(116,'MO',91),(117,'MP',91),(118,'Barcelona',79),(119,'MS',91),(120,'MT',91),(121,'Badajoz',79),(122,'MEC',30),(123,'VA',91),(124,'VB',5),(125,'Cuenca',79),(126,'WIAT',5),(127,'VD',82),(128,'Sevilla',79),(129,'VI',91),(130,'Zaragoza',79),(131,'NB',13),(132,'SAC',30),(133,'NC',91),(134,'ND',91),(135,'NE',91),(136,'NF',13),(137,'NH',91),(138,'NJ',91),(139,'VS',82),(140,'VT',91),(141,'NM',91),(142,'NO',5),(143,'SAS',30),(144,'NS',13),(145,'SAR',30),(146,'FL',91),(147,'NT',13),(148,'FM',91),(149,'NU',13),(150,'NV',91),(151,'NW',82),(152,'WA',91),(153,'NY',91),(154,'Granada',79),(155,'Soria',79),(156,'FR',82),(157,'RHE',30),(158,'Ourense',79),(159,'WI',91),(160,'OH',91),(161,'GA',91),(162,'Murcia',79),(163,'OK',91),(164,'GE',82),(165,'WV',91),(166,'ON',13),(167,'OO',5),(168,'WY',91),(169,'BLAT',5),(170,'Avila',79),(171,'OR',91),(172,'Salamanca',79),(173,'GL',82),(174,'Baleares',79),(175,'OW',82),(176,'GR',82),(177,'GU',91),(178,'PA',91),(179,'VIC',4),(180,'BRE',30),(181,'PE',13),(182,'BRG',30),(183,'HES',30),(184,'Almeria',79),(185,'BAW',30),(186,'BAY',30),(187,'Navarra',79),(188,'Valencia',79),(189,'SCN',30);
/*!40000 ALTER TABLE `ZONE` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ZONE_DESCRIPTION`
--

DROP TABLE IF EXISTS `ZONE_DESCRIPTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ZONE_DESCRIPTION` (
  `DESCRIPTION_ID` bigint(20) NOT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_MODIFIED` datetime DEFAULT NULL,
  `UPDT_ID` varchar(20) DEFAULT NULL,
  `DESCRIPTION` longtext,
  `NAME` varchar(120) NOT NULL,
  `TITLE` varchar(100) DEFAULT NULL,
  `LANGUAGE_ID` int(11) NOT NULL,
  `ZONE_ID` bigint(20) NOT NULL,
  PRIMARY KEY (`DESCRIPTION_ID`),
  UNIQUE KEY `UK_m64laxgrv9fxm6io232ap4su9` (`ZONE_ID`,`LANGUAGE_ID`),
  KEY `FK_c0kdjwp4gdxe36vlu83qfvme5` (`LANGUAGE_ID`),
  CONSTRAINT `FK_11l2ifk07g04697nmb9arifnb` FOREIGN KEY (`ZONE_ID`) REFERENCES `ZONE` (`ZONE_ID`),
  CONSTRAINT `FK_c0kdjwp4gdxe36vlu83qfvme5` FOREIGN KEY (`LANGUAGE_ID`) REFERENCES `LANGUAGE` (`LANGUAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ZONE_DESCRIPTION`
--

LOCK TABLES `ZONE_DESCRIPTION` WRITE;
/*!40000 ALTER TABLE `ZONE_DESCRIPTION` DISABLE KEYS */;
INSERT INTO `ZONE_DESCRIPTION` VALUES (200,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Guipuzcoa',NULL,1,1),(201,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Guipuzcoa',NULL,2,1),(202,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Hawaii',NULL,1,2),(203,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Hawaii',NULL,2,2),(204,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Puerto Rico',NULL,1,3),(205,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Puerto Rico',NULL,2,3),(206,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Zamora',NULL,1,4),(207,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Zamora',NULL,2,4),(208,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Vizcaya',NULL,1,5),(209,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Vizcaya',NULL,2,5),(210,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Albacete',NULL,1,6),(211,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Albacete',NULL,2,6),(212,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Lleida',NULL,1,7),(213,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Lleida',NULL,2,7),(214,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Quebec',NULL,1,8),(215,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Québec',NULL,2,8),(216,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Nordrhein-Westfalen',NULL,1,9),(217,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Nordrhein-Westfalen',NULL,2,9),(218,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Iowa',NULL,1,10),(219,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Iowa',NULL,2,10),(220,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Idaho',NULL,1,11),(221,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Idaho',NULL,2,11),(222,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Yukon Territory',NULL,1,12),(223,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Yukon',NULL,2,12),(224,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Leon',NULL,1,13),(225,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Leon',NULL,2,13),(226,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'A Corua',NULL,1,14),(227,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Castellon',NULL,1,15),(228,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Castellon',NULL,2,15),(229,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Las Palmas',NULL,1,16),(230,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Las Palmas',NULL,2,16),(231,'2019-06-22 04:10:52','2019-06-22 04:10:52',NULL,NULL,'Pontevedra',NULL,1,17),(232,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Pontevedra',NULL,2,17),(233,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Armed Forces Americas',NULL,1,18),(234,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Armed Forces Americas',NULL,2,18),(235,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Teruel',NULL,1,19),(236,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Teruel',NULL,2,19),(237,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Alberta',NULL,1,20),(238,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Alberta',NULL,2,20),(239,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Armed Forces Canada',NULL,1,21),(240,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Armed Forces Canada',NULL,2,21),(241,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Illinois',NULL,1,22),(242,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Illinois',NULL,2,22),(243,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Armed Forces Europe',NULL,1,23),(244,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Armed Forces Europe',NULL,2,23),(245,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Armed Forces Africa',NULL,1,24),(246,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Armed Forces Africa',NULL,2,24),(247,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Indiana',NULL,1,25),(248,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Indiana',NULL,2,25),(249,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Aargau',NULL,1,26),(250,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Aargau',NULL,2,26),(251,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'A Corua',NULL,2,27),(252,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Appenzell Innerrhoden',NULL,1,28),(253,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Appenzell Innerrhoden',NULL,2,28),(254,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Alaska',NULL,1,29),(255,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Alaska',NULL,2,29),(256,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Caceres',NULL,1,30),(257,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Caceres',NULL,2,30),(258,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Segovia',NULL,1,31),(259,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Segovia',NULL,2,31),(260,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Alabama',NULL,1,32),(261,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Alabama',NULL,2,32),(262,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Armed Forces Middle East',NULL,1,33),(263,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Armed Forces Middle East',NULL,2,33),(264,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Zug',NULL,1,34),(265,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Zug',NULL,2,34),(266,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Malaga',NULL,1,35),(267,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Malaga',NULL,2,35),(268,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Zrich',NULL,1,36),(269,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Zrich',NULL,2,36),(270,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'La Rioja',NULL,1,37),(271,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'La Rioja',NULL,2,37),(272,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Armed Forces Pacific',NULL,1,38),(273,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Armed Forces Pacific',NULL,2,38),(274,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Melilla',NULL,1,39),(275,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Melilla',NULL,2,39),(276,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Arkansas',NULL,1,40),(277,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Arkansas',NULL,2,40),(278,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'American Samoa',NULL,1,41),(279,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'American Samoa',NULL,2,41),(280,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'New South Wales',NULL,1,42),(281,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Nouvelle-Galles du Sud',NULL,2,42),(282,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Madrid',NULL,1,43),(283,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Madrid',NULL,2,43),(284,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Rhode Island',NULL,1,44),(285,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Rhode Island',NULL,2,44),(286,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Arizona',NULL,1,45),(287,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Arizona',NULL,2,45),(288,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Ceuta',NULL,1,46),(289,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Ceuta',NULL,2,46),(290,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'British Columbia',NULL,1,47),(291,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Columbie Britanique',NULL,2,47),(292,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Huelva',NULL,1,48),(293,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Huelva',NULL,2,48),(294,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Bern',NULL,1,49),(295,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Bern',NULL,2,49),(296,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Huesca',NULL,1,50),(297,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Huesca',NULL,2,50),(298,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Appenzell Ausserrhoden',NULL,1,51),(299,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Appenzell Ausserrhoden',NULL,2,51),(300,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Basel-Landschaft',NULL,1,52),(301,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Basel-Landschaft',NULL,2,52),(302,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Jura',NULL,1,53),(303,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Jura',NULL,2,53),(304,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Asturias',NULL,1,54),(305,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Asturias',NULL,2,54),(306,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'South Australia',NULL,1,55),(307,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Australie-Mridionale',NULL,2,55),(308,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Salzburg',NULL,1,56),(309,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Salzburg',NULL,2,56),(310,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Tirol',NULL,1,57),(311,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Tirol',NULL,2,57),(312,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'South Carolina',NULL,1,58),(313,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Caroline du Sud',NULL,2,58),(314,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Thringen',NULL,1,59),(315,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Thringen',NULL,2,59),(316,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'South Dakota',NULL,1,60),(317,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Dakota du Sud',NULL,2,60),(318,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Basel-Stadt',NULL,1,61),(319,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Basel-Stadt',NULL,2,61),(320,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Cordoba',NULL,1,62),(321,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Cordoba',NULL,2,62),(322,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Tarragona',NULL,1,63),(323,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Tarragona',NULL,2,63),(324,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Valladolid',NULL,1,64),(325,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Valladolid',NULL,2,64),(326,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'St. Gallen',NULL,1,65),(327,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'St. Gallen',NULL,2,65),(328,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Schaffhausen',NULL,1,66),(329,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Schaffhausen',NULL,2,66),(330,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Western Australia',NULL,1,67),(331,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Australie-Occidentale',NULL,2,67),(332,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Saskatchewan',NULL,1,68),(333,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Saskatchewan',NULL,2,68),(334,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Niedersachsen',NULL,1,69),(335,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Niedersachsen',NULL,2,69),(336,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Solothurn',NULL,1,70),(337,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Solothurn',NULL,2,70),(338,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'California',NULL,1,71),(339,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Californie',NULL,2,71),(340,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Northern Territory',NULL,1,72),(341,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Territoire du Nord',NULL,2,72),(342,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Steiermark',NULL,1,73),(343,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Steiermark',NULL,2,73),(344,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Katen',NULL,1,74),(345,'2019-06-22 04:10:53','2019-06-22 04:10:53',NULL,NULL,'Karten',NULL,2,74),(346,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Jaen',NULL,1,75),(347,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Jaen',NULL,2,75),(348,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Ciudad Real',NULL,1,76),(349,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Ciudad Real',NULL,2,76),(350,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Schwyz',NULL,1,77),(351,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Schwyz',NULL,2,77),(352,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Alava',NULL,1,78),(353,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Alava',NULL,2,78),(354,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Kansas',NULL,1,79),(355,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Kansas',NULL,2,79),(356,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Colorado',NULL,1,80),(357,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Colorado',NULL,2,80),(358,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Kentucky',NULL,1,81),(359,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Kentucky',NULL,2,81),(360,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Berlin',NULL,1,82),(361,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Berlin',NULL,2,82),(362,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Connecticut',NULL,1,83),(363,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Connecticut',NULL,2,83),(364,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Australian Capital Territory',NULL,1,84),(365,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Territoire de la capitale australienne',NULL,2,84),(366,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Thurgau',NULL,1,85),(367,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Thurgau',NULL,2,85),(368,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Louisiana',NULL,1,86),(369,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Louisiane',NULL,2,86),(370,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Hamburg',NULL,1,87),(371,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Hamburg',NULL,2,87),(372,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Tessin',NULL,1,88),(373,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Tessin',NULL,2,88),(374,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Lugo',NULL,1,89),(375,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Lugo',NULL,2,89),(376,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Neuenburg',NULL,1,90),(377,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Neuenburg',NULL,2,90),(378,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Tennessee',NULL,1,91),(379,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Tennessee',NULL,2,91),(380,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Toledo',NULL,1,92),(381,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Toledo',NULL,2,92),(382,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'District of Columbia',NULL,1,93),(383,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'District de Columbia',NULL,2,93),(384,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Palencia',NULL,1,94),(385,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Palencia',NULL,2,94),(386,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Delaware',NULL,1,95),(387,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Delaware',NULL,2,95),(388,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Texas',NULL,1,96),(389,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Texas',NULL,2,96),(390,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Tasmania',NULL,1,97),(391,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Tasmanie',NULL,2,97),(392,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Queensland',NULL,1,98),(393,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Queensland',NULL,2,98),(394,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Luzern',NULL,1,99),(395,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Luzern',NULL,2,99),(396,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Burgos',NULL,1,100),(397,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Burgos',NULL,2,100),(398,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Cadiz',NULL,1,101),(399,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Cadiz',NULL,2,101),(400,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Santa Cruz de Tenerife',NULL,1,102),(401,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Santa Cruz de Tenerife',NULL,2,102),(402,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Massachusetts',NULL,1,103),(403,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Massachusetts',NULL,2,103),(404,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Manitoba',NULL,1,104),(405,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Manitoba',NULL,2,104),(406,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Maryland',NULL,1,105),(407,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Maryland',NULL,2,105),(408,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Girona',NULL,1,106),(409,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Girona',NULL,2,106),(410,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Maine',NULL,1,107),(411,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Maine',NULL,2,107),(412,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Alicante',NULL,1,108),(413,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Alicante',NULL,2,108),(414,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Guadalajara',NULL,1,109),(415,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Guadalajara',NULL,2,109),(416,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Cantabria',NULL,1,110),(417,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Cantabria',NULL,2,110),(418,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Marshall Islands',NULL,1,111),(419,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Marshall Islands',NULL,2,111),(420,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Michigan',NULL,1,112),(421,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Michigan',NULL,2,112),(422,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Uri',NULL,1,113),(423,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Uri',NULL,2,113),(424,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Utah',NULL,1,114),(425,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Utah',NULL,2,114),(426,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Minnesota',NULL,1,115),(427,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Minnesota',NULL,2,115),(428,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Missouri',NULL,1,116),(429,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Missouri',NULL,2,116),(430,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Northern Mariana Islands',NULL,1,117),(431,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Northern Mariana Islands',NULL,2,117),(432,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Barcelona',NULL,1,118),(433,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Barcelona',NULL,2,118),(434,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Mississippi',NULL,1,119),(435,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Mississippi',NULL,2,119),(436,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Montana',NULL,1,120),(437,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Montana',NULL,2,120),(438,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Badajoz',NULL,1,121),(439,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Badajoz',NULL,2,121),(440,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Mecklenburg-Vorpommern',NULL,1,122),(441,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Mecklenburg-Vorpommern',NULL,2,122),(442,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Virginia',NULL,1,123),(443,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Virginie',NULL,2,123),(444,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Voralberg',NULL,1,124),(445,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Voralberg',NULL,2,124),(446,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Cuenca',NULL,1,125),(447,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Cuenca',NULL,2,125),(448,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Wien',NULL,1,126),(449,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Wien',NULL,2,126),(450,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Waadt',NULL,1,127),(451,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Waadt',NULL,2,127),(452,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Sevilla',NULL,1,128),(453,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Sevilla',NULL,2,128),(454,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Virgin Islands',NULL,1,129),(455,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Virgin Islands',NULL,2,129),(456,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Zaragoza',NULL,1,130),(457,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Zaragoza',NULL,2,130),(458,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'New Brunswick',NULL,1,131),(459,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Nouveau Brunswick',NULL,2,131),(460,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Sachsen-Anhalt',NULL,1,132),(461,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Sachsen-Anhalt',NULL,2,132),(462,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'North Carolina',NULL,1,133),(463,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Caroline du Nord',NULL,2,133),(464,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'North Dakota',NULL,1,134),(465,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Dakota du Nord',NULL,2,134),(466,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Nebraska',NULL,1,135),(467,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Nebraska',NULL,2,135),(468,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Newfoundland - Labrador',NULL,1,136),(469,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Terre-Neuve - Labrador',NULL,2,136),(470,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'New Hampshire',NULL,1,137),(471,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Nouveau Hampshire',NULL,2,137),(472,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'New Jersey',NULL,1,138),(473,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'New Jersey',NULL,2,138),(474,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Wallis',NULL,1,139),(475,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Wallis',NULL,2,139),(476,'2019-06-22 04:10:54','2019-06-22 04:10:54',NULL,NULL,'Vermont',NULL,1,140),(477,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Vermont',NULL,2,140),(478,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'New Mexico',NULL,1,141),(479,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Nouveau Mexique',NULL,2,141),(480,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Niederosterreich',NULL,1,142),(481,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Niederosterreich',NULL,2,142),(482,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Sachsen',NULL,1,143),(483,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Sachsen',NULL,2,143),(484,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Nova Scotia',NULL,1,144),(485,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Nouvelle Écosse',NULL,2,144),(486,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Saarland',NULL,1,145),(487,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Saarland',NULL,2,145),(488,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Florida',NULL,1,146),(489,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Floride',NULL,2,146),(490,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Northwest Territories',NULL,1,147),(491,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Territores du Nord-Ouest',NULL,2,147),(492,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Federated States Of Micronesia',NULL,1,148),(493,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Federated States Of Micronesia',NULL,2,148),(494,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Nunavut',NULL,1,149),(495,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Nunavut',NULL,2,149),(496,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Nevada',NULL,1,150),(497,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Nevada',NULL,2,150),(498,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Nidwalden',NULL,1,151),(499,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Nidwalden',NULL,2,151),(500,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Washington',NULL,1,152),(501,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Washington',NULL,2,152),(502,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'New York',NULL,1,153),(503,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'New York',NULL,2,153),(504,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Granada',NULL,1,154),(505,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Granada',NULL,2,154),(506,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Soria',NULL,1,155),(507,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Soria',NULL,2,155),(508,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Freiburg',NULL,1,156),(509,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Freiburg',NULL,2,156),(510,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Rheinland-Pfalz',NULL,1,157),(511,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Rheinland-Pfalz',NULL,2,157),(512,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Ourense',NULL,1,158),(513,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Ourense',NULL,2,158),(514,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Wisconsin',NULL,1,159),(515,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Wisconsin',NULL,2,159),(516,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Ohio',NULL,1,160),(517,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Ohio',NULL,2,160),(518,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Georgia',NULL,1,161),(519,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Georgie',NULL,2,161),(520,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Murcia',NULL,1,162),(521,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Murcia',NULL,2,162),(522,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Oklahoma',NULL,1,163),(523,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Oklahoma',NULL,2,163),(524,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Genf',NULL,1,164),(525,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Genf',NULL,2,164),(526,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'West Virginia',NULL,1,165),(527,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'West Virginia',NULL,2,165),(528,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Ontario',NULL,1,166),(529,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Ontario',NULL,2,166),(530,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Oberosterreich',NULL,1,167),(531,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Oberosterreich',NULL,2,167),(532,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Wyoming',NULL,1,168),(533,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Wyoming',NULL,2,168),(534,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Burgenland',NULL,1,169),(535,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Burgenland',NULL,2,169),(536,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Avila',NULL,1,170),(537,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Avila',NULL,2,170),(538,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Oregon',NULL,1,171),(539,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Oregon',NULL,2,171),(540,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Salamanca',NULL,1,172),(541,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Salamanca',NULL,2,172),(542,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Glarus',NULL,1,173),(543,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Glarus',NULL,2,173),(544,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Baleares',NULL,1,174),(545,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Baleares',NULL,2,174),(546,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Obwalden',NULL,1,175),(547,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Obwalden',NULL,2,175),(548,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Graubnden',NULL,1,176),(549,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Graubnden',NULL,2,176),(550,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Guam',NULL,1,177),(551,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Guam',NULL,2,177),(552,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Pennsylvania',NULL,1,178),(553,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Pennsylvanie',NULL,2,178),(554,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Victoria',NULL,1,179),(555,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Victoria',NULL,2,179),(556,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Bremen',NULL,1,180),(557,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Bremen',NULL,2,180),(558,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Prince Edward Island',NULL,1,181),(559,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Île-du-Prince-Édouard',NULL,2,181),(560,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Brandenburg',NULL,1,182),(561,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Brandenburg',NULL,2,182),(562,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Hessen',NULL,1,183),(563,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Hessen',NULL,2,183),(564,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Almeria',NULL,1,184),(565,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Almeria',NULL,2,184),(566,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Baden-Wrttemberg',NULL,1,185),(567,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Baden-Wrttemberg',NULL,2,185),(568,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Bayern',NULL,1,186),(569,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Bayern',NULL,2,186),(570,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Navarra',NULL,1,187),(571,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Navarra',NULL,2,187),(572,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Valencia',NULL,1,188),(573,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Valencia',NULL,2,188),(574,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Schleswig-Holstein',NULL,1,189),(575,'2019-06-22 04:10:55','2019-06-22 04:10:55',NULL,NULL,'Schleswig-Holstein',NULL,2,189);
/*!40000 ALTER TABLE `ZONE_DESCRIPTION` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2019-06-24  5:15:09
