#!/bin/bash

if [ "$(whoami)" != 'root' ]; then
    echo "You have no permission to run $0 as non-root user."
    exit 1;
fi

export JAVA_OPTS="-Xms4096m -Xmx6124m"

host="localhost"
versions=$(echo applications/cached/*/)
applications="*"
if [[ ! -z $1 ]]; then
	host=$1
	if [[ ! -z $2 ]]; then
		versions=$2
		if [[ ! -z $3 ]]; then
			applications=$3
		fi
	fi
fi

echo "Reducing in host $host for the applications $applications among the versions $versions"
for workload in {1..10}; do
	for user in 1 5 10 25 50; do
		for version in $versions; do
			version=${version%/}
			if [[ $applications = "*" ]]; then
				existing_applications=$(echo applications/cached/$version/*/)
			else
				existing_applications=$applications
			fi
			echo "Reducing applications $existing_applications with $user users and workload $workload"
			for application in $existing_applications; do
				application=${application%/}
				echo "Reducing $application with $user users and workload $workload"
				java -jar adapters/RequestsSimulator/target/RequestsSimulator-1.0.jar --throughput=applications/output/$application-$version-${user}user-${workload}workload-requests --reduce=applications/output/requests-handled.csv --prefix=$application,$version,$user,$workload,
				if [[ $host = "localhost" ]]; then
					java -jar adapters/Cache/target/Cache-1.0.jar applications/output/$application-$version-${user}user-${workload}workload-cache applications/output/hits-additions-distribution.csv $application,$version,$user,$workload,
				else
					echo "java -jar adapters/Cache/target/Cache-1.0.jar applications/output/$application-$version-${user}user-${workload}workload-cache applications/output/hits-additions-distribution.csv $application,$version,$user,$workload," | netcat -w0 $host 5000
				fi
			done
		done
	done
done