#!/bin/bash

if [ "$(whoami)" != 'root' ]; then
    echo "You have no permission to run $0 as non-root user."
    exit 1;
fi

JAVA_OPTS=${JAVA_OPTS:-"-Xms4096m -Xmx6124m"}

host="localhost"
versions="uncached developers aplcache memoizeit"
applications="*"
if [[ ! -z $1 ]]; then
	host=$1
	if [[ ! -z $2 ]]; then
		versions=$2
		if [[ ! -z $3 ]]; then
			applications=$3
		fi
	fi
fi

echo "$(date '+%F %T') Reducing in host $host for the applications $applications among the versions $versions"
for version in $versions; do
	version=${version%/}
	if [[ $applications = "*" ]]; then
		existing_applications=$(echo applications/$version/*/)
	else
		existing_applications=$applications
	fi
	for application in $existing_applications; do
		application=${application%/}
		for user in 1 5 25; do
			for execution in {1..10}; do
				echo "$(date '+%F %T')  Reducing $application-$version with $user users and execution $execution"
				java $JAVA_OPTS -jar adapters/RequestsSimulator/target/RequestsSimulator-1.0.jar --throughput=applications/output/$application-$version-${user}user-${execution}execution-requests --reduce=applications/output/requests-handled.csv --prefix=$application,$version,$user,$execution,
				if [[ $host = "localhost" ]]; then
					java $JAVA_OPTS -jar adapters/Cache/target/Cache-1.0.jar applications/output/$application-$version-${user}user-${execution}execution-cache applications/output/hits-distribution.csv $application,$version,$user,$execution,
				else
					command="java $JAVA_OPTS -jar adapters/Cache/target/Cache-1.0.jar applications/output/$application-$version-${user}user-${execution}execution-cache applications/output/hits-distribution.csv $application,$version,$user,$execution,"
					while ! java -jar adapters/RemoteExecutor/target/RemoteExecutor-1.0.jar --send="caching-approaches-comparison $command" --host=$host --port=5000; do sleep 5; done
				fi
			done
		done
	done
done
