#!/bin/bash

source functions.sh

if [ "$(whoami)" != 'root' ]; then
	echo "You have no permission to run $0 as non-root user."
	exit 1;
fi

export JAVA_OPTS=${JAVA_OPTS:-"-Xmx7500m"}
JAVA_SERVER_OPTS=${JAVA_SERVER_OPTS:-"-Xmx30000m"}

host="localhost"
applications=$(echo applications/uncached/*/)
if [[ ! -z $1 ]]; then
	host=$1
	if [[ ! -z $2 ]]; then
		applications=$2
	fi
fi

echo "$(date '+%F %T') Running in host $host for the applications: $applications"
for application in $applications; do
	application=${application%/}
	if [[ -f applications/output/$application-uncached-requests ]]; then
		echo "$(date '+%F %T')  Skipping application $application"
	else
		echo "$(date '+%F %T')  Running application $application"
		command="JAVA_OPTS=$JAVA_SERVER_OPTS TRACER_ENABLE=true docker-compose -f applications/uncached/$application/docker-compose.yml up -d --build"
		execute "$host" "$command"
		while ! curl -s $host:8080 > /dev/null; do sleep 5; done
		java $JAVA_OPTS -jar adapters/RequestsSimulator/target/RequestsSimulator-1.0.jar --profile=applications/workloads/$application.json --time=300000 --users=1 --log=applications/workloads/$application-execution-uncached.json --throughput=applications/output/$application-uncached-requests --host=$host --home="applications/workloads/" > applications/output/$application-uncached-simulator.log 2>&1
		command="docker-compose -f applications/uncached/$application/docker-compose.yml down -v"
		execute "$host" "$command"
		sleep 30
	fi
done
