library(ggplot2)
library(plyr)
library(scales)

hits <- read.csv("../applications/output/hits-distribution.csv")

print("cache-balance")
pdf("cache-balance.pdf")

slice <- aggregate(formula = amount~application+version+users+name+event, data = hits, FUN = sum)

iter_applications = unique(slice$application)
iter_users = unique(slice$users)
for (iter_application in iter_applications) {
	for (iter_user in iter_users) {
		slice_application <- subset(slice, application == iter_application & users == iter_user)
		misses <- subset(slice_application, event == "miss" | event == "addition")
		misses[, "amount"] <- -misses[, "amount"]
		plot <- ggplot(slice_application, aes(x = factor(name), y = amount, fill = event)) +
			geom_bar(data = subset(slice_application, event == "hit"), stat = "identity") +
			geom_bar(data = misses, position = "dodge", stat = "identity") +
			scale_colour_grey(start = 0.1, end = 0.6) +
			scale_fill_grey(start = 0.1, end = 0.6) +
			scale_y_continuous(labels = scientific) +
			coord_flip() +
			facet_grid(~ version, scales = "free") +
			theme(text = element_text(size = 8)) +
			theme(axis.text.x = element_text(angle = 20)) +
			theme(legend.position = "bottom") +
			ggtitle(paste(iter_application, iter_user))
		print(plot)
	}
}