library(ggplot2)
library(ggforce)

requests <- read.csv2("../applications/output/requests-handled.csv", header=TRUE, sep=",", dec=".")

print("throughput -> aggregating")

aggregate <- aggregate(formula = requests~application+version+users+execution, data = requests, FUN = length)
names(aggregate)[names(aggregate) == "requests"] <- "time"
aggregate["requests"] <- aggregate(formula = requests~application+version+users+execution, data = requests, FUN = max)["requests"]

aggregate["throughput"] <- aggregate$requests / aggregate$time
aggregate["time"] <- NULL
aggregate["requests"] <- NULL

aggregate <- reshape(aggregate, idvar = c("application", "version", "users"), timevar = "execution", direction = "wide")

actual_length <- length(aggregate)

aggregate["min_throughput"] <- apply(aggregate[, 4:actual_length], 1, FUN = min)
aggregate["median_throughput"] <- apply(aggregate[, 4:actual_length], 1, FUN = median)
aggregate["max_throughput"] <- apply(aggregate[, 4:actual_length], 1, FUN = max)

iter_applications = unique(aggregate$application)
iter_users = unique(aggregate$users)
iter_events = unique(aggregate$event)
for (iter_application in iter_applications) {
	for (iter_user in iter_users) {
		maximum <- max(aggregate[aggregate$application == iter_application & aggregate$users == iter_user, "max_throughput"])
		aggregate[aggregate$application == iter_application & aggregate$users == iter_user, "median_percentage"] <- aggregate[aggregate$application == iter_application & aggregate$users == iter_user, "median_throughput"] / maximum
		aggregate[aggregate$application == iter_application & aggregate$users == iter_user, "min_percentage"] <- aggregate[aggregate$application == iter_application & aggregate$users == iter_user, "min_throughput"] / maximum
		aggregate[aggregate$application == iter_application & aggregate$users == iter_user, "max_percentage"] <- aggregate[aggregate$application == iter_application & aggregate$users == iter_user, "max_throughput"] / maximum
	}
}

temp <- aggregate
temp[4:13] <- NULL
temp[4] <- NULL
temp[5:8] <- NULL
print("throughput median values")
reshape(temp, timevar = "users", idvar = c("application", "version"), direction = "wide")

plot <- ggplot(aggregate, aes(x = factor(users), y = median_percentage, fill = version)) +
	geom_bar(position = "dodge", stat = "identity") +
	geom_errorbar(aes(ymin = min_percentage, ymax = max_percentage), width = .2, position = position_dodge(.9)) +
	geom_text(aes(label = sprintf("%.2f", median_throughput)), colour = "white", stat = "identity", size = 3.2, angle = 90, position = position_dodge(width = 0.9), hjust = 1.2) +
	scale_fill_grey(start = 0.2, end = 0.6) +
	scale_colour_grey(start = 0.2, end = 0.6) +
	facet_wrap(~ application, scales = "free", ncol = 4) +
	theme(axis.text.x = element_text(angle = 0)) +
	theme(legend.position = "bottom")

ggsave("throughput-normalised.pdf", width = 10, height = 5)
