library(ggplot2)
library(ggforce)

requests <- read.csv2("../applications/output/requests-handled.csv", header=TRUE, sep=",", dec=".")

print("median")

median <- aggregate(formula = requests~application+version+users+execution, data = requests, FUN = length)
median <- reshape(median, idvar = c("application", "version", "users"), timevar = "execution", direction = "wide")
median[, "median"] <- apply(median[, 4:length(median)], 1, FUN = function(x) which.min(abs(x - median(x))))
median[, "reference"] <- paste(median$application, median$version, median$users, median$median)

print("requests variability")

slice <- requests
slice <- subset(slice, paste(slice$application, slice$version, slice$users, slice$execution) %in% median$reference)

pdf("requests-variability.pdf")

iter_applications = unique(slice$application)
for(i in 1:length(iter_applications)) {
	plot <- ggplot(requests, aes(x = time, y = requests, colour = factor(execution), group = factor(execution))) + 
		geom_line(aes(linetype = factor(execution))) +
		scale_colour_grey(start = 0.1, end = 0.6) +
		facet_grid_paginate(application ~ users ~ version, scales = "free", ncol = 4, nrow = 3, page = i) +
		theme(legend.position = "bottom")
	print(plot)
}