package org.springframework.samples.petclinic;

import br.ufrgs.inf.prosoft.tigris.configuration.annotation.ComponentScan;
import br.ufrgs.inf.prosoft.tigris.configuration.annotation.Metrics;
import br.ufrgs.inf.prosoft.tigris.configuration.annotation.TigrisConfiguration;
import br.ufrgs.inf.prosoft.tigris.configuration.annotation.TigrisCriteria;
import br.ufrgs.inf.prosoft.tigris.configuration.types.RepositoryType;
import br.ufrgs.inf.prosoft.tigris.sampling.GranularityType;

@TigrisConfiguration(
    logRepository = RepositoryType.MEMORY,
    staticMetricFile = "petclinic.csv",
    samplingPercentage = 0.5)
@TigrisCriteria(
    criteria = "more frequent '∪' more expensive",
    granularity = GranularityType.METHOD,
    frequencyMetric = Metrics.INVOCATION_FREQUENCY,
    expensivenessMetric = Metrics.EXECUTION_TIME,
    changeabilityMetric = Metrics.COMPUTATION_PATTERN
)
@ComponentScan(allowed = "org.springframework.samples.petclinic.*",
        denied = "org.springframework.samples.petclinic.model.*")
public class ApplicationInitializer { }
