/*
 * Decompiled with CFR 0.152.
 */
package ca.uqac.lif.bullwinkle;

import ca.uqac.lif.bullwinkle.EpsilonTerminalToken;
import ca.uqac.lif.bullwinkle.NonTerminalToken;
import ca.uqac.lif.bullwinkle.RegexTerminalToken;
import ca.uqac.lif.bullwinkle.TerminalToken;
import ca.uqac.lif.bullwinkle.Token;
import ca.uqac.lif.bullwinkle.TokenString;
import ca.uqac.lif.util.EmptyException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BnfRule
implements Serializable {
    private static final transient long serialVersionUID = 579372107761975753L;
    private List<TokenString> m_alternatives = new ArrayList<TokenString>();
    private NonTerminalToken m_leftHandSide;

    BnfRule() {
    }

    public static BnfRule parseRule(String input) throws InvalidRuleException {
        BnfRule out = new BnfRule();
        String[] lr = input.split("\\s*:=\\s*");
        if (lr.length != 2) {
            throw new InvalidRuleException("Cannot find left- and right-hand side of BNF rule");
        }
        assert (lr.length == 2);
        String lhs = lr[0].trim();
        out.setLeftHandSide(new NonTerminalToken(lhs));
        if (lr[1].startsWith("^")) {
            String regex = BnfRule.unescapeString(lr[1]);
            TokenString alternative_to_add = new TokenString();
            RegexTerminalToken to_add = new RegexTerminalToken(regex);
            alternative_to_add.add(to_add);
            out.addAlternative(alternative_to_add);
        } else {
            String[] parts = lr[1].split("\\s+\\|\\|\\s+");
            String[] normal_alternatives = parts[0].split("\\s+\\|\\s+");
            String[] sticky_alternatives = new String[]{};
            if (parts.length > 1) {
                sticky_alternatives = parts[1].split("\\s+\\|\\s+");
            }
            if (normal_alternatives.length == 0 && sticky_alternatives.length == 0) {
                throw new InvalidRuleException("Right-hand side of BNF rule is empty");
            }
            BnfRule.processAlternatives(out, normal_alternatives, false);
            BnfRule.processAlternatives(out, sticky_alternatives, true);
        }
        return out;
    }

    private static void processAlternatives(BnfRule out, String[] alternatives, boolean sticky) throws InvalidRuleException {
        String[] stringArray = alternatives;
        int n = alternatives.length;
        int n2 = 0;
        while (n2 < n) {
            String alt = stringArray[n2];
            TokenString alternative_to_add = new TokenString();
            alternative_to_add.setTryLast(sticky);
            String[] words = alt.split(" ");
            if (words.length == 0) {
                throw new InvalidRuleException("Alternative of BNF rule is empty");
            }
            assert (words.length > 0);
            String[] stringArray2 = words;
            int n3 = words.length;
            int n4 = 0;
            while (n4 < n3) {
                Token to_add;
                String word = stringArray2[n4];
                String trimmed_word = word.trim();
                if (trimmed_word.contains("<") && !trimmed_word.startsWith("<")) {
                    throw new InvalidRuleException("The expression '" + trimmed_word + "' contains tokens that are not separated by spaces");
                }
                if (trimmed_word.startsWith("<")) {
                    to_add = new NonTerminalToken(trimmed_word);
                    alternative_to_add.add(to_add);
                } else if (trimmed_word.compareTo("\uceb5") == 0 || trimmed_word.compareTo("\u03b5") == 0) {
                    to_add = new EpsilonTerminalToken();
                    alternative_to_add.add(to_add);
                } else {
                    if (trimmed_word.isEmpty()) {
                        throw new InvalidRuleException("Trying to create an empty terminal token");
                    }
                    trimmed_word = BnfRule.unescapeString(trimmed_word);
                    alternative_to_add.add(new TerminalToken(trimmed_word));
                }
                ++n4;
            }
            out.addAlternative(alternative_to_add);
            ++n2;
        }
    }

    void setLeftHandSide(NonTerminalToken t) {
        this.m_leftHandSide = t;
    }

    void addAlternative(TokenString ts) {
        this.m_alternatives.add(ts);
    }

    void addAlternative(int index, TokenString ts) {
        this.m_alternatives.add(index, ts);
    }

    public List<TokenString> getAlternatives() {
        ArrayList<TokenString> ordered_list = new ArrayList<TokenString>();
        ArrayList<TokenString> last_elements = new ArrayList<TokenString>();
        for (TokenString ts : this.m_alternatives) {
            if (ts.getTryLast()) {
                last_elements.add(ts);
                continue;
            }
            ordered_list.add(ts);
        }
        ordered_list.addAll(last_elements);
        return ordered_list;
    }

    public NonTerminalToken getLeftHandSide() {
        return this.m_leftHandSide;
    }

    protected static String unescapeString(String s) {
        String new_s = s.replaceAll("\\\\([^u])", "\\\\\\\\$1");
        Properties p = new Properties();
        try {
            p.load(new StringReader("key=" + new_s));
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().log(Level.WARNING, "", e);
        }
        return p.getProperty("key");
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.m_leftHandSide).append(" := ");
        boolean first = true;
        for (TokenString alt : this.m_alternatives) {
            if (!first) {
                out.append(" | ");
            }
            first = false;
            out.append(alt);
        }
        return out.toString();
    }

    public Set<TerminalToken> getTerminalTokens() {
        HashSet<TerminalToken> out = new HashSet<TerminalToken>();
        for (TokenString ts : this.m_alternatives) {
            out.addAll(ts.getTerminalTokens());
        }
        return out;
    }

    public void addAlternatives(Collection<TokenString> alternatives) {
        this.m_alternatives.addAll(alternatives);
    }

    public void addAlternatives(int position, Collection<TokenString> alternatives) {
        for (TokenString alt : alternatives) {
            this.m_alternatives.add(position, alt);
        }
    }

    public static class InvalidRuleException
    extends EmptyException {
        private static final transient long serialVersionUID = 1L;

        public InvalidRuleException(String message) {
            super(message);
        }
    }
}

