package br.ufrgs.inf.prosoft.tigris;

import ca.uqac.lif.bullwinkle.BnfParser;
import ca.uqac.lif.bullwinkle.ParseNode;
import com.google.common.io.Resources;
import org.junit.Assert;
import org.junit.Test;

import java.io.IOException;

public class TigrisDslTest {

    @Test
    public void loadDsl() throws BnfParser.ParseException, BnfParser.InvalidGrammarException, IOException {
        BnfParser parser = new BnfParser();
        parser.setGrammar("<filter> := <filterdef> | ( <filter> ) | <filter> <operator> <filter>;\n" +
                "<filterdef>  := <modifier> <criterion> | <criterion>;\n" +
                "<operator> := '∪' | '∩' | '\\';\n" +
                "<modifier> := more | less | most | least;\n" +
                "<criterion> := frequent | maintainable | expensive | changeable | error-prone | usage-pattern | state-variation | concurrent | latent;");
        ParseNode node = parser.parse("more frequent '∪' more expensive");
        Assert.assertNotNull(node);
    }
}
