/*
 * Decompiled with CFR 0.152.
 */
package ca.uqac.lif.bullwinkle;

import ca.uqac.lif.bullwinkle.BnfParser;
import ca.uqac.lif.bullwinkle.ParseNodeVisitor;
import ca.uqac.lif.bullwinkle.output.GraphvizVisitor;
import ca.uqac.lif.bullwinkle.output.IndentedTextVisitor;
import ca.uqac.lif.bullwinkle.output.XmlVisitor;
import ca.uqac.lif.util.CliParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Scanner;

public class BullwinkleCli {
    public static final int ERR_OK = 0;
    public static final int ERR_PARSE = 2;
    public static final int ERR_IO = 3;
    public static final int ERR_ARGUMENTS = 4;
    public static final int ERR_RUNTIME = 6;
    public static final int ERR_GRAMMAR = 7;
    public static final int ERR_INPUT = 9;
    private static final String P_FORMAT = "format";
    private static final String P_HELP = "help";
    private static final String P_VERBOSITY = "verbosity";
    private static final String P_VERSION = "version";
    protected static final String VERSION_STRING = BullwinkleCli.class.getPackage().getImplementationVersion();

    private BullwinkleCli() {
        throw new IllegalAccessError("Main class");
    }

    public static void main(String[] args) {
        System.exit(BullwinkleCli.doMain(args, System.in, System.out, System.err));
    }

    /*
     * Unable to fully structure code
     */
    public static int doMain(String[] args, InputStream stdin, PrintStream stdout, PrintStream stderr) {
        verbosity = 1;
        output_format = "xml";
        grammar_filename = null;
        filename_to_parse = null;
        cli_parser = BullwinkleCli.setupOptions();
        c_line = BullwinkleCli.setupCommandLine(cli_parser, args);
        if (c_line == null) {
            stderr.println("Error parsing command-line arguments");
            return 4;
        }
        if (!BullwinkleCli.$assertionsDisabled && c_line == null) {
            throw new AssertionError();
        }
        if (c_line.hasOption("verbosity")) {
            verbosity = Integer.parseInt(c_line.getOptionValue("verbosity"));
        }
        if (verbosity > 0) {
            BullwinkleCli.showHeader(stderr);
        }
        if (c_line.hasOption("version")) {
            stderr.println("(C) 2014-2018 Sylvain Hall\u00e9 et al., Universit\u00e9 du Qu\u00e9bec \u00e0 Chicoutimi");
            stderr.println("This program comes with ABSOLUTELY NO WARRANTY.");
            stderr.println("This is a free software, and you are welcome to redistribute it");
            stderr.println("under certain conditions. See the file LICENSE-2.0 for details.\n");
            return 0;
        }
        if (c_line.hasOption("help")) {
            BullwinkleCli.showUsage(cli_parser, stderr);
            return 0;
        }
        if (c_line.hasOption("format")) {
            output_format = c_line.getOptionValue("format");
        }
        if ((remaining_args = c_line.getOthers()).isEmpty()) {
            stderr.println("ERROR: no grammar file specified");
            return 4;
        }
        grammar_filename = remaining_args.get(0);
        if (remaining_args.size() >= 2) {
            filename_to_parse = remaining_args.get(1);
        }
        parser = null;
        try {
            parser = new BnfParser(new FileInputStream(new File(grammar_filename)));
        }
        catch (BnfParser.InvalidGrammarException e) {
            stderr.println("ERROR: invalid grammar");
            return 7;
        }
        catch (IOException e) {
            stderr.println("ERROR reading grammar " + grammar_filename);
            return 3;
        }
        if (!BullwinkleCli.$assertionsDisabled && parser == null) {
            throw new AssertionError();
        }
        scanner = null;
        if (filename_to_parse == null) {
            scanner = new Scanner(stdin);
        } else {
            try {
                scanner = new Scanner(new File(filename_to_parse));
            }
            catch (FileNotFoundException e) {
                stderr.println("ERROR reading input\n");
                return 3;
            }
        }
        input_file = new StringBuilder();
        if (BullwinkleCli.$assertionsDisabled || scanner != null) ** GOTO lbl61
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            line = scanner.nextLine();
            input_file.append(line).append("\n");
lbl61:
            // 2 sources

            ** while (scanner.hasNextLine())
        }
lbl62:
        // 1 sources

        scanner.close();
        file_contents = input_file.toString();
        p_node = null;
        try {
            p_node = parser.parse(file_contents);
        }
        catch (BnfParser.ParseException e) {
            stderr.println("ERROR parsing input\n");
            e.printStackTrace();
            return 2;
        }
        if (p_node == null) {
            stderr.println("ERROR parsing input\n");
            return 2;
        }
        if (!BullwinkleCli.$assertionsDisabled && p_node == null) {
            throw new AssertionError();
        }
        output = stdout;
        out_vis = null;
        if (output_format.compareToIgnoreCase("xml") == 0) {
            out_vis = new XmlVisitor();
        } else if (output_format.compareToIgnoreCase("dot") == 0) {
            out_vis = new GraphvizVisitor();
        } else if (output_format.compareToIgnoreCase("txt") == 0) {
            out_vis = new IndentedTextVisitor();
        }
        if (out_vis == null) {
            stderr.println("ERROR: unknown output format " + output_format);
            return 4;
        }
        if (!BullwinkleCli.$assertionsDisabled && out_vis == null) {
            throw new AssertionError();
        }
        try {
            p_node.prefixAccept(out_vis);
            output.print(out_vis.toOutputString());
        }
        catch (ParseNodeVisitor.VisitException e) {
            return 2;
        }
        return 0;
    }

    private static CliParser setupOptions() {
        CliParser cli_parser = new CliParser();
        cli_parser.addArgument(new CliParser.Argument().withShortName("h").withLongName(P_HELP).withDescription("Display command line usage"));
        cli_parser.addArgument(new CliParser.Argument().withShortName("f").withLongName(P_FORMAT).withArgument("x").withDescription("Output parse tree in format x (dot, xml, txt). Default: xml"));
        cli_parser.addArgument(new CliParser.Argument().withLongName(P_VERBOSITY).withArgument("x").withDescription("Verbose messages with level x"));
        cli_parser.addArgument(new CliParser.Argument().withLongName(P_VERSION).withDescription("Show version number"));
        return cli_parser;
    }

    private static void showUsage(CliParser cli_parser, PrintStream ps) {
        cli_parser.printHelp("java -jar BullwinkleParser.jar [options] grammar [inputfile]", ps);
    }

    private static CliParser.ArgumentMap setupCommandLine(CliParser cli_parser, String[] cli) {
        return cli_parser.parse(cli);
    }

    private static void showHeader(PrintStream ps) {
        ps.println("Bullwinkle " + VERSION_STRING + ", a LL(k) parser");
    }

    public static String getVersionString() {
        return VERSION_STRING;
    }
}

