/*
 * Decompiled with CFR 0.152.
 */
package ca.uqac.lif.bullwinkle;

import ca.uqac.lif.bullwinkle.Builds;
import ca.uqac.lif.bullwinkle.ParseNode;
import ca.uqac.lif.bullwinkle.ParseNodeVisitor;
import ca.uqac.lif.util.EmptyException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class ParseTreeObjectBuilder<T>
implements ParseNodeVisitor {
    protected Deque<Object> m_stack;
    protected T m_builtObject = null;
    protected final Map<String, MethodAnnotation> m_methods = new HashMap<String, MethodAnnotation>();

    public ParseTreeObjectBuilder() {
        this.fillMethods(this.m_methods);
    }

    public final synchronized T build(ParseNode tree) throws BuildException {
        if (tree == null) {
            throw new BuildException("The input tree is null");
        }
        this.m_stack = new ArrayDeque<Object>();
        try {
            this.preVisit();
            tree.postfixAccept(this);
            this.m_builtObject = this.postVisit(this.m_stack);
            return this.m_builtObject;
        }
        catch (ParseNodeVisitor.VisitException e) {
            throw new BuildException(e);
        }
    }

    protected synchronized void preVisit() {
    }

    protected synchronized T postVisit(Deque<Object> stack) {
        if (stack.isEmpty()) {
            return null;
        }
        return (T)stack.peek();
    }

    protected synchronized void fillMethods(Map<String, MethodAnnotation> methods) {
        List<Class<?>> parents = this.getParents();
        for (Class<?> cl : parents) {
            Method[] ms;
            Method[] methodArray = ms = cl.getDeclaredMethods();
            int n = ms.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                Builds an = method.getAnnotation(Builds.class);
                if (an != null) {
                    String non_terminal = an.rule();
                    methods.put(non_terminal, new MethodAnnotation(method, an.pop(), an.clean()));
                }
                ++n2;
            }
        }
    }

    protected List<Class<?>> getParents() {
        ArrayList parents = new ArrayList();
        Class<?> cur_class = this.getClass();
        while (true) {
            parents.add(0, cur_class);
            Class<?> parent = cur_class.getSuperclass();
            if (parent == Object.class) break;
            cur_class = parent;
        }
        return parents;
    }

    @Override
    public synchronized void visit(ParseNode node) throws ParseNodeVisitor.VisitException {
        try {
            this.handleNode(node);
        }
        catch (SecurityException e) {
            throw new ParseNodeVisitor.VisitException(e);
        }
        catch (IllegalAccessException e) {
            throw new ParseNodeVisitor.VisitException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ParseNodeVisitor.VisitException(e);
        }
        catch (InvocationTargetException e) {
            throw new ParseNodeVisitor.VisitException(e);
        }
    }

    protected void handleNode(ParseNode node) throws IllegalAccessException, InvocationTargetException {
        String token_name = node.getToken();
        if (!token_name.startsWith("<")) {
            this.m_stack.push(token_name);
            return;
        }
        if (this.m_methods.containsKey(token_name)) {
            MethodAnnotation ma = this.m_methods.get(token_name);
            if (!ma.pop) {
                ma.m.invoke((Object)this, this.m_stack);
                return;
            }
            LinkedList<Object> argument_list = new LinkedList<Object>();
            List<ParseNode> children = node.getChildren();
            int i = children.size() - 1;
            while (i >= 0) {
                ParseNode child = children.get(i);
                Object o = this.m_stack.pop();
                if (!ma.clean || child.getToken().startsWith("<")) {
                    argument_list.add(0, o);
                }
                --i;
            }
            Object[] arguments = argument_list.toArray();
            Object o = ma.m.invoke((Object)this, new Object[]{arguments});
            if (o != null) {
                this.m_stack.push(o);
            }
        }
    }

    @Override
    public synchronized void pop() {
    }

    public static class BuildException
    extends EmptyException {
        private static final transient long serialVersionUID = 1L;

        public BuildException(String message) {
            super(message);
        }

        public BuildException(Throwable t) {
            super(t);
        }
    }

    protected static class MethodAnnotation {
        Method m;
        boolean pop = false;
        boolean clean = false;

        public MethodAnnotation(Method m, boolean pop, boolean clean) {
            this.m = m;
            this.pop = pop;
            this.clean = clean;
        }
    }
}

