/*
 * Decompiled with CFR 0.152.
 */
package ca.uqac.lif.bullwinkle;

import ca.uqac.lif.bullwinkle.TerminalToken;
import ca.uqac.lif.bullwinkle.Token;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexTerminalToken
extends TerminalToken {
    private static final transient long serialVersionUID = -2430670680001437707L;
    private transient Pattern m_pattern;

    protected RegexTerminalToken() {
    }

    public RegexTerminalToken(String label) {
        super(label);
    }

    @Override
    public void setName(String s) {
        super.setName(s);
        this.m_pattern = Pattern.compile(s);
    }

    @Override
    public boolean matches(Token tok) {
        String contents = tok.getName();
        Matcher matcher = this.m_pattern.matcher(contents);
        return matcher.matches();
    }

    @Override
    public int match(String s) {
        Matcher matcher = this.m_pattern.matcher(s);
        if (matcher.find()) {
            return matcher.end();
        }
        return -1;
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.getName());
        return out.toString();
    }

    public List<String> getCaptureBlocks(String s) {
        LinkedList<String> out = new LinkedList<String>();
        Matcher matcher = this.m_pattern.matcher(s);
        if (matcher.find()) {
            int i = 1;
            while (i <= matcher.groupCount()) {
                String group_match = matcher.group(i);
                out.add(group_match);
                ++i;
            }
        }
        return out;
    }

    @Override
    public int hashCode() {
        return this.m_pattern.toString().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof RegexTerminalToken)) {
            return false;
        }
        RegexTerminalToken rt = (RegexTerminalToken)o;
        return this.m_pattern.toString().compareTo(rt.m_pattern.toString()) == 0;
    }
}

