package br.ufrgs.inf.prosoft.tigris.configuration.annotation;

import br.ufrgs.inf.prosoft.tigris.sampling.GranularityType;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * The interface Tigris criteria.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
public @interface TigrisCriteria {

    /**
     * Criteria in form of SET operations over the criteria.
     * <p>
     * Operations allowed: union (U), intersection (I), difference (D), complement (C)
     * Verbs: frequent, expensive, changeable, errorprone, globalimpact
     * Additional: more, less
     * <p>
     * Examples:
     * more frequent U more expensive C less changeable
     * less frequent C less expensive
     *
     * @return the criteria string
     */
    String criteria();

    /**
     * Granularity granularity type.
     *
     * @return the granularity type
     */
    GranularityType granularity() default GranularityType.METHOD;

    /**
     * Frequency metric
     * @return the frequency metric
     */
    Metrics frequencyMetric() default Metrics.INVOCATION_FREQUENCY;

    /**
     * Expensiveness metric
     * @return the expensiveness metric
     */
    Metrics expensivenessMetric() default Metrics.EXECUTION_TIME;

    /**
     * Changeability metric
     * @return the changeability metric
     */
    Metrics changeabilityMetric() default Metrics.COMPUTATION_PATTERN;
}
