/*
 * Decompiled with CFR 0.152.
 */
package ca.uqac.lif.bullwinkle;

import ca.uqac.lif.bullwinkle.ParseNodeVisitor;
import java.util.ArrayList;
import java.util.List;

public class ParseNode {
    private ArrayList<ParseNode> m_children = new ArrayList();
    private String m_token = null;
    private String m_value = null;

    ParseNode() {
    }

    ParseNode(String token) {
        this();
        this.setToken(token);
    }

    public List<ParseNode> getChildren() {
        if (this.m_children != null) {
            ArrayList<ParseNode> nodes = new ArrayList<ParseNode>(this.m_children.size());
            nodes.addAll(this.m_children);
            return nodes;
        }
        return new ArrayList<ParseNode>(0);
    }

    public String getValue() {
        return this.m_value;
    }

    public String getToken() {
        return this.m_token;
    }

    void setValue(String value) {
        this.m_value = value;
    }

    void setToken(String token) {
        this.m_token = token;
    }

    void addChild(ParseNode child) {
        this.m_children.add(child);
    }

    public String toString() {
        return this.toString("");
    }

    private String toString(String indent) {
        StringBuilder out = new StringBuilder();
        out.append(indent).append(this.m_token).append("\n");
        String n_indent = String.valueOf(indent) + " ";
        for (ParseNode n : this.m_children) {
            out.append(n.toString(n_indent));
        }
        return out.toString();
    }

    public int getSize() {
        int size = 1;
        for (ParseNode node : this.m_children) {
            size += node.getSize();
        }
        return size;
    }

    public void postfixAccept(ParseNodeVisitor visitor) throws ParseNodeVisitor.VisitException {
        for (ParseNode n : this.m_children) {
            n.postfixAccept(visitor);
        }
        visitor.visit(this);
        visitor.pop();
    }

    public void prefixAccept(ParseNodeVisitor visitor) throws ParseNodeVisitor.VisitException {
        visitor.visit(this);
        for (ParseNode n : this.m_children) {
            n.prefixAccept(visitor);
        }
        visitor.pop();
    }
}

