package br.ufrgs.inf.prosoft.tigris.configuration.annotation;

import br.ufrgs.inf.prosoft.tigris.configuration.types.RepositoryType;

import java.lang.annotation.*;

/**
 * The interface Tigris configuration.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
public @interface TigrisConfiguration {

    /**
     * Static metric file string.
     *
     * @return the string
     */
    String staticMetricFile();

    /**
     * Log repository repository type.
     *
     * @return the repository type
     */
    RepositoryType logRepository() default RepositoryType.MONGODB;

    /**
     * Clear monitoring data on start boolean.
     *
     * @return the boolean
     */
    boolean clearMonitoringDataOnStart() default false;

    /**
     * Sampling percentage int.
     *
     * @return the sampling percentage
     */
    double samplingPercentage() default 0.5;

    /**
     * Cycle time in seconds int.
     *
     * @return the int
     */
    long cycleTimeInMilliseconds() default 3600000; //3600000 milliseconds = 1h
}
